/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.Format;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidator;

public class LongValidator
extends AbstractNumberValidator {
    private static final long serialVersionUID = -5117231731027866098L;
    private static final LongValidator VALIDATOR = new LongValidator();

    public static LongValidator getInstance() {
        return VALIDATOR;
    }

    public LongValidator() {
        this(true, 0);
    }

    public LongValidator(boolean strict, int formatType) {
        super(strict, formatType, false);
    }

    public Long validate(String value) {
        return (Long)this.parse(value, null, null);
    }

    public Long validate(String value, String pattern) {
        return (Long)this.parse(value, pattern, null);
    }

    public Long validate(String value, Locale locale) {
        return (Long)this.parse(value, null, locale);
    }

    public Long validate(String value, String pattern, Locale locale) {
        return (Long)this.parse(value, pattern, locale);
    }

    public boolean isInRange(long value, long min2, long max2) {
        return value >= min2 && value <= max2;
    }

    public boolean isInRange(Long value, long min2, long max2) {
        return this.isInRange((long)value, min2, max2);
    }

    public boolean minValue(long value, long min2) {
        return value >= min2;
    }

    public boolean minValue(Long value, long min2) {
        return this.minValue((long)value, min2);
    }

    public boolean maxValue(long value, long max2) {
        return value <= max2;
    }

    public boolean maxValue(Long value, long max2) {
        return this.maxValue((long)value, max2);
    }

    @Override
    protected Object processParsedValue(Object value, Format formatter) {
        if (value instanceof Long) {
            return value;
        }
        return null;
    }
}

