"""Class map for the traffic sign classification dataset."""

CLASS_NAME_TO_CLASS_IDX = {
    "NotListed": 0,
    "Indication_CameraSurveillance": 1,
    "Mandatory_PassOnEitherSide": 2,
    "Mandatory_PassOnThisSideLeft": 3,
    "Mandatory_PassOnThisSideRight": 4,
    "Mandatory_ProceedStraight": 5,
    "Mandatory_ProceedStraightOrTurnRight": 6,
    "Mandatory_ProceedStraightOrTurnLeft": 7,
    "Mandatory_Roundabout": 8,
    "Mandatory_TurnAhead": 9,
    "Mandatory_TurnLeft": 10,
    "Mandatory_TurnLeftAhead": 11,
    "Mandatory_TurnRight": 12,
    "Mandatory_TurnRightAhead": 13,
    "Priority_GiveWayOncoming": 14,
    "Priority_GiveWay": 15,
    "Priority_PriorityRoadBegin": 16,
    "Priority_PriorityRoadEnd": 17,
    "Priority_PrioOverOncoming": 18,
    "Priority_Stop": 19,
    "Prohibitory_MaximumSpeedLimit5End": 20,
    "Prohibitory_MaximumSpeedLimit5Begin": 21,
    "Prohibitory_MaximumSpeedLimit10End": 22,
    "Prohibitory_MaximumSpeedLimit10Begin": 23,
    "Prohibitory_MaximumSpeedLimit15End": 24,
    "Prohibitory_MaximumSpeedLimit15Begin": 25,
    "Prohibitory_MaximumSpeedLimit20Begin": 26,
    "Prohibitory_MaximumSpeedLimit20End": 27,
    "Prohibitory_MaximumSpeedLimit25End": 28,
    "Prohibitory_MaximumSpeedLimit25Begin": 29,
    "Prohibitory_MaximumSpeedLimit30End": 30,
    "Prohibitory_MaximumSpeedLimit30Begin": 31,
    "Prohibitory_MaximumSpeedLimit35End": 32,
    "Prohibitory_MaximumSpeedLimit35Begin": 33,
    "Prohibitory_MaximumSpeedLimit40End": 34,
    "Prohibitory_MaximumSpeedLimit40Begin": 35,
    "Prohibitory_MaximumSpeedLimit45End": 36,
    "Prohibitory_MaximumSpeedLimit45Begin": 37,
    "Prohibitory_MaximumSpeedLimit50Begin": 38,
    "Prohibitory_MaximumSpeedLimit50End": 39,
    "Prohibitory_MaximumSpeedLimit55Begin": 40,
    "Prohibitory_MaximumSpeedLimit55End": 41,
    "Prohibitory_MaximumSpeedLimit60Begin": 42,
    "Prohibitory_MaximumSpeedLimit60End": 43,
    "Prohibitory_MaximumSpeedLimit65Begin": 44,
    "Prohibitory_MaximumSpeedLimit65End": 45,
    "Prohibitory_MaximumSpeedLimit70Begin": 46,
    "Prohibitory_MaximumSpeedLimit70End": 47,
    "Prohibitory_MaximumSpeedLimit75End": 48,
    "Prohibitory_MaximumSpeedLimit75Begin": 49,
    "Prohibitory_MaximumSpeedLimit80Begin": 50,
    "Prohibitory_MaximumSpeedLimit80End": 51,
    "Prohibitory_MaximumSpeedLimit85Begin": 52,
    "Prohibitory_MaximumSpeedLimit85End": 53,
    "Prohibitory_MaximumSpeedLimit90Begin": 54,
    "Prohibitory_MaximumSpeedLimit90End": 55,
    "Prohibitory_MaximumSpeedLimit95Begin": 56,
    "Prohibitory_MaximumSpeedLimit95End": 57,
    "Prohibitory_MaximumSpeedLimit100End": 58,
    "Prohibitory_MaximumSpeedLimit100Begin": 59,
    "Prohibitory_MaximumSpeedLimit105End": 60,
    "Prohibitory_MaximumSpeedLimit105Begin": 61,
    "Prohibitory_MaximumSpeedLimit110End": 62,
    "Prohibitory_MaximumSpeedLimit110Begin": 63,
    "Prohibitory_MaximumSpeedLimit115Begin": 64,
    "Prohibitory_MaximumSpeedLimit115End": 65,
    "Prohibitory_MaximumSpeedLimit120End": 66,
    "Prohibitory_MaximumSpeedLimit120Begin": 67,
    "Prohibitory_MaximumSpeedLimit125Begin": 68,
    "Prohibitory_MaximumSpeedLimit125End": 69,
    "Prohibitory_MaximumSpeedLimit130End": 70,
    "Prohibitory_MaximumSpeedLimit130Begin": 71,
    "Prohibitory_NoEntry": 72,
    "Prohibitory_NoOvertakingBegin": 73,
    "Prohibitory_NoOvertakingEnd": 74,
    "Prohibitory_NoParking": 75,
    "Prohibitory_NoStopping": 76,
    "Prohibitory_NoTurn": 77,
    "Prohibitory_NoUTurn": 78,
    "Prohibitory_RoadClosed": 79,
    "Prohibitory_SpeedLimitZone5End": 80,
    "Prohibitory_SpeedLimitZone5Begin": 81,
    "Prohibitory_SpeedLimitZone10Begin": 82,
    "Prohibitory_SpeedLimitZone10End": 83,
    "Prohibitory_SpeedLimitZone15End": 84,
    "Prohibitory_SpeedLimitZone15Begin": 85,
    "Prohibitory_SpeedLimitZone20Begin": 86,
    "Prohibitory_SpeedLimitZone20End": 87,
    "Prohibitory_SpeedLimitZone25End": 88,
    "Prohibitory_SpeedLimitZone25Begin": 89,
    "Prohibitory_SpeedLimitZone30End": 90,
    "Prohibitory_SpeedLimitZone30Begin": 91,
    "Prohibitory_SpeedLimitZone35End": 92,
    "Prohibitory_SpeedLimitZone35Begin": 93,
    "Prohibitory_SpeedLimitZone40End": 94,
    "Prohibitory_SpeedLimitZone40Begin": 95,
    "Prohibitory_SpeedLimitZone45Begin": 96,
    "Prohibitory_SpeedLimitZone45End": 97,
    "Prohibitory_SpeedLimitZone50Begin": 98,
    "Prohibitory_SpeedLimitZone50End": 99,
    "Prohibitory_SpeedLimitZone55End": 100,
    "Prohibitory_SpeedLimitZone55Begin": 101,
    "Prohibitory_SpeedLimitZone60End": 102,
    "Prohibitory_SpeedLimitZone60Begin": 103,
    "Prohibitory_SpeedLimitZone65End": 104,
    "Prohibitory_SpeedLimitZone65Begin": 105,
    "Prohibitory_SpeedLimitZone70End": 106,
    "Prohibitory_SpeedLimitZone70Begin": 107,
    "Prohibitory_SpeedLimitZone75End": 108,
    "Prohibitory_SpeedLimitZone75Begin": 109,
    "Prohibitory_SpeedLimitZone80Begin": 110,
    "Prohibitory_SpeedLimitZone80End": 111,
    "Prohibitory_SpeedLimitZone85End": 112,
    "Prohibitory_SpeedLimitZone85Begin": 113,
    "Prohibitory_SpeedLimitZone90Begin": 114,
    "Prohibitory_SpeedLimitZone90End": 115,
    "Prohibitory_SpeedLimitZone95Begin": 116,
    "Prohibitory_SpeedLimitZone95End": 117,
    "Prohibitory_SpeedLimitZone100End": 118,
    "Prohibitory_SpeedLimitZone100Begin": 119,
    "Prohibitory_SpeedLimitZone105End": 120,
    "Prohibitory_SpeedLimitZone105Begin": 121,
    "Prohibitory_SpeedLimitZone110End": 122,
    "Prohibitory_SpeedLimitZone110Begin": 123,
    "Prohibitory_SpeedLimitZone115Begin": 124,
    "Prohibitory_SpeedLimitZone115End": 125,
    "Prohibitory_SpeedLimitZone120Begin": 126,
    "Prohibitory_SpeedLimitZone120End": 127,
    "Prohibitory_SpeedLimitZone125Begin": 128,
    "Prohibitory_SpeedLimitZone125End": 129,
    "Prohibitory_SpeedLimitZone130End": 130,
    "Prohibitory_SpeedLimitZone130Begin": 131,
    "RoadType_MotorwayBegin": 132,
    "RoadType_MotorwayEnd": 133,
    "Special_VulnurableRoadUserCrossing": 134,
    "Special_VulnurableRoadUserPathWay": 135,
    "Warning_Animal": 136,
    "Warning_Children": 137,
    "Warning_CongestionAhead": 138,
    "Warning_Crossroads": 139,
    "Warning_Crossing": 140,
    "Warning_Curve": 141,
    "Warning_Cyclists": 142,
    "Warning_DoubleCurve": 143,
    "Warning_GenericWarning": 144,
    "Warning_MergingTraffic": 145,
    "Warning_RoadBump": 146,
    "Warning_RoadWorkEnd": 147,
    "Warning_RoadWorkBegin": 148,
    "Warning_RoadNarrows": 149,
    "Warning_RoughRoad": 150,
    "Warning_Roundabout": 151,
    "Warning_Slippery": 152,
    "Warning_TrafficSignalAhead": 153,
    "Warning_TunnelAhead": 154,
    "Warning_TwoWayTraffic": 155,
}

CLASS_IDX_TO_CLASS_NAME = {v: k for k, v in CLASS_NAME_TO_CLASS_IDX.items()}

TRAIN_SAMPLES_PER_CLASS_NAME = {
    "NotListed": 211898,
    "Indication_CameraSurveillance": 44,
    "Mandatory_PassOnEitherSide": 1003,
    "Mandatory_PassOnThisSideLeft": 1052,
    "Mandatory_PassOnThisSideRight": 15819,
    "Mandatory_ProceedStraight": 6892,
    "Mandatory_ProceedStraightOrTurnRight": 1805,
    "Mandatory_ProceedStraightOrTurnLeft": 548,
    "Mandatory_Roundabout": 1908,
    "Mandatory_TurnAhead": 145,
    "Mandatory_TurnLeft": 386,
    "Mandatory_TurnLeftAhead": 1047,
    "Mandatory_TurnRight": 811,
    "Mandatory_TurnRightAhead": 2087,
    "Priority_GiveWayOncoming": 26,
    "Priority_GiveWay": 17132,
    "Priority_PriorityRoadBegin": 20270,
    "Priority_PriorityRoadEnd": 1846,
    "Priority_PrioOverOncoming": 34,
    "Priority_Stop": 1463,
    "Prohibitory_MaximumSpeedLimit5End": 0,
    "Prohibitory_MaximumSpeedLimit5Begin": 49,
    "Prohibitory_MaximumSpeedLimit10End": 0,
    "Prohibitory_MaximumSpeedLimit10Begin": 156,
    "Prohibitory_MaximumSpeedLimit15End": 0,
    "Prohibitory_MaximumSpeedLimit15Begin": 11,
    "Prohibitory_MaximumSpeedLimit20Begin": 155,
    "Prohibitory_MaximumSpeedLimit20End": 2,
    "Prohibitory_MaximumSpeedLimit25End": 0,
    "Prohibitory_MaximumSpeedLimit25Begin": 6,
    "Prohibitory_MaximumSpeedLimit30End": 118,
    "Prohibitory_MaximumSpeedLimit30Begin": 3141,
    "Prohibitory_MaximumSpeedLimit35End": 0,
    "Prohibitory_MaximumSpeedLimit35Begin": 2,
    "Prohibitory_MaximumSpeedLimit40End": 35,
    "Prohibitory_MaximumSpeedLimit40Begin": 1524,
    "Prohibitory_MaximumSpeedLimit45End": 0,
    "Prohibitory_MaximumSpeedLimit45Begin": 1,
    "Prohibitory_MaximumSpeedLimit50Begin": 1624,
    "Prohibitory_MaximumSpeedLimit50End": 16,
    "Prohibitory_MaximumSpeedLimit55Begin": 0,
    "Prohibitory_MaximumSpeedLimit55End": 0,
    "Prohibitory_MaximumSpeedLimit60Begin": 1260,
    "Prohibitory_MaximumSpeedLimit60End": 18,
    "Prohibitory_MaximumSpeedLimit65Begin": 2,
    "Prohibitory_MaximumSpeedLimit65End": 0,
    "Prohibitory_MaximumSpeedLimit70Begin": 2887,
    "Prohibitory_MaximumSpeedLimit70End": 48,
    "Prohibitory_MaximumSpeedLimit75End": 0,
    "Prohibitory_MaximumSpeedLimit75Begin": 0,
    "Prohibitory_MaximumSpeedLimit80Begin": 806,
    "Prohibitory_MaximumSpeedLimit80End": 25,
    "Prohibitory_MaximumSpeedLimit85Begin": 1,
    "Prohibitory_MaximumSpeedLimit85End": 0,
    "Prohibitory_MaximumSpeedLimit90Begin": 627,
    "Prohibitory_MaximumSpeedLimit90End": 10,
    "Prohibitory_MaximumSpeedLimit95Begin": 1,
    "Prohibitory_MaximumSpeedLimit95End": 0,
    "Prohibitory_MaximumSpeedLimit100End": 12,
    "Prohibitory_MaximumSpeedLimit100Begin": 232,
    "Prohibitory_MaximumSpeedLimit105End": 0,
    "Prohibitory_MaximumSpeedLimit105Begin": 0,
    "Prohibitory_MaximumSpeedLimit110End": 3,
    "Prohibitory_MaximumSpeedLimit110Begin": 120,
    "Prohibitory_MaximumSpeedLimit115Begin": 0,
    "Prohibitory_MaximumSpeedLimit115End": 0,
    "Prohibitory_MaximumSpeedLimit120End": 9,
    "Prohibitory_MaximumSpeedLimit120Begin": 63,
    "Prohibitory_MaximumSpeedLimit125Begin": 0,
    "Prohibitory_MaximumSpeedLimit125End": 0,
    "Prohibitory_MaximumSpeedLimit130End": 2,
    "Prohibitory_MaximumSpeedLimit130Begin": 19,
    "Prohibitory_NoEntry": 18597,
    "Prohibitory_NoOvertakingBegin": 1663,
    "Prohibitory_NoOvertakingEnd": 93,
    "Prohibitory_NoParking": 6574,
    "Prohibitory_NoStopping": 20033,
    "Prohibitory_NoTurn": 3956,
    "Prohibitory_NoUTurn": 1108,
    "Prohibitory_RoadClosed": 2051,
    "Prohibitory_SpeedLimitZone5End": 0,
    "Prohibitory_SpeedLimitZone5Begin": 0,
    "Prohibitory_SpeedLimitZone10Begin": 19,
    "Prohibitory_SpeedLimitZone10End": 1,
    "Prohibitory_SpeedLimitZone15End": 0,
    "Prohibitory_SpeedLimitZone15Begin": 1,
    "Prohibitory_SpeedLimitZone20Begin": 90,
    "Prohibitory_SpeedLimitZone20End": 4,
    "Prohibitory_SpeedLimitZone25End": 0,
    "Prohibitory_SpeedLimitZone25Begin": 0,
    "Prohibitory_SpeedLimitZone30End": 235,
    "Prohibitory_SpeedLimitZone30Begin": 1784,
    "Prohibitory_SpeedLimitZone35End": 0,
    "Prohibitory_SpeedLimitZone35Begin": 1,
    "Prohibitory_SpeedLimitZone40End": 2,
    "Prohibitory_SpeedLimitZone40Begin": 51,
    "Prohibitory_SpeedLimitZone45Begin": 0,
    "Prohibitory_SpeedLimitZone45End": 0,
    "Prohibitory_SpeedLimitZone50Begin": 424,
    "Prohibitory_SpeedLimitZone50End": 109,
    "Prohibitory_SpeedLimitZone55End": 0,
    "Prohibitory_SpeedLimitZone55Begin": 0,
    "Prohibitory_SpeedLimitZone60End": 0,
    "Prohibitory_SpeedLimitZone60Begin": 27,
    "Prohibitory_SpeedLimitZone65End": 0,
    "Prohibitory_SpeedLimitZone65Begin": 0,
    "Prohibitory_SpeedLimitZone70End": 0,
    "Prohibitory_SpeedLimitZone70Begin": 7,
    "Prohibitory_SpeedLimitZone75End": 0,
    "Prohibitory_SpeedLimitZone75Begin": 1,
    "Prohibitory_SpeedLimitZone80Begin": 9,
    "Prohibitory_SpeedLimitZone80End": 0,
    "Prohibitory_SpeedLimitZone85End": 0,
    "Prohibitory_SpeedLimitZone85Begin": 1,
    "Prohibitory_SpeedLimitZone90Begin": 2,
    "Prohibitory_SpeedLimitZone90End": 0,
    "Prohibitory_SpeedLimitZone95Begin": 0,
    "Prohibitory_SpeedLimitZone95End": 0,
    "Prohibitory_SpeedLimitZone100End": 0,
    "Prohibitory_SpeedLimitZone100Begin": 5,
    "Prohibitory_SpeedLimitZone105End": 0,
    "Prohibitory_SpeedLimitZone105Begin": 0,
    "Prohibitory_SpeedLimitZone110End": 0,
    "Prohibitory_SpeedLimitZone110Begin": 0,
    "Prohibitory_SpeedLimitZone115Begin": 0,
    "Prohibitory_SpeedLimitZone115End": 0,
    "Prohibitory_SpeedLimitZone120Begin": 4,
    "Prohibitory_SpeedLimitZone120End": 0,
    "Prohibitory_SpeedLimitZone125Begin": 0,
    "Prohibitory_SpeedLimitZone125End": 0,
    "Prohibitory_SpeedLimitZone130End": 0,
    "Prohibitory_SpeedLimitZone130Begin": 0,
    "RoadType_MotorwayBegin": 161,
    "RoadType_MotorwayEnd": 100,
    "Special_VulnurableRoadUserCrossing": 31023,
    "Special_VulnurableRoadUserPathWay": 6673,
    "Warning_Animal": 294,
    "Warning_Children": 621,
    "Warning_CongestionAhead": 109,
    "Warning_Crossroads": 1061,
    "Warning_Crossing": 751,
    "Warning_Curve": 392,
    "Warning_Cyclists": 398,
    "Warning_DoubleCurve": 92,
    "Warning_GenericWarning": 2097,
    "Warning_MergingTraffic": 323,
    "Warning_RoadBump": 620,
    "Warning_RoadWorkEnd": 7,
    "Warning_RoadWorkBegin": 2485,
    "Warning_RoadNarrows": 841,
    "Warning_RoughRoad": 230,
    "Warning_Roundabout": 205,
    "Warning_Slippery": 149,
    "Warning_TrafficSignalAhead": 409,
    "Warning_TunnelAhead": 4,
    "Warning_TwoWayTraffic": 234,
}

VAL_SAMPLES_PER_CLASS_NAME = {
    "NotListed": 21851,
    "Indication_CameraSurveillance": 8,
    "Mandatory_PassOnEitherSide": 83,
    "Mandatory_PassOnThisSideLeft": 107,
    "Mandatory_PassOnThisSideRight": 1775,
    "Mandatory_ProceedStraight": 669,
    "Mandatory_ProceedStraightOrTurnRight": 147,
    "Mandatory_ProceedStraightOrTurnLeft": 62,
    "Mandatory_Roundabout": 183,
    "Mandatory_TurnAhead": 9,
    "Mandatory_TurnLeft": 26,
    "Mandatory_TurnLeftAhead": 127,
    "Mandatory_TurnRight": 94,
    "Mandatory_TurnRightAhead": 197,
    "Priority_GiveWayOncoming": 3,
    "Priority_GiveWay": 1798,
    "Priority_PriorityRoadBegin": 2026,
    "Priority_PriorityRoadEnd": 108,
    "Priority_PrioOverOncoming": 7,
    "Priority_Stop": 158,
    "Prohibitory_MaximumSpeedLimit5End": 0,
    "Prohibitory_MaximumSpeedLimit5Begin": 1,
    "Prohibitory_MaximumSpeedLimit10End": 0,
    "Prohibitory_MaximumSpeedLimit10Begin": 10,
    "Prohibitory_MaximumSpeedLimit15End": 0,
    "Prohibitory_MaximumSpeedLimit15Begin": 4,
    "Prohibitory_MaximumSpeedLimit20Begin": 19,
    "Prohibitory_MaximumSpeedLimit20End": 0,
    "Prohibitory_MaximumSpeedLimit25End": 0,
    "Prohibitory_MaximumSpeedLimit25Begin": 2,
    "Prohibitory_MaximumSpeedLimit30End": 11,
    "Prohibitory_MaximumSpeedLimit30Begin": 444,
    "Prohibitory_MaximumSpeedLimit35End": 0,
    "Prohibitory_MaximumSpeedLimit35Begin": 0,
    "Prohibitory_MaximumSpeedLimit40End": 0,
    "Prohibitory_MaximumSpeedLimit40Begin": 89,
    "Prohibitory_MaximumSpeedLimit45End": 0,
    "Prohibitory_MaximumSpeedLimit45Begin": 0,
    "Prohibitory_MaximumSpeedLimit50Begin": 192,
    "Prohibitory_MaximumSpeedLimit50End": 3,
    "Prohibitory_MaximumSpeedLimit55Begin": 0,
    "Prohibitory_MaximumSpeedLimit55End": 0,
    "Prohibitory_MaximumSpeedLimit60Begin": 89,
    "Prohibitory_MaximumSpeedLimit60End": 5,
    "Prohibitory_MaximumSpeedLimit65Begin": 0,
    "Prohibitory_MaximumSpeedLimit65End": 0,
    "Prohibitory_MaximumSpeedLimit70Begin": 276,
    "Prohibitory_MaximumSpeedLimit70End": 1,
    "Prohibitory_MaximumSpeedLimit75End": 0,
    "Prohibitory_MaximumSpeedLimit75Begin": 0,
    "Prohibitory_MaximumSpeedLimit80Begin": 69,
    "Prohibitory_MaximumSpeedLimit80End": 1,
    "Prohibitory_MaximumSpeedLimit85Begin": 0,
    "Prohibitory_MaximumSpeedLimit85End": 0,
    "Prohibitory_MaximumSpeedLimit90Begin": 67,
    "Prohibitory_MaximumSpeedLimit90End": 1,
    "Prohibitory_MaximumSpeedLimit95Begin": 0,
    "Prohibitory_MaximumSpeedLimit95End": 0,
    "Prohibitory_MaximumSpeedLimit100End": 1,
    "Prohibitory_MaximumSpeedLimit100Begin": 21,
    "Prohibitory_MaximumSpeedLimit105End": 0,
    "Prohibitory_MaximumSpeedLimit105Begin": 0,
    "Prohibitory_MaximumSpeedLimit110End": 0,
    "Prohibitory_MaximumSpeedLimit110Begin": 27,
    "Prohibitory_MaximumSpeedLimit115Begin": 0,
    "Prohibitory_MaximumSpeedLimit115End": 0,
    "Prohibitory_MaximumSpeedLimit120End": 2,
    "Prohibitory_MaximumSpeedLimit120Begin": 6,
    "Prohibitory_MaximumSpeedLimit125Begin": 0,
    "Prohibitory_MaximumSpeedLimit125End": 0,
    "Prohibitory_MaximumSpeedLimit130End": 0,
    "Prohibitory_MaximumSpeedLimit130Begin": 12,
    "Prohibitory_NoEntry": 1771,
    "Prohibitory_NoOvertakingBegin": 249,
    "Prohibitory_NoOvertakingEnd": 3,
    "Prohibitory_NoParking": 777,
    "Prohibitory_NoStopping": 1798,
    "Prohibitory_NoTurn": 379,
    "Prohibitory_NoUTurn": 94,
    "Prohibitory_RoadClosed": 158,
    "Prohibitory_SpeedLimitZone5End": 0,
    "Prohibitory_SpeedLimitZone5Begin": 0,
    "Prohibitory_SpeedLimitZone10Begin": 2,
    "Prohibitory_SpeedLimitZone10End": 0,
    "Prohibitory_SpeedLimitZone15End": 0,
    "Prohibitory_SpeedLimitZone15Begin": 0,
    "Prohibitory_SpeedLimitZone20Begin": 17,
    "Prohibitory_SpeedLimitZone20End": 1,
    "Prohibitory_SpeedLimitZone25End": 0,
    "Prohibitory_SpeedLimitZone25Begin": 0,
    "Prohibitory_SpeedLimitZone30End": 32,
    "Prohibitory_SpeedLimitZone30Begin": 173,
    "Prohibitory_SpeedLimitZone35End": 0,
    "Prohibitory_SpeedLimitZone35Begin": 0,
    "Prohibitory_SpeedLimitZone40End": 1,
    "Prohibitory_SpeedLimitZone40Begin": 6,
    "Prohibitory_SpeedLimitZone45Begin": 0,
    "Prohibitory_SpeedLimitZone45End": 0,
    "Prohibitory_SpeedLimitZone50Begin": 39,
    "Prohibitory_SpeedLimitZone50End": 9,
    "Prohibitory_SpeedLimitZone55End": 0,
    "Prohibitory_SpeedLimitZone55Begin": 0,
    "Prohibitory_SpeedLimitZone60End": 0,
    "Prohibitory_SpeedLimitZone60Begin": 0,
    "Prohibitory_SpeedLimitZone65End": 0,
    "Prohibitory_SpeedLimitZone65Begin": 0,
    "Prohibitory_SpeedLimitZone70End": 0,
    "Prohibitory_SpeedLimitZone70Begin": 0,
    "Prohibitory_SpeedLimitZone75End": 0,
    "Prohibitory_SpeedLimitZone75Begin": 0,
    "Prohibitory_SpeedLimitZone80Begin": 0,
    "Prohibitory_SpeedLimitZone80End": 0,
    "Prohibitory_SpeedLimitZone85End": 0,
    "Prohibitory_SpeedLimitZone85Begin": 0,
    "Prohibitory_SpeedLimitZone90Begin": 0,
    "Prohibitory_SpeedLimitZone90End": 0,
    "Prohibitory_SpeedLimitZone95Begin": 0,
    "Prohibitory_SpeedLimitZone95End": 0,
    "Prohibitory_SpeedLimitZone100End": 0,
    "Prohibitory_SpeedLimitZone100Begin": 0,
    "Prohibitory_SpeedLimitZone105End": 0,
    "Prohibitory_SpeedLimitZone105Begin": 0,
    "Prohibitory_SpeedLimitZone110End": 0,
    "Prohibitory_SpeedLimitZone110Begin": 0,
    "Prohibitory_SpeedLimitZone115Begin": 0,
    "Prohibitory_SpeedLimitZone115End": 0,
    "Prohibitory_SpeedLimitZone120Begin": 0,
    "Prohibitory_SpeedLimitZone120End": 0,
    "Prohibitory_SpeedLimitZone125Begin": 0,
    "Prohibitory_SpeedLimitZone125End": 0,
    "Prohibitory_SpeedLimitZone130End": 0,
    "Prohibitory_SpeedLimitZone130Begin": 0,
    "RoadType_MotorwayBegin": 32,
    "RoadType_MotorwayEnd": 11,
    "Special_VulnurableRoadUserCrossing": 2991,
    "Special_VulnurableRoadUserPathWay": 681,
    "Warning_Animal": 32,
    "Warning_Children": 91,
    "Warning_CongestionAhead": 12,
    "Warning_Crossroads": 173,
    "Warning_Crossing": 78,
    "Warning_Curve": 50,
    "Warning_Cyclists": 37,
    "Warning_DoubleCurve": 17,
    "Warning_GenericWarning": 164,
    "Warning_MergingTraffic": 32,
    "Warning_RoadBump": 78,
    "Warning_RoadWorkEnd": 0,
    "Warning_RoadWorkBegin": 299,
    "Warning_RoadNarrows": 81,
    "Warning_RoughRoad": 34,
    "Warning_Roundabout": 16,
    "Warning_Slippery": 26,
    "Warning_TrafficSignalAhead": 31,
    "Warning_TunnelAhead": 1,
    "Warning_TwoWayTraffic": 41,
}

N_VAL_SAMPLES_LOWER_BOUND = 10

CLASSES_USED_FOR_VALIDATION = [
    name for name, count in VAL_SAMPLES_PER_CLASS_NAME.items() if count >= N_VAL_SAMPLES_LOWER_BOUND
]


def get_class_name(class_idx: int) -> str:
    """Get class name from class index."""
    if class_idx not in CLASS_IDX_TO_CLASS_NAME:
        raise ValueError(f"Unknown class index: {class_idx}")
    return CLASS_IDX_TO_CLASS_NAME.get(class_idx)


def get_class_idx(class_name: str) -> int:
    """Get class index from class name."""
    if class_name not in CLASS_NAME_TO_CLASS_IDX:
        raise ValueError(f"Unknown class name: {class_name}")
    return CLASS_NAME_TO_CLASS_IDX.get(class_name)
