"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return redis_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new redis_generated_1.RosInstance(this, id, {
            connections: props.connections,
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            evictionPolicy: props.evictionPolicy,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            productType: props.productType,
            instanceMaintainTime: props.instanceMaintainTime,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            autoRenewDuration: props.autoRenewDuration,
            instanceName: props.instanceName,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            vpcId: props.vpcId,
            sslEnabled: props.sslEnabled,
            capacity: props.capacity,
            chargeType: props.chargeType,
            tags: props.tags,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrArchitectureType = rosInstance.attrArchitectureType;
        this.attrBandwidth = rosInstance.attrBandwidth;
        this.attrCapacity = rosInstance.attrCapacity;
        this.attrChargeType = rosInstance.attrChargeType;
        this.attrClassicInnerConnectionPort = rosInstance.attrClassicInnerConnectionPort;
        this.attrClassicInnerConnectionString = rosInstance.attrClassicInnerConnectionString;
        this.attrConnectionDomain = rosInstance.attrConnectionDomain;
        this.attrConnections = rosInstance.attrConnections;
        this.attrDirectConnectionPort = rosInstance.attrDirectConnectionPort;
        this.attrDirectConnectionString = rosInstance.attrDirectConnectionString;
        this.attrEngineVersion = rosInstance.attrEngineVersion;
        this.attrHasRenewChangeOrder = rosInstance.attrHasRenewChangeOrder;
        this.attrInstanceClass = rosInstance.attrInstanceClass;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrInstanceType = rosInstance.attrInstanceType;
        this.attrNetworkType = rosInstance.attrNetworkType;
        this.attrNodeType = rosInstance.attrNodeType;
        this.attrOrderId = rosInstance.attrOrderId;
        this.attrPackageType = rosInstance.attrPackageType;
        this.attrPort = rosInstance.attrPort;
        this.attrPrivateIp = rosInstance.attrPrivateIp;
        this.attrPublicConnectionPort = rosInstance.attrPublicConnectionPort;
        this.attrPublicConnectionString = rosInstance.attrPublicConnectionString;
        this.attrQps = rosInstance.attrQps;
        this.attrResourceGroupId = rosInstance.attrResourceGroupId;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
        this.attrVpcId = rosInstance.attrVpcId;
        this.attrVpcPrivateConnectionPort = rosInstance.attrVpcPrivateConnectionPort;
        this.attrVpcPrivateConnectionString = rosInstance.attrVpcPrivateConnectionString;
        this.attrZoneId = rosInstance.attrZoneId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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