# coding: utf-8

"""
    RAWG Video Games Database API

     The largest open video games database.  ### Why build on RAWG - More than 350,000 games for 50 platforms including mobiles. - Rich metadata: tags, genres, developers, publishers, individual creators, official websites, release dates, Metacritic ratings. - Where to buy: links to digital distribution services - Similar games based on visual similarity. - Player activity data: Steam average playtime and RAWG player counts and ratings. - Actively developing and constantly getting better by user contribution and our algorithms.  ### Terms of Use - Free for personal use as long as you attribute RAWG as the source of the data and/or images and add an active hyperlink from every page where the data of RAWG is used. - Free for commercial use for startups and hobby projects with not more than 100,000 monthly active users or 500,000 page views per month. If your project is larger than that, email us at [api@rawg.io](mailto:api@rawg.io) for commercial terms. - No cloning. It would not be cool if you used our API to launch a clone of RAWG. We know it is not always easy to say what is a duplicate and what isn't. Drop us a line at [api@rawg.io](mailto:api@rawg.io) if you are in doubt, and we will talk it through. - Every API request should have a User-Agent header with your app name. If you don’t provide it, we may ban your requests.  __[Read more](https://rawg.io/apidocs)__.   # noqa: E501

    The version of the OpenAPI document: v1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from rawg.configuration import Configuration


class Reddit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'text': 'str',
        'image': 'str',
        'url': 'str',
        'username': 'str',
        'username_url': 'str',
        'created': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'text': 'text',
        'image': 'image',
        'url': 'url',
        'username': 'username',
        'username_url': 'username_url',
        'created': 'created'
    }

    def __init__(self, id=None, name=None, text=None, image=None, url=None, username=None, username_url=None, created=None, local_vars_configuration=None):  # noqa: E501
        """Reddit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._text = None
        self._image = None
        self._url = None
        self._username = None
        self._username_url = None
        self._created = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if text is not None:
            self.text = text
        if image is not None:
            self.image = image
        if url is not None:
            self.url = url
        if username is not None:
            self.username = username
        if username_url is not None:
            self.username_url = username_url
        if created is not None:
            self.created = created

    @property
    def id(self):
        """Gets the id of this Reddit.  # noqa: E501


        :return: The id of this Reddit.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Reddit.


        :param id: The id of this Reddit.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Reddit.  # noqa: E501


        :return: The name of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Reddit.


        :param name: The name of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def text(self):
        """Gets the text of this Reddit.  # noqa: E501


        :return: The text of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this Reddit.


        :param text: The text of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                text is not None and len(text) < 1):
            raise ValueError("Invalid value for `text`, length must be greater than or equal to `1`")  # noqa: E501

        self._text = text

    @property
    def image(self):
        """Gets the image of this Reddit.  # noqa: E501


        :return: The image of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this Reddit.


        :param image: The image of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                image is not None and len(image) < 1):
            raise ValueError("Invalid value for `image`, length must be greater than or equal to `1`")  # noqa: E501

        self._image = image

    @property
    def url(self):
        """Gets the url of this Reddit.  # noqa: E501


        :return: The url of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Reddit.


        :param url: The url of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) < 1):
            raise ValueError("Invalid value for `url`, length must be greater than or equal to `1`")  # noqa: E501

        self._url = url

    @property
    def username(self):
        """Gets the username of this Reddit.  # noqa: E501


        :return: The username of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this Reddit.


        :param username: The username of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) < 1):
            raise ValueError("Invalid value for `username`, length must be greater than or equal to `1`")  # noqa: E501

        self._username = username

    @property
    def username_url(self):
        """Gets the username_url of this Reddit.  # noqa: E501


        :return: The username_url of this Reddit.  # noqa: E501
        :rtype: str
        """
        return self._username_url

    @username_url.setter
    def username_url(self, username_url):
        """Sets the username_url of this Reddit.


        :param username_url: The username_url of this Reddit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                username_url is not None and len(username_url) < 1):
            raise ValueError("Invalid value for `username_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._username_url = username_url

    @property
    def created(self):
        """Gets the created of this Reddit.  # noqa: E501


        :return: The created of this Reddit.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Reddit.


        :param created: The created of this Reddit.  # noqa: E501
        :type: datetime
        """

        self._created = created

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Reddit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Reddit):
            return True

        return self.to_dict() != other.to_dict()
