# coding: utf-8

"""
    RAWG Video Games Database API

     The largest open video games database.  ### Why build on RAWG - More than 350,000 games for 50 platforms including mobiles. - Rich metadata: tags, genres, developers, publishers, individual creators, official websites, release dates, Metacritic ratings. - Where to buy: links to digital distribution services - Similar games based on visual similarity. - Player activity data: Steam average playtime and RAWG player counts and ratings. - Actively developing and constantly getting better by user contribution and our algorithms.  ### Terms of Use - Free for personal use as long as you attribute RAWG as the source of the data and/or images and add an active hyperlink from every page where the data of RAWG is used. - Free for commercial use for startups and hobby projects with not more than 100,000 monthly active users or 500,000 page views per month. If your project is larger than that, email us at [api@rawg.io](mailto:api@rawg.io) for commercial terms. - No cloning. It would not be cool if you used our API to launch a clone of RAWG. We know it is not always easy to say what is a duplicate and what isn't. Drop us a line at [api@rawg.io](mailto:api@rawg.io) if you are in doubt, and we will talk it through. - Every API request should have a User-Agent header with your app name. If you don’t provide it, we may ban your requests.  __[Read more](https://rawg.io/apidocs)__.   # noqa: E501

    The version of the OpenAPI document: v1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from rawg.configuration import Configuration


class GameStoreFull(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'game_id': 'str',
        'store_id': 'str',
        'url': 'str'
    }

    attribute_map = {
        'id': 'id',
        'game_id': 'game_id',
        'store_id': 'store_id',
        'url': 'url'
    }

    def __init__(self, id=None, game_id=None, store_id=None, url=None, local_vars_configuration=None):  # noqa: E501
        """GameStoreFull - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._game_id = None
        self._store_id = None
        self._url = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if game_id is not None:
            self.game_id = game_id
        if store_id is not None:
            self.store_id = store_id
        self.url = url

    @property
    def id(self):
        """Gets the id of this GameStoreFull.  # noqa: E501


        :return: The id of this GameStoreFull.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GameStoreFull.


        :param id: The id of this GameStoreFull.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def game_id(self):
        """Gets the game_id of this GameStoreFull.  # noqa: E501


        :return: The game_id of this GameStoreFull.  # noqa: E501
        :rtype: str
        """
        return self._game_id

    @game_id.setter
    def game_id(self, game_id):
        """Sets the game_id of this GameStoreFull.


        :param game_id: The game_id of this GameStoreFull.  # noqa: E501
        :type: str
        """

        self._game_id = game_id

    @property
    def store_id(self):
        """Gets the store_id of this GameStoreFull.  # noqa: E501


        :return: The store_id of this GameStoreFull.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this GameStoreFull.


        :param store_id: The store_id of this GameStoreFull.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def url(self):
        """Gets the url of this GameStoreFull.  # noqa: E501


        :return: The url of this GameStoreFull.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this GameStoreFull.


        :param url: The url of this GameStoreFull.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) > 500):
            raise ValueError("Invalid value for `url`, length must be less than or equal to `500`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) < 1):
            raise ValueError("Invalid value for `url`, length must be greater than or equal to `1`")  # noqa: E501

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GameStoreFull):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GameStoreFull):
            return True

        return self.to_dict() != other.to_dict()
