# coding: utf-8

"""
    RAWG Video Games Database API

     The largest open video games database.  ### Why build on RAWG - More than 350,000 games for 50 platforms including mobiles. - Rich metadata: tags, genres, developers, publishers, individual creators, official websites, release dates, Metacritic ratings. - Where to buy: links to digital distribution services - Similar games based on visual similarity. - Player activity data: Steam average playtime and RAWG player counts and ratings. - Actively developing and constantly getting better by user contribution and our algorithms.  ### Terms of Use - Free for personal use as long as you attribute RAWG as the source of the data and/or images and add an active hyperlink from every page where the data of RAWG is used. - Free for commercial use for startups and hobby projects with not more than 100,000 monthly active users or 500,000 page views per month. If your project is larger than that, email us at [api@rawg.io](mailto:api@rawg.io) for commercial terms. - No cloning. It would not be cool if you used our API to launch a clone of RAWG. We know it is not always easy to say what is a duplicate and what isn't. Drop us a line at [api@rawg.io](mailto:api@rawg.io) if you are in doubt, and we will talk it through. - Every API request should have a User-Agent header with your app name. If you don’t provide it, we may ban your requests.  __[Read more](https://rawg.io/apidocs)__.   # noqa: E501

    The version of the OpenAPI document: v1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from rawg.configuration import Configuration


class Game(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'slug': 'str',
        'name': 'str',
        'released': 'date',
        'tba': 'bool',
        'background_image': 'str',
        'rating': 'float',
        'rating_top': 'int',
        'ratings': 'object',
        'ratings_count': 'int',
        'reviews_text_count': 'str',
        'added': 'int',
        'added_by_status': 'object',
        'metacritic': 'int',
        'playtime': 'int',
        'suggestions_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'slug': 'slug',
        'name': 'name',
        'released': 'released',
        'tba': 'tba',
        'background_image': 'background_image',
        'rating': 'rating',
        'rating_top': 'rating_top',
        'ratings': 'ratings',
        'ratings_count': 'ratings_count',
        'reviews_text_count': 'reviews_text_count',
        'added': 'added',
        'added_by_status': 'added_by_status',
        'metacritic': 'metacritic',
        'playtime': 'playtime',
        'suggestions_count': 'suggestions_count'
    }

    def __init__(self, id=None, slug=None, name=None, released=None, tba=None, background_image=None, rating=None, rating_top=None, ratings=None, ratings_count=None, reviews_text_count=None, added=None, added_by_status=None, metacritic=None, playtime=None, suggestions_count=None, local_vars_configuration=None):  # noqa: E501
        """Game - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._slug = None
        self._name = None
        self._released = None
        self._tba = None
        self._background_image = None
        self._rating = None
        self._rating_top = None
        self._ratings = None
        self._ratings_count = None
        self._reviews_text_count = None
        self._added = None
        self._added_by_status = None
        self._metacritic = None
        self._playtime = None
        self._suggestions_count = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if slug is not None:
            self.slug = slug
        if name is not None:
            self.name = name
        if released is not None:
            self.released = released
        if tba is not None:
            self.tba = tba
        if background_image is not None:
            self.background_image = background_image
        self.rating = rating
        if rating_top is not None:
            self.rating_top = rating_top
        if ratings is not None:
            self.ratings = ratings
        if ratings_count is not None:
            self.ratings_count = ratings_count
        if reviews_text_count is not None:
            self.reviews_text_count = reviews_text_count
        if added is not None:
            self.added = added
        if added_by_status is not None:
            self.added_by_status = added_by_status
        if metacritic is not None:
            self.metacritic = metacritic
        if playtime is not None:
            self.playtime = playtime
        if suggestions_count is not None:
            self.suggestions_count = suggestions_count

    @property
    def id(self):
        """Gets the id of this Game.  # noqa: E501


        :return: The id of this Game.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Game.


        :param id: The id of this Game.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def slug(self):
        """Gets the slug of this Game.  # noqa: E501


        :return: The slug of this Game.  # noqa: E501
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this Game.


        :param slug: The slug of this Game.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                slug is not None and len(slug) < 1):
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                slug is not None and not re.search(r'^[-a-zA-Z0-9_]+$', slug)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug = slug

    @property
    def name(self):
        """Gets the name of this Game.  # noqa: E501


        :return: The name of this Game.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Game.


        :param name: The name of this Game.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def released(self):
        """Gets the released of this Game.  # noqa: E501


        :return: The released of this Game.  # noqa: E501
        :rtype: date
        """
        return self._released

    @released.setter
    def released(self, released):
        """Sets the released of this Game.


        :param released: The released of this Game.  # noqa: E501
        :type: date
        """

        self._released = released

    @property
    def tba(self):
        """Gets the tba of this Game.  # noqa: E501


        :return: The tba of this Game.  # noqa: E501
        :rtype: bool
        """
        return self._tba

    @tba.setter
    def tba(self, tba):
        """Sets the tba of this Game.


        :param tba: The tba of this Game.  # noqa: E501
        :type: bool
        """

        self._tba = tba

    @property
    def background_image(self):
        """Gets the background_image of this Game.  # noqa: E501


        :return: The background_image of this Game.  # noqa: E501
        :rtype: str
        """
        return self._background_image

    @background_image.setter
    def background_image(self, background_image):
        """Sets the background_image of this Game.


        :param background_image: The background_image of this Game.  # noqa: E501
        :type: str
        """

        self._background_image = background_image

    @property
    def rating(self):
        """Gets the rating of this Game.  # noqa: E501


        :return: The rating of this Game.  # noqa: E501
        :rtype: float
        """
        return self._rating

    @rating.setter
    def rating(self, rating):
        """Sets the rating of this Game.


        :param rating: The rating of this Game.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and rating is None:  # noqa: E501
            raise ValueError("Invalid value for `rating`, must not be `None`")  # noqa: E501

        self._rating = rating

    @property
    def rating_top(self):
        """Gets the rating_top of this Game.  # noqa: E501


        :return: The rating_top of this Game.  # noqa: E501
        :rtype: int
        """
        return self._rating_top

    @rating_top.setter
    def rating_top(self, rating_top):
        """Sets the rating_top of this Game.


        :param rating_top: The rating_top of this Game.  # noqa: E501
        :type: int
        """

        self._rating_top = rating_top

    @property
    def ratings(self):
        """Gets the ratings of this Game.  # noqa: E501


        :return: The ratings of this Game.  # noqa: E501
        :rtype: object
        """
        return self._ratings

    @ratings.setter
    def ratings(self, ratings):
        """Sets the ratings of this Game.


        :param ratings: The ratings of this Game.  # noqa: E501
        :type: object
        """

        self._ratings = ratings

    @property
    def ratings_count(self):
        """Gets the ratings_count of this Game.  # noqa: E501


        :return: The ratings_count of this Game.  # noqa: E501
        :rtype: int
        """
        return self._ratings_count

    @ratings_count.setter
    def ratings_count(self, ratings_count):
        """Sets the ratings_count of this Game.


        :param ratings_count: The ratings_count of this Game.  # noqa: E501
        :type: int
        """

        self._ratings_count = ratings_count

    @property
    def reviews_text_count(self):
        """Gets the reviews_text_count of this Game.  # noqa: E501


        :return: The reviews_text_count of this Game.  # noqa: E501
        :rtype: str
        """
        return self._reviews_text_count

    @reviews_text_count.setter
    def reviews_text_count(self, reviews_text_count):
        """Sets the reviews_text_count of this Game.


        :param reviews_text_count: The reviews_text_count of this Game.  # noqa: E501
        :type: str
        """

        self._reviews_text_count = reviews_text_count

    @property
    def added(self):
        """Gets the added of this Game.  # noqa: E501


        :return: The added of this Game.  # noqa: E501
        :rtype: int
        """
        return self._added

    @added.setter
    def added(self, added):
        """Sets the added of this Game.


        :param added: The added of this Game.  # noqa: E501
        :type: int
        """

        self._added = added

    @property
    def added_by_status(self):
        """Gets the added_by_status of this Game.  # noqa: E501


        :return: The added_by_status of this Game.  # noqa: E501
        :rtype: object
        """
        return self._added_by_status

    @added_by_status.setter
    def added_by_status(self, added_by_status):
        """Sets the added_by_status of this Game.


        :param added_by_status: The added_by_status of this Game.  # noqa: E501
        :type: object
        """

        self._added_by_status = added_by_status

    @property
    def metacritic(self):
        """Gets the metacritic of this Game.  # noqa: E501


        :return: The metacritic of this Game.  # noqa: E501
        :rtype: int
        """
        return self._metacritic

    @metacritic.setter
    def metacritic(self, metacritic):
        """Sets the metacritic of this Game.


        :param metacritic: The metacritic of this Game.  # noqa: E501
        :type: int
        """

        self._metacritic = metacritic

    @property
    def playtime(self):
        """Gets the playtime of this Game.  # noqa: E501

        in hours  # noqa: E501

        :return: The playtime of this Game.  # noqa: E501
        :rtype: int
        """
        return self._playtime

    @playtime.setter
    def playtime(self, playtime):
        """Sets the playtime of this Game.

        in hours  # noqa: E501

        :param playtime: The playtime of this Game.  # noqa: E501
        :type: int
        """

        self._playtime = playtime

    @property
    def suggestions_count(self):
        """Gets the suggestions_count of this Game.  # noqa: E501


        :return: The suggestions_count of this Game.  # noqa: E501
        :rtype: int
        """
        return self._suggestions_count

    @suggestions_count.setter
    def suggestions_count(self, suggestions_count):
        """Sets the suggestions_count of this Game.


        :param suggestions_count: The suggestions_count of this Game.  # noqa: E501
        :type: int
        """

        self._suggestions_count = suggestions_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Game):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Game):
            return True

        return self.to_dict() != other.to_dict()
