# coding: utf-8

# flake8: noqa

"""
    RAWG Video Games Database API

     The largest open video games database.  ### Why build on RAWG - More than 350,000 games for 50 platforms including mobiles. - Rich metadata: tags, genres, developers, publishers, individual creators, official websites, release dates, Metacritic ratings. - Where to buy: links to digital distribution services - Similar games based on visual similarity. - Player activity data: Steam average playtime and RAWG player counts and ratings. - Actively developing and constantly getting better by user contribution and our algorithms.  ### Terms of Use - Free for personal use as long as you attribute RAWG as the source of the data and/or images and add an active hyperlink from every page where the data of RAWG is used. - Free for commercial use for startups and hobby projects with not more than 100,000 monthly active users or 500,000 page views per month. If your project is larger than that, email us at [api@rawg.io](mailto:api@rawg.io) for commercial terms. - No cloning. It would not be cool if you used our API to launch a clone of RAWG. We know it is not always easy to say what is a duplicate and what isn't. Drop us a line at [api@rawg.io](mailto:api@rawg.io) if you are in doubt, and we will talk it through. - Every API request should have a User-Agent header with your app name. If you don’t provide it, we may ban your requests.  __[Read more](https://rawg.io/apidocs)__.   # noqa: E501

    The version of the OpenAPI document: v1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

# import apis into sdk package
from rawg.api.creator_roles_api import CreatorRolesApi
from rawg.api.creators_api import CreatorsApi
from rawg.api.developers_api import DevelopersApi
from rawg.api.games_api import GamesApi
from rawg.api.genres_api import GenresApi
from rawg.api.platforms_api import PlatformsApi
from rawg.api.publishers_api import PublishersApi
from rawg.api.stores_api import StoresApi
from rawg.api.tags_api import TagsApi

# import ApiClient
from rawg.api_client import ApiClient
from rawg.configuration import Configuration
from rawg.exceptions import OpenApiException
from rawg.exceptions import ApiTypeError
from rawg.exceptions import ApiValueError
from rawg.exceptions import ApiKeyError
from rawg.exceptions import ApiException
# import models into sdk package
from rawg.models.added_by_status import AddedByStatus
from rawg.models.data import Data
from rawg.models.developer import Developer
from rawg.models.developer_single import DeveloperSingle
from rawg.models.game import Game
from rawg.models.game_person_list import GamePersonList
from rawg.models.game_platform_metacritic import GamePlatformMetacritic
from rawg.models.game_single import GameSingle
from rawg.models.game_store_full import GameStoreFull
from rawg.models.genre import Genre
from rawg.models.genre_single import GenreSingle
from rawg.models.inline_response200 import InlineResponse200
from rawg.models.inline_response2001 import InlineResponse2001
from rawg.models.inline_response20010 import InlineResponse20010
from rawg.models.inline_response20011 import InlineResponse20011
from rawg.models.inline_response20012 import InlineResponse20012
from rawg.models.inline_response20013 import InlineResponse20013
from rawg.models.inline_response2002 import InlineResponse2002
from rawg.models.inline_response2003 import InlineResponse2003
from rawg.models.inline_response2004 import InlineResponse2004
from rawg.models.inline_response2005 import InlineResponse2005
from rawg.models.inline_response2006 import InlineResponse2006
from rawg.models.inline_response2007 import InlineResponse2007
from rawg.models.inline_response2008 import InlineResponse2008
from rawg.models.inline_response2009 import InlineResponse2009
from rawg.models.movie import Movie
from rawg.models.parent_achievement import ParentAchievement
from rawg.models.person import Person
from rawg.models.person_single import PersonSingle
from rawg.models.platform import Platform
from rawg.models.platform_parent_single import PlatformParentSingle
from rawg.models.platform_single import PlatformSingle
from rawg.models.position import Position
from rawg.models.publisher import Publisher
from rawg.models.publisher_single import PublisherSingle
from rawg.models.ratings import Ratings
from rawg.models.reactions import Reactions
from rawg.models.reddit import Reddit
from rawg.models.screen_shot import ScreenShot
from rawg.models.store import Store
from rawg.models.store_single import StoreSingle
from rawg.models.tag import Tag
from rawg.models.tag_single import TagSingle
from rawg.models.thumbnails import Thumbnails
from rawg.models.twitch import Twitch
from rawg.models.youtube import Youtube
