import { Construct } from "constructs";
import { CIATriad } from "./cia-triad";
import { Resource, ResourceProps } from "./resource";
import * as spec from "./spec/threatgile.generated";
import { Usage } from "./usage";
export interface DataAssetProps extends ResourceProps {
    readonly usage: Usage;
    readonly tags?: string[];
    readonly origin?: string;
    readonly owner?: string;
    readonly quantity: Quantity;
    readonly ciaTriad: CIATriad;
}
export declare class DataAsset extends Resource {
    readonly usage: Usage;
    readonly tags?: string[];
    readonly origin?: string;
    readonly owner?: string;
    readonly quantity: Quantity;
    readonly ciaTriad: CIATriad;
    constructor(scope: Construct, id: string, props: DataAssetProps);
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["data_assets"];
}
export declare enum Quantity {
    VERY_FEW = "very-few",
    FEW = "few",
    MANY = "many",
    VERY_MANY = "very-many"
}
