"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PingCommand = void 0;
const threagile_1 = require("../api/threagile");
class PingCommand {
    constructor() {
        this.command = "ping";
        this.describe = "ping the api";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            try {
                const resp = await api.ping();
                if (resp.status === 200) {
                    console.log(`✅  ${resp.data.message}\n`);
                }
                else {
                    console.log("❌  Error\n");
                }
            }
            catch (e) {
                console.log(`❌  ${e.message}`);
            }
        };
    }
}
exports.PingCommand = PingCommand;
//# sourceMappingURL=data:application/json;base64,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