"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dotenv_1 = require("dotenv");
const yargs = require("yargs");
const analyze_1 = require("./analyze");
const check_1 = require("./check");
const ping_1 = require("./ping");
const synth_1 = require("./synth");
async function main() {
    dotenv_1.config(); //.env
    const ya = yargs;
    ya.command(new synth_1.SynthCommand());
    ya.command(new ping_1.PingCommand());
    ya.command(new check_1.CheckCommand());
    ya.command(new analyze_1.AnalyzeCommand());
    ya.recommendCommands();
    ya.strictCommands();
    ya.showHelpOnFail(false);
    ya.completion();
    ya.help();
    // do not use the default yargs '--version' implementation since it is
    // global by default (it appears on all subcommands)
    ya.version(false);
    ya.option("version", {
        type: "boolean",
        description: "Show version number",
        global: false,
    });
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = "true";
    }
}
main().catch((e) => {
    console.error(e.message);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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