"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckCommand = void 0;
const path = require("path");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class CheckCommand {
    constructor() {
        this.command = "check";
        this.describe = "check the models";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(".cdktg.out");
            for (const k in manifest.models) {
                try {
                    const modelManifest = manifest.models[k];
                    const resp = await api.check(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                    console.log(`Results for model "${modelManifest.name}":`);
                    if (resp.status === 200) {
                        console.log(`✅  ${resp.data.message}\n`);
                    }
                    else {
                        console.log(`❌  ${resp.data.message}\n`);
                    }
                }
                catch (e) {
                    console.log(`❌  ${e.message}`);
                }
            }
        };
    }
}
exports.CheckCommand = CheckCommand;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hlY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY2xpL2NoZWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZCQUE2QjtBQUc3QixnREFBNkM7QUFDN0MsMENBQXVDO0FBTXZDLE1BQWEsWUFBWTtJQUF6QjtRQUdTLFlBQU8sR0FBRyxPQUFPLENBQUM7UUFDbEIsYUFBUSxHQUFHLGtCQUFrQixDQUFDO1FBRXJDLFlBQU8sR0FBRyxDQUFDLElBQVUsRUFBVyxFQUFFO1lBQ2hDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLFFBQVEsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1lBRWpFLE9BQU8sSUFBMEIsQ0FBQztRQUNwQyxDQUFDLENBQUM7UUFFSyxZQUFPLEdBQUcsS0FBSyxFQUFFLElBQWtCLEVBQUUsRUFBRTtZQUM1QyxNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsd0JBQXdCLENBQUM7WUFFN0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxxQkFBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBRS9CLE1BQU0sUUFBUSxHQUFHLG1CQUFRLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBRWpELEtBQUssTUFBTSxDQUFDLElBQUksUUFBUSxDQUFDLE1BQU0sRUFBRTtnQkFDL0IsSUFBSTtvQkFDRixNQUFNLGFBQWEsR0FBRyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUV6QyxNQUFNLElBQUksR0FBRyxNQUFNLEdBQUcsQ0FBQyxLQUFLLENBQzFCLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLGFBQWEsQ0FBQyxvQkFBb0IsQ0FBQyxDQUM1RCxDQUFDO29CQUVGLE9BQU8sQ0FBQyxHQUFHLENBQUMsc0JBQXNCLGFBQWEsQ0FBQyxJQUFJLElBQUksQ0FBQyxDQUFDO29CQUUxRCxJQUFJLElBQUksQ0FBQyxNQUFNLEtBQUssR0FBRyxFQUFFO3dCQUN2QixPQUFPLENBQUMsR0FBRyxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLElBQUksQ0FBQyxDQUFDO3FCQUMxQzt5QkFBTTt3QkFDTCxPQUFPLENBQUMsR0FBRyxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLElBQUksQ0FBQyxDQUFDO3FCQUMxQztpQkFDRjtnQkFBQyxPQUFPLENBQUMsRUFBRTtvQkFDVixPQUFPLENBQUMsR0FBRyxDQUFDLE1BQU8sQ0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7aUJBQzNDO2FBQ0Y7UUFDSCxDQUFDLENBQUM7SUFDSixDQUFDO0NBQUE7QUF2Q0Qsb0NBdUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgQ29tbWFuZE1vZHVsZSwgQXJndW1lbnRzLCBBcmd2LCBPcHRpb25zIH0gZnJvbSBcInlhcmdzXCI7XG5cbmltcG9ydCB7IFRocmVhZ2lsZSB9IGZyb20gXCIuLi9hcGkvdGhyZWFnaWxlXCI7XG5pbXBvcnQgeyBNYW5pZmVzdCB9IGZyb20gXCIuLi9tYW5pZmVzdFwiO1xuXG5pbnRlcmZhY2UgQ2hlY2tPcHRpb25zIGV4dGVuZHMgT3B0aW9ucyB7XG4gIHVybDogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQ2hlY2tDb21tYW5kPFUgZXh0ZW5kcyBDaGVja09wdGlvbnM+XG4gIGltcGxlbWVudHMgQ29tbWFuZE1vZHVsZTx7fSwgVT5cbntcbiAgcHVibGljIGNvbW1hbmQgPSBcImNoZWNrXCI7XG4gIHB1YmxpYyBkZXNjcmliZSA9IFwiY2hlY2sgdGhlIG1vZGVsc1wiO1xuXG4gIGJ1aWxkZXIgPSAoYXJnczogQXJndik6IEFyZ3Y8VT4gPT4ge1xuICAgIGFyZ3Mub3B0aW9uKFwidXJsXCIsIHsgdHlwZTogXCJzdHJpbmdcIiwgYWxpYXM6IFwidVwiLCBkZXNjcmliZTogXCJcIiB9KTtcblxuICAgIHJldHVybiBhcmdzIGFzIHVua25vd24gYXMgQXJndjxVPjtcbiAgfTtcblxuICBwdWJsaWMgaGFuZGxlciA9IGFzeW5jIChhcmdzOiBBcmd1bWVudHM8VT4pID0+IHtcbiAgICBjb25zdCB1cmwgPSBhcmdzLnVybCA/PyBwcm9jZXNzLmVudi5DREtUR19USFJFQUdJTEVfQkFTRV9VUkw7XG5cbiAgICBjb25zdCBhcGkgPSBuZXcgVGhyZWFnaWxlKHVybCk7XG5cbiAgICBjb25zdCBtYW5pZmVzdCA9IE1hbmlmZXN0LmZyb21QYXRoKFwiLmNka3RnLm91dFwiKTtcblxuICAgIGZvciAoY29uc3QgayBpbiBtYW5pZmVzdC5tb2RlbHMpIHtcbiAgICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IG1vZGVsTWFuaWZlc3QgPSBtYW5pZmVzdC5tb2RlbHNba107XG5cbiAgICAgICAgY29uc3QgcmVzcCA9IGF3YWl0IGFwaS5jaGVjayhcbiAgICAgICAgICBwYXRoLmpvaW4oXCIuY2RrdGcub3V0XCIsIG1vZGVsTWFuaWZlc3Quc3ludGhlc2l6ZWRNb2RlbFBhdGgpXG4gICAgICAgICk7XG5cbiAgICAgICAgY29uc29sZS5sb2coYFJlc3VsdHMgZm9yIG1vZGVsIFwiJHttb2RlbE1hbmlmZXN0Lm5hbWV9XCI6YCk7XG5cbiAgICAgICAgaWYgKHJlc3Auc3RhdHVzID09PSAyMDApIHtcbiAgICAgICAgICBjb25zb2xlLmxvZyhg4pyFICAke3Jlc3AuZGF0YS5tZXNzYWdlfVxcbmApO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGNvbnNvbGUubG9nKGDinYwgICR7cmVzcC5kYXRhLm1lc3NhZ2V9XFxuYCk7XG4gICAgICAgIH1cbiAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgY29uc29sZS5sb2coYOKdjCAgJHsoZSBhcyBFcnJvcikubWVzc2FnZX1gKTtcbiAgICAgIH1cbiAgICB9XG4gIH07XG59XG4iXX0=