/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.File;
import java.util.ArrayList;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.AccessAgentCaller;
import uk.ac.cam.cares.jps.base.query.JenaHelper;
import uk.ac.cam.cares.jps.base.query.JenaResultSetFormatter;
import uk.ac.cam.cares.jps.base.query.ResourcePathConverter;
import uk.ac.cam.cares.jps.base.scenario.BucketHelper;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;
import uk.ac.cam.cares.jps.base.scenario.ScenarioClient;
import uk.ac.cam.cares.jps.base.scenario.ScenarioHelper;
import uk.ac.cam.cares.jps.base.util.FileUtil;

@Deprecated
public class QueryBroker {
    private static final Logger LOGGER = LogManager.getLogger(QueryBroker.class);

    public String readFile(String url) {
        if (!url.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must be a URL");
        }
        String result = AccessAgentCaller.get(null, url, null);
        return result;
    }

    public String readFileLocal(String path) {
        if (path.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must not be a URL");
        }
        String localFile = ScenarioHelper.cutHash(path);
        return FileUtil.readFileLocally(localFile);
    }

    public String readFileOLD(String urlOrPath) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        LOGGER.info("reading file for urlOrPath=" + urlOrPath + ", scenarioUrl=" + scenarioUrl);
        if (!urlOrPath.startsWith("http")) {
            String localFile = ScenarioHelper.cutHash(urlOrPath);
            return FileUtil.readFileLocally(localFile);
        }
        if (scenarioUrl != null) {
            return new ScenarioClient().read(scenarioUrl, urlOrPath);
        }
        if (urlOrPath.startsWith("http")) {
            int i = urlOrPath.lastIndexOf("#");
            if (i >= 0) {
                urlOrPath = urlOrPath.substring(0, i);
            }
            return AgentCaller.executeGetWithURL(urlOrPath);
        }
        String localFile = ScenarioHelper.cutHash(urlOrPath);
        return FileUtil.readFileLocally(localFile);
    }

    public String queryFile(String targetUrl, String sparqlQuery) {
        String result = AccessAgentCaller.query(null, targetUrl, sparqlQuery);
        return result;
    }

    public String queryFileOld(String urlOrPath, String sparqlQuery) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        LOGGER.info("querying file for urlOrPath=" + urlOrPath + ", scenarioUrl=" + scenarioUrl);
        if (scenarioUrl != null) {
            return new ScenarioClient().query(scenarioUrl, urlOrPath, sparqlQuery);
        }
        urlOrPath = ResourcePathConverter.convert(urlOrPath);
        ResultSet resultSet = null;
        if (urlOrPath.startsWith("http")) {
            resultSet = JenaHelper.queryUrl(urlOrPath, sparqlQuery);
        } else {
            String localFile = ScenarioHelper.cutHash(urlOrPath);
            resultSet = JenaHelper.queryFile(localFile, sparqlQuery);
        }
        return JenaResultSetFormatter.convertToJSONW3CStandard(resultSet);
    }

    public OntModel readModelGreedy(String urlOrPath, String greedySparqlQuery) {
        String greedyResult = this.queryFile(urlOrPath, greedySparqlQuery);
        JSONObject jo = JenaResultSetFormatter.convertToSimplifiedList(greedyResult);
        JSONArray ja = jo.getJSONArray("results");
        ArrayList<String> nodesToVisit = new ArrayList<String>();
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject row = ja.getJSONObject(i);
            for (String current : row.keySet()) {
                String potentialIri = row.getString(current);
                if (!potentialIri.startsWith("http")) continue;
                int index = potentialIri.lastIndexOf("#");
                if (index > 0) {
                    potentialIri = potentialIri.substring(0, index);
                }
                if (nodesToVisit.contains(potentialIri)) continue;
                nodesToVisit.add(potentialIri);
            }
        }
        LOGGER.info("number of nodes to visit for greedy sparql query = " + nodesToVisit.size());
        OntModel model = JenaHelper.createModel();
        int count = 0;
        for (String current : nodesToVisit) {
            if (++count % 50 == 0) {
                LOGGER.info("reading file number=" + count + ", name=" + current);
            }
            current = ResourcePathConverter.convert(current);
            LOGGER.info("what is the current now?: " + current);
            model.read(current, null);
        }
        return model;
    }

    public String queryFilesGreedy(String urlOrPath, String greedySparqlQuery, String secondSparqlQuery) {
        OntModel model = this.readModelGreedy(urlOrPath, greedySparqlQuery);
        ResultSet result = JenaHelper.query(model, secondSparqlQuery);
        return JenaResultSetFormatter.convertToJSONW3CStandard(result);
    }

    public String writeFile(String urlOrPath, String content) {
        String result = AccessAgentCaller.put(null, urlOrPath, content, null);
        return result;
    }

    public String writeFileOLD(String urlOrPath, String content) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        LOGGER.info("writing file for urlOrPath=" + urlOrPath + ", scenarioUrl=" + scenarioUrl);
        if (scenarioUrl != null) {
            int i = scenarioUrl.lastIndexOf("/");
            String scenarioName = scenarioUrl.substring(i);
            String scenarioBucket = ScenarioHelper.getScenarioBucket(scenarioName);
            String path = ScenarioHelper.getFileNameWithinBucket(urlOrPath, scenarioBucket);
            FileUtil.writeFileLocally(path, content);
            return path;
        }
        if (urlOrPath.startsWith("http")) {
            throw new JPSRuntimeException("writing file via HTTP is not supported yet, urlOrPath=" + urlOrPath);
        }
        FileUtil.writeFileLocally(urlOrPath, content);
        return urlOrPath;
    }

    public void put(String destinationUrl, String content) {
        if (!destinationUrl.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must be a URL");
        }
        AccessAgentCaller.put(null, destinationUrl, content, null);
    }

    public void putLocal(String destinationUrl, String content) {
        if (destinationUrl.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must not be a URL");
        }
        FileUtil.writeFileLocally(destinationUrl, content);
    }

    public void putOld(String destinationUrl, String content) {
        String path = destinationUrl;
        if (destinationUrl.startsWith("http")) {
            String destinationUrlWithoutHash = ScenarioHelper.cutHash(destinationUrl);
            path = BucketHelper.getLocalPath(destinationUrlWithoutHash);
        }
        FileUtil.writeFileLocally(path, content);
    }

    public void put(String destinationUrl, File file) {
        if (!destinationUrl.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must be a URL");
        }
        String content = FileUtil.readFileLocally(file.getAbsolutePath());
        this.put(destinationUrl, content);
    }

    public void putLocal(String destinationUrl, File file) {
        if (destinationUrl.startsWith("http")) {
            throw new JPSRuntimeException("destinationUrl must not be a URL");
        }
        String content = FileUtil.readFileLocally(file.getAbsolutePath());
        FileUtil.writeFileLocally(destinationUrl, content);
    }

    public void updateFile(String targetUrl, String sparqlUpdate) {
        AccessAgentCaller.update(null, targetUrl, sparqlUpdate);
    }

    public void updateFileOLD(String urlOrPath, String sparqlUpdate) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        LOGGER.info("updating file for urlOrPath=" + urlOrPath + ", scenarioUrl=" + scenarioUrl);
        if (scenarioUrl != null) {
            String url = scenarioUrl + "/update";
            String json = new JSONStringer().object().key("scenarioresource").value(urlOrPath).key("sparqlupdate").value(sparqlUpdate).endObject().toString();
            AgentCaller.executeGetWithURLAndJSON(url, json);
            return;
        }
        String localFile = urlOrPath;
        if (urlOrPath.startsWith("http")) {
            localFile = ScenarioHelper.cutHash(localFile);
            localFile = ResourcePathConverter.convertToLocalPath(localFile);
        }
        LOGGER.info("updating local file=" + localFile);
        LOGGER.info("SPARQL update =" + sparqlUpdate);
        UpdateRequest request = UpdateFactory.create(sparqlUpdate);
        OntModel model = JenaHelper.createModel(localFile);
        UpdateAction.execute(request, (Model)model);
        JenaHelper.writeAsFile(model, localFile);
    }

    public static String getIriPrefix() {
        return BucketHelper.getIriPrefix();
    }

    public static String getLocalDataPath() {
        return BucketHelper.getLocalDataPath();
    }

    public static String getLocalDataPath(String humanReadableSubPath) {
        String separator = KeyValueManager.get("scenario.usecasedirectory.separator");
        String path = BucketHelper.getLocalDataPath() + separator + humanReadableSubPath;
        return path;
    }
}

