/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.function.Supplier;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.shared.JenaException;

public abstract class TransactionHandlerBase
implements TransactionHandler {
    private void abort(Throwable e) {
        try {
            this.abort();
        }
        catch (Throwable th) {
            e.addSuppressed(th);
        }
    }

    @Override
    public void execute(Runnable action) {
        this.begin();
        try {
            action.run();
            this.commit();
        }
        catch (JenaException e) {
            this.abort(e);
            throw e;
        }
        catch (Throwable e) {
            this.abort(e);
            throw new JenaException(e);
        }
    }

    @Override
    public <T> T calculate(Supplier<T> action) {
        this.begin();
        try {
            T result = action.get();
            this.commit();
            return result;
        }
        catch (JenaException e) {
            this.abort(e);
            throw e;
        }
        catch (Throwable e) {
            this.abort(e);
            throw new JenaException(e);
        }
    }
}

