/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.io.MeasurableInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferInputStream
extends MeasurableInputStream
implements RepositionableStream {
    private static int FIRST_SHIFT = 30;
    private static int SECOND_SHIFT = FIRST_SHIFT - 1;
    public static final long CHUNK_SIZE = (1 << FIRST_SHIFT) + (1 << SECOND_SHIFT);
    private final ByteBuffer[] byteBuffer;
    private final int n;
    private int curr = 0;
    private long mark;
    private long size;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this(new ByteBuffer[]{byteBuffer});
    }

    protected ByteBufferInputStream(ByteBuffer[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.n = byteBuffer.length;
        long size = 0L;
        for (int i = 0; i < this.n; ++i) {
            if (i < this.n - 1 && (long)byteBuffer[i].capacity() != CHUNK_SIZE) {
                throw new IllegalArgumentException();
            }
            size += (long)byteBuffer[i].capacity();
        }
        this.size = size;
        this.position(0L);
    }

    public static ByteBufferInputStream map(FileChannel fileChannel, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size();
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        ByteBuffer[] byteBuffer = new ByteBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            byteBuffer[i] = fileChannel.map(mapMode, CHUNK_SIZE * (long)i, Math.min(CHUNK_SIZE, size - CHUNK_SIZE * (long)i));
        }
        return new ByteBufferInputStream(byteBuffer);
    }

    private long remaining() {
        return this.curr == this.n - 1 ? (long)this.byteBuffer[this.curr].remaining() : (long)this.byteBuffer[this.curr].remaining() + ((long)(this.n - 2 - this.curr) << FIRST_SHIFT) + ((long)(this.n - 2 - this.curr) << SECOND_SHIFT) + (long)this.byteBuffer[this.n - 1].capacity();
    }

    public int available() {
        long available = this.remaining();
        return available < Integer.MAX_VALUE ? (int)available : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int unused) {
        this.mark = this.position();
    }

    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException();
        }
        this.position(this.mark);
    }

    public long skip(long n) throws IOException {
        long toSkip = Math.min(this.remaining(), n);
        this.position(this.position() + toSkip);
        return toSkip;
    }

    public int read() {
        if (!this.byteBuffer[this.curr].hasRemaining()) {
            if (this.curr < this.n - 1) {
                this.byteBuffer[++this.curr].position(0);
            } else {
                return -1;
            }
        }
        return this.byteBuffer[this.curr].get() & 0xFF;
    }

    public int read(byte[] b, int offset, int length) {
        int rem;
        if (length == 0) {
            return 0;
        }
        long remaining = this.remaining();
        if (remaining == 0L) {
            return -1;
        }
        int realLength = (int)Math.min(remaining, (long)length);
        for (int read = 0; read < realLength; read += Math.min(realLength, rem)) {
            rem = this.byteBuffer[this.curr].remaining();
            if (rem == 0) {
                this.byteBuffer[++this.curr].position(0);
            }
            this.byteBuffer[this.curr].get(b, offset + read, Math.min(realLength - read, rem));
        }
        return realLength;
    }

    public long length() {
        return this.size;
    }

    public long position() {
        return ((long)this.curr << FIRST_SHIFT) + ((long)this.curr << SECOND_SHIFT) + (long)this.byteBuffer[this.curr].position();
    }

    public void position(long newPosition) {
        if ((newPosition = Math.min(newPosition, this.length())) == this.length()) {
            this.curr = this.n - 1;
            this.byteBuffer[this.curr].position(this.byteBuffer[this.curr].capacity());
            return;
        }
        this.curr = (int)(newPosition / CHUNK_SIZE);
        this.byteBuffer[this.curr].position((int)(newPosition - ((long)this.curr << FIRST_SHIFT) - ((long)this.curr << SECOND_SHIFT)));
    }

    public ByteBufferInputStream copy() {
        ByteBuffer[] byteBuffer = new ByteBuffer[this.byteBuffer.length];
        int i = this.byteBuffer.length;
        while (i-- != 0) {
            byteBuffer[i] = this.byteBuffer[i].duplicate();
        }
        return new ByteBufferInputStream(byteBuffer);
    }
}

