/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.MiniMime;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;

public class JettyResponseListener
extends InputStreamResponseListener {
    private static final transient Logger log = Logger.getLogger(JettyResponseListener.class);
    private final long queryTimeoutMillis;
    private volatile Request m_request;
    private volatile Response m_response;
    private volatile InputStream m_cachedStream = null;
    private static final String ISO_8859_1 = "ISO-8859-1";

    public JettyResponseListener(Request request, long queryTimeoutMillis) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this.m_request = request;
        this.queryTimeoutMillis = queryTimeoutMillis <= 0L ? Long.MAX_VALUE : queryTimeoutMillis;
    }

    private void ensureResponse() throws IOException {
        if (this.m_response == null) {
            try {
                boolean traceEnabled = log.isTraceEnabled();
                long start = traceEnabled ? System.currentTimeMillis() : 0L;
                this.m_response = this.get(this.queryTimeoutMillis, TimeUnit.MILLISECONDS);
                if (traceEnabled) {
                    log.trace((Object)("Response in " + (System.currentTimeMillis() - start) + "ms"));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException(e);
            }
        }
    }

    public String getContentType() throws IOException {
        this.ensureResponse();
        HttpFields headers = this.m_response.getHeaders();
        return headers.get(HttpHeader.CONTENT_TYPE);
    }

    public String getContentEncoding() throws IOException {
        this.ensureResponse();
        HttpFields headers = this.m_response.getHeaders();
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        MiniMime mimeType = new MiniMime(contentType);
        return mimeType.getContentEncoding();
    }

    public int getStatus() throws IOException {
        this.ensureResponse();
        return this.m_response.getStatus();
    }

    public String getReason() throws IOException {
        this.ensureResponse();
        return this.m_response.getReason();
    }

    public HttpFields getHeaders() throws IOException {
        this.ensureResponse();
        return this.m_response.getHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseBody() throws IOException {
        String contentEncoding = this.getContentEncoding();
        try (InputStreamReader r = contentEncoding != null ? new InputStreamReader(this.getInputStream(), contentEncoding) : (this.getContentType() != null && this.getContentType().startsWith("text/") ? new InputStreamReader(this.getInputStream(), ISO_8859_1) : new InputStreamReader(this.getInputStream()));){
            StringWriter w = new StringWriter();
            char[] buf = new char[1024];
            int rdlen = 0;
            while ((rdlen = r.read(buf)) != -1) {
                w.write(buf, 0, rdlen);
            }
            String string = w.toString();
            return string;
        }
    }

    public InputStream getInputStream() {
        if (this.m_cachedStream != null) {
            return super.getInputStream();
        }
        try {
            this.ensureResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.m_cachedStream = super.getInputStream();
        return this.m_cachedStream;
    }

    public void abort() {
        this.abort(new IOException());
    }

    public void abort(Throwable cause) {
        Request r;
        InputStream is = this.m_cachedStream;
        if (is != null) {
            this.m_cachedStream = null;
            try {
                is.close();
            }
            catch (IOException ex) {
                log.warn((Object)ex);
            }
        }
        if ((r = this.m_request) != null) {
            this.m_request = null;
            r.abort(cause);
        }
    }
}

