/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.DefaultHttpClientFactory;
import com.bigdata.rdf.sail.webapp.client.IHttpClientFactory;

public class HttpClientConfigurator {
    public static IHttpClientFactory getInstance() {
        String configuredFactory = System.getProperty(Options.CONNECTION_MANAGER_FACTORY_CLASS, Options.DEFAULT_CONNECTION_MANAGER_FACTORY_CLASS);
        try {
            Class<?> factoryClass = Class.forName(configuredFactory);
            if (!IHttpClientFactory.class.isAssignableFrom(factoryClass)) {
                throw new RuntimeException("Invalid option: " + Options.CONNECTION_MANAGER_FACTORY_CLASS + "=" + factoryClass + ":: Class does not extend " + IHttpClientFactory.class);
            }
            IHttpClientFactory factory = (IHttpClientFactory)factoryClass.newInstance();
            return factory;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + IHttpClientFactory.class.getSimpleName() + ": " + e, e);
        }
    }

    public static interface Options {
        public static final String CONNECTION_MANAGER_FACTORY_CLASS = HttpClientConfigurator.class.getName();
        public static final String DEFAULT_CONNECTION_MANAGER_FACTORY_CLASS = DefaultHttpClientFactory.class.getName();
    }
}

