/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.AbstractDataServiceProcedureTask;
import com.bigdata.service.ndx.AbstractScaleOutClientIndexView;
import com.bigdata.service.ndx.IdentityHandler;
import com.bigdata.service.ndx.KeyArrayDataServiceProcedureTask;
import com.bigdata.service.ndx.KeyRangeDataServiceProcedureTask;
import com.bigdata.service.ndx.SimpleDataServiceProcedureTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractScaleOutClientIndexView2
extends AbstractScaleOutClientIndexView {
    private final ThreadLocal<AtomicInteger> recursionDepth = new ThreadLocal<AtomicInteger>(){

        @Override
        protected synchronized AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };

    public AbstractScaleOutClientIndexView2(AbstractScaleOutFederation fed, String name, long timestamp, IMetadataIndex metadataIndex) {
        super(fed, name, timestamp, metadataIndex);
    }

    @Override
    public final AtomicInteger getRecursionDepth() {
        return this.recursionDepth.get();
    }

    protected abstract void runTasks(boolean var1, ArrayList<AbstractDataServiceProcedureTask> var2);

    @Override
    protected Object submit(long ts, byte[] key, ISimpleIndexProcedure proc) {
        PartitionLocator locator = this.fed.getMetadataIndex(this.name, ts).find(key);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Submitting " + proc.getClass() + " to partition" + locator));
            }
            IdentityHandler resultHandler = new IdentityHandler();
            SimpleDataServiceProcedureTask task = new SimpleDataServiceProcedureTask(this, key, ts, new Split(locator, 0, 0), proc, resultHandler);
            this.getThreadPool().submit(task).get(this.taskTimeout, TimeUnit.MILLISECONDS);
            Object result = resultHandler.getResult();
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void submit(long ts, byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler resultHandler) {
        int maxTasks;
        boolean parallel = proc instanceof IParallelizableIndexProcedure;
        if (log.isInfoEnabled()) {
            log.info((Object)("Procedure " + proc.getClass().getName() + " will be mapped across index partitions in " + (parallel ? "parallel" : "sequence")));
        }
        int poolSize = this.getThreadPool().getCorePoolSize();
        int maxTasksPerRequest = ((AbstractClient)this.fed.getClient()).getMaxParallelTasksPerRequest();
        int n = maxTasks = poolSize == 0 ? maxTasksPerRequest : Math.min(poolSize, maxTasksPerRequest);
        assert (maxTasks > 0) : "maxTasks=" + maxTasks + ", poolSize=" + poolSize + ", maxTasksPerRequest=" + maxTasksPerRequest;
        Iterator<PartitionLocator> itr = this.locatorScan(ts, fromKey, toKey, false);
        long nparts = 0L;
        while (itr.hasNext()) {
            ArrayList<AbstractDataServiceProcedureTask> tasks = new ArrayList<AbstractDataServiceProcedureTask>(maxTasks);
            for (int i = 0; i < maxTasks && itr.hasNext(); ++i) {
                PartitionLocator locator = itr.next();
                Split split = new Split(locator, 0, 0);
                tasks.add(new KeyRangeDataServiceProcedureTask(this, fromKey, toKey, ts, split, proc, resultHandler));
                ++nparts;
            }
            this.runTasks(parallel, tasks);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Procedure " + proc.getClass().getName() + " mapped across " + nparts + " index partitions in " + (parallel ? "parallel" : "sequence")));
        }
    }

    @Override
    protected void submit(long ts, int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler aggregator) {
        LinkedList<Split> splits = this.splitKeys(ts, fromIndex, toIndex, keys);
        int nsplits = splits.size();
        ArrayList<AbstractDataServiceProcedureTask> tasks = new ArrayList<AbstractDataServiceProcedureTask>(nsplits);
        Iterator itr = splits.iterator();
        boolean parallel = false;
        while (itr.hasNext()) {
            Split split = (Split)itr.next();
            Object proc = ctor.newInstance(this, split.fromIndex, split.toIndex, keys, vals);
            if (proc instanceof IParallelizableIndexProcedure) {
                parallel = true;
            }
            tasks.add(new KeyArrayDataServiceProcedureTask(this, keys, vals, ts, split, (IKeyArrayIndexProcedure)proc, aggregator, ctor));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Procedures created by " + ctor.getClass().getName() + " will run on " + nsplits + " index partitions in " + (parallel ? "parallel" : "sequence")));
        }
        this.runTasks(parallel, tasks);
    }
}

