/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailException;

public class DeleteServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(DeleteServlet.class);
    private static final boolean includeInferred = false;

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!DeleteServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String queryStr = req.getParameter("query");
        if (queryStr != null) {
            this.doDeleteWithQuery(req, resp);
        } else {
            this.doDeleteWithAccessPath(req, resp);
        }
    }

    private void doDeleteWithQuery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String baseURI = req.getRequestURL().toString();
        String namespace = this.getNamespace(req);
        String queryStr = req.getParameter("query");
        boolean suppressTruthMaintenance = this.getBooleanValue(req, "suppressTruthMaintenance", false);
        Map<String, Value> bindings = this.parseBindings(req, resp);
        if (bindings == null) {
            return;
        }
        if (queryStr == null) {
            throw new UnsupportedOperationException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("delete with query: " + queryStr));
        }
        try {
            if (this.getIndexManager().isGroupCommit()) {
                this.submitApiTask(new DeleteWithQueryMaterializedTask(req, resp, namespace, 0L, queryStr, baseURI, suppressTruthMaintenance, bindings)).get();
            } else {
                this.submitApiTask(new DeleteWithQuerySteamingTask(req, resp, namespace, 0L, queryStr, baseURI, suppressTruthMaintenance, bindings)).get();
            }
        }
        catch (Throwable t) {
            DeleteServlet.launderThrowable(t, resp, "UPDATE-WITH-QUERY: queryStr=" + queryStr + ", baseURI=" + baseURI);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!DeleteServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String contentType = req.getContentType();
        String queryStr = req.getParameter("query");
        Map<String, Value> bindings = this.parseBindings(req, resp);
        if (bindings == null) {
            return;
        }
        if (queryStr != null) {
            this.doDeleteWithQuery(req, resp);
        } else if (contentType != null) {
            this.doDeleteWithBody(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    private void doDeleteWithBody(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] defaultContext;
        RDFFormat format;
        String baseURI = req.getRequestURL().toString();
        String contentType = req.getContentType();
        boolean suppressTruthMaintenance = this.getBooleanValue(req, "suppressTruthMaintenance", false);
        if (contentType == null) {
            throw new UnsupportedOperationException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((format = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType())) == null) {
            DeleteServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType, new NV[0]);
            return;
        }
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
        if (rdfParserFactory == null) {
            DeleteServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        String[] s = req.getParameterValues("context-uri");
        if (s != null && s.length > 0) {
            try {
                defaultContext = DeleteServlet.toURIs(s);
            }
            catch (IllegalArgumentException ex) {
                DeleteServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage(), new NV[0]);
                return;
            }
        } else {
            defaultContext = new Resource[]{};
        }
        try {
            this.submitApiTask(new DeleteWithBodyTask(req, resp, this.getNamespace(req), 0L, baseURI, suppressTruthMaintenance, (Resource[])defaultContext, rdfParserFactory)).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "DELETE-WITH-BODY: baseURI=" + baseURI + ", context-uri=" + Arrays.toString(defaultContext));
        }
    }

    private void doDeleteWithAccessPath(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] c;
        Value o;
        URI p;
        Resource s;
        String namespace = this.getNamespace(req);
        boolean suppressTruthMaintenance = this.getBooleanValue(req, "suppressTruthMaintenance", false);
        try {
            s = EncodeDecodeValue.decodeResource((String)req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI((String)req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue((String)req.getParameter("o"));
            c = DeleteServlet.decodeContexts(req, "c");
        }
        catch (IllegalArgumentException ex) {
            DeleteServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage(), new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("DELETE-WITH-ACCESS-PATH: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")"));
        }
        try {
            this.submitApiTask(new DeleteWithAccessPathTask(req, resp, namespace, 0L, suppressTruthMaintenance, s, p, o, (Resource[])c)).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "DELETE-WITH-ACCESS-PATH: (s=" + s + ",p=" + p + ",o=" + o + ",c=" + Arrays.toString(c) + ")");
        }
    }

    private static class DeleteWithAccessPathTask
    extends AbstractRestApiTask<Void> {
        private Resource s;
        private URI p;
        private final Value o;
        private final Resource[] c;
        private final boolean suppressTruthMaintenance;

        public DeleteWithAccessPathTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, boolean suppressTruthMaintenance, Resource s, URI p, Value o, Resource[] c) {
            super(req, resp, namespace, timestamp);
            this.suppressTruthMaintenance = suppressTruthMaintenance;
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection repoConn = null;
            BigdataSail.BigdataSailConnection conn = null;
            boolean success = false;
            try {
                repoConn = this.getConnection();
                conn = repoConn.getSailConnection();
                boolean truthMaintenance = conn.getTruthMaintenance();
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(false);
                }
                long nmodified = 0L;
                if (this.c != null && this.c.length > 0) {
                    for (Resource r : this.c) {
                        nmodified += conn.getTripleStore().removeStatements(this.s, this.p, this.o, r);
                    }
                } else {
                    nmodified += conn.getTripleStore().removeStatements(this.s, this.p, this.o, null);
                }
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(true);
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified, elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
                if (repoConn != null) {
                    repoConn.close();
                }
            }
        }
    }

    static class RemoveStatementHandler
    extends RDFHandlerBase {
        private final BigdataSail.BigdataSailConnection conn;
        private final AtomicLong nmodified;
        private final Resource[] defaultContext;

        public RemoveStatementHandler(BigdataSail.BigdataSailConnection conn, AtomicLong nmodified, Resource ... defaultContext) {
            this.conn = conn;
            this.nmodified = nmodified;
            boolean quads = conn.getTripleStore().isQuads();
            this.defaultContext = quads && defaultContext != null ? defaultContext : new Resource[0];
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            Resource[] resourceArray;
            if (stmt.getContext() == null) {
                resourceArray = this.defaultContext;
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = stmt.getContext();
            }
            Resource[] c = resourceArray;
            try {
                this.conn.removeStatements(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), c);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
            if (c.length >= 2) {
                this.nmodified.addAndGet(c.length);
            } else {
                this.nmodified.incrementAndGet();
            }
        }
    }

    static class BufferStatementHandler
    extends RDFHandlerBase {
        private final BigdataSail.BigdataSailConnection conn;
        private final AtomicLong nmodified;
        private final Resource[] defaultContext;
        private final Set<Statement> stmts = new LinkedHashSet<Statement>();

        public BufferStatementHandler(BigdataSail.BigdataSailConnection conn, AtomicLong nmodified, Resource ... defaultContext) {
            this.conn = conn;
            this.nmodified = nmodified;
            boolean quads = conn.getTripleStore().isQuads();
            this.defaultContext = quads && defaultContext != null ? defaultContext : new Resource[0];
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            this.stmts.add(stmt);
        }

        void removeAll() throws SailException {
            for (Statement stmt : this.stmts) {
                this.doRemoveStatement(stmt);
            }
        }

        private void doRemoveStatement(Statement stmt) throws SailException {
            Resource[] resourceArray;
            if (stmt.getContext() == null) {
                resourceArray = this.defaultContext;
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = stmt.getContext();
            }
            Resource[] c = resourceArray;
            this.conn.removeStatements(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), c);
            if (c.length >= 2) {
                this.nmodified.addAndGet(c.length);
            } else {
                this.nmodified.incrementAndGet();
            }
        }
    }

    private static class DeleteWithBodyTask
    extends AbstractRestApiTask<Void> {
        private final String baseURI;
        private final boolean suppressTruthMaintenance;
        private final Resource[] defaultContext;
        private final RDFParserFactory rdfParserFactory;

        public DeleteWithBodyTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String baseURI, boolean suppressTruthMaintenance, Resource[] defaultContext, RDFParserFactory rdfParserFactory) {
            super(req, resp, namespace, timestamp);
            this.baseURI = baseURI;
            this.suppressTruthMaintenance = suppressTruthMaintenance;
            this.defaultContext = defaultContext;
            this.rdfParserFactory = rdfParserFactory;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection repoConn = null;
            BigdataSail.BigdataSailConnection conn = null;
            boolean success = false;
            try {
                repoConn = this.getConnection();
                conn = repoConn.getSailConnection();
                boolean truthMaintenance = conn.getTruthMaintenance();
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(false);
                }
                RDFParser rdfParser = this.rdfParserFactory.getParser();
                AtomicLong nmodified = new AtomicLong(0L);
                rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(true);
                rdfParser.setStopAtFirstError(true);
                rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                rdfParser.setRDFHandler((RDFHandler)new RemoveStatementHandler(conn, nmodified, this.defaultContext));
                rdfParser.parse((InputStream)this.req.getInputStream(), this.baseURI);
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(true);
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
                if (repoConn != null) {
                    repoConn.close();
                }
            }
        }
    }

    private static class DeleteWithQueryMaterializedTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final String baseURI;
        private final boolean suppressTruthMaintenance;
        private final Map<String, Value> bindings;

        public DeleteWithQueryMaterializedTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, String baseURI, boolean suppressTruthMaintenance, Map<String, Value> bindings) {
            super(req, resp, namespace, timestamp);
            this.queryStr = queryStr;
            this.baseURI = baseURI;
            this.suppressTruthMaintenance = suppressTruthMaintenance;
            this.bindings = bindings;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            String baseURI = BigdataRDFContext.getBaseURI(this.req, this.resp);
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(this.queryStr, baseURI);
            BigdataSailRepositoryConnection repoConn = null;
            BigdataSail.BigdataSailConnection conn = null;
            boolean success = false;
            try {
                repoConn = this.getConnection();
                conn = repoConn.getSailConnection();
                boolean truthMaintenance = conn.getTruthMaintenance();
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(false);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("delete with query: " + this.queryStr));
                }
                BigdataRDFContext context = BigdataServlet.getBigdataRDFContext(this.req.getServletContext());
                PipedOutputStream os = new PipedOutputStream();
                RDFFormat format = RDFFormat.NTRIPLES;
                BigdataRDFContext.AbstractQueryTask queryTask = context.getQueryTask(repoConn, this.namespace, 0L, this.queryStr, baseURI, astContainer, false, this.bindings, format.getDefaultMIMEType(), this.req, this.resp, os);
                switch (queryTask.queryType) {
                    case DESCRIBE: 
                    case CONSTRUCT: {
                        break;
                    }
                    default: {
                        throw new MalformedQueryException("Must be DESCRIBE or CONSTRUCT query");
                    }
                }
                RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
                RDFParser rdfParser = factory.getParser();
                rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(false);
                rdfParser.setStopAtFirstError(true);
                rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                BufferStatementHandler buffer = new BufferStatementHandler(conn, nmodified, new Resource[0]);
                rdfParser.setRDFHandler((RDFHandler)buffer);
                FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                context.queryService.execute(ft);
                PipedInputStream is = BigdataRDFServlet.newPipedInputStream(os);
                rdfParser.parse((InputStream)is, baseURI);
                ft.get();
                buffer.removeAll();
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(true);
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
                if (repoConn != null) {
                    repoConn.close();
                }
            }
        }
    }

    private static class DeleteWithQuerySteamingTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final String baseURI;
        private final boolean suppressTruthMaintenance;
        private final Map<String, Value> bindings;

        public DeleteWithQuerySteamingTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, String baseURI, boolean suppressTruthMaintenance, Map<String, Value> bindings) {
            super(req, resp, namespace, timestamp);
            this.queryStr = queryStr;
            this.baseURI = baseURI;
            this.suppressTruthMaintenance = suppressTruthMaintenance;
            this.bindings = bindings;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            String baseURI = BigdataRDFContext.getBaseURI(this.req, this.resp);
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(this.queryStr, baseURI);
            BigdataSailRepositoryConnection repoConn = null;
            BigdataSail.BigdataSailConnection conn = null;
            boolean success = false;
            try {
                repoConn = this.getConnection();
                conn = repoConn.getSailConnection();
                boolean truthMaintenance = conn.getTruthMaintenance();
                if (truthMaintenance && this.suppressTruthMaintenance) {
                    conn.setTruthMaintenance(false);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("delete with query: " + this.queryStr));
                }
                BigdataRDFContext context = BigdataServlet.getBigdataRDFContext(this.req.getServletContext());
                PipedOutputStream os = new PipedOutputStream();
                BigdataSailRepositoryConnection roconn = null;
                try {
                    long readOnlyTimestamp = -1L;
                    roconn = this.getQueryConnection(this.namespace, -1L);
                    RDFFormat format = RDFFormat.NTRIPLES;
                    BigdataRDFContext.AbstractQueryTask queryTask = context.getQueryTask(roconn, this.namespace, -1L, this.queryStr, baseURI, astContainer, false, this.bindings, format.getDefaultMIMEType(), this.req, this.resp, os);
                    switch (queryTask.queryType) {
                        case DESCRIBE: 
                        case CONSTRUCT: {
                            break;
                        }
                        default: {
                            throw new MalformedQueryException("Must be DESCRIBE or CONSTRUCT query");
                        }
                    }
                    RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
                    RDFParser rdfParser = factory.getParser();
                    rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                    rdfParser.setVerifyData(false);
                    rdfParser.setStopAtFirstError(true);
                    rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                    rdfParser.setRDFHandler((RDFHandler)new RemoveStatementHandler(conn, nmodified, new Resource[0]));
                    FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                    context.queryService.execute(ft);
                    PipedInputStream is = BigdataRDFServlet.newPipedInputStream(os);
                    rdfParser.parse((InputStream)is, baseURI);
                    ft.get();
                    if (truthMaintenance && this.suppressTruthMaintenance) {
                        conn.setTruthMaintenance(true);
                    }
                }
                finally {
                    if (roconn != null) {
                        roconn.rollback();
                    }
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
                if (repoConn != null) {
                    repoConn.close();
                }
            }
        }
    }
}

