/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.counters.CAT;
import com.bigdata.rdf.inf.ClosureStats;

public class LoadStats {
    public final CAT toldTriples = new CAT();
    public final CAT loadTime = new CAT();
    public final CAT commitTime = new CAT();
    public final CAT totalTime = new CAT();
    private volatile transient long lastReportTime = 0L;
    protected static transient long REPORT_INTERVAL = 600000L;
    public final ClosureStats closureStats = new ClosureStats();

    public long triplesPerSecond() {
        return (long)((double)this.toldTriples.estimate_get() / (double)this.totalTime.estimate_get() * 1000.0);
    }

    public void add(LoadStats stats) {
        this.toldTriples.add(stats.toldTriples.get());
        this.loadTime.add(stats.loadTime.get());
        this.commitTime.add(stats.commitTime.get());
        this.totalTime.add(stats.totalTime.get());
        if (stats.closureStats != null) {
            this.closureStats.add(stats.closureStats);
        }
        long now = System.currentTimeMillis();
        if (this.lastReportTime == 0L) {
            if (this.loadTime.estimate_get() >= REPORT_INTERVAL) {
                System.out.println("loading: " + this.toString());
                this.lastReportTime = now;
            }
        } else if (now - this.lastReportTime >= REPORT_INTERVAL) {
            System.out.println("loading: " + this.toString());
            this.lastReportTime = now;
        }
    }

    public String toString() {
        return this.toldTriples + " stmts added in " + (double)this.loadTime.estimate_get() / 1000.0 + " secs, rate= " + this.triplesPerSecond() + ", commitLatency=" + this.commitTime.estimate_get() + "ms" + (this.closureStats.elapsed.estimate_get() != 0L ? "\n" + this.closureStats.toString() : "");
    }
}

