/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateDDM;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordinateDMS
implements ICoordinate {
    public static Logger log = Logger.getLogger(CoordinateDMS.class.getName());
    public final int degreesNorth;
    public final int minutesNorth;
    public final int tenthsOfSecondsNorth;
    public final int degreesEast;
    public final int minutesEast;
    public final int tenthsOfSecondsEast;
    static final String regex_lat = "((\\d{1,2})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([NnSs]))";
    static final String regex_long = "((\\d{1,3})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([EeWw]))";
    static final Pattern pattern_dms1 = Pattern.compile("^((((\\d{1,2})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([NnSs]))(\\s?[/,]?\\s?)((\\d{1,3})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([EeWw]))))$");
    static final int group_degreesNorth = 4;
    static final int group_minutesNorth = 5;
    static final int group_secondsNorth = 7;
    static final int group_northSouth = 8;
    static final int group_degreesEast = 11;
    static final int group_minutesEast = 12;
    static final int group_secondsEast = 14;
    static final int group_eastWest = 15;

    public CoordinateDMS(int degreesNorth, int minutesNorth, int tenthsOfSecondsNorth, int degreesEast, int minutesEast, int tenthsOfSecondsEast) {
        if (degreesNorth > 90 || degreesNorth < -90) {
            throw new IllegalArgumentException();
        }
        if (minutesNorth > 60 || minutesNorth < -60) {
            throw new IllegalArgumentException();
        }
        if (tenthsOfSecondsNorth > 600 || tenthsOfSecondsNorth < -600) {
            throw new IllegalArgumentException();
        }
        if (degreesEast > 180 || degreesEast < -180) {
            throw new IllegalArgumentException();
        }
        if (minutesEast > 60 || minutesEast < -60) {
            throw new IllegalArgumentException();
        }
        if (tenthsOfSecondsEast > 600 || tenthsOfSecondsEast < -600) {
            throw new IllegalArgumentException();
        }
        if (degreesNorth < 0) {
            if (minutesNorth > 0) {
                throw new IllegalArgumentException();
            }
            if (tenthsOfSecondsNorth > 0) {
                throw new IllegalArgumentException();
            }
        }
        if (degreesEast < 0) {
            if (minutesEast > 0) {
                throw new IllegalArgumentException();
            }
            if (tenthsOfSecondsEast > 0) {
                throw new IllegalArgumentException();
            }
        }
        this.degreesNorth = degreesNorth;
        this.minutesNorth = minutesNorth;
        this.tenthsOfSecondsNorth = tenthsOfSecondsNorth;
        this.degreesEast = degreesEast;
        this.minutesEast = minutesEast;
        this.tenthsOfSecondsEast = tenthsOfSecondsEast;
    }

    public String toString() {
        boolean northSouth = this.degreesNorth > 0;
        boolean eastWest = this.degreesEast > 0;
        String north = "" + (northSouth ? this.degreesNorth : -this.degreesNorth) + " " + (northSouth ? this.minutesNorth : -this.minutesNorth) + " " + CoordinateDMS.formatTenthsOfSecond(northSouth ? this.tenthsOfSecondsNorth : -this.tenthsOfSecondsNorth) + (northSouth ? "N" : "S");
        String east = (eastWest ? "" + this.degreesEast : Integer.valueOf(-this.degreesEast)) + " " + (eastWest ? this.minutesEast : -this.minutesEast) + " " + CoordinateDMS.formatTenthsOfSecond(eastWest ? this.tenthsOfSecondsEast : -this.tenthsOfSecondsEast) + (eastWest ? "E" : "W");
        return north + " " + east;
    }

    public CoordinateDMS roundSeconds() {
        int secondsNorth = this.tenthsOfSecondsNorth > 0 ? (int)Math.round((double)this.tenthsOfSecondsNorth / 10.0) : -((int)Math.round((double)(-this.tenthsOfSecondsNorth) / 10.0));
        int secondsEast = this.tenthsOfSecondsEast > 0 ? (int)Math.round((double)this.tenthsOfSecondsEast / 10.0) : -((int)Math.round((double)(-this.tenthsOfSecondsEast) / 10.0));
        return new CoordinateDMS(this.degreesNorth, this.minutesNorth, secondsNorth * 10, this.degreesEast, this.minutesEast, secondsEast * 10);
    }

    public CoordinateDMS roundMinutes() {
        int roundMinutesNorth;
        int n = this.tenthsOfSecondsNorth > 300 ? this.minutesNorth + 1 : (roundMinutesNorth = this.tenthsOfSecondsNorth < -300 ? this.minutesNorth - 1 : this.minutesNorth);
        int roundMinutesEast = this.tenthsOfSecondsEast > 300 ? this.minutesEast + 1 : (this.tenthsOfSecondsEast < -300 ? this.minutesEast - 1 : this.minutesEast);
        return new CoordinateDMS(this.degreesNorth, roundMinutesNorth, 0, this.degreesEast, roundMinutesEast, 0);
    }

    @Override
    public boolean equals(ICoordinate o) {
        if (o instanceof CoordinateDMS) {
            return this.equals((CoordinateDMS)o);
        }
        return false;
    }

    public boolean equals(CoordinateDMS o) {
        return this.degreesNorth == o.degreesNorth && this.minutesNorth == o.minutesNorth && this.tenthsOfSecondsNorth == o.tenthsOfSecondsNorth && this.degreesEast == o.degreesEast && this.minutesEast == o.minutesEast && this.tenthsOfSecondsEast == o.tenthsOfSecondsEast;
    }

    public static CoordinateDMS parse(String text) throws ParseException {
        Matcher m = pattern_dms1.matcher(text);
        if (m.matches()) {
            int degreesNorth;
            try {
                degreesNorth = Integer.parseInt(m.group(4));
            }
            catch (NumberFormatException ex) {
                log.log(Level.WARNING, "Parsing text: [" + text + "]", ex);
                throw ex;
            }
            int minutesNorth = Integer.parseInt(m.group(5));
            int tenthsOfSecondsNorth = m.group(7) != null && m.group(7).length() > 0 ? (int)(Float.parseFloat(m.group(7)) * 10.0f) : 0;
            boolean northSouth = !"S".equalsIgnoreCase(m.group(8));
            int degreesEast = Integer.parseInt(m.group(11));
            int minutesEast = Integer.parseInt(m.group(12));
            int tenthsOfSecondsEast = m.group(14) != null && m.group(14).length() > 0 ? (int)(Float.parseFloat(m.group(14)) * 10.0f) : 0;
            boolean eastWest = !"W".equalsIgnoreCase(m.group(15));
            return new CoordinateDMS(northSouth ? degreesNorth : -degreesNorth, northSouth ? minutesNorth : -minutesNorth, northSouth ? tenthsOfSecondsNorth : -tenthsOfSecondsNorth, eastWest ? degreesEast : -degreesEast, eastWest ? minutesEast : -minutesEast, eastWest ? tenthsOfSecondsEast : -tenthsOfSecondsEast);
        }
        throw new ParseException("Not recognized: " + text, 0);
    }

    static String formatTenthsOfSecond(int tenthsOfSecond) {
        int seconds = tenthsOfSecond / 10;
        int tenths = tenthsOfSecond - seconds * 10;
        return seconds + "." + tenths;
    }

    static int parseTenthsOfSecond(String text) throws ParseException {
        int tenthsOfSecond;
        int lastPos;
        int pos = text.indexOf(".");
        if (pos != (lastPos = text.lastIndexOf("."))) {
            throw new ParseException(text, lastPos);
        }
        if (pos == -1) {
            int seconds = Integer.parseInt(text);
            tenthsOfSecond = seconds * 10;
        } else {
            String secondsStr = text.substring(0, pos);
            String tenthsStr = text.substring(pos + 1);
            int seconds = Integer.parseInt(secondsStr);
            int tenths = tenthsStr.length() == 0 ? 0 : Integer.parseInt(tenthsStr);
            tenthsOfSecond = seconds * 10 + tenths;
        }
        return tenthsOfSecond;
    }

    @Override
    public CoordinateDD toDD() {
        double _degreesNorth = CoordinateUtility.toDecimalDegrees(this.degreesNorth, this.minutesNorth, (double)this.tenthsOfSecondsNorth / 10.0);
        double _degreesEast = CoordinateUtility.toDecimalDegrees(this.degreesEast, this.minutesEast, (double)this.tenthsOfSecondsEast / 10.0);
        return new CoordinateDD(_degreesNorth, _degreesEast);
    }

    @Override
    public double distance(ICoordinate o, ICoordinate.UNITS units) {
        return CoordinateUtility.distance(this.toDD(), o.toDD(), units);
    }

    @Override
    public CoordinateDMS toDMS() {
        return this;
    }

    @Override
    public CoordinateDDM toDDM() {
        return null;
    }
}

