/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.rto;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.NV;
import com.bigdata.bop.ap.SampleIndex;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.joinGraph.rto.EstimateEnum;
import com.bigdata.bop.joinGraph.rto.VertexSample;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Vertex
implements Serializable {
    private static final transient Logger log = Logger.getLogger(Vertex.class);
    private static final long serialVersionUID = 1L;
    public final IPredicate<?> pred;
    transient VertexSample sample = null;

    Vertex(IPredicate<?> pred) {
        if (pred == null) {
            throw new IllegalArgumentException();
        }
        this.pred = pred;
    }

    public String toString() {
        return "Vertex{pred=" + this.pred + ",sample=" + this.sample + "}";
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.pred.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(QueryEngine queryEngine, int limit, SampleIndex.SampleType sampleType) {
        long rangeCount;
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        if (sampleType == null) {
            throw new IllegalArgumentException();
        }
        VertexSample oldSample = this.sample;
        if (oldSample != null && oldSample.estimateEnum == EstimateEnum.Exact) {
            return;
        }
        if (oldSample != null && oldSample.limit >= limit) {
            return;
        }
        BOpContextBase context = new BOpContextBase(queryEngine);
        IRelation<?> r = context.getRelation(this.pred);
        IAccessPath<?> ap = context.getAccessPath(r, this.pred);
        long l = rangeCount = oldSample == null ? ap.rangeCount(false) : oldSample.estCard;
        if (rangeCount <= (long)limit) {
            ArrayList tmp = new ArrayList((int)rangeCount);
            try (IChunkedOrderedIterator<?> itr = ap.iterator();){
                while (itr.hasNext()) {
                    tmp.add(itr.next());
                }
            }
            this.sample = new VertexSample(rangeCount, limit, EstimateEnum.Exact, Vertex.elementsToBindingSets(this.pred, tmp.toArray(new Object[tmp.size()])));
        } else {
            SampleIndex sampleOp = new SampleIndex(new BOp[0], NV.asMap(new NV(SampleIndex.Annotations.PREDICATE, this.pred), new NV(SampleIndex.Annotations.LIMIT, limit), new NV(SampleIndex.Annotations.SAMPLE_TYPE, sampleType.name())));
            this.sample = new VertexSample(rangeCount, limit, EstimateEnum.Normal, Vertex.elementsToBindingSets(this.pred, sampleOp.eval(context)));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sampled: id=" + this.pred.getId() + ", sample=" + this.sample));
        }
    }

    private static IBindingSet[] elementsToBindingSets(IPredicate<?> pred, Object[] elements) {
        IBindingSet[] sourceSample = new IBindingSet[elements.length];
        for (int i = 0; i < sourceSample.length; ++i) {
            ListBindingSet bset = new ListBindingSet();
            BOpContext.copyValues((IElement)elements[i], pred, bset);
            sourceSample[i] = bset;
        }
        return sourceSample;
    }
}

