/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.PersistentObject;

public class Timer
extends PersistentObject {
    private long baseTime;
    private long elapsedTime;
    private static final long UNIT = 1000L;

    public Timer() {
        this.reset();
    }

    public Timer display() {
        System.out.println(this);
        return this;
    }

    public float elapsedTime() {
        return this.seconds();
    }

    public long millis() {
        long elapsed = this.elapsedTime;
        if (this.baseTime != 0L) {
            elapsed += System.currentTimeMillis() - this.baseTime;
        }
        return elapsed;
    }

    public Timer minus(Timer other) {
        Timer copy = new Timer();
        copy.elapsedTime = this.millis() - other.millis();
        return copy;
    }

    public float minutes() {
        return this.seconds() / 60.0f;
    }

    public Timer plus(Timer other) {
        Timer copy = new Timer();
        copy.elapsedTime = this.millis() + other.millis();
        return copy;
    }

    public Timer reset() {
        this.elapsedTime = 0L;
        this.baseTime = 0L;
        return this;
    }

    public float seconds() {
        return (float)this.millis() / 1000.0f;
    }

    public Timer start() {
        this.baseTime = System.currentTimeMillis();
        return this;
    }

    public Timer stop() {
        if (this.baseTime != 0L) {
            this.elapsedTime += System.currentTimeMillis() - this.baseTime;
        }
        this.baseTime = 0L;
        return this;
    }

    public static void test(int size) {
        int i;
        Timer t = new Timer().start();
        int j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop();
        t.display();
        System.out.println("I finished the test using " + t);
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.start();
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop().display();
        t.reset();
        t.start();
        j = 0;
        for (i = 0; i < size; ++i) {
            ++j;
        }
        t.stop().display();
    }

    public String toString() {
        return "Time=" + Float.toString(this.elapsedTime()) + " secs";
    }
}

