/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.AggregationHandler;
import org.apache.jena.arq.querybuilder.handlers.ConstructHandler;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.PrologHandler;
import org.apache.jena.arq.querybuilder.handlers.SelectHandler;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.arq.querybuilder.handlers.ValuesHandler;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class HandlerBlock {
    private final AggregationHandler aggHandler;
    private final ConstructHandler constructHandler;
    private final DatasetHandler datasetHandler;
    private final PrologHandler prologHandler;
    private final SelectHandler selectHandler;
    private final SolutionModifierHandler modifierHandler;
    private final WhereHandler whereHandler;
    private final ValuesHandler valueHandler;

    public HandlerBlock(Query query) {
        this.prologHandler = new PrologHandler(query);
        this.aggHandler = new AggregationHandler(query);
        this.whereHandler = new WhereHandler(query);
        this.datasetHandler = new DatasetHandler(query);
        this.modifierHandler = new SolutionModifierHandler(query);
        this.valueHandler = new ValuesHandler(query);
        SelectHandler sTemp = null;
        ConstructHandler cTemp = null;
        if (query.isSelectType()) {
            sTemp = new SelectHandler(this.aggHandler);
        } else if (!query.isAskType()) {
            if (query.isDescribeType()) {
                sTemp = new SelectHandler(this.aggHandler);
            } else if (query.isConstructType()) {
                cTemp = new ConstructHandler(query);
            }
        }
        this.selectHandler = sTemp;
        this.constructHandler = cTemp;
    }

    public AggregationHandler getAggregationHandler() {
        return this.aggHandler;
    }

    public ConstructHandler getConstructHandler() {
        return this.constructHandler;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    public PrologHandler getPrologHandler() {
        return this.prologHandler;
    }

    public SelectHandler getSelectHandler() {
        return this.selectHandler;
    }

    public SolutionModifierHandler getModifierHandler() {
        return this.modifierHandler;
    }

    public WhereHandler getWhereHandler() {
        return this.whereHandler;
    }

    public ValuesHandler getValueHandler() {
        return this.valueHandler;
    }

    public void addAll(PrologHandler handler) {
        this.prologHandler.addAll(handler);
    }

    public void addAll(AggregationHandler handler) {
        this.aggHandler.addAll(handler);
    }

    public void addAll(ConstructHandler handler) {
        if (this.constructHandler != null && handler != null) {
            this.constructHandler.addAll(handler);
        }
    }

    public void addAll(DatasetHandler handler) {
        this.datasetHandler.addAll(handler);
    }

    public void addAll(SolutionModifierHandler handler) {
        this.modifierHandler.addAll(handler);
    }

    public void addAll(SelectHandler handler) {
        if (this.selectHandler != null && handler != null) {
            this.selectHandler.addAll(handler);
        }
    }

    public void addAll(WhereHandler handler) {
        this.whereHandler.addAll(handler);
    }

    public void addAll(ValuesHandler handler) {
        this.valueHandler.addAll(handler);
    }

    public void addAll(HandlerBlock handler) {
        this.addAll(handler.aggHandler);
        this.addAll(handler.constructHandler);
        this.addAll(handler.selectHandler);
        this.addAll(handler.datasetHandler);
        this.addAll(handler.modifierHandler);
        this.addAll(handler.prologHandler);
        this.addAll(handler.whereHandler);
        this.addAll(handler.valueHandler);
    }

    public void setVars(Map<Var, Node> values) {
        this.aggHandler.setVars(values);
        if (this.constructHandler != null) {
            this.constructHandler.setVars(values);
        }
        this.datasetHandler.setVars(values);
        this.prologHandler.setVars(values);
        if (this.selectHandler != null) {
            this.selectHandler.setVars(values);
        }
        this.modifierHandler.setVars(values);
        this.whereHandler.setVars(values);
    }

    public void build() {
        this.prologHandler.build();
        if (this.selectHandler != null) {
            this.selectHandler.build();
        }
        if (this.constructHandler != null) {
            this.constructHandler.build();
        }
        this.datasetHandler.build();
        this.modifierHandler.build();
        this.whereHandler.build();
        this.aggHandler.build();
        this.valueHandler.build();
    }
}

