"""
Django settings for corgy_erp project.

Generated by 'django-admin startproject' using Django 3.0.6.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os
import sentry_sdk
from sentry_sdk.integrations.django import DjangoIntegration
from configurations import Configuration, values
from django.utils.translation import ugettext_lazy as _
from django.core import validators
import logging

from dotenv import load_dotenv
load_dotenv(verbose=True)

class URIValue(values.ValidationMixin, values.Value):
    message = 'Cannot interpret URL value {0!r}'
    validator = validators.URLValidator(schemes=[
        'http', 'https',
        'ftp', 'ftps',
        'ldap', 'ldaps',
        'smtp', 'smtps',
        'redis',
        'postgres',
    ])

ENVIRON_PREFIX = 'CORGY'

class GoogleMapConfigurationMixin(object):
    GOOGLE_API_KEY = values.Value(default='AIzaSyBkrEScRkVmdQ-KN_rv-E-sV0UmhyMxFjo', environ_prefix=ENVIRON_PREFIX)

class Base(GoogleMapConfigurationMixin, Configuration):

    # Build paths inside the project like this: os.path.join(BASE_DIR, ...)
    BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


    # Quick-start development settings - unsuitable for production
    # See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

    # SECURITY WARNING: keep the secret key used in production secret!
    SECRET_KEY = 'u)0-b^so@4ci*ehto*c)))3jjh&=c%($@))52(cjk+g$tdfoyx'

    # SECURITY WARNING: don't run with debug turned on in production!
    DEBUG = True

    ALLOWED_HOSTS = [
        '*'
    ]

    SITE_ID = 1

    # Application definition
    PLATFORM_INSTALLED_APPS = [

        'material.theme.amber',

        'material',
        'material.frontend',
        'material.admin',

        'viewflow',
        'viewflow.frontend',

        'django.contrib.admin',
        'django.contrib.auth',
        'django.contrib.contenttypes',
        'django.contrib.sessions',
        'django.contrib.sites',
        'django.contrib.flatpages',
        'django.contrib.humanize',
        'django.contrib.redirects',
        'django.contrib.messages',
        'django.contrib.staticfiles',
        'django.contrib.sitemaps',

        'address',

        'phonenumber_field',
        'avatar',

    ]

    @property
    def CORGY_MODULES(self):
        return [
            'corgy_accounts',
            'corgy_mdm',
            'corgy_worksheet',
            'corgy_payroll',
        ]

    @property
    def INSTALLED_APPS(self):
        return self.PLATFORM_INSTALLED_APPS + self.CORGY_MODULES

    MIDDLEWARE = [
        'django.middleware.security.SecurityMiddleware',
        'django.contrib.sessions.middleware.SessionMiddleware',
        'django.middleware.locale.LocaleMiddleware',
        'django.middleware.common.CommonMiddleware',
        'django.middleware.csrf.CsrfViewMiddleware',
        'django.contrib.auth.middleware.AuthenticationMiddleware',
        'django.contrib.messages.middleware.MessageMiddleware',
        'django.middleware.clickjacking.XFrameOptionsMiddleware',
        'django.contrib.flatpages.middleware.FlatpageFallbackMiddleware',
        'django.contrib.redirects.middleware.RedirectFallbackMiddleware',
    ]

    ROOT_URLCONF = 'corgy_erp.urls'

    TEMPLATES = [
        {
            'BACKEND': 'django.template.backends.django.DjangoTemplates',
            'DIRS': [
                os.path.join(BASE_DIR, 'corgy_erp', 'templates'),
                os.path.join(BASE_DIR, 'templates'),
            ],
            'APP_DIRS': True,
            'OPTIONS': {
                'libraries': {
                    'corgy.erp.version': 'corgy_erp.templatetags.version',
                    'corgy.verbose': 'corgy_erp.templatetags.verbose',
                },
                'context_processors': [
                    'django.template.context_processors.debug',
                    'django.template.context_processors.request',
                    'django.contrib.auth.context_processors.auth',
                    'django.template.context_processors.i18n',
                    'django.template.context_processors.media',
                    'django.template.context_processors.static',
                    'django.template.context_processors.tz',
                    'django.contrib.messages.context_processors.messages',
                ],
            },
        },
    ]

    WSGI_APPLICATION = 'corgy_erp.wsgi.application'

    # Database
    # https://docs.djangoproject.com/en/3.0/ref/settings/#databases

    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.sqlite3',
            'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
        }
    }

    @property
    def FIXTURE_DIRS(self):
        return [os.path.join(self.BASE_DIR, module_name) for module_name in self.CORGY_MODULES]

    # Password validation
    # https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators

    AUTH_PASSWORD_VALIDATORS = [
        {
            'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
        },
    ]


    # Internationalization
    # https://docs.djangoproject.com/en/3.0/topics/i18n/

    LANGUAGE_CODE = values.Value('en-us', environ_prefix=ENVIRON_PREFIX)
    TIME_ZONE = values.Value('Europe/Budapest', environ_prefix=ENVIRON_PREFIX)
    USE_I18N = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    USE_L10N = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    USE_TZ = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    PHONENUMBER_DEFAULT_REGION = 'HU'

    LANGUAGES = (
        ('en', _('English')),
        ('hu', _('Hungarian')),
    )

    LOCALE_PATHS = []

    # Static files (CSS, JavaScript, Images)
    # https://docs.djangoproject.com/en/3.0/howto/static-files/

    STATIC_URL = '/static/'
    STATIC_ROOT = values.PathValue(default=os.path.join(BASE_DIR, 'static'), environ_prefix=ENVIRON_PREFIX)
    STATICFILES_FINDERS = [
        'django.contrib.staticfiles.finders.FileSystemFinder',
        'django.contrib.staticfiles.finders.AppDirectoriesFinder',
        #'compressor.finders.CompressorFinder',
    ]
    STATICFILES_DIRS = [
        os.path.join(BASE_DIR, 'corgy_erp', 'static')
    ]

    # Media files

    MEDIA_URL = '/media/'
    MEDIA_ROOT = values.PathValue(default=os.path.join(BASE_DIR, 'media'), environ_prefix=ENVIRON_PREFIX)


    # Error diagnosting

    SENTRY_DSN = values.URLValue("https://63e1e6dd28b64a2d86cd91c70236d69c@o361028.ingest.sentry.io/5241305")

    LOGGING = {
        'version': 1,
        'disable_existing_loggers': False,
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
            },
        },
        'root': {
            'handlers': ['console'],
            'level': 'INFO',
        },
    }

class Development(Base):

    DATABASES = values.DatabaseURLValue(
        default='sqlite:///%s/development.sqlite3' % str(Base.BASE_DIR),
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Development, cls).post_setup()
        print("Base directory: %s" % cls.BASE_DIR)
        print("Static root: %s" % cls.STATIC_ROOT)
        print("Media root: %s" % cls.MEDIA_ROOT)
        print("Database connection: %s" % cls.DATABASES['default']['NAME'])


class Staging(Base):

    DATABASES = values.DatabaseURLValue(
        default='sqlite:///%s/staging.sqlite3' % str(Base.BASE_DIR),
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Production, cls).post_setup()

        sentry_sdk.init(
            dsn=cls.SENTRY_DSN,
            server_name='gitlab.com',
            environment='staging',
            debug=True,
            integrations=[
                DjangoIntegration(),
            ],
            # If you wish to associate users to errors (assuming you are using
            # django.contrib.auth) you may enable sending PII data.
            send_default_pii=True
        )

class Production(Base):
    SECRET_KEY = values.SecretValue(environ_prefix=ENVIRON_PREFIX)

    DATABASES = values.DatabaseURLValue(
        default='postgres://corgy:qwe123@localhost:5432/corgy_database',
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Production, cls).post_setup()

        print("Base directory: %s" % cls.BASE_DIR)
        print("Static root: %s" % cls.STATIC_ROOT)
        print("Media root: %s" % cls.MEDIA_ROOT)
        print("Database connection: %s" % cls.DATABASES['default']['NAME'])

        from .version import __version__ as release_version

        sentry_sdk.init(
            dsn=cls.SENTRY_DSN,
            server_name='corgy.cherubits.hu',
            environment='production',
            release='corgy_erp@%s' % release_version,
            debug=False,
            integrations=[
                DjangoIntegration(),
            ],
            # If you wish to associate users to errors (assuming you are using
            # django.contrib.auth) you may enable sending PII data.
            send_default_pii=True
        )