# LiuAlgoTrader
[![Build Status](https://travis-ci.org/amor71/LiuAlgoTrader.svg?branch=master)](https://travis-ci.org/amor71/LiuAlgoTrader)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/liualgotrader)
[![Python 3](https://pyup.io/repos/github/amor71/LiuAlgoTrader/python-3-shield.svg)](https://pyup.io/repos/github/amor71/LiuAlgoTrader/)
[![Updates](https://pyup.io/repos/github/amor71/LiuAlgoTrader/shield.svg)](https://pyup.io/repos/github/amor71/LiuAlgoTrader/)
[![Documentation Status](https://readthedocs.org/projects/liualgotrader/badge/?version=latest)](https://liualgotrader.readthedocs.io/en/latest/?badge=latest)

## Introduction

**LiuAlgoTrader** is a scalable, multi-process framework
for effective algorithmic trading. The framework is
intended to simplify development, testing,
deployment and evaluating algo trading strategies.

LiuAlgoTrader can run on a laptop and 
*hedge-on-the-go*, or run on a multi-core hosted Linux server 
and it will automatically optimize for best performance for either. 

## See LiuAlgoTrader in Action

LiuAlgoTrader comes equipped with powerful & user-friendly back-testing tool. 

[Watch a $4,000 Profit](https://youtu.be/rVwFCbHsbIY) using LiuAlgoTrader out-of-the-box tools.


## Quickstart

### Prerequisite

- Paper, and a funded account with [Alpaca Markets](https://alpaca.markets/docs/about-us/).
- Installed [Docker Engine](https://docs.docker.com/engine/install/) and [Docker Compose](https://docs.docker.com/compose/install/)
### Install & Configure

**Step 1**: 
To install LiuAlgoTrader just type: 

`pip install liualgotrader`
 
**Step 2**: To configure the frame work type:

`liu quickstart` 

and follow the installation wizard instructions. The wizard will walk you
through the configuration of environment variables, setup of a local 
dockerized PostgreSQL and pre-populate with test data. 
 

### Try the samples

LiuAlgoTrader `quickstart` wizard installs samples allowing a first-time experience of the framework. Follow the post-installation instructions, and try to back-test a specific day.   

Additional samples can we found in the [examples](examples) directory. 

## What's Next?

Read the [documentation](https://liualgotrader.readthedocs.io/en/latest/) and learn how to use LiuAlgoTrader to develop, deploy & testing money making strategies.


## Contributing

Would you like to help improve & evolve LiuAlgoTrader? 
Do you have a suggestion, comment, idea for improvement or 
a have a wish-list item? Please read our
[Contribution Document](https://github.com/amor71/LiuAlgoTrader/blob/master/CONTRIBUTING.md) or 
email me at  amichay@sgeltd.com

## Contributors

Special thanks to the below individuals for their comments, reviews and suggestions:

- Shlomi Kushchi [shlomikushchi](https://github.com/shlomikushchi)
- Venkat Y [vinmestmant](https://github.com/vinmestmant)
- Chris [crowforc3](https://github.com/crawforc3)







