# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['get_source_code', 'file_extract']

# %% ../nbs/00_core.ipynb 3
import inspect

# %% ../nbs/00_core.ipynb 4
def get_source_code(obj:object, # The object whose source code you want to retrieve.
                    markdown=False): # Returns the source code formatted as markdown
    """
    Returns the source code of an object, with an optional markdown formatting.
    """
    # Get the source code of the object
    source = inspect.getsource(obj)
    
    if markdown:
        # Format the source code as markdown code block
        source = f"```python\n{source}\n```"
        
        # Check if the code is running in Jupyter Notebook
        try:
            get_ipython
            from IPython.display import Markdown
            # Format the source code as an IPython Markdown object
            source = Markdown(source)
        except NameError:
            # If not in Jupyter Notebook, do nothing
            pass
    # Return the formatted source code
    return source

# %% ../nbs/00_core.ipynb 7
import zipfile
import tarfile
from pathlib import Path
import os

# %% ../nbs/00_core.ipynb 8
def file_extract(fname, # The path of the archive file
                 dest=None): # The path of the destination directory
    """
    Extract the contents of the given archive file to the destination directory.

    Raises:
        Exception: if the archive file format is not recognized (supported formats are gz and zip)
    """
    
    # If destination directory is not provided, use the parent directory of the archive file
    if dest is None: dest = Path(fname).parent
    
    fname = str(fname)
    
    # Extract the archive file based on its format
    if fname.endswith('gz'):
        tarfile.open(fname, 'r:gz').extractall(dest)
    elif fname.endswith('zip'):
        zipfile.ZipFile(fname).extractall(dest)
    else:
        # Raise an exception if the archive format is not recognized
        raise Exception(f'Unrecognized archive: {fname}')
