# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['adaswarm', 'adaswarm.nn', 'adaswarm.utils']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.5.1,<4.0.0',
 'pandas>=1.4.0,<2.0.0',
 'scikit-learn>=1.0.2,<2.0.0',
 'scipy>=1.7.0,<2.0.0',
 'seaborn>=0.11.2,<0.12.0',
 'tabulate>=0.8.9,<0.9.0',
 'torch>=1.10.0,<2.0.0',
 'torchvision>=0.11.1,<0.12.0',
 'visidata>=2.8,<3.0']

setup_kwargs = {
    'name': 'adaswarm',
    'version': '0.0.1',
    'description': 'An implementation of particle swarm optimisation loss function for PyTorch',
    'long_description': '<!---\nLicensed under the Apache License, Version 2.0 (the "License");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an "AS IS" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n-->\n\n# AdaSwarm\n\nThis repo purportedly implements *AdaSwarm*, an optimizer, that combines Gradient Descent and Particle Swarms. \n\n*AdaSwarm* is based on "AdaSwarm: Augmenting Gradient-Based optimizers in Deep Learning with Swarm Intelligence, _Rohan Mohapatra, Snehanshu Saha, Carlos A. Coello Coello, Anwesh Bhattacharya Soma S. Dhavala, and Sriparna Saha_", to appear in IEEE Transactions on Emerging Topics in Computational Intelligence. An arXiv version can be found [here](https://arxiv.org/abs/2006.09875). [This](https://github.com/rohanmohapatra/pytorch-cifar) repo contains implementation used the paper.\n\n\n## Why *AdaSwarm*:\nSaid  et  al.  [[1]](#1)  postulated  that  swarms behavior is similar to  that of classical  and  quantum  particles.  In  fact, their analogy is so striking that one may think that the social and  individual  intelligence  components  in  Swarms  are,  after  all, nice useful metaphors, and that there is a neat underlying dynamical system at play. This dynamical system perspective was indeed useful in unifying two almost parallel streams, namely, optimization  and  Markov  Chain  Monte  Carlo  sampling. \n\nIn a seminal paper, Wellington and Teh [[2]](#2), showed that a  stochastic  gradient  descent  (SGD)  optimization  technique can  be  turned  into  a  sampling  technique  by  just  adding noise,  governed  by  Langevin  dynamics.  Recently,  Soma  and Sato [[3]](#3) provided further insights into this connection based on  an  underlying  dynamical  system  governed  by  stochastic differential equations (SDEs). \n\nWhile these results are new, the connections  between  derivative-free  optimization  techniques based on Stochastic Approximation and Finite Differences are well documented [[4]](#4). Such strong connections between these seemingly  different  subfields  of  optimization  and  sampling made  us  wonder:  Is  there  a  larger,  more  general  template, of which  the  aforementioned  approaches  are  special  cases, exist? *AdaSwarm* is a result of that deliberation.\n\nWe believe that it is just a beginning of a new breed of **composable optimizers**\n\n## What is *AdaSwarm* in simple terms, in the context Deep Learning:\n1. Setup\n    - ``y``: responses\n    - ``f(.)`` is a model specified by a network with parameters ``w``\n    - ``f(x)``is the prediction at observed feature ``x``\n    - ``L(.)`` is loss, to drive the optimization\n\n2. Approximate gradients of ``L(.)`` w.r.t ``f(.)``\n    - run an independent Swarm optimizer over ``L(.)`` with particle dimension equal to the size of the network\'s output layer\n    - using swarm particle parameters, approximate the gradient of  ``L(.)`` w.r.t ``f(.)``\n\n3. Get gradients of ``f(.)`` w.r.t ``w``\n    - using standard ``AutoDiff``, via chain rule, get the approximate gradient of ``f(.)`` w.r.t ``w``\n\n4. Approximate gradients of ``L(.)`` w.r.t ``w`` via Chain Rule\n    - take the product of gradients in steps (2) and (3)\n\n5. Updates the network weights via standard Back Propagation\n\n## Why does it work? Minor changes are meaningful!\n\nAt this time, we could embellish the fact that Swarm, by being a meta-heuristic algorithm, has less tendency to get trapped in local minimal or has better exploration capabilities. It is helping the problem overall. Secondly, entire information about the "learning" the task comes from the loss, and the function ``f(.)`` only specifies the structural relationship between input and output. Moreover, the ability of EMPSO, the first step toward AdaSwarm facilitates exploration and exploitation equally by using a modified formulation leveraging exponentially averaged velocities and by not ignoring past velocities. It is these velocities (which are different at different stages in the search space) that make the difference at local minima successfully by being able to differentiate between stagnating regions/saddle points and true local minima. Particular objects of interest are the equivalence theorems, such as the following:\n\n"partial derivative of the loss wrt the weights" can be expressed in terms of Swarm parameters thus keeping tight control over the hyper-parameters and not tuning those at all for convergence. This addresses a common complaint about meta-heuristics.\n\n\nSo, having better "optimization" capabilities at the loss, in general, are going to be helpful. While we have ample empirical evidence that shows that *AdaSwarm* is working well, we also have some theory (not complete but enough to offer the convergence insights, particularly from the point of robust loss functions such as MAE and irregular losses used to solve PDEs/PDEs such as the Schrodinger Equation). \n\nAnother speculation, speculation at this time, is that, to the best of our knowledge, all current optimization techniques only harvest information coming from a single paradigm. *AdaSwarm*, whereas, combines different perspectives, like in an ensemble. More than an ensemble, it is a composition -- where different perspectives get chained. That is one fundamental difference between *AdaSwarm* and other population-based techniques.\n\nIn someways, just like an neural network architecture is composed of several layers, *AdaSwarm* is a composition of optmizers. That composition eventually fits into the chain rule.\n\nAs a result, the changes are very small. Same is the case with Adam and RMSProp, right? Other notable examples, where we see pronounced differences in speed/convergence, with very simple changes in the maps are:\n- _Proximal gradient descent_ vs _Accelerated Proximal gradient descent_\n- _Euler_ vs _LeapFrog_ \n_ ...\n\nTherefore, in order to better understand, and develop the theory and tools for composable optimizers, we have to develop both theoretical and computational tools to understand why and where *AdaSwarm* works. Along the way, make such optimizers accessible to the community.\n\n## Adaswarm Equivalence of Gradients: Why is it happening?\n\nThe equivalences are driven by the fllowing equations in the main text (cf. docs/papers folder): \n\nEqns (4)-(6), (15), (18) and the eqn below for non-differentiable loss and (20)-(24)\n\n## Objectives:\n\n1. Develop a plug-and-play optimizer that works with\n    - other optimizers in the PyTorch ecosystem, along side the likes of ``Adam``, ``RMSProp``, ``SGD``\n    - any architecture \n    - any dataset\n    - with the same api as others, i.e., ``optim.AdaSwarm()``\n\n2. Battle test on variety of\n    - test objectives functions\n    - datasets\n    - architectures (Transformers, MLPs,..)\n    - losses (BCE, CCE, MSE, MAE, CheckLoss,...)\n    - paradigms (RIL, Active Learning, Supervised Learning etc..)\n    - etc..\n\n3. Provide insights into the workings of *AdaSwarm* by\n    - analyzing the workings of the optimizers\n    - visualizing the path trajectories\n    - etc..\n\n4. Most importantly, be community driven\n    - there is lot of enthusiasm and interest in the recent graduates and undergraduates, that want to learn ML/AI technologies. Instead of fiddling with MNIST datasets, and predicting Cats and Dogs, do something foundational and meaningful. If you take offence to statement, you are not ready for this project.\n    - turn this into a truly community-driven effort to offer a useable, useful, foundational building block to the deep learning ecosystem\n\n## How to run this project\n\n### Pre-requisites\n\n* Python 3.8+\n* [Poetry](https://python-poetry.org/)\n\n### Setup\n\n```\n$ git clone https://github.com/AdaSwarm/AdaSwarm.git\n```\n\n### Running the example (single method - runs Adaswarm/PSO)\n\n```\n$ cd AdaSwarm\n$ poetry install\n$ poetry shell\n$ ./examples/main.py\n```\n\n### Running the comparison (Adaswarm/PSO versus Adam Optimiser and torch cross entropy loss)\n\n```\n$ cd AdaSwarm\n$ poetry install\n$ poetry shell\n$ ./examples/compare.py\n```\n\n### Viewing the comparison output\nComparison reports are available in the `reports` folder. In both graph (PNG) and tabular formats, or tabular alone if running the `main.py`. To view the CSV contents in a nicely formatted style use this command:  \n```\n$ poetry run vd report/summary.csv\n```\n\n\n## Contributing:\n\n1. While we are yet to establish the policy to contribute, we will follow how any Apache open source project works. For example, see airflow project\'s [contribution](https://github.com/apache/airflow/blob/master/CONTRIBUTING.rst) guidelines. \n\n2. [tbd] \n    - developer slack channel will be coming soon\n    - we will hold weekly zoom/meet at specific times (off office hours, so anybody can join)\n \n \n2. But be mindful. There may not be any no short-term rewards. \n    - Research is bloody hard work. There will not be any instant gratification or recognition for the work. Expect lot of negative results, and set backs.\n    - Optimization problems are generally hard, and writing an Engineering level framework that works on _any_ problem is even harder. It is scientific computing, not writing hello world examples.\n    - So take a plunge only if you are willing to endure the pain, w/o worrying about the end result.\n\n\n## References\n<a id="1">[1]</a> \nS. M. Mikki and A. A. Kishk, Particle Swarm Optimizaton: A Physics-Based Approach.    Morgan & Claypool, 2008.\n\n<a id="2">[2]</a> \nM.  Welling  and  Y.  W.  Teh,  “Bayesian  learning  via  stochastic  gradient langevin dynamics,”In Proceedings of the 28th International Conference on Machine Learning, p. 681–688, 2011.\n\n<a id="3">[3]</a> \nS.  Yokoi  and  I.  Sato,  “Bayesian  interpretation  of  SGD  as  Ito  process,” ArXiv, vol. abs/1911.09011, 201.\n\n<a id="3">[4]</a> \nJ.  Spall, Introduction  to  stochastic  search  and  optimization. Wiley-Interscience, 2003\n\n## Citation\n\n*AdaSwarm* will be appearing in the [paper](https://arxiv.org/abs/2006.09875) you can cite:\n```bibtex\n@inproceedings{adaswarm,\n    title = "daSwarm: Augmenting Gradient-Based optimizers in Deep Learning with Swarm Intelligence",\n    author = "Rohan Mohapatra, Snehanshu Saha, Carlos A. Coello Coello, Anwesh Bhattacharya Soma S. Dhavala, and Sriparna Saha",\n    booktitle = "IEEE Transaction on Emerging Topics in Computational Intelligence",\n    month = tbd,\n    year = "2021",\n    address = "Online",\n    publisher = "IEEE",\n    url = "https://arxiv.org/abs/2006.09875",\n    pages = tbd\n}\n```\n',
    'author': 'Frank Kelly',
    'author_email': None,
    'maintainer': 'Frank Kelly',
    'maintainer_email': None,
    'url': 'https://github.com/AdaSwarm/AdaSwarm',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9.0,<3.11',
}


setup(**setup_kwargs)
