window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"phml": {"fullname": "phml", "modulename": "phml", "type": "module", "doc": "<p>Python Hypertext Markup Language (phml)</p>\n\n<p>The idea behind the creation of Python in Hypertext Markup Language (phml), is to allow for web page\ngeneration with direct access to python. This language pulls directly from frameworks like VueJS.\nThere is conditional rendering, components, python elements, inline/embedded python blocks, and much\nmore. Now let's dive into more about this language.</p>\n\n<p>Let's start with the new <code>python</code> element. Python is a whitespace language. As such phml\nhas the challenge of maintaining the indentation in an appropriate way. With phml, I have made the\ndecision to allow you to have as much leading whitespace as you want as long as the indentation is\nconsistent. This means that indentation is based on the first lines offset. Take this phml example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&lt;</span><span class=\"n\">python</span><span class=\"o\">&gt;</span>\n    <span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n<span class=\"o\">&lt;/</span><span class=\"n\">python</span><span class=\"o\">&gt;</span>\n</code></pre>\n</div>\n\n<p>This phml python block will adjust the offset so that the python is executed as seen below:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>So now we can write python code, now what? You can define functions and variables\nhow you normally would and they are now available to the scope of the entire file.\nTake, for instance, the example from above, the one with <code>py-src=\"urls('youtube')\"</code>.\nYou can define the <code>URL</code> function in the <code>python</code> element and it can be accessed in an element. So\nthe code would look like this:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\ndef URL(link: str) -&gt; str:\n    links = {\n        &quot;youtube&quot;: &quot;https://youtube.com&quot;\n    }\n    if link in links:\n        return links[link]\n    else:\n        return &quot;&quot;\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n\n...\n\n<span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;{URL(&#39;youtube&#39;)}&quot;</span><span class=\"p\">&gt;</span>Youtube<span class=\"p\">&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>phml combines all <code>python</code> elements and treats them as a python file. All local variables and\nimports are parsed and stored so that they may be accessed later. With that in mind that means you\nhave the full power of the python programming language.</p>\n\n<p>Next up is inline python blocks. These are represented with <code>{}</code>. Any text in-between the brackets\nwill be processed as python. This is mostly useful when you want to inject a value from python.\nAssume that there is a variable defined in the <code>python</code> element called <code>message</code>\nand it contains <code>Hello World!</code>. Now this variable can be used like this, <code>&lt;p&gt;{ message }&lt;/p&gt;</code>,\nwhich renders to, <code>&lt;p&gt;Hello World!&lt;/p&gt;</code>.</p>\n\n<blockquote>\n  <p>Note:  Inline python blocks are only rendered in a Text element or inside an html attribute.</p>\n</blockquote>\n\n<p>Multiline blocks are a lot like inline python blocks, but they also have some differences.\nYou can do whatever you like inside this block, however if you expect a value to come from the block\nyou must have at least one local variable. The last local variable defined in this block is used at\nthe result/value.</p>\n\n<p>Conditional Rendering with <code>py-if</code>, <code>py-elif</code>, and <code>py-else</code> is an extremely helpful tool in phml.\n<code>py-if</code> can be used alone and that the python inside it's value must be truthy for the element to be\nrendered. <code>py-elif</code> requires an element with a <code>py-if</code> or <code>py-elif</code> attribute immediately before\nit, and it's condition is rendered the same as <code>py-if</code> but only rendered if a <code>py-if</code> or <code>py-elif</code>\nfirst\nfails. <code>py-else</code> requires there to be either a <code>py-if</code> or a <code>py-else</code> immediately before it. It only\nrenders if the previous element's condition fails. If <code>py-elif</code> or <code>py-else</code> is on an element, but\nthe previous element isn't a <code>py-if</code> or <code>py-elif</code> then an exception will occur. Most importantly,\nthe first element in a chain of conditions must be a <code>py-if</code>. For ease of use, instead of writing\n<code>py-if</code>, <code>py-elif</code>, or <code>py-else</code> can be written as <code>@if</code>, <code>@elif</code>, or <code>@else</code> respectively.</p>\n\n<p>Other than conditions, there is also a built in <code>py-for</code> attribute. Any element with py-for will\ntake a python for-loop expression that will be applied to that element. So if you did something like\nthis:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span> <span class=\"na\">py-for</span><span class=\"o\">=</span><span class=\"s\">&#39;i in range(3)&#39;</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{i}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The compiled html will be:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>1<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>2<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>3<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The <code>for</code> and <code>:</code> in the for loops condition are optional. So you can combine <code>for</code>,\n<code>i in range(10)</code>, and <code>:</code> or leave out <code>for</code> and <code>:</code> at your discretion. <code>py-for</code> can also be\nwritten as <code>@for</code>.</p>\n\n<p>Python attributes are shortcuts for using inline python blocks in html attributes. Normally, in\nphml, you would inject python logic into an attribute similar to this: <code>src=\"{url('youtube')}\"</code>. If\nyou would like to make the whole attribute value a python expression you may prefix any attribute\nwith a <code>py-</code> or <code>:</code>. This keeps the attribute name the same after the prefix, but tells\nthe parser that the entire value should be processed as python. So the previous example can also be\nexpressed as <code>py-src=\"URL('youtube')\"</code> or <code>:src=\"URL('youtube')\"</code>.</p>\n\n<p>This language also has the ability to convert back to html and json with converting to html having\nmore features. Converting to json is just a json representation of a phml ast. However, converting\nto html is where the magic happens. The compiler executes python blocks, substitutes components, and\nprocesses conditions to create a final html string that is dynamic to its original ast. A user may\npass additional kwargs to the compiler to expose additional data to the execution of python blocks.\nIf you wish to compile to a non supported language the compiler can take a callable that returns the\nfinal string. It passes all the data; components, kwargs, ast, etc\u2026 So if a user wishes to extend\nthe language thay may.</p>\n\n<blockquote>\n  <p>:warning: This language is in early planning and development stages. All forms of feedback are\n  encouraged.</p>\n</blockquote>\n"}, "phml.PHMLCore": {"fullname": "phml.PHMLCore", "modulename": "phml", "qualname": "PHMLCore", "type": "class", "doc": "<p>A helper class that bundles the functionality\nof the parser and compiler together. Allows for loading source files,\nparsing strings and dicts, rendering to a different format, and finally\nwriting the results of a render to a file.</p>\n"}, "phml.PHMLCore.__init__": {"fullname": "phml.PHMLCore.__init__", "modulename": "phml", "qualname": "PHMLCore.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.PHMLCore.parser": {"fullname": "phml.PHMLCore.parser", "modulename": "phml", "qualname": "PHMLCore.parser", "type": "variable", "doc": "<p>Instance of a [Parser][phml.parser.Parser].</p>\n", "annotation": ": phml.core.parser.Parser"}, "phml.PHMLCore.compiler": {"fullname": "phml.PHMLCore.compiler", "modulename": "phml", "qualname": "PHMLCore.compiler", "type": "variable", "doc": "<p>Instance of a [Compiler][phml.compile.Compiler].</p>\n", "annotation": ": phml.core.compile.Compiler"}, "phml.PHMLCore.ast": {"fullname": "phml.PHMLCore.ast", "modulename": "phml", "qualname": "PHMLCore.ast", "type": "variable", "doc": "<p>Reference to the parser attributes ast value.</p>\n", "annotation": ": phml.nodes.AST.AST"}, "phml.PHMLCore.add": {"fullname": "phml.PHMLCore.add", "modulename": "phml", "qualname": "PHMLCore.add", "type": "function", "doc": "<p>Add a component to the element replacement list.</p>\n\n<p>Components passed in can be of a few types. The first type it can be is a\npathlib.Path type. This will allow for automatic parsing of the file at the\npath and then the filename and parsed ast are passed to the compiler. It can\nalso be a dictionary of str being the name of the element to be replaced.\nThe name can be snake case, camel case, or pascal cased. The value can either\nbe the parsed result of the component from phml.utils.parse_component() or the\nparsed ast of the component. Lastely, the component can be a tuple. The first\nvalue is the name of the element to be replaced; with the second value being\neither the parsed result of the component or the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.PHMLCore.remove": {"fullname": "phml.PHMLCore.remove", "modulename": "phml", "qualname": "PHMLCore.remove", "type": "function", "doc": "<p>Remove an element from the list of element replacements.</p>\n\n<p>Takes any number of strings or node objects. If a string is passed\nit is used as the key that will be removed. If a node object is passed\nit will attempt to find a matching node and remove it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.PHMLCore.load": {"fullname": "phml.PHMLCore.load", "modulename": "phml", "qualname": "PHMLCore.load", "type": "function", "doc": "<p>Load a source files data and parse it to phml.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>path (str | Path):</strong>  The path to the source file.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.PHMLCore.parse": {"fullname": "phml.PHMLCore.parse", "modulename": "phml", "qualname": "PHMLCore.parse", "type": "function", "doc": "<p>Parse a str or dict object into phml.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Object to parse to phml</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.PHMLCore.render": {"fullname": "phml.PHMLCore.render", "modulename": "phml", "qualname": "PHMLCore.render", "type": "function", "doc": "<p>Render the parsed ast to a different format. Defaults to rendering to html.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>file_type (str):</strong>  The format to render to. Currently support html, phml, and json.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The rendered content in the appropriate format.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;html&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.PHMLCore.write": {"fullname": "phml.PHMLCore.write", "modulename": "phml", "qualname": "PHMLCore.write", "type": "function", "doc": "<p>Renders the parsed ast to a different format, then writes\nit to a given file. Defaults to rendering and writing out as html.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>dest (str | Path):</strong>  The path to the file to be written to.</li>\n<li><strong>file_type (str):</strong>  The format to render the ast as.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n<li><strong>kwargs:</strong>  Any additional data to pass to the compiler that will be exposed to the</li>\n<li>phml files.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">dest</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">file_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;html&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.Compiler": {"fullname": "phml.Compiler", "modulename": "phml", "qualname": "Compiler", "type": "class", "doc": "<p>Used to compile phml into other formats. HTML, PHML,\nJSON, Markdown, etc...</p>\n"}, "phml.Compiler.__init__": {"fullname": "phml.Compiler.__init__", "modulename": "phml", "qualname": "Compiler.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.Compiler.ast": {"fullname": "phml.Compiler.ast", "modulename": "phml", "qualname": "Compiler.ast", "type": "variable", "doc": "<p>phml ast used by the compiler to generate a new format.</p>\n", "annotation": ": phml.nodes.AST.AST"}, "phml.Compiler.add": {"fullname": "phml.Compiler.add", "modulename": "phml", "qualname": "Compiler.add", "type": "function", "doc": "<p>Add a component to the compilers component list.</p>\n\n<p>Components passed in can be of a few types. It can also be a dictionary of str\nbeing the name of the element to be replaced. The name can be snake case, camel\ncase, or pascal cased. The value can either be the parsed result of the component\nfrom phml.utils.parse_component() or the parsed ast of the component. Lastely,\nthe component can be a tuple. The first value is the name of the element to be\nreplaced; with the second value being either the parsed result of the component\nor the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.Compiler.remove": {"fullname": "phml.Compiler.remove", "modulename": "phml", "qualname": "Compiler.remove", "type": "function", "doc": "<p>Takes either component names or components and removes them\nfrom the dictionary.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components (str | All_Nodes):</strong>  Any str name of components or</li>\n<li>node value to remove from the components list in the compiler.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.Compiler.compile": {"fullname": "phml.Compiler.compile", "modulename": "phml", "qualname": "Compiler.compile", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">to_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;html&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.Parser": {"fullname": "phml.Parser", "modulename": "phml", "qualname": "Parser", "type": "class", "doc": "<p>Primary logic to handle everything with a phml file.</p>\n\n<p>This class can parse files as phml files and create an ast.\nThe ast and the nodes themselfs can translate themselves to;\nhtml, phml, and json. The ast can recursively return itself as\nan html string. However, only this class can process the python\nblocks inside of the phml file.</p>\n\n<p>Call Parser.convert() and pass any kwargs you wish to be exposed to\nthe process that processes the python. You may also use Parser.util to\npass extensions to convert and manipulate the html along with the python\nprocessing.</p>\n"}, "phml.Parser.__init__": {"fullname": "phml.Parser.__init__", "modulename": "phml", "qualname": "Parser.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.Parser.parser": {"fullname": "phml.Parser.parser", "modulename": "phml", "qualname": "Parser.parser", "type": "variable", "doc": "<p>The custom builtin <code>html.parser</code> class that builds phml ast.</p>\n", "annotation": ": phml.core.parser.hypertext_markup_parser.HypertextMarkupParser"}, "phml.Parser.ast": {"fullname": "phml.Parser.ast", "modulename": "phml", "qualname": "Parser.ast", "type": "variable", "doc": "<p>The recursive node tree of the phml ast.</p>\n", "annotation": ": phml.nodes.AST.AST"}, "phml.Parser.load": {"fullname": "phml.Parser.load", "modulename": "phml", "qualname": "Parser.load", "type": "function", "doc": "<p>Parse a given phml file to AST following hast and unist.</p>\n\n<p>When finished the PHML.ast variable will be populated with the\nresulting ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>path (str | Path):</strong>  The path to the file that should be parsed.</li>\n<li><strong>handler (Callable | None):</strong>  A function to call instead of the built in</li>\n<li>parser to parse to a phml.AST. Must take a string and return a phml.AST.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>, </span><span class=\"param\"><span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.Parser.parse": {"fullname": "phml.Parser.parse", "modulename": "phml", "qualname": "Parser.parse", "type": "function", "doc": "<p>Parse data from a phml/html string or from a dict to a phml ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Data to parse in to a ast</li>\n<li><strong>data_type (str):</strong>  Can be <code>HTML</code>, <code>PHML</code>, <code>MARKDOWN</code>, or <code>JSON</code> which</li>\n<li>tells parser how to parse the data. Otherwise it will assume</li>\n<li>str data to be html/phml and dict as <code>json</code>.</li>\n<li><strong>handler (Callable | None):</strong>  A function to call instead of the built in</li>\n<li>parser to parse to a phml.AST. Must take a string and return a phml.AST.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.AST": {"fullname": "phml.AST", "modulename": "phml", "qualname": "AST", "type": "class", "doc": "<p>PHML ast.</p>\n\n<p>Contains utility functions that can manipulate the ast.</p>\n"}, "phml.AST.__init__": {"fullname": "phml.AST.__init__", "modulename": "phml", "qualname": "AST.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tree</span></span>)</span>"}, "phml.AST.size": {"fullname": "phml.AST.size", "modulename": "phml", "qualname": "AST.size", "type": "variable", "doc": "<p>Get the number of nodes in the ast tree.</p>\n", "annotation": ": int"}, "phml.AST.children": {"fullname": "phml.AST.children", "modulename": "phml", "qualname": "AST.children", "type": "variable", "doc": "<p>Get access to the ast roots children.\nIs none if there is no root.</p>\n", "annotation": ": list"}, "phml.builder": {"fullname": "phml.builder", "modulename": "phml.builder", "type": "module", "doc": "<p>phml.utils.builder</p>\n\n<p>This module serves as a utility to make building elements and ast's easier.</p>\n"}, "phml.builder.p": {"fullname": "phml.builder.p", "modulename": "phml.builder", "qualname": "p", "type": "function", "doc": "<p>Generic factory for creating phml nodes.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">selector</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core": {"fullname": "phml.core", "modulename": "phml.core", "type": "module", "doc": "<p>phml.core</p>\n\n<p>All core parsing, compiling, and valid file_types.</p>\n"}, "phml.core.Compiler": {"fullname": "phml.core.Compiler", "modulename": "phml.core", "qualname": "Compiler", "type": "class", "doc": "<p>Used to compile phml into other formats. HTML, PHML,\nJSON, Markdown, etc...</p>\n"}, "phml.core.Compiler.__init__": {"fullname": "phml.core.Compiler.__init__", "modulename": "phml.core", "qualname": "Compiler.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.Compiler.ast": {"fullname": "phml.core.Compiler.ast", "modulename": "phml.core", "qualname": "Compiler.ast", "type": "variable", "doc": "<p>phml ast used by the compiler to generate a new format.</p>\n", "annotation": ": phml.nodes.AST.AST"}, "phml.core.Compiler.add": {"fullname": "phml.core.Compiler.add", "modulename": "phml.core", "qualname": "Compiler.add", "type": "function", "doc": "<p>Add a component to the compilers component list.</p>\n\n<p>Components passed in can be of a few types. It can also be a dictionary of str\nbeing the name of the element to be replaced. The name can be snake case, camel\ncase, or pascal cased. The value can either be the parsed result of the component\nfrom phml.utils.parse_component() or the parsed ast of the component. Lastely,\nthe component can be a tuple. The first value is the name of the element to be\nreplaced; with the second value being either the parsed result of the component\nor the component's ast.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.Compiler.remove": {"fullname": "phml.core.Compiler.remove", "modulename": "phml.core", "qualname": "Compiler.remove", "type": "function", "doc": "<p>Takes either component names or components and removes them\nfrom the dictionary.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>components (str | All_Nodes):</strong>  Any str name of components or</li>\n<li>node value to remove from the components list in the compiler.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.Compiler.compile": {"fullname": "phml.core.Compiler.compile", "modulename": "phml.core", "qualname": "Compiler.compile", "type": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">to_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;html&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.Parser": {"fullname": "phml.core.Parser", "modulename": "phml.core", "qualname": "Parser", "type": "class", "doc": "<p>Primary logic to handle everything with a phml file.</p>\n\n<p>This class can parse files as phml files and create an ast.\nThe ast and the nodes themselfs can translate themselves to;\nhtml, phml, and json. The ast can recursively return itself as\nan html string. However, only this class can process the python\nblocks inside of the phml file.</p>\n\n<p>Call Parser.convert() and pass any kwargs you wish to be exposed to\nthe process that processes the python. You may also use Parser.util to\npass extensions to convert and manipulate the html along with the python\nprocessing.</p>\n"}, "phml.core.Parser.__init__": {"fullname": "phml.core.Parser.__init__", "modulename": "phml.core", "qualname": "Parser.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.Parser.parser": {"fullname": "phml.core.Parser.parser", "modulename": "phml.core", "qualname": "Parser.parser", "type": "variable", "doc": "<p>The custom builtin <code>html.parser</code> class that builds phml ast.</p>\n", "annotation": ": phml.core.parser.hypertext_markup_parser.HypertextMarkupParser"}, "phml.core.Parser.ast": {"fullname": "phml.core.Parser.ast", "modulename": "phml.core", "qualname": "Parser.ast", "type": "variable", "doc": "<p>The recursive node tree of the phml ast.</p>\n", "annotation": ": phml.nodes.AST.AST"}, "phml.core.Parser.load": {"fullname": "phml.core.Parser.load", "modulename": "phml.core", "qualname": "Parser.load", "type": "function", "doc": "<p>Parse a given phml file to AST following hast and unist.</p>\n\n<p>When finished the PHML.ast variable will be populated with the\nresulting ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>path (str | Path):</strong>  The path to the file that should be parsed.</li>\n<li><strong>handler (Callable | None):</strong>  A function to call instead of the built in</li>\n<li>parser to parse to a phml.AST. Must take a string and return a phml.AST.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>, </span><span class=\"param\"><span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.Parser.parse": {"fullname": "phml.core.Parser.parse", "modulename": "phml.core", "qualname": "Parser.parse", "type": "function", "doc": "<p>Parse data from a phml/html string or from a dict to a phml ast.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Data to parse in to a ast</li>\n<li><strong>data_type (str):</strong>  Can be <code>HTML</code>, <code>PHML</code>, <code>MARKDOWN</code>, or <code>JSON</code> which</li>\n<li>tells parser how to parse the data. Otherwise it will assume</li>\n<li>str data to be html/phml and dict as <code>json</code>.</li>\n<li><strong>handler (Callable | None):</strong>  A function to call instead of the built in</li>\n<li>parser to parse to a phml.AST. Must take a string and return a phml.AST.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>, </span><span class=\"param\"><span class=\"n\">handler</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.file_types": {"fullname": "phml.core.file_types", "modulename": "phml.core.file_types", "type": "module", "doc": "<p>File types for phml parsing logic.</p>\n"}, "phml.nodes": {"fullname": "phml.nodes", "modulename": "phml.nodes", "type": "module", "doc": "<p>phml.nodes</p>\n\n<p>All things related to phml node data objects.</p>\n"}, "phml.nodes.AST": {"fullname": "phml.nodes.AST", "modulename": "phml.nodes.AST", "type": "module", "doc": "<p>Basic node that holds a root node and has basic utilties.</p>\n\n<p>You can check the size of the tree, iterate over the tree, and directly access\nthe children of the root node.</p>\n"}, "phml.nodes.AST.__init__": {"fullname": "phml.nodes.AST.__init__", "modulename": "phml.nodes", "qualname": "AST.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tree</span></span>)</span>"}, "phml.nodes.AST.size": {"fullname": "phml.nodes.AST.size", "modulename": "phml.nodes", "qualname": "AST.size", "type": "variable", "doc": "<p>Get the number of nodes in the ast tree.</p>\n", "annotation": ": int"}, "phml.nodes.AST.children": {"fullname": "phml.nodes.AST.children", "modulename": "phml.nodes", "qualname": "AST.children", "type": "variable", "doc": "<p>Get access to the ast roots children.\nIs none if there is no root.</p>\n", "annotation": ": list"}, "phml.nodes.Node": {"fullname": "phml.nodes.Node", "modulename": "phml.nodes", "qualname": "Node", "type": "class", "doc": "<p>All node values can be expressed in JSON as: string, number,\nobject, array, true, false, or null. This means that the syntax tree should\nbe able to be converted to and from JSON and produce the same tree.\nFor example, in JavaScript, a tree can be passed through JSON.parse(JSON.phml(tree))\nand result in the same tree.</p>\n"}, "phml.nodes.Node.__init__": {"fullname": "phml.nodes.Node.__init__", "modulename": "phml.nodes", "qualname": "Node.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">position</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.Node.position": {"fullname": "phml.nodes.Node.position", "modulename": "phml.nodes", "qualname": "Node.position", "type": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.nodes.position.Position"}, "phml.nodes.Node.type": {"fullname": "phml.nodes.Node.type", "modulename": "phml.nodes", "qualname": "Node.type", "type": "variable", "doc": "<p>Non-empty string representing the variant of a node.\nThis field can be used to determine the type a node implements.</p>\n", "annotation": ": str"}, "phml.nodes.Root": {"fullname": "phml.nodes.Root", "modulename": "phml.nodes", "qualname": "Root", "type": "class", "doc": "<p>Root (Parent) represents a document.</p>\n\n<p>Root can be used as the root of a tree, or as a value\nof the content field on a 'template' Element, never as a child.</p>\n", "bases": "phml.nodes.parent.Parent"}, "phml.nodes.Root.__init__": {"fullname": "phml.nodes.Root.__init__", "modulename": "phml.nodes", "qualname": "Root.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">position</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.Root.stringify": {"fullname": "phml.nodes.Root.stringify", "modulename": "phml.nodes", "qualname": "Root.stringify", "type": "function", "doc": "<p>Build indented html string of documents elements and their children.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of document</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.DocType": {"fullname": "phml.nodes.DocType", "modulename": "phml.nodes", "qualname": "DocType", "type": "class", "doc": "<p>Doctype (Node) represents a DocumentType ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cp\">&lt;!doctype html&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;doctype&#39;</span><span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "phml.nodes.node.Node"}, "phml.nodes.DocType.__init__": {"fullname": "phml.nodes.DocType.__init__", "modulename": "phml.nodes", "qualname": "DocType.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">position</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.DocType.stringify": {"fullname": "phml.nodes.DocType.stringify", "modulename": "phml.nodes", "qualname": "DocType.stringify", "type": "function", "doc": "<p>Build indented html string of html doctype element.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of doctype element</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Parent": {"fullname": "phml.nodes.Parent", "modulename": "phml.nodes", "qualname": "Parent", "type": "class", "doc": "<p>Parent (UnistParent) represents a node in hast containing other nodes (said to be children).</p>\n\n<p>Its content is limited to only other hast content.</p>\n", "bases": "phml.nodes.node.Node"}, "phml.nodes.Parent.__init__": {"fullname": "phml.nodes.Parent.__init__", "modulename": "phml.nodes", "qualname": "Parent.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">position</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.Element": {"fullname": "phml.nodes.Element", "modulename": "phml.nodes", "qualname": "Element", "type": "class", "doc": "<p>Element (Parent) represents an Element ([DOM]).</p>\n\n<p>A tagName field must be present. It represents the element's local name ([DOM]).</p>\n\n<p>The properties field represents information associated with the element.\nThe value of the properties field implements the Properties interface.</p>\n\n<p>If the tagName field is 'template', a content field can be present. The value\nof the content field implements the Root interface.</p>\n\n<p>If the tagName field is 'template', the element must be a leaf.</p>\n\n<p>If the tagName field is 'noscript', its children should be represented as if\nscripting is disabled ([HTML]).</p>\n\n<p>For example, the following HTML:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;https://alpha.com&quot;</span> <span class=\"na\">class</span><span class=\"o\">=</span><span class=\"s\">&quot;bravo&quot;</span> <span class=\"na\">download</span><span class=\"p\">&gt;&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">href</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;https://alpha.com&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">className</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[</span><span class=\"s1\">&#39;bravo&#39;</span><span class=\"p\">],</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">download</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"kc\">true</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"p\">},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "phml.nodes.parent.Parent"}, "phml.nodes.Element.__init__": {"fullname": "phml.nodes.Element.__init__", "modulename": "phml.nodes", "qualname": "Element.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;element&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">startend</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "phml.nodes.Element.start_tag": {"fullname": "phml.nodes.Element.start_tag", "modulename": "phml.nodes", "qualname": "Element.start_tag", "type": "function", "doc": "<p>Builds the open/start tag for the element.</p>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>It will return <code>/&gt;</code> if the tag is self closing.</p>\n</blockquote>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built element start tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Element.end_tag": {"fullname": "phml.nodes.Element.end_tag", "modulename": "phml.nodes", "qualname": "Element.end_tag", "type": "function", "doc": "<p>Build the elements end tag.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built element end tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Literal": {"fullname": "phml.nodes.Literal", "modulename": "phml.nodes", "qualname": "Literal", "type": "class", "doc": "<p>Literal (UnistLiteral) represents a node in hast containing a value.</p>\n", "bases": "phml.nodes.node.Node"}, "phml.nodes.Literal.__init__": {"fullname": "phml.nodes.Literal.__init__", "modulename": "phml.nodes", "qualname": "Literal.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">position</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.Literal.position": {"fullname": "phml.nodes.Literal.position", "modulename": "phml.nodes", "qualname": "Literal.position", "type": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.nodes.position.Position"}, "phml.nodes.Literal.value": {"fullname": "phml.nodes.Literal.value", "modulename": "phml.nodes", "qualname": "Literal.value", "type": "variable", "doc": "<p>The Literal nodes value. All literal values must be strings</p>\n", "annotation": ": str"}, "phml.nodes.Literal.get_ancestry": {"fullname": "phml.nodes.Literal.get_ancestry", "modulename": "phml.nodes", "qualname": "Literal.get_ancestry", "type": "function", "doc": "<p>Get the ancestry of the literal node.</p>\n\n<p>Used to validate whether there is a <code>pre</code> element in the ancestry.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Comment": {"fullname": "phml.nodes.Comment", "modulename": "phml.nodes", "qualname": "Comment", "type": "class", "doc": "<p>Comment (Literal) represents a Comment ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!--Charlie--&gt;</span>\n</code></pre>\n</div>\n", "bases": "phml.nodes.literal.Literal"}, "phml.nodes.Comment.stringify": {"fullname": "phml.nodes.Comment.stringify", "modulename": "phml.nodes", "qualname": "Comment.stringify", "type": "function", "doc": "<p>Build indented html string of html comment.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of comment</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Text": {"fullname": "phml.nodes.Text", "modulename": "phml.nodes", "qualname": "Text", "type": "class", "doc": "<p>Text (Literal) represents a Text ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>Foxtrot<span class=\"p\">&lt;/</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;text&#39;</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"nx\">value</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;Foxtrot&#39;</span><span class=\"p\">}]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "phml.nodes.literal.Literal"}, "phml.nodes.Text.num_lines": {"fullname": "phml.nodes.Text.num_lines", "modulename": "phml.nodes", "qualname": "Text.num_lines", "type": "variable", "doc": "<p>Determine the number of lines the text has.</p>\n", "annotation": ": int"}, "phml.nodes.Text.stringify": {"fullname": "phml.nodes.Text.stringify", "modulename": "phml.nodes", "qualname": "Text.stringify", "type": "function", "doc": "<p>Build indented html string of html text.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Built html of text</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.nodes.Position": {"fullname": "phml.nodes.Position", "modulename": "phml.nodes", "qualname": "Position", "type": "class", "doc": "<p>Position represents the location of a node in a source file.</p>\n\n<p>The <code>start</code> field of <code>Position</code> represents the place of the first character\nof the parsed source region. The <code>end</code> field of Position represents the place\nof the first character after the parsed source region, whether it exists or not.\nThe value of the <code>start</code> and <code>end</code> fields implement the <code>Point</code> interface.</p>\n\n<p>The <code>indent</code> field of <code>Position</code> represents the start column at each index\n(plus start line) in the source region, for elements that span multiple lines.</p>\n\n<p>If the syntactic unit represented by a node is not present in the source file at\nthe time of parsing, the node is said to be <code>generated</code> and it must not have positional\ninformation.</p>\n"}, "phml.nodes.Position.__init__": {"fullname": "phml.nodes.Position.__init__", "modulename": "phml.nodes", "qualname": "Position.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">point</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">point</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.Point": {"fullname": "phml.nodes.Point", "modulename": "phml.nodes", "qualname": "Point", "type": "class", "doc": "<p>Represents one place in a source file.</p>\n\n<p>The line field (1-indexed integer) represents a line in a source file. The column field\n(1-indexed integer) represents a column in a source file. The offset field (0-indexed integer)\nrepresents a character in a source file.</p>\n"}, "phml.nodes.Point.__init__": {"fullname": "phml.nodes.Point.__init__", "modulename": "phml.nodes", "qualname": "Point.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.nodes.PropertyName": {"fullname": "phml.nodes.PropertyName", "modulename": "phml.nodes", "qualname": "PropertyName", "type": "class", "doc": "<p>str(object='') -> str\nstr(bytes_or_buffer[, encoding[, errors]]) -> str</p>\n\n<p>Create a new string object from the given object. If encoding or\nerrors is specified, then the object must expose a data buffer\nthat will be decoded using the given encoding and error handler.\nOtherwise, returns the result of object.__str__() (if defined)\nor repr(object).\nencoding defaults to sys.getdefaultencoding().\nerrors defaults to 'strict'.</p>\n"}, "phml.nodes.PropertyName.__init__": {"fullname": "phml.nodes.PropertyName.__init__", "modulename": "phml.nodes", "qualname": "PropertyName.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.nodes.PropertyName.encode": {"fullname": "phml.nodes.PropertyName.encode", "modulename": "phml.nodes", "qualname": "PropertyName.encode", "type": "function", "doc": "<p>Encode the string using the codec registered for encoding.</p>\n\n<p>encoding\n  The encoding in which to encode the string.\nerrors\n  The error handling scheme to use for encoding errors.\n  The default is 'strict' meaning that encoding errors raise a\n  UnicodeEncodeError.  Other possible values are 'ignore', 'replace' and\n  'xmlcharrefreplace' as well as any other name registered with\n  codecs.register_error that can handle UnicodeEncodeErrors.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">encoding</span><span class=\"o\">=</span><span class=\"s1\">&#39;utf-8&#39;</span>, </span><span class=\"param\"><span class=\"n\">errors</span><span class=\"o\">=</span><span class=\"s1\">&#39;strict&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.replace": {"fullname": "phml.nodes.PropertyName.replace", "modulename": "phml.nodes", "qualname": "PropertyName.replace", "type": "function", "doc": "<p>Return a copy with all occurrences of substring old replaced by new.</p>\n\n<p>count\n    Maximum number of occurrences to replace.\n    -1 (the default value) means replace all occurrences.</p>\n\n<p>If the optional argument count is given, only the first count occurrences are\nreplaced.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">old</span>, </span><span class=\"param\"><span class=\"n\">new</span>, </span><span class=\"param\"><span class=\"n\">count</span><span class=\"o\">=-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.split": {"fullname": "phml.nodes.PropertyName.split", "modulename": "phml.nodes", "qualname": "PropertyName.split", "type": "function", "doc": "<p>Return a list of the substrings in the string, using sep as the separator string.</p>\n\n<p>sep\n    The separator used to split the string.</p>\n\n<pre><code>When set to None (the default value), will split on any whitespace\ncharacter (including \\\\n \\\\r \\\\t \\\\f and spaces) and will discard\nempty strings from the result.\n</code></pre>\n\n<p>maxsplit\n    Maximum number of splits (starting from the left).\n    -1 (the default value) means no limit.</p>\n\n<p>Note, str.split() is mainly useful for data that has been intentionally\ndelimited.  With natural text that includes punctuation, consider using\nthe regular expression module.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">maxsplit</span><span class=\"o\">=-</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rsplit": {"fullname": "phml.nodes.PropertyName.rsplit", "modulename": "phml.nodes", "qualname": "PropertyName.rsplit", "type": "function", "doc": "<p>Return a list of the substrings in the string, using sep as the separator string.</p>\n\n<p>sep\n    The separator used to split the string.</p>\n\n<pre><code>When set to None (the default value), will split on any whitespace\ncharacter (including \\\\n \\\\r \\\\t \\\\f and spaces) and will discard\nempty strings from the result.\n</code></pre>\n\n<p>maxsplit\n    Maximum number of splits (starting from the left).\n    -1 (the default value) means no limit.</p>\n\n<p>Splitting starts at the end of the string and works to the front.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">maxsplit</span><span class=\"o\">=-</span><span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.join": {"fullname": "phml.nodes.PropertyName.join", "modulename": "phml.nodes", "qualname": "PropertyName.join", "type": "function", "doc": "<p>Concatenate any number of strings.</p>\n\n<p>The string whose method is called is inserted in between each given string.\nThe result is returned as a new string.</p>\n\n<p>Example: '.'.join(['ab', 'pq', 'rs']) -> 'ab.pq.rs'</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">iterable</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.capitalize": {"fullname": "phml.nodes.PropertyName.capitalize", "modulename": "phml.nodes", "qualname": "PropertyName.capitalize", "type": "function", "doc": "<p>Return a capitalized version of the string.</p>\n\n<p>More specifically, make the first character have upper case and the rest lower\ncase.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.casefold": {"fullname": "phml.nodes.PropertyName.casefold", "modulename": "phml.nodes", "qualname": "PropertyName.casefold", "type": "function", "doc": "<p>Return a version of the string suitable for caseless comparisons.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.title": {"fullname": "phml.nodes.PropertyName.title", "modulename": "phml.nodes", "qualname": "PropertyName.title", "type": "function", "doc": "<p>Return a version of the string where each word is titlecased.</p>\n\n<p>More specifically, words start with uppercased characters and all remaining\ncased characters have lower case.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.center": {"fullname": "phml.nodes.PropertyName.center", "modulename": "phml.nodes", "qualname": "PropertyName.center", "type": "function", "doc": "<p>Return a centered string of length width.</p>\n\n<p>Padding is done using the specified fill character (default is a space).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"n\">fillchar</span><span class=\"o\">=</span><span class=\"s1\">&#39; &#39;</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.count": {"fullname": "phml.nodes.PropertyName.count", "modulename": "phml.nodes", "qualname": "PropertyName.count", "type": "function", "doc": "<p>S.count(sub[, start[, end]]) -> int</p>\n\n<p>Return the number of non-overlapping occurrences of substring sub in\nstring S[start:end].  Optional arguments start and end are\ninterpreted as in slice notation.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.expandtabs": {"fullname": "phml.nodes.PropertyName.expandtabs", "modulename": "phml.nodes", "qualname": "PropertyName.expandtabs", "type": "function", "doc": "<p>Return a copy where all tab characters are expanded using spaces.</p>\n\n<p>If tabsize is not given, a tab size of 8 characters is assumed.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">tabsize</span><span class=\"o\">=</span><span class=\"mi\">8</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.find": {"fullname": "phml.nodes.PropertyName.find", "modulename": "phml.nodes", "qualname": "PropertyName.find", "type": "function", "doc": "<p>S.find(sub[, start[, end]]) -> int</p>\n\n<p>Return the lowest index in S where substring sub is found,\nsuch that sub is contained within S[start:end].  Optional\narguments start and end are interpreted as in slice notation.</p>\n\n<p>Return -1 on failure.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.partition": {"fullname": "phml.nodes.PropertyName.partition", "modulename": "phml.nodes", "qualname": "PropertyName.partition", "type": "function", "doc": "<p>Partition the string into three parts using the given separator.</p>\n\n<p>This will search for the separator in the string.  If the separator is found,\nreturns a 3-tuple containing the part before the separator, the separator\nitself, and the part after it.</p>\n\n<p>If the separator is not found, returns a 3-tuple containing the original string\nand two empty strings.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sep</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.index": {"fullname": "phml.nodes.PropertyName.index", "modulename": "phml.nodes", "qualname": "PropertyName.index", "type": "function", "doc": "<p>S.index(sub[, start[, end]]) -> int</p>\n\n<p>Return the lowest index in S where substring sub is found,\nsuch that sub is contained within S[start:end].  Optional\narguments start and end are interpreted as in slice notation.</p>\n\n<p>Raises ValueError when the substring is not found.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.ljust": {"fullname": "phml.nodes.PropertyName.ljust", "modulename": "phml.nodes", "qualname": "PropertyName.ljust", "type": "function", "doc": "<p>Return a left-justified string of length width.</p>\n\n<p>Padding is done using the specified fill character (default is a space).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"n\">fillchar</span><span class=\"o\">=</span><span class=\"s1\">&#39; &#39;</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.lower": {"fullname": "phml.nodes.PropertyName.lower", "modulename": "phml.nodes", "qualname": "PropertyName.lower", "type": "function", "doc": "<p>Return a copy of the string converted to lowercase.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.lstrip": {"fullname": "phml.nodes.PropertyName.lstrip", "modulename": "phml.nodes", "qualname": "PropertyName.lstrip", "type": "function", "doc": "<p>Return a copy of the string with leading whitespace removed.</p>\n\n<p>If chars is given and not None, remove characters in chars instead.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">chars</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rfind": {"fullname": "phml.nodes.PropertyName.rfind", "modulename": "phml.nodes", "qualname": "PropertyName.rfind", "type": "function", "doc": "<p>S.rfind(sub[, start[, end]]) -> int</p>\n\n<p>Return the highest index in S where substring sub is found,\nsuch that sub is contained within S[start:end].  Optional\narguments start and end are interpreted as in slice notation.</p>\n\n<p>Return -1 on failure.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rindex": {"fullname": "phml.nodes.PropertyName.rindex", "modulename": "phml.nodes", "qualname": "PropertyName.rindex", "type": "function", "doc": "<p>S.rindex(sub[, start[, end]]) -> int</p>\n\n<p>Return the highest index in S where substring sub is found,\nsuch that sub is contained within S[start:end].  Optional\narguments start and end are interpreted as in slice notation.</p>\n\n<p>Raises ValueError when the substring is not found.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rjust": {"fullname": "phml.nodes.PropertyName.rjust", "modulename": "phml.nodes", "qualname": "PropertyName.rjust", "type": "function", "doc": "<p>Return a right-justified string of length width.</p>\n\n<p>Padding is done using the specified fill character (default is a space).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"n\">fillchar</span><span class=\"o\">=</span><span class=\"s1\">&#39; &#39;</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rstrip": {"fullname": "phml.nodes.PropertyName.rstrip", "modulename": "phml.nodes", "qualname": "PropertyName.rstrip", "type": "function", "doc": "<p>Return a copy of the string with trailing whitespace removed.</p>\n\n<p>If chars is given and not None, remove characters in chars instead.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">chars</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.rpartition": {"fullname": "phml.nodes.PropertyName.rpartition", "modulename": "phml.nodes", "qualname": "PropertyName.rpartition", "type": "function", "doc": "<p>Partition the string into three parts using the given separator.</p>\n\n<p>This will search for the separator in the string, starting at the end. If\nthe separator is found, returns a 3-tuple containing the part before the\nseparator, the separator itself, and the part after it.</p>\n\n<p>If the separator is not found, returns a 3-tuple containing two empty strings\nand the original string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sep</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.splitlines": {"fullname": "phml.nodes.PropertyName.splitlines", "modulename": "phml.nodes", "qualname": "PropertyName.splitlines", "type": "function", "doc": "<p>Return a list of the lines in the string, breaking at line boundaries.</p>\n\n<p>Line breaks are not included in the resulting list unless keepends is given and\ntrue.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span>, </span><span class=\"param\"><span class=\"n\">keepends</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.strip": {"fullname": "phml.nodes.PropertyName.strip", "modulename": "phml.nodes", "qualname": "PropertyName.strip", "type": "function", "doc": "<p>Return a copy of the string with leading and trailing whitespace removed.</p>\n\n<p>If chars is given and not None, remove characters in chars instead.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">chars</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.swapcase": {"fullname": "phml.nodes.PropertyName.swapcase", "modulename": "phml.nodes", "qualname": "PropertyName.swapcase", "type": "function", "doc": "<p>Convert uppercase characters to lowercase and lowercase characters to uppercase.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.translate": {"fullname": "phml.nodes.PropertyName.translate", "modulename": "phml.nodes", "qualname": "PropertyName.translate", "type": "function", "doc": "<p>Replace each character in the string using the given translation table.</p>\n\n<p>table\n    Translation table, which must be a mapping of Unicode ordinals to\n    Unicode ordinals, strings, or None.</p>\n\n<p>The table must implement lookup/indexing via __getitem__, for instance a\ndictionary or list.  If this operation raises LookupError, the character is\nleft untouched.  Characters mapped to None are deleted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.upper": {"fullname": "phml.nodes.PropertyName.upper", "modulename": "phml.nodes", "qualname": "PropertyName.upper", "type": "function", "doc": "<p>Return a copy of the string converted to uppercase.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.startswith": {"fullname": "phml.nodes.PropertyName.startswith", "modulename": "phml.nodes", "qualname": "PropertyName.startswith", "type": "function", "doc": "<p>S.startswith(prefix[, start[, end]]) -> bool</p>\n\n<p>Return True if S starts with the specified prefix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nprefix can also be a tuple of strings to try.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.endswith": {"fullname": "phml.nodes.PropertyName.endswith", "modulename": "phml.nodes", "qualname": "PropertyName.endswith", "type": "function", "doc": "<p>S.endswith(suffix[, start[, end]]) -> bool</p>\n\n<p>Return True if S ends with the specified suffix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nsuffix can also be a tuple of strings to try.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.removeprefix": {"fullname": "phml.nodes.PropertyName.removeprefix", "modulename": "phml.nodes", "qualname": "PropertyName.removeprefix", "type": "function", "doc": "<p>Return a str with the given prefix string removed if present.</p>\n\n<p>If the string starts with the prefix string, return string[len(prefix):].\nOtherwise, return a copy of the original string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">prefix</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.removesuffix": {"fullname": "phml.nodes.PropertyName.removesuffix", "modulename": "phml.nodes", "qualname": "PropertyName.removesuffix", "type": "function", "doc": "<p>Return a str with the given suffix string removed if present.</p>\n\n<p>If the string ends with the suffix string and that suffix is not empty,\nreturn string[:-len(suffix)]. Otherwise, return a copy of the original\nstring.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">suffix</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isascii": {"fullname": "phml.nodes.PropertyName.isascii", "modulename": "phml.nodes", "qualname": "PropertyName.isascii", "type": "function", "doc": "<p>Return True if all characters in the string are ASCII, False otherwise.</p>\n\n<p>ASCII characters have code points in the range U+0000-U+007F.\nEmpty string is ASCII too.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.islower": {"fullname": "phml.nodes.PropertyName.islower", "modulename": "phml.nodes", "qualname": "PropertyName.islower", "type": "function", "doc": "<p>Return True if the string is a lowercase string, False otherwise.</p>\n\n<p>A string is lowercase if all cased characters in the string are lowercase and\nthere is at least one cased character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isupper": {"fullname": "phml.nodes.PropertyName.isupper", "modulename": "phml.nodes", "qualname": "PropertyName.isupper", "type": "function", "doc": "<p>Return True if the string is an uppercase string, False otherwise.</p>\n\n<p>A string is uppercase if all cased characters in the string are uppercase and\nthere is at least one cased character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.istitle": {"fullname": "phml.nodes.PropertyName.istitle", "modulename": "phml.nodes", "qualname": "PropertyName.istitle", "type": "function", "doc": "<p>Return True if the string is a title-cased string, False otherwise.</p>\n\n<p>In a title-cased string, upper- and title-case characters may only\nfollow uncased characters and lowercase characters only cased ones.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isspace": {"fullname": "phml.nodes.PropertyName.isspace", "modulename": "phml.nodes", "qualname": "PropertyName.isspace", "type": "function", "doc": "<p>Return True if the string is a whitespace string, False otherwise.</p>\n\n<p>A string is whitespace if all characters in the string are whitespace and there\nis at least one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isdecimal": {"fullname": "phml.nodes.PropertyName.isdecimal", "modulename": "phml.nodes", "qualname": "PropertyName.isdecimal", "type": "function", "doc": "<p>Return True if the string is a decimal string, False otherwise.</p>\n\n<p>A string is a decimal string if all characters in the string are decimal and\nthere is at least one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isdigit": {"fullname": "phml.nodes.PropertyName.isdigit", "modulename": "phml.nodes", "qualname": "PropertyName.isdigit", "type": "function", "doc": "<p>Return True if the string is a digit string, False otherwise.</p>\n\n<p>A string is a digit string if all characters in the string are digits and there\nis at least one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isnumeric": {"fullname": "phml.nodes.PropertyName.isnumeric", "modulename": "phml.nodes", "qualname": "PropertyName.isnumeric", "type": "function", "doc": "<p>Return True if the string is a numeric string, False otherwise.</p>\n\n<p>A string is numeric if all characters in the string are numeric and there is at\nleast one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isalpha": {"fullname": "phml.nodes.PropertyName.isalpha", "modulename": "phml.nodes", "qualname": "PropertyName.isalpha", "type": "function", "doc": "<p>Return True if the string is an alphabetic string, False otherwise.</p>\n\n<p>A string is alphabetic if all characters in the string are alphabetic and there\nis at least one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isalnum": {"fullname": "phml.nodes.PropertyName.isalnum", "modulename": "phml.nodes", "qualname": "PropertyName.isalnum", "type": "function", "doc": "<p>Return True if the string is an alpha-numeric string, False otherwise.</p>\n\n<p>A string is alpha-numeric if all characters in the string are alpha-numeric and\nthere is at least one character in the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isidentifier": {"fullname": "phml.nodes.PropertyName.isidentifier", "modulename": "phml.nodes", "qualname": "PropertyName.isidentifier", "type": "function", "doc": "<p>Return True if the string is a valid Python identifier, False otherwise.</p>\n\n<p>Call keyword.iskeyword(s) to test whether string s is a reserved identifier,\nsuch as \"def\" or \"class\".</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.isprintable": {"fullname": "phml.nodes.PropertyName.isprintable", "modulename": "phml.nodes", "qualname": "PropertyName.isprintable", "type": "function", "doc": "<p>Return True if the string is printable, False otherwise.</p>\n\n<p>A string is printable if all of its characters are considered printable in\nrepr() or if it is empty.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.zfill": {"fullname": "phml.nodes.PropertyName.zfill", "modulename": "phml.nodes", "qualname": "PropertyName.zfill", "type": "function", "doc": "<p>Pad a numeric string with zeros on the left, to fill a field of the given width.</p>\n\n<p>The string is never truncated.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"o\">/</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.format": {"fullname": "phml.nodes.PropertyName.format", "modulename": "phml.nodes", "qualname": "PropertyName.format", "type": "function", "doc": "<p>S.format(<em>args, *</em>kwargs) -> str</p>\n\n<p>Return a formatted version of S, using substitutions from args and kwargs.\nThe substitutions are identified by braces ('{' and '}').</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.format_map": {"fullname": "phml.nodes.PropertyName.format_map", "modulename": "phml.nodes", "qualname": "PropertyName.format_map", "type": "function", "doc": "<p>S.format_map(mapping) -> str</p>\n\n<p>Return a formatted version of S, using substitutions from mapping.\nThe substitutions are identified by braces ('{' and '}').</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.PropertyName.maketrans": {"fullname": "phml.nodes.PropertyName.maketrans", "modulename": "phml.nodes", "qualname": "PropertyName.maketrans", "type": "function", "doc": "<p>Return a translation table usable for str.translate().</p>\n\n<p>If there is only one argument, it must be a dictionary mapping Unicode\nordinals (integers) or characters to Unicode ordinals, strings or None.\nCharacter keys will be then converted to ordinals.\nIf there are two arguments, they must be strings of equal length, and\nin the resulting dictionary, each character in x will be mapped to the\ncharacter at the same position in y. If there is a third argument, it\nmust be a string, whose characters will be mapped to None in the result.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.nodes.AST.AST": {"fullname": "phml.nodes.AST.AST", "modulename": "phml.nodes.AST", "qualname": "AST", "type": "class", "doc": "<p>PHML ast.</p>\n\n<p>Contains utility functions that can manipulate the ast.</p>\n"}, "phml.nodes.AST.AST.__init__": {"fullname": "phml.nodes.AST.AST.__init__", "modulename": "phml.nodes.AST", "qualname": "AST.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tree</span></span>)</span>"}, "phml.nodes.AST.AST.size": {"fullname": "phml.nodes.AST.AST.size", "modulename": "phml.nodes.AST", "qualname": "AST.size", "type": "variable", "doc": "<p>Get the number of nodes in the ast tree.</p>\n", "annotation": ": int"}, "phml.nodes.AST.AST.children": {"fullname": "phml.nodes.AST.AST.children", "modulename": "phml.nodes.AST", "qualname": "AST.children", "type": "variable", "doc": "<p>Get access to the ast roots children.\nIs none if there is no root.</p>\n", "annotation": ": list"}, "phml.utils": {"fullname": "phml.utils", "modulename": "phml.utils", "type": "module", "doc": "<p>phml.Utils</p>\n\n<p>This is a collection of utility functions that allow for manipulation, traversal,\nand discovery inside a phml.ast.AST.</p>\n"}, "phml.utils.locate": {"fullname": "phml.utils.locate", "modulename": "phml.utils.locate", "type": "module", "doc": "<p>utils.find</p>\n\n<p>Collection of utilities centered around finding nodes in an ast.</p>\n"}, "phml.utils.locate.find": {"fullname": "phml.utils.locate.find", "modulename": "phml.utils.locate.find", "type": "module", "doc": "<p>phml.utils.locate.find</p>\n\n<p>Collection of utility methods to find one or many of a specific node.</p>\n"}, "phml.utils.locate.find.ancestor": {"fullname": "phml.utils.locate.find.ancestor", "modulename": "phml.utils.locate.find", "qualname": "ancestor", "type": "function", "doc": "<p>Get the common ancestor between two nodes.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>*nodes (All_Nodes):</strong>  A list of any number of nodes</li>\n<li>to find the common ancestor form. Worst case it will</li>\n<li>return the root.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[All_Nodes]: The node that is the common\n  ancestor or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">nodes</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find": {"fullname": "phml.utils.locate.find.find", "modulename": "phml.utils.locate.find", "qualname": "find", "type": "function", "doc": "<p>Walk the nodes children and return the desired node.</p>\n\n<p>Returns the first node that matches the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[All_Nodes]: Returns the found node or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_all": {"fullname": "phml.utils.locate.find.find_all", "modulename": "phml.utils.locate.find", "qualname": "find_all", "type": "function", "doc": "<p>Find all nodes that match the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[All_Nodes]: List of found nodes. Empty if no nodes are found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_after": {"fullname": "phml.utils.locate.find.find_after", "modulename": "phml.utils.locate.find", "qualname": "find_after", "type": "function", "doc": "<p>Get the first sibling node following the provided node that matches\nthe condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (All_Nodes):</strong>  Node to get sibling from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[All_Nodes]: Returns the first sibling or None if there\n  are no siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_all_after": {"fullname": "phml.utils.locate.find.find_all_after", "modulename": "phml.utils.locate.find", "qualname": "find_all_after", "type": "function", "doc": "<p>Get all sibling nodes that match the condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (All_Nodes):</strong>  Node to get siblings from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[All_Nodes]: Returns the all siblings that match the\n  condition or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_all_before": {"fullname": "phml.utils.locate.find.find_all_before", "modulename": "phml.utils.locate.find", "qualname": "find_all_before", "type": "function", "doc": "<p>Find all nodes that come before the given node.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (All_Nodes):</strong>  The node to find all previous siblings from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[All_Nodes]: A list of nodes that come before the given node.\n  Empty list if no nodes were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_before": {"fullname": "phml.utils.locate.find.find_before", "modulename": "phml.utils.locate.find", "qualname": "find_before", "type": "function", "doc": "<p>Find the first sibling node before the given node. If a condition is applied\nthen it will be the first sibling node that passes that condition.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (All_Nodes):</strong>  The node to find the previous sibling from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The test that is applied to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Optional[All_Nodes]: The first node before the given node\n  or None if no prior siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.find.find_all_between": {"fullname": "phml.utils.locate.find.find_all_between", "modulename": "phml.utils.locate.find", "qualname": "find_all_between", "type": "function", "doc": "<p>Find all sibling nodes in parent that meet the provided condition from start index\nto end index.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>parent (Root | Element):</strong>  The parent element to get nodes from.</li>\n<li><strong>start (int, optional):</strong>  The starting index, inclusive. Defaults to 0.</li>\n<li><strong>end (int, optional):</strong>  The ending index, exclusive. Defaults to 0.</li>\n<li><strong>condition (Test, optional):</strong>  Condition to apply to each node. Defaults to None.</li>\n<li><strong>_range (slice, optional):</strong>  Slice to apply to the parent nodes children instead of start and</li>\n<li>end indecies. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[All_Nodes]: List of all matching nodes or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_range</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">slice</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.index": {"fullname": "phml.utils.locate.index", "modulename": "phml.utils.locate.index", "type": "module", "doc": "<p></p>\n"}, "phml.utils.locate.index.Index": {"fullname": "phml.utils.locate.index.Index", "modulename": "phml.utils.locate.index", "qualname": "Index", "type": "class", "doc": "<p>Uses the given key or key generator and creates a mutable dict of key value pairs\nthat can be easily indexed.</p>\n\n<p>Nodes that don't match the condition or don't have a valid key are not indexed.</p>\n"}, "phml.utils.locate.index.Index.__init__": {"fullname": "phml.utils.locate.index.Index.__init__", "modulename": "phml.utils.locate.index", "qualname": "Index.__init__", "type": "function", "doc": "<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong><code>key</code> (str | Callable):</strong>  Str represents the property to use as an index. Callable</li>\n<li>represents a function to call on each element to generate a key. The returned key</li>\n<li>must be able to be converted to a string. If none then element is skipped.</li>\n<li><strong><code>start</code> (AST | Root | Element):</strong>  The root or node to start at while indexing</li>\n<li><strong><code>test</code> (Test):</strong>  The test to apply to each node. Only valid/passing nodes</li>\n<li>will be indexed</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.utils.locate.index.Index.indexed_tree": {"fullname": "phml.utils.locate.index.Index.indexed_tree", "modulename": "phml.utils.locate.index", "qualname": "Index.indexed_tree", "type": "variable", "doc": "<p>The indexed collection of elements</p>\n", "annotation": ": dict[str, list[phml.nodes.element.Element]]"}, "phml.utils.locate.index.Index.add": {"fullname": "phml.utils.locate.index.Index.add", "modulename": "phml.utils.locate.index", "qualname": "Index.add", "type": "function", "doc": "<p>Adds element to indexed collection if not already there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.locate.index.Index.remove": {"fullname": "phml.utils.locate.index.Index.remove", "modulename": "phml.utils.locate.index", "qualname": "Index.remove", "type": "function", "doc": "<p>Removes element from indexed collection if there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.locate.index.Index.get": {"fullname": "phml.utils.locate.index.Index.get", "modulename": "phml.utils.locate.index", "qualname": "Index.get", "type": "function", "doc": "<p>Get a specific index from the indexed tree.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.index.Index.map": {"fullname": "phml.utils.locate.index.Index.map", "modulename": "phml.utils.locate.index", "qualname": "Index.map", "type": "function", "doc": "<p>Applies the passed modifier to each index.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list of results generated by the modifier applied\n  to each index.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">modifier</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.select": {"fullname": "phml.utils.locate.select", "modulename": "phml.utils.locate.select", "type": "module", "doc": "<p>utils.select</p>\n\n<p>A collection of utilities around querying for specific\ntypes of data.</p>\n"}, "phml.utils.locate.select.query": {"fullname": "phml.utils.locate.select.query", "modulename": "phml.utils.locate.select", "qualname": "query", "type": "function", "doc": "<p>Same as javascripts querySelector. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return</h6>\n\n<blockquote>\n  <p>Element | None: The first element matching the specifier or None if no element was\n  found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.select.query_all": {"fullname": "phml.utils.locate.select.query_all", "modulename": "phml.utils.locate.select", "qualname": "query_all", "type": "function", "doc": "<p>Same as javascripts querySelectorAll. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return</h6>\n\n<blockquote>\n  <p>list[Element] | None: The all elements matching the specifier or and empty list if no\n  elements were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.select.matches": {"fullname": "phml.utils.locate.select.matches", "modulename": "phml.utils.locate.select", "qualname": "matches", "type": "function", "doc": "<p>Works the same as the Javascript matches. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are not supported. Everything in the specifier\nmust relate to one element/tag.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.locate.select.parse_specifiers": {"fullname": "phml.utils.locate.select.parse_specifiers", "modulename": "phml.utils.locate.select", "qualname": "parse_specifiers", "type": "function", "doc": "<p>Rules:</p>\n\n<ul>\n<li><code>*</code> = any element</li>\n<li><code>&gt;</code> = Everything with certain parent child relationship</li>\n<li><code>+</code> = first sibling</li>\n<li><code>~</code> = All after</li>\n<li><code>.</code> = class</li>\n<li><code>#</code> = id</li>\n<li><code>[attribute]</code> = all elements with attribute</li>\n<li><code>[attribute=value]</code> = all elements with attribute=value</li>\n<li><code>[attribute~=value]</code> = all elements with attribute containing value</li>\n<li><code>[attribute|=value]</code> = all elements with attribute=value or attribute starting with value-</li>\n<li><code>node[attribute^=value]</code> = all elements with attribute starting with value</li>\n<li><code>node[attribute$=value]</code> = all elements with attribute ending with value</li>\n<li><code>node[attribute*=value]</code> = all elements with attribute containing value</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc": {"fullname": "phml.utils.misc", "modulename": "phml.utils.misc", "type": "module", "doc": "<p>phml.utils.misc</p>\n\n<p>Helpful utilities for different tasks that doesn't have a place in the other categories.</p>\n"}, "phml.utils.misc.depth": {"fullname": "phml.utils.misc.depth", "modulename": "phml.utils.misc", "qualname": "depth", "type": "function", "doc": "<p>Get the depth in the tree for a given node.</p>\n\n<p>-1 means that you passed in the tree itself and you are at the\nast's root.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.size": {"fullname": "phml.utils.misc.size", "modulename": "phml.utils.misc", "qualname": "size", "type": "function", "doc": "<p>Get the number of nodes recursively.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.classes": {"fullname": "phml.utils.misc.classes", "modulename": "phml.utils.misc.classes", "type": "module", "doc": "<p>utils.misc</p>\n\n<p>A collection of utilities that don't fit in with finding, selecting, testing,\ntransforming, traveling, or validating nodes.</p>\n"}, "phml.utils.misc.classes.classnames": {"fullname": "phml.utils.misc.classes.classnames", "modulename": "phml.utils.misc.classes", "qualname": "classnames", "type": "function", "doc": "<p>Concat a bunch of class names. Can take a str as a class,\nint which is cast to a str to be a class, a dict of conditional classes,\nand a list of all the previous conditions including itself.</p>\n\n<p>Examples:</p>\n\n<ul>\n<li><code>classnames(node, 'flex')</code> yields <code>'flex'</code></li>\n<li><code>classnames(node, 13)</code> yields <code>'13'</code></li>\n<li><code>classnames(node, {'shadow': True, 'border': 0})</code> yields <code>'shadow'</code></li>\n<li><code>classnames(node, 'a', 13, {'b': True}, ['c', {'d': False}])</code> yields <code>'a b c'</code></li>\n</ul>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Element | None):</strong>  Node to apply the classes too. If no node is given</li>\n<li>then the function returns a string.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The concat string of classes after processing.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">conditionals</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.classes.ClassList": {"fullname": "phml.utils.misc.classes.ClassList", "modulename": "phml.utils.misc.classes", "qualname": "ClassList", "type": "class", "doc": "<p>Utility class to manipulate the class list on a node.</p>\n\n<p>Based on the hast-util-class-list:\n<a href=\"https://github.com/brechtcs/hast-util-class-list\">https://github.com/brechtcs/hast-util-class-list</a></p>\n"}, "phml.utils.misc.classes.ClassList.__init__": {"fullname": "phml.utils.misc.classes.ClassList.__init__", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span>)</span>"}, "phml.utils.misc.classes.ClassList.contains": {"fullname": "phml.utils.misc.classes.ClassList.contains", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.contains", "type": "function", "doc": "<p>Check if <code>class</code> contains a certain class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.classes.ClassList.toggle": {"fullname": "phml.utils.misc.classes.ClassList.toggle", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.toggle", "type": "function", "doc": "<p>Toggle a class in <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.classes.ClassList.add": {"fullname": "phml.utils.misc.classes.ClassList.add", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.add", "type": "function", "doc": "<p>Add one or more classes to <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.classes.ClassList.replace": {"fullname": "phml.utils.misc.classes.ClassList.replace", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.replace", "type": "function", "doc": "<p>Replace a certain class in <code>class</code> with\nanother class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">old_klass</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_klass</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.classes.ClassList.remove": {"fullname": "phml.utils.misc.classes.ClassList.remove", "modulename": "phml.utils.misc.classes", "qualname": "ClassList.remove", "type": "function", "doc": "<p>Remove one or more classes from <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.component": {"fullname": "phml.utils.misc.component", "modulename": "phml.utils.misc.component", "type": "module", "doc": "<p></p>\n"}, "phml.utils.misc.component.tag_from_file": {"fullname": "phml.utils.misc.component.tag_from_file", "modulename": "phml.utils.misc.component", "qualname": "tag_from_file", "type": "function", "doc": "<p>Generates a tag name some-tag-name from a filename.\nAssumes filenames of:</p>\n\n<ul>\n<li>snakecase - some_file_name</li>\n<li>camel case - someFileName</li>\n<li>pascal case - SomeFileName</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.component.filename_from_path": {"fullname": "phml.utils.misc.component.filename_from_path", "modulename": "phml.utils.misc.component", "qualname": "filename_from_path", "type": "function", "doc": "<p>Get the filename without the suffix from a pathlib.Path.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.component.parse_component": {"fullname": "phml.utils.misc.component.parse_component", "modulename": "phml.utils.misc.component", "qualname": "parse_component", "type": "function", "doc": "<p>Helper function to parse the components elements.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.heading": {"fullname": "phml.utils.misc.heading", "modulename": "phml.utils.misc.heading", "type": "module", "doc": "<p>Utility functions that do something with heading tags.</p>\n"}, "phml.utils.misc.heading.heading_rank": {"fullname": "phml.utils.misc.heading.heading_rank", "modulename": "phml.utils.misc.heading", "qualname": "heading_rank", "type": "function", "doc": "<p>Get the rank of the heading element.</p>\n\n<h6 id=\"example\">Example</h6>\n\n<blockquote>\n  <p><code>h2</code> yields <code>2</code></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utils.misc.inspect": {"fullname": "phml.utils.misc.inspect", "modulename": "phml.utils.misc.inspect", "type": "module", "doc": "<p>phml.utils.misc.inspect</p>\n\n<p>Logic to inspect any phml node. Outputs a tree representation\nof the node as a string.</p>\n"}, "phml.utils.misc.inspect.inspect": {"fullname": "phml.utils.misc.inspect.inspect", "modulename": "phml.utils.misc.inspect", "qualname": "inspect", "type": "function", "doc": "<p>Recursively inspect the passed node or ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.misc.inspect.normalize_indent": {"fullname": "phml.utils.misc.inspect.normalize_indent", "modulename": "phml.utils.misc.inspect", "qualname": "normalize_indent", "type": "function", "doc": "<p>Remove extra prefix whitespac while preserving relative indenting.</p>\n\n<p>Example:\n    <div class=\"pdoc-code codehilite\">\n    <pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n    </code></pre>\n    </div></p>\n\n<p>becomes</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utils.transform": {"fullname": "phml.utils.transform", "modulename": "phml.utils.transform", "type": "module", "doc": "<p>utils.transform</p>\n\n<p>A collection of utilities focused around transforming an\nast or a specific nodes.</p>\n"}, "phml.utils.transform.extract": {"fullname": "phml.utils.transform.extract", "modulename": "phml.utils.transform.extract", "type": "module", "doc": "<p></p>\n"}, "phml.utils.transform.extract.to_string": {"fullname": "phml.utils.transform.extract.to_string", "modulename": "phml.utils.transform.extract", "qualname": "to_string", "type": "function", "doc": "<p>Get the raw text content of the element. Works similar to\nthe DOMs Node#textContent getter.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (Root | Element | Text):</strong>  Node to get the text content from</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: Raw inner text without formatting.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utils.transform.sanitize": {"fullname": "phml.utils.transform.sanitize", "modulename": "phml.utils.transform.sanitize", "type": "module", "doc": "<p>phml.utils.transform.sanatize</p>\n\n<p>Logic for sanatizing a phml ast.</p>\n"}, "phml.utils.transform.sanitize.sanatize": {"fullname": "phml.utils.transform.sanitize.sanatize", "modulename": "phml.utils.transform.sanitize", "qualname": "sanatize", "type": "function", "doc": "<p>Sanatize elements and attributes in the phml tree. Should be used when using\ndata from an unkown source. It should be used with an AST that has already been\ncompiled to html to no unkown values are unchecked.</p>\n\n<p>By default the sanatization schema uses the github schema and follows the hast\nsanatize utility.</p>\n\n<ul>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize/blob/main/lib/schema.js\">github schema</a></li>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize\">hast sanatize</a></li>\n</ul>\n\n<h6 id=\"note\">Note</h6>\n\n<blockquote>\n  <p>This utility will edit the tree in place.</p>\n</blockquote>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (AST | Root | Element):</strong>  The root of the tree that will be sanatized.</li>\n<li><strong>schema (Optional[Schema], optional):</strong>  User defined schema. Defaults to github schema.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">utils</span><span class=\"o\">.</span><span class=\"n\">transform</span><span class=\"o\">.</span><span class=\"n\">sanitize</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">Schema</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"n\">Schema</span><span class=\"p\">(</span><span class=\"n\">strip</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;script&#39;</span><span class=\"p\">],</span> <span class=\"n\">ancestors</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">]},</span> <span class=\"n\">protocols</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mailto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;xmpp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;irc&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ircs&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;src&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">]},</span> <span class=\"n\">tag_names</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;h1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h4&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h5&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h6&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;br&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strong&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;em&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;pre&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;code&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sup&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sub&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;p&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ol&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ul&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;table&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dl&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;kbd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;samp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;var&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ruby&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;s&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strike&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;details&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;caption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figure&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figcaption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bdo&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dfn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mark&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;small&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;time&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;wbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">],</span> <span class=\"n\">attributes</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;src&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;class&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;task-list-item&#39;</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;itemScope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemType&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;*&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accept&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;acceptCharset&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accessKey&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;action&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;align&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;alt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaDescribedBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaHidden&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabelledBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;axis&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;border&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellPadding&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellSpacing&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;char&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charOff&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charSet&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checked&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;clear&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cols&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;colSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;compact&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;coords&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dateTime&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dir&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;encType&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;htmlFor&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;frame&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;headers&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;height&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hrefLang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;isMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;id&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;lang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;maxLength&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;media&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;method&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;multiple&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noHref&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noShade&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noWrap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;open&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;prompt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;readOnly&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rev&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rows&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rowSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rules&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;scope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;selected&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;shape&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;size&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;start&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tabIndex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;target&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;title&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;useMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vAlign&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;value&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;width&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemProp&#39;</span><span class=\"p\">]},</span> <span class=\"n\">required</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}})</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.transform.sanitize.Schema": {"fullname": "phml.utils.transform.sanitize.Schema", "modulename": "phml.utils.transform.sanitize", "qualname": "Schema", "type": "class", "doc": "<p>Dataclass of information on how to sanatize a phml tree.</p>\n\n<p><code>strip (list[str])</code>: The elements to strip from the tree.\n<code>protocols (dict[str, list])</code>: Collection of element name and allowed protocal value list\n<code>tag_names (list[str])</code>: List of allowed tag names.\n<code>attributes (dict[str, list[str | list[str]]])</code>: Collection of element name and allowed property\nnames.\n<code>required (dict[str, str | list[str]])</code>: Collection of element names and their required\nproperties and required property values.</p>\n"}, "phml.utils.transform.sanitize.Schema.__init__": {"fullname": "phml.utils.transform.sanitize.Schema.__init__", "modulename": "phml.utils.transform.sanitize", "qualname": "Schema.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">ancestors</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">protocols</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">tag_names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">attributes</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">required</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span></span>)</span>"}, "phml.utils.transform.transform": {"fullname": "phml.utils.transform.transform", "modulename": "phml.utils.transform.transform", "type": "module", "doc": "<p>phml.utils.transform.transform</p>\n\n<p>Utility methods that revolve around transforming or manipulating the ast.</p>\n"}, "phml.utils.transform.transform.filter_nodes": {"fullname": "phml.utils.transform.transform.filter_nodes", "modulename": "phml.utils.transform.transform", "qualname": "filter_nodes", "type": "function", "doc": "<p>Take a given tree and filter the nodes with the condition.\nOnly nodes passing the condition stay. If the parent node fails,\nthen all children are removed.</p>\n\n<p>Same as remove_nodes but keeps the nodes that match.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The tree node to filter.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Root | Element: The given tree after being filtered.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.transform.transform.remove_nodes": {"fullname": "phml.utils.transform.transform.remove_nodes", "modulename": "phml.utils.transform.transform", "qualname": "remove_nodes", "type": "function", "doc": "<p>Take a given tree and remove the nodes that match the condition.\nIf a parent node is removed so is all the children.</p>\n\n<p>Same as filter_nodes except removes nodes that match.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The parent node to start recursively removing from.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.transform.transform.map_nodes": {"fullname": "phml.utils.transform.transform.map_nodes", "modulename": "phml.utils.transform.transform", "qualname": "map_nodes", "type": "function", "doc": "<p>Takes a tree and a callable that returns a node and maps each node.</p>\n\n<p>Signature for the transform function should be as follows:</p>\n\n<ol>\n<li>Takes a single argument that is the node.</li>\n<li>Returns any type of node that is assigned to the original node.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">to_links</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">):</span>\n    <span class=\"k\">return</span> <span class=\"n\">Element</span><span class=\"p\">(</span><span class=\"s2\">&quot;a&quot;</span><span class=\"p\">,</span> <span class=\"p\">{},</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"p\">,</span> <span class=\"n\">children</span><span class=\"o\">=</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">children</span><span class=\"p\">)</span>\n        <span class=\"k\">if</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">type</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;element&quot;</span>\n        <span class=\"k\">else</span> <span class=\"n\">node</span>\n</code></pre>\n</div>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  Tree to transform.</li>\n<li><strong>transform (Callable):</strong>  The Callable that returns a node that is assigned</li>\n<li>to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.transform.transform.find_and_replace": {"fullname": "phml.utils.transform.transform.find_and_replace", "modulename": "phml.utils.transform.transform", "qualname": "find_and_replace", "type": "function", "doc": "<p>Takes a ast, root, or any node and replaces text in <code>text</code>\nnodes with matching replacements.</p>\n\n<p>First value in each replacement tuple is the regex to match and\nthe second value is what to replace it with. This can either be\na string or a callable that returns a string or a new node. If\na new node is returned then the text element will be split.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">replacements</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utils.transform.transform.shift_heading": {"fullname": "phml.utils.transform.transform.shift_heading", "modulename": "phml.utils.transform.transform", "qualname": "shift_heading", "type": "function", "doc": "<p>Shift the heading by the amount specified.</p>\n\n<p>value is clamped between 1 and 6.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">amount</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.transform.transform.replace_node": {"fullname": "phml.utils.transform.transform.replace_node", "modulename": "phml.utils.transform.transform", "qualname": "replace_node", "type": "function", "doc": "<p>Search for a specific node in the tree and replace it with either\na node or list of nodes. If replacement is None the found node is just removed.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  The starting point.</li>\n<li><strong>condition (test):</strong>  Test condition to find the correct node.</li>\n<li><strong>replacement (All_Nodes | list[All_Nodes] | None):</strong>  What to replace the node with.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">replacement</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utils.travel": {"fullname": "phml.utils.travel", "modulename": "phml.utils.travel", "type": "module", "doc": "<p>utils.travel</p>\n\n<p>Collection of utilities that hep with traversing an ast or node tree.</p>\n"}, "phml.utils.travel.path": {"fullname": "phml.utils.travel.path", "modulename": "phml.utils.travel", "qualname": "path", "type": "function", "doc": "<p>Get a list of nodes where each one is a child of\nthe other leading to the node passed in. This gives a\npath to the node.</p>\n\n<p>Does not include given node.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (All_Nodes):</strong>  Node to find ancestors of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>list[All_Nodes]: List of nodes leading to the given node\n  starting from the root.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utils.travel.walk": {"fullname": "phml.utils.travel.walk", "modulename": "phml.utils.travel", "qualname": "walk", "type": "function", "doc": "<p>Recursively traverse the node and it's chidlren as an iterator.\nLeft to right depth first.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utils.travel.visit_children": {"fullname": "phml.utils.travel.visit_children", "modulename": "phml.utils.travel", "qualname": "visit_children", "type": "function", "doc": "<p>Traverse the children of a Root or Element as an iterator.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utils.travel.visit_all_after": {"fullname": "phml.utils.travel.visit_all_after", "modulename": "phml.utils.travel", "qualname": "visit_all_after", "type": "function", "doc": "<p>Recursively traverse the tree starting at given node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate": {"fullname": "phml.utils.validate", "modulename": "phml.utils.validate", "type": "module", "doc": "<p>utils.validate</p>\n\n<p>A collection of utilities centered around validating nodes, types,\nvalues on nodes, and any other condition you want to apply to a node\nor ast.</p>\n"}, "phml.utils.validate.test": {"fullname": "phml.utils.validate.test", "modulename": "phml.utils.validate.test", "type": "module", "doc": "<p>phml.utils.validate.test</p>\n\n<p>Logic that allows nodes to be tested against a series of conditions.</p>\n"}, "phml.utils.validate.test.test": {"fullname": "phml.utils.validate.test.test", "modulename": "phml.utils.validate.test", "qualname": "test", "type": "function", "doc": "<p>Test if a node passes the given test(s).</p>\n\n<h6 id=\"test-types\">Test Types</h6>\n\n<blockquote>\n  <ul>\n  <li><code>None</code>: Just checks that the node is a valid node.</li>\n  <li><code>str</code>: Checks that the test value is == the <code>node.type</code>.</li>\n  <li><code>dict</code>: Checks all items are valid attributes on the node.\n  and that the values are strictly equal.</li>\n  <li><code>Callable</code>: Passes the given function the node and it's index, if provided,\n  and checks if the callable returned true.</li>\n  <li><code>list[Test]</code>: Apply all the rules above for each Test in the list.</li>\n  </ul>\n</blockquote>\n\n<p>If the <code>parent</code> arg is passed so should the <code>index</code> arg.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (All_Nodes):</strong>  Node to test. Can be any phml node.</li>\n<li><strong>test (Test):</strong>  Test to apply to the node. See previous section</li>\n<li>for more info.</li>\n<li><strong>index (Optional[int], optional):</strong>  Index in the parent where the</li>\n<li>node exists. Defaults to None.</li>\n<li><strong>parent (Optional[Root | Element], optional):</strong>  The nodes parent. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>True if all tests pass.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">_test</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate": {"fullname": "phml.utils.validate.validate", "modulename": "phml.utils.validate.validate", "type": "module", "doc": "<p></p>\n"}, "phml.utils.validate.validate.validate": {"fullname": "phml.utils.validate.validate.validate", "modulename": "phml.utils.validate.validate", "qualname": "validate", "type": "function", "doc": "<p>Validate a node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.parent": {"fullname": "phml.utils.validate.validate.parent", "modulename": "phml.utils.validate.validate", "qualname": "parent", "type": "function", "doc": "<p>Validate a parent node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.literal": {"fullname": "phml.utils.validate.validate.literal", "modulename": "phml.utils.validate.validate", "qualname": "literal", "type": "function", "doc": "<p>Validate a literal node based on attributes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.generated": {"fullname": "phml.utils.validate.validate.generated", "modulename": "phml.utils.validate.validate", "qualname": "generated", "type": "function", "doc": "<p>Checks if a node has been generated. A node is concidered\ngenerated if it does not have a position.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>node (All_Nodes):</strong>  Node to check for position with.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>bool: Whether a node has a position or not.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">root</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">element</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">text</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">comment</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">doctype</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">literal</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.has_property": {"fullname": "phml.utils.validate.validate.has_property", "modulename": "phml.utils.validate.validate", "qualname": "has_property", "type": "function", "doc": "<p>Check to see if an element has a certain property in properties.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_heading": {"fullname": "phml.utils.validate.validate.is_heading", "modulename": "phml.utils.validate.validate", "qualname": "is_heading", "type": "function", "doc": "<p>Check if an element is a heading.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_css_link": {"fullname": "phml.utils.validate.validate.is_css_link", "modulename": "phml.utils.validate.validate", "qualname": "is_css_link", "type": "function", "doc": "<p>Check if an element is a <code>link</code> to a css file.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;link&gt;</code> element with a <code>rel</code> list that\ncontains <code>'stylesheet'</code> and has no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code>\nas its <code>type</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_css_style": {"fullname": "phml.utils.validate.validate.is_css_style", "modulename": "phml.utils.validate.validate", "qualname": "is_css_style", "type": "function", "doc": "<p>Check if an element is a css <code>style</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;style&gt;</code> element that\nhas no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code> as its <code>type</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_javascript": {"fullname": "phml.utils.validate.validate.is_javascript", "modulename": "phml.utils.validate.validate", "qualname": "is_javascript", "type": "function", "doc": "<p>Check if an element is a javascript <code>script</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;script&gt;</code> element that has a valid JavaScript <code>type</code>, has no\n<code>type</code> and a valid JavaScript <code>language</code>, or has neither.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_element": {"fullname": "phml.utils.validate.validate.is_element", "modulename": "phml.utils.validate.validate", "qualname": "is_element", "type": "function", "doc": "<p>Checks if the given node is a certain element.</p>\n\n<p>When providing an str it will check that the elements tag matches.\nIf a list is provided it checks that one of the conditions in the list\npasses.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">conditions</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utils.validate.validate.is_event_handler": {"fullname": "phml.utils.validate.validate.is_event_handler", "modulename": "phml.utils.validate.validate", "qualname": "is_event_handler", "type": "function", "doc": "<p>Takes a attribute name and returns true if\nit starts with <code>on</code> and its length is <code>5</code> or more.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.virtual_python": {"fullname": "phml.virtual_python", "modulename": "phml.virtual_python", "type": "module", "doc": "<p>Virtual Python</p>\n\n<p>This module serves to solve the problem of processing python\nin scopes and to evaluate python expressions.</p>\n\n<p>These expressions and scopes are python \"blocks\" that are injected\ninto html which then creates my language phml.</p>\n\n<p>Here are examples of the python blocks:</p>\n\n<ol>\n<li>Python element. This is treated as python files similarly to how\n<code>&lt;script&gt;</code> elements are treated as javascript files.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n    from datetime import datetime\n\n    current_time = datetime.now().strftime(&#39;%H:%M:%S&#39;)\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Inline python block. Mainly used for retreiving values\nor creating conditions. The local variables in the blocks are given\nfrom the python elements and from kwargs passed to the parser</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{current_time}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Multiline python blocks. Same as inline python blocks just that they\ntake up multiple lines. You can write more logic in these blocks, but\nthere local variables are not retained. By default phml will return the last\nlocal variable similar to how Jupyter or the python in cli works.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    Hello, everyone my name is {firstname}. I\n    am a {work_position}.\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>Here is a list of people and what they like<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    {\n        result = []\n        for i, person, like in enumerate(zip(people, likes)):\n            result.append(f&quot;{i}. {person} likes {like}&quot;)\n        result = &quot;\\n&quot;.join(result)\n    }\n<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n"}, "phml.virtual_python.VirtualPython": {"fullname": "phml.virtual_python.VirtualPython", "modulename": "phml.virtual_python", "qualname": "VirtualPython", "type": "class", "doc": "<p>Represents a python string. Extracts the imports along\nwith the locals.</p>\n"}, "phml.virtual_python.VirtualPython.__init__": {"fullname": "phml.virtual_python.VirtualPython.__init__", "modulename": "phml.virtual_python", "qualname": "VirtualPython.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">imports</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">local_env</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.virtual_python.get_vp_result": {"fullname": "phml.virtual_python.get_vp_result", "modulename": "phml.virtual_python", "qualname": "get_vp_result", "type": "function", "doc": "<p>Execute the given python expression, while using\nthe kwargs as the local variables.</p>\n\n<p>This will collect the result of the expression and return it.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expr</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "phml.virtual_python.process_vp_blocks": {"fullname": "phml.virtual_python.process_vp_blocks", "modulename": "phml.virtual_python", "qualname": "process_vp_blocks", "type": "function", "doc": "<p>Process a lines python blocks. Use the VirtualPython locals,\nand kwargs as local variables for each python block. Import\nVirtualPython imports in this methods scope.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The line to process.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  Parsed locals and imports from all python blocks.</li>\n<li><strong>**kwargs (Any):</strong>  The extra data to pass to the exec function.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>str: The processed line as str.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.virtual_python.Import": {"fullname": "phml.virtual_python.Import", "modulename": "phml.virtual_python", "qualname": "Import", "type": "class", "doc": "<p>Helper object that stringifies the python ast Import.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.virtual_python.import_objects.PythonImport"}, "phml.virtual_python.Import.__init__": {"fullname": "phml.virtual_python.Import.__init__", "modulename": "phml.virtual_python", "qualname": "Import.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">modules</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.virtual_python.Import.from_node": {"fullname": "phml.virtual_python.Import.from_node", "modulename": "phml.virtual_python", "qualname": "Import.from_node", "type": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}, "phml.virtual_python.ImportFrom": {"fullname": "phml.virtual_python.ImportFrom", "modulename": "phml.virtual_python", "qualname": "ImportFrom", "type": "class", "doc": "<p>Helper object that stringifies the python ast ImportFrom.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.virtual_python.import_objects.PythonImport"}, "phml.virtual_python.ImportFrom.__init__": {"fullname": "phml.virtual_python.ImportFrom.__init__", "modulename": "phml.virtual_python", "qualname": "ImportFrom.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">module</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.virtual_python.ImportFrom.from_node": {"fullname": "phml.virtual_python.ImportFrom.from_node", "modulename": "phml.virtual_python", "qualname": "ImportFrom.from_node", "type": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"args\">Args</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"phml": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1501}, "phml.PHMLCore": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 41}, "phml.PHMLCore.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 216, "bases": 0, "doc": 3}, "phml.PHMLCore.parser": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.PHMLCore.compiler": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.PHMLCore.ast": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "phml.PHMLCore.add": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 468, "bases": 0, "doc": 202}, "phml.PHMLCore.remove": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 193, "bases": 0, "doc": 55}, "phml.PHMLCore.load": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 36}, "phml.PHMLCore.parse": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 32}, "phml.PHMLCore.render": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 104}, "phml.PHMLCore.write": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 89, "bases": 0, "doc": 135}, "phml.Compiler": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.Compiler.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 255, "bases": 0, "doc": 3}, "phml.Compiler.ast": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.Compiler.add": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 457, "bases": 0, "doc": 167}, "phml.Compiler.remove": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 193, "bases": 0, "doc": 52}, "phml.Compiler.compile": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 138, "bases": 0, "doc": 9}, "phml.Parser": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 107}, "phml.Parser.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.Parser.parser": {"qualname": 2, "fullname": 3, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.Parser.ast": {"qualname": 2, "fullname": 3, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.Parser.load": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 93}, "phml.Parser.parse": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 128}, "phml.AST": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "phml.AST.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "phml.AST.size": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.AST.children": {"qualname": 2, "fullname": 3, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.builder": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.builder.p": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 223, "bases": 0, "doc": 9}, "phml.core": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.Compiler": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.Compiler.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 255, "bases": 0, "doc": 3}, "phml.core.Compiler.ast": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.Compiler.add": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 457, "bases": 0, "doc": 167}, "phml.core.Compiler.remove": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 193, "bases": 0, "doc": 52}, "phml.core.Compiler.compile": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 138, "bases": 0, "doc": 9}, "phml.core.Parser": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 107}, "phml.core.Parser.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.Parser.parser": {"qualname": 2, "fullname": 4, "annotation": 8, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.Parser.ast": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.core.Parser.load": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 93}, "phml.core.Parser.parse": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 128}, "phml.core.file_types": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.nodes": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.nodes.AST": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 38}, "phml.nodes.AST.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "phml.nodes.AST.size": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.nodes.AST.children": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.nodes.Node": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 62}, "phml.nodes.Node.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 3}, "phml.nodes.Node.position": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.nodes.Node.type": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 24}, "phml.nodes.Root": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 37}, "phml.nodes.Root.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 3}, "phml.nodes.Root.stringify": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 27}, "phml.nodes.DocType": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 65}, "phml.nodes.DocType.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 133, "bases": 0, "doc": 3}, "phml.nodes.DocType.stringify": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 26}, "phml.nodes.Parent": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 29}, "phml.nodes.Parent.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 3}, "phml.nodes.Element": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 341}, "phml.nodes.Element.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 152, "bases": 0, "doc": 3}, "phml.nodes.Element.start_tag": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 49}, "phml.nodes.Element.end_tag": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "phml.nodes.Literal": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 13}, "phml.nodes.Literal.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 130, "bases": 0, "doc": 3}, "phml.nodes.Literal.position": {"qualname": 2, "fullname": 4, "annotation": 5, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.nodes.Literal.value": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.nodes.Literal.get_ancestry": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 27}, "phml.nodes.Comment": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 31}, "phml.nodes.Comment.stringify": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 24}, "phml.nodes.Text": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 177}, "phml.nodes.Text.num_lines": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.nodes.Text.stringify": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 24}, "phml.nodes.Position": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 151}, "phml.nodes.Position.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 80, "bases": 0, "doc": 3}, "phml.nodes.Point": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 52}, "phml.nodes.Point.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "phml.nodes.PropertyName": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 72}, "phml.nodes.PropertyName.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.nodes.PropertyName.encode": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 45, "bases": 0, "doc": 68}, "phml.nodes.PropertyName.replace": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 50}, "phml.nodes.PropertyName.split": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 109}, "phml.nodes.PropertyName.rsplit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 97}, "phml.nodes.PropertyName.join": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 46}, "phml.nodes.PropertyName.capitalize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 27}, "phml.nodes.PropertyName.casefold": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 13}, "phml.nodes.PropertyName.title": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 32}, "phml.nodes.PropertyName.center": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 25}, "phml.nodes.PropertyName.count": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 36}, "phml.nodes.PropertyName.expandtabs": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "phml.nodes.PropertyName.find": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 48}, "phml.nodes.PropertyName.partition": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 69}, "phml.nodes.PropertyName.index": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 52}, "phml.nodes.PropertyName.ljust": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 26}, "phml.nodes.PropertyName.lower": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "phml.nodes.PropertyName.lstrip": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 28}, "phml.nodes.PropertyName.rfind": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 48}, "phml.nodes.PropertyName.rindex": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 52}, "phml.nodes.PropertyName.rjust": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 26}, "phml.nodes.PropertyName.rstrip": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 28}, "phml.nodes.PropertyName.rpartition": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 73}, "phml.nodes.PropertyName.splitlines": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 34}, "phml.nodes.PropertyName.strip": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "phml.nodes.PropertyName.swapcase": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 13}, "phml.nodes.PropertyName.translate": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 66}, "phml.nodes.PropertyName.upper": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "phml.nodes.PropertyName.startswith": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 51}, "phml.nodes.PropertyName.endswith": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 51}, "phml.nodes.PropertyName.removeprefix": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 37}, "phml.nodes.PropertyName.removesuffix": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 44}, "phml.nodes.PropertyName.isascii": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 33}, "phml.nodes.PropertyName.islower": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 41}, "phml.nodes.PropertyName.isupper": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 41}, "phml.nodes.PropertyName.istitle": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "phml.nodes.PropertyName.isspace": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "phml.nodes.PropertyName.isdecimal": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 41}, "phml.nodes.PropertyName.isdigit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 41}, "phml.nodes.PropertyName.isnumeric": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "phml.nodes.PropertyName.isalpha": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "phml.nodes.PropertyName.isalnum": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 42}, "phml.nodes.PropertyName.isidentifier": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "phml.nodes.PropertyName.isprintable": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "phml.nodes.PropertyName.zfill": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 28}, "phml.nodes.PropertyName.format": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 34}, "phml.nodes.PropertyName.format_map": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 30}, "phml.nodes.PropertyName.maketrans": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 99}, "phml.nodes.AST.AST": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "phml.nodes.AST.AST.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "phml.nodes.AST.AST.size": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.nodes.AST.AST.children": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.utils": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 26}, "phml.utils.locate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.utils.locate.find": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.utils.locate.find.ancestor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 358, "bases": 0, "doc": 74}, "phml.utils.locate.find.find": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 292, "bases": 0, "doc": 77}, "phml.utils.locate.find.find_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 286, "bases": 0, "doc": 65}, "phml.utils.locate.find.find_after": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 299, "bases": 0, "doc": 74}, "phml.utils.locate.find.find_all_after": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 251, "bases": 0, "doc": 74}, "phml.utils.locate.find.find_all_before": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 251, "bases": 0, "doc": 80}, "phml.utils.locate.find.find_before": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 257, "bases": 0, "doc": 94}, "phml.utils.locate.find.find_all_between": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 366, "bases": 0, "doc": 148}, "phml.utils.locate.index": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utils.locate.index.Index": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 44}, "phml.utils.locate.index.Index.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 143, "bases": 0, "doc": 109}, "phml.utils.locate.index.Index.indexed_tree": {"qualname": 3, "fullname": 7, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "phml.utils.locate.index.Index.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 12}, "phml.utils.locate.index.Index.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 10}, "phml.utils.locate.index.Index.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 11}, "phml.utils.locate.index.Index.map": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 31}, "phml.utils.locate.select": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 18}, "phml.utils.locate.select.query": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 103, "bases": 0, "doc": 259}, "phml.utils.locate.select.query_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 109, "bases": 0, "doc": 261}, "phml.utils.locate.select.matches": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 191}, "phml.utils.locate.select.parse_specifiers": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 141}, "phml.utils.misc": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 23}, "phml.utils.misc.depth": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 34}, "phml.utils.misc.size": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 9}, "phml.utils.misc.classes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utils.misc.classes.classnames": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 91, "bases": 0, "doc": 178}, "phml.utils.misc.classes.ClassList": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 29}, "phml.utils.misc.classes.ClassList.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 3}, "phml.utils.misc.classes.ClassList.contains": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "phml.utils.misc.classes.ClassList.toggle": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 10}, "phml.utils.misc.classes.ClassList.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utils.misc.classes.ClassList.replace": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 14}, "phml.utils.misc.classes.ClassList.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utils.misc.component": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utils.misc.component.tag_from_file": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 35}, "phml.utils.misc.component.filename_from_path": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 13}, "phml.utils.misc.component.parse_component": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 61, "bases": 0, "doc": 10}, "phml.utils.misc.heading": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.utils.misc.heading.heading_rank": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 26}, "phml.utils.misc.inspect": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utils.misc.inspect.inspect": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 218, "bases": 0, "doc": 10}, "phml.utils.misc.inspect.normalize_indent": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 87}, "phml.utils.transform": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 20}, "phml.utils.transform.extract": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utils.transform.extract.to_string": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 203, "bases": 0, "doc": 59}, "phml.utils.transform.sanitize": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.utils.transform.sanitize.sanatize": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 2103, "bases": 0, "doc": 137}, "phml.utils.transform.sanitize.Schema": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 90}, "phml.utils.transform.sanitize.Schema.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 245, "bases": 0, "doc": 3}, "phml.utils.transform.transform": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utils.transform.transform.filter_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 115, "bases": 0, "doc": 99}, "phml.utils.transform.transform.remove_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 115, "bases": 0, "doc": 78}, "phml.utils.transform.transform.map_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 203}, "phml.utils.transform.transform.find_and_replace": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 101, "bases": 0, "doc": 75}, "phml.utils.transform.transform.shift_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 20}, "phml.utils.transform.transform.replace_node": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 451, "bases": 0, "doc": 87}, "phml.utils.travel": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utils.travel.path": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 350, "bases": 0, "doc": 83}, "phml.utils.travel.walk": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 19}, "phml.utils.travel.visit_children": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 14}, "phml.utils.travel.visit_all_after": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 11}, "phml.utils.validate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 32}, "phml.utils.validate.test": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "phml.utils.validate.test.test": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 314, "bases": 0, "doc": 238}, "phml.utils.validate.validate": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utils.validate.validate.validate": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 11}, "phml.utils.validate.validate.parent": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 12}, "phml.utils.validate.validate.literal": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 10}, "phml.utils.validate.validate.generated": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 182, "bases": 0, "doc": 63}, "phml.utils.validate.validate.has_property": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 15}, "phml.utils.validate.validate.is_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.utils.validate.validate.is_css_link": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 71}, "phml.utils.validate.validate.is_css_style": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 57}, "phml.utils.validate.validate.is_javascript": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 58}, "phml.utils.validate.validate.is_element": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 43}, "phml.utils.validate.validate.is_event_handler": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 26}, "phml.virtual_python": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 380}, "phml.virtual_python.VirtualPython": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.virtual_python.VirtualPython.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 3}, "phml.virtual_python.get_vp_result": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "phml.virtual_python.process_vp_blocks": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 97}, "phml.virtual_python.Import": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 19}, "phml.virtual_python.Import.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "phml.virtual_python.Import.from_node": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 46}, "phml.virtual_python.ImportFrom": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 19}, "phml.virtual_python.ImportFrom.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 3}, "phml.virtual_python.ImportFrom.from_node": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 46}}, "length": 222, "save": true}, "index": {"qualname": {"root": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 23, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 11}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.parse": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}}, "df": 5, "r": {"docs": {"phml.PHMLCore.parser": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.Parser.parser": {"tf": 1.4142135623730951}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1.4142135623730951}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 13}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Parent": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Point": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 49}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 23}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.index": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.inspect.inspect": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 6, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.nodes.PropertyName.isalpha": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.PropertyName.isalnum": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.islower": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.isupper": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.isspace": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.isdecimal": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.isdigit": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.PropertyName.isnumeric": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.isprintable": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 2, "r": {"docs": {"phml.PHMLCore.compiler": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 13}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.component.parse_component": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Comment": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.casefold": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.ast": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}}, "df": 17}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}}, "df": 5}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 6, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removeprefix": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 1}}}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.render": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.rstrip": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.rfind": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.load": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}}, "df": 3}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.lower": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 6}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "k": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.ljust": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.lstrip": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.travel.walk": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.AST.size": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 4}}}}}, "p": {"docs": {"phml.nodes.PropertyName.strip": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}}, "df": 1}}}}}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.swapcase": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node.type": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Text": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.depth": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 5}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element.end_tag": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Literal.value": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.validate.validate": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "p": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 3}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 9}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 4}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.upper": {"tf": 1}}, "df": 1}}}}}, "z": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 3}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.matches": {"tf": 1}}, "df": 1}}}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}}}, "fullname": {"root": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 23, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.core.file_types": {"tf": 1}, "phml.nodes": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.component": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.extract": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 222, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 11}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.parse": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}}, "df": 5, "r": {"docs": {"phml.PHMLCore.parser": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.Parser.parser": {"tf": 1.4142135623730951}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1.4142135623730951}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 13}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Parent": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Point": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 49}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Parser.__init__": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 23}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.index": {"tf": 1}, "phml.utils.locate.index": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}}, "df": 9, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.inspect": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {"phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 6, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.nodes.PropertyName.isalpha": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.PropertyName.isalnum": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.islower": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.isupper": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.isspace": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.isdecimal": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.isdigit": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.PropertyName.isnumeric": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.isprintable": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 2, "r": {"docs": {"phml.PHMLCore.compiler": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 13}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.component": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1.4142135623730951}}, "df": 4}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Comment": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.__init__": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.core.file_types": {"tf": 1}}, "df": 14}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.casefold": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 9}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.ast": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.AST.__init__": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.__init__": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.children": {"tf": 1.4142135623730951}}, "df": 17}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}}, "df": 5}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 6, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removeprefix": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 1}}}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.render": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.rstrip": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.rfind": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 1}}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.load": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}}, "df": 3}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.lower": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 23}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 6}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "k": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.ljust": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.lstrip": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.travel.walk": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.AST.size": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 4}}}}}, "p": {"docs": {"phml.nodes.PropertyName.strip": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}}, "df": 1}}}}}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.swapcase": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.select": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 5}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.file_types": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 11}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node.type": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.file_types": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Text": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utils.transform": {"tf": 1}, "phml.utils.transform.extract": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}}, "df": 14}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.travel": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 5}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "o": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.nodes": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.__init__": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 91}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.depth": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 5}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element.end_tag": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.extract": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Literal.value": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.has_property": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_heading": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1.4142135623730951}}, "df": 15}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.virtual_python": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "p": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 3}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.upper": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.component": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.extract": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 79}}}}}, "z": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 3}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.matches": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.component": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 21}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.heading": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}}}, "annotation": {"root": {"docs": {"phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.ast": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 21, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.ast": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}}, "df": 11}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.parser": {"tf": 1.4142135623730951}, "phml.Parser.parser": {"tf": 1.4142135623730951}, "phml.core.Parser.parser": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 4}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.compiler": {"tf": 1}}, "df": 1, "r": {"docs": {"phml.PHMLCore.compiler": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.PHMLCore.ast": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 8}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.ast": {"tf": 1.4142135623730951}, "phml.Compiler.ast": {"tf": 1.4142135623730951}, "phml.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.Parser.ast": {"tf": 1.4142135623730951}}, "df": 5}}}, "h": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.AST.size": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}}, "df": 4}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}}, "df": 3, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}}, "df": 2}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"docs": {"phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}}, "df": 4}, "1": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 3}, "2": {"docs": {"phml.utils.misc.inspect.inspect": {"tf": 1}}, "df": 1}, "3": {"9": {"docs": {"phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.encode": {"tf": 2}, "phml.nodes.PropertyName.center": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.ljust": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rjust": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 19.493588689617926}}, "df": 11}, "docs": {}, "df": 0}, "8": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 2}, "docs": {"phml.PHMLCore.__init__": {"tf": 13.2664991614216}, "phml.PHMLCore.add": {"tf": 19.544820285692065}, "phml.PHMLCore.remove": {"tf": 12.569805089976535}, "phml.PHMLCore.load": {"tf": 5.196152422706632}, "phml.PHMLCore.parse": {"tf": 4.795831523312719}, "phml.PHMLCore.render": {"tf": 7.54983443527075}, "phml.PHMLCore.write": {"tf": 8.54400374531753}, "phml.Compiler.__init__": {"tf": 14.422205101855956}, "phml.Compiler.add": {"tf": 19.313207915827967}, "phml.Compiler.remove": {"tf": 12.569805089976535}, "phml.Compiler.compile": {"tf": 10.63014581273465}, "phml.Parser.__init__": {"tf": 2}, "phml.Parser.load": {"tf": 6.782329983125268}, "phml.Parser.parse": {"tf": 6.48074069840786}, "phml.AST.__init__": {"tf": 2.8284271247461903}, "phml.builder.p": {"tf": 13.527749258468683}, "phml.core.Compiler.__init__": {"tf": 14.422205101855956}, "phml.core.Compiler.add": {"tf": 19.313207915827967}, "phml.core.Compiler.remove": {"tf": 12.569805089976535}, "phml.core.Compiler.compile": {"tf": 10.63014581273465}, "phml.core.Parser.__init__": {"tf": 2}, "phml.core.Parser.load": {"tf": 6.782329983125268}, "phml.core.Parser.parse": {"tf": 6.48074069840786}, "phml.nodes.AST.__init__": {"tf": 2.8284271247461903}, "phml.nodes.Node.__init__": {"tf": 5.916079783099616}, "phml.nodes.Root.__init__": {"tf": 7.483314773547883}, "phml.nodes.Root.stringify": {"tf": 3.4641016151377544}, "phml.nodes.DocType.__init__": {"tf": 10.488088481701515}, "phml.nodes.DocType.stringify": {"tf": 5.0990195135927845}, "phml.nodes.Parent.__init__": {"tf": 7.483314773547883}, "phml.nodes.Element.__init__": {"tf": 11.180339887498949}, "phml.nodes.Element.start_tag": {"tf": 3.4641016151377544}, "phml.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.nodes.Literal.__init__": {"tf": 10.344080432788601}, "phml.nodes.Literal.get_ancestry": {"tf": 4.123105625617661}, "phml.nodes.Comment.stringify": {"tf": 5.0990195135927845}, "phml.nodes.Text.stringify": {"tf": 5.0990195135927845}, "phml.nodes.Position.__init__": {"tf": 8.12403840463596}, "phml.nodes.Point.__init__": {"tf": 6.244997998398398}, "phml.nodes.PropertyName.__init__": {"tf": 2}, "phml.nodes.PropertyName.encode": {"tf": 5.916079783099616}, "phml.nodes.PropertyName.replace": {"tf": 5.5677643628300215}, "phml.nodes.PropertyName.split": {"tf": 5.5677643628300215}, "phml.nodes.PropertyName.rsplit": {"tf": 5.5677643628300215}, "phml.nodes.PropertyName.join": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.capitalize": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.casefold": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.title": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.center": {"tf": 5.385164807134504}, "phml.nodes.PropertyName.count": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.expandtabs": {"tf": 4.795831523312719}, "phml.nodes.PropertyName.find": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.partition": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.index": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.ljust": {"tf": 5.385164807134504}, "phml.nodes.PropertyName.lower": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.lstrip": {"tf": 4.795831523312719}, "phml.nodes.PropertyName.rfind": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.rindex": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.rjust": {"tf": 5.385164807134504}, "phml.nodes.PropertyName.rstrip": {"tf": 4.795831523312719}, "phml.nodes.PropertyName.rpartition": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.splitlines": {"tf": 4.795831523312719}, "phml.nodes.PropertyName.strip": {"tf": 4.795831523312719}, "phml.nodes.PropertyName.swapcase": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.translate": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.upper": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.startswith": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.endswith": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.removeprefix": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.removesuffix": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.isascii": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.islower": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isupper": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.istitle": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isspace": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isdecimal": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isdigit": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isnumeric": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isalpha": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isalnum": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isidentifier": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.isprintable": {"tf": 3.872983346207417}, "phml.nodes.PropertyName.zfill": {"tf": 4.358898943540674}, "phml.nodes.PropertyName.format": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.format_map": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.maketrans": {"tf": 3.1622776601683795}, "phml.nodes.AST.AST.__init__": {"tf": 2.8284271247461903}, "phml.utils.locate.find.ancestor": {"tf": 17.05872210923198}, "phml.utils.locate.find.find": {"tf": 15.427248620541512}, "phml.utils.locate.find.find_all": {"tf": 15.264337522473747}, "phml.utils.locate.find.find_after": {"tf": 15.620499351813308}, "phml.utils.locate.find.find_all_after": {"tf": 14.317821063276353}, "phml.utils.locate.find.find_all_before": {"tf": 14.317821063276353}, "phml.utils.locate.find.find_before": {"tf": 14.491376746189438}, "phml.utils.locate.find.find_all_between": {"tf": 17.320508075688775}, "phml.utils.locate.index.Index.__init__": {"tf": 10.862780491200215}, "phml.utils.locate.index.Index.add": {"tf": 5.477225575051661}, "phml.utils.locate.index.Index.remove": {"tf": 5.477225575051661}, "phml.utils.locate.index.Index.get": {"tf": 6.4031242374328485}, "phml.utils.locate.index.Index.map": {"tf": 4.47213595499958}, "phml.utils.locate.select.query": {"tf": 9.16515138991168}, "phml.utils.locate.select.query_all": {"tf": 9.433981132056603}, "phml.utils.locate.select.matches": {"tf": 6}, "phml.utils.locate.select.parse_specifiers": {"tf": 4}, "phml.utils.misc.depth": {"tf": 3.4641016151377544}, "phml.utils.misc.size": {"tf": 6.708203932499369}, "phml.utils.misc.classes.classnames": {"tf": 8.717797887081348}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 4.898979485566356}, "phml.utils.misc.classes.ClassList.contains": {"tf": 4.242640687119285}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 4.47213595499958}, "phml.utils.misc.classes.ClassList.add": {"tf": 4.47213595499958}, "phml.utils.misc.classes.ClassList.replace": {"tf": 5.0990195135927845}, "phml.utils.misc.classes.ClassList.remove": {"tf": 4.47213595499958}, "phml.utils.misc.component.tag_from_file": {"tf": 4}, "phml.utils.misc.component.filename_from_path": {"tf": 4.47213595499958}, "phml.utils.misc.component.parse_component": {"tf": 7.0710678118654755}, "phml.utils.misc.heading.heading_rank": {"tf": 5.291502622129181}, "phml.utils.misc.inspect.inspect": {"tf": 13.341664064126334}, "phml.utils.misc.inspect.normalize_indent": {"tf": 4}, "phml.utils.transform.extract.to_string": {"tf": 12.84523257866513}, "phml.utils.transform.sanitize.sanatize": {"tf": 38.742741255621034}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 14.106735979665885}, "phml.utils.transform.transform.filter_nodes": {"tf": 9.746794344808963}, "phml.utils.transform.transform.remove_nodes": {"tf": 9.746794344808963}, "phml.utils.transform.transform.map_nodes": {"tf": 8.366600265340756}, "phml.utils.transform.transform.find_and_replace": {"tf": 9.1104335791443}, "phml.utils.transform.transform.shift_heading": {"tf": 5.830951894845301}, "phml.utils.transform.transform.replace_node": {"tf": 19.157244060668017}, "phml.utils.travel.path": {"tf": 16.852299546352718}, "phml.utils.travel.walk": {"tf": 6.708203932499369}, "phml.utils.travel.visit_children": {"tf": 6.708203932499369}, "phml.utils.travel.visit_all_after": {"tf": 12.165525060596439}, "phml.utils.validate.test.test": {"tf": 16.0312195418814}, "phml.utils.validate.validate.validate": {"tf": 12.165525060596439}, "phml.utils.validate.validate.parent": {"tf": 6.708203932499369}, "phml.utils.validate.validate.literal": {"tf": 6.708203932499369}, "phml.utils.validate.validate.generated": {"tf": 12.165525060596439}, "phml.utils.validate.validate.has_property": {"tf": 4.47213595499958}, "phml.utils.validate.validate.is_heading": {"tf": 3.4641016151377544}, "phml.utils.validate.validate.is_css_link": {"tf": 3.4641016151377544}, "phml.utils.validate.validate.is_css_style": {"tf": 3.4641016151377544}, "phml.utils.validate.validate.is_javascript": {"tf": 3.4641016151377544}, "phml.utils.validate.validate.is_element": {"tf": 5.196152422706632}, "phml.utils.validate.validate.is_event_handler": {"tf": 4}, "phml.virtual_python.VirtualPython.__init__": {"tf": 8}, "phml.virtual_python.get_vp_result": {"tf": 4.69041575982343}, "phml.virtual_python.process_vp_blocks": {"tf": 6.708203932499369}, "phml.virtual_python.Import.__init__": {"tf": 4.123105625617661}, "phml.virtual_python.Import.from_node": {"tf": 5.291502622129181}, "phml.virtual_python.ImportFrom.__init__": {"tf": 5}, "phml.virtual_python.ImportFrom.from_node": {"tf": 5.291502622129181}}, "df": 152, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}}, "df": 9}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 27}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Point.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 11, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 21}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.compile": {"tf": 1.7320508075688772}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1.7320508075688772}}, "df": 26}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Point.__init__": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.PHMLCore.parse": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 2}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 27}}, "v": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 26}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml.PHMLCore.parse": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.write": {"tf": 1}}, "df": 1}}, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "f": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 3.1622776601683795}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1.4142135623730951}}, "df": 68, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Position.__init__": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 14, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element.__init__": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 69}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "b": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 2.6457513110645907}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.virtual_python.Import.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 33}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 26}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Point.__init__": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.DocType.__init__": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utils.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 1}}, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.__init__": {"tf": 2.8284271247461903}, "phml.PHMLCore.add": {"tf": 4.242640687119285}, "phml.PHMLCore.remove": {"tf": 2.8284271247461903}, "phml.Compiler.__init__": {"tf": 3}, "phml.Compiler.add": {"tf": 4.242640687119285}, "phml.Compiler.remove": {"tf": 2.8284271247461903}, "phml.Compiler.compile": {"tf": 1}, "phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.Compiler.__init__": {"tf": 3}, "phml.core.Compiler.add": {"tf": 4.242640687119285}, "phml.core.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 4}, "phml.utils.locate.find.find": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_all": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_after": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_all_after": {"tf": 3}, "phml.utils.locate.find.find_all_before": {"tf": 3}, "phml.utils.locate.find.find_before": {"tf": 3}, "phml.utils.locate.find.find_all_between": {"tf": 3.3166247903554}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.size": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 3}, "phml.utils.transform.extract.to_string": {"tf": 3}, "phml.utils.transform.sanitize.sanatize": {"tf": 2}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 4.242640687119285}, "phml.utils.travel.path": {"tf": 4}, "phml.utils.travel.walk": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utils.validate.test.test": {"tf": 3.1622776601683795}, "phml.utils.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utils.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 2.8284271247461903}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 60}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 30}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser.load": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 1.4142135623730951}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 6, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 6}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Root.__init__": {"tf": 1.7320508075688772}, "phml.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Parent.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Literal.__init__": {"tf": 1.7320508075688772}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Position.__init__": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Element.__init__": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.removeprefix": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2.23606797749979}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 44, "s": {"docs": {"phml.PHMLCore.__init__": {"tf": 2.8284271247461903}, "phml.PHMLCore.add": {"tf": 4.242640687119285}, "phml.PHMLCore.remove": {"tf": 2.8284271247461903}, "phml.Compiler.__init__": {"tf": 3}, "phml.Compiler.add": {"tf": 4.242640687119285}, "phml.Compiler.remove": {"tf": 2.8284271247461903}, "phml.Compiler.compile": {"tf": 1}, "phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.Compiler.__init__": {"tf": 3}, "phml.core.Compiler.add": {"tf": 4.242640687119285}, "phml.core.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1}, "phml.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Parent.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 4.123105625617661}, "phml.utils.locate.find.find": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_all": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_after": {"tf": 3.3166247903554}, "phml.utils.locate.find.find_all_after": {"tf": 3}, "phml.utils.locate.find.find_all_before": {"tf": 3}, "phml.utils.locate.find.find_before": {"tf": 3}, "phml.utils.locate.find.find_all_between": {"tf": 3.3166247903554}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.size": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 3}, "phml.utils.transform.extract.to_string": {"tf": 3}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 4.242640687119285}, "phml.utils.travel.path": {"tf": 4}, "phml.utils.travel.walk": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utils.validate.test.test": {"tf": 3.1622776601683795}, "phml.utils.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utils.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 2.8284271247461903}}, "df": 57}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.__init__": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.compile": {"tf": 1.7320508075688772}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Node.__init__": {"tf": 1}, "phml.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1.7320508075688772}}, "df": 34, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 16}}}}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 2}, "phml.utils.locate.find.find_all": {"tf": 2}, "phml.utils.locate.find.find_after": {"tf": 2}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.misc.size": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2.449489742783178}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.walk": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 2}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 41}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "v": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 2}, "phml.utils.locate.find.find_all": {"tf": 2}, "phml.utils.locate.find.find_after": {"tf": 2}, "phml.utils.locate.find.find_all_after": {"tf": 2}, "phml.utils.locate.find.find_all_before": {"tf": 2}, "phml.utils.locate.find.find_before": {"tf": 2}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.misc.size": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1.4142135623730951}, "phml.utils.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utils.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2.449489742783178}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.walk": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 2}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 50}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Position.__init__": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {"phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.__init__": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 2}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_all_after": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 28}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 4}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 3}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 2}, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.AST.__init__": {"tf": 1}, "phml.nodes.AST.__init__": {"tf": 1}, "phml.nodes.AST.AST.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 9}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Element.__init__": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 3}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 2.6457513110645907}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "h": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.add": {"tf": 2}, "phml.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utils.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}}, "df": 21}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 4}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 3}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "h": {"1": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "2": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "3": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "4": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "5": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 4, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 2}}, "df": 1, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 6}}}}}}, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}}, "df": 9}}, "x": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.Position.__init__": {"tf": 1}, "phml.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 19}, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "p": {"docs": {"phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 7}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 3}}}}}}, "b": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.DocType.__init__": {"tf": 1}, "phml.nodes.Element.__init__": {"tf": 1}, "phml.nodes.Literal.__init__": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 17}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 10}}}}}}, "t": {"docs": {}, "df": 0, "f": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Element.__init__": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 15}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Literal.__init__": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "p": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.index.Index.map": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.virtual_python.Import.__init__": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 5}}}}, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "g": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 1}}}}, "bases": {"root": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 9}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Root": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType": {"tf": 1.4142135623730951}, "phml.nodes.Parent": {"tf": 1.4142135623730951}, "phml.nodes.Literal": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}}, "df": 7}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Comment": {"tf": 1.4142135623730951}, "phml.nodes.Text": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}, "doc": {"root": {"0": {"docs": {"phml.nodes.Point": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 3}, "1": {"0": {"docs": {"phml": {"tf": 1}}, "df": 1}, "3": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {"phml": {"tf": 1}, "phml.nodes.Point": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 9}, "2": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 4}, "3": {"9": {"docs": {"phml": {"tf": 2}, "phml.nodes.DocType": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 2.8284271247461903}, "phml.nodes.Text": {"tf": 2.8284271247461903}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 5}, "docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}}, "df": 3}, "4": {"docs": {"phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}}, "df": 2}, "5": {"docs": {"phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}, "8": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}, "docs": {"phml": {"tf": 21.817424229271428}, "phml.PHMLCore": {"tf": 1.7320508075688772}, "phml.PHMLCore.__init__": {"tf": 1.7320508075688772}, "phml.PHMLCore.parser": {"tf": 1.7320508075688772}, "phml.PHMLCore.compiler": {"tf": 1.7320508075688772}, "phml.PHMLCore.ast": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 5.477225575051661}, "phml.PHMLCore.remove": {"tf": 2.449489742783178}, "phml.PHMLCore.load": {"tf": 4}, "phml.PHMLCore.parse": {"tf": 3.872983346207417}, "phml.PHMLCore.render": {"tf": 5.830951894845301}, "phml.PHMLCore.write": {"tf": 6.244997998398398}, "phml.Compiler": {"tf": 1.7320508075688772}, "phml.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.Compiler.ast": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 5.477225575051661}, "phml.Compiler.remove": {"tf": 4.242640687119285}, "phml.Compiler.compile": {"tf": 1.7320508075688772}, "phml.Parser": {"tf": 3}, "phml.Parser.__init__": {"tf": 1.7320508075688772}, "phml.Parser.parser": {"tf": 2.23606797749979}, "phml.Parser.ast": {"tf": 1.7320508075688772}, "phml.Parser.load": {"tf": 5.291502622129181}, "phml.Parser.parse": {"tf": 6.6332495807108}, "phml.AST": {"tf": 2.449489742783178}, "phml.AST.__init__": {"tf": 1.7320508075688772}, "phml.AST.size": {"tf": 1.7320508075688772}, "phml.AST.children": {"tf": 1.7320508075688772}, "phml.builder": {"tf": 2.23606797749979}, "phml.builder.p": {"tf": 1.7320508075688772}, "phml.core": {"tf": 2.23606797749979}, "phml.core.Compiler": {"tf": 1.7320508075688772}, "phml.core.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.Compiler.ast": {"tf": 1.7320508075688772}, "phml.core.Compiler.add": {"tf": 5.477225575051661}, "phml.core.Compiler.remove": {"tf": 4.242640687119285}, "phml.core.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.Parser": {"tf": 3}, "phml.core.Parser.__init__": {"tf": 1.7320508075688772}, "phml.core.Parser.parser": {"tf": 2.23606797749979}, "phml.core.Parser.ast": {"tf": 1.7320508075688772}, "phml.core.Parser.load": {"tf": 5.291502622129181}, "phml.core.Parser.parse": {"tf": 6.6332495807108}, "phml.core.file_types": {"tf": 1.7320508075688772}, "phml.nodes": {"tf": 2.23606797749979}, "phml.nodes.AST": {"tf": 2.449489742783178}, "phml.nodes.AST.__init__": {"tf": 1.7320508075688772}, "phml.nodes.AST.size": {"tf": 1.7320508075688772}, "phml.nodes.AST.children": {"tf": 1.7320508075688772}, "phml.nodes.Node": {"tf": 1.7320508075688772}, "phml.nodes.Node.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.nodes.Node.type": {"tf": 1.7320508075688772}, "phml.nodes.Root": {"tf": 2.449489742783178}, "phml.nodes.Root.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Root.stringify": {"tf": 3.3166247903554}, "phml.nodes.DocType": {"tf": 7}, "phml.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.nodes.DocType.stringify": {"tf": 3.3166247903554}, "phml.nodes.Parent": {"tf": 2.449489742783178}, "phml.nodes.Parent.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Element": {"tf": 14.422205101855956}, "phml.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Element.start_tag": {"tf": 5}, "phml.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.nodes.Literal": {"tf": 1.7320508075688772}, "phml.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.nodes.Literal.get_ancestry": {"tf": 2.8284271247461903}, "phml.nodes.Comment": {"tf": 4.58257569495584}, "phml.nodes.Comment.stringify": {"tf": 3.3166247903554}, "phml.nodes.Text": {"tf": 12}, "phml.nodes.Text.num_lines": {"tf": 1.7320508075688772}, "phml.nodes.Text.stringify": {"tf": 3.3166247903554}, "phml.nodes.Position": {"tf": 5.477225575051661}, "phml.nodes.Position.__init__": {"tf": 1.7320508075688772}, "phml.nodes.Point": {"tf": 2.449489742783178}, "phml.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName": {"tf": 2.6457513110645907}, "phml.nodes.PropertyName.__init__": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.encode": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.replace": {"tf": 3}, "phml.nodes.PropertyName.split": {"tf": 4.123105625617661}, "phml.nodes.PropertyName.rsplit": {"tf": 4.123105625617661}, "phml.nodes.PropertyName.join": {"tf": 3.4641016151377544}, "phml.nodes.PropertyName.capitalize": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.casefold": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.title": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.center": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.count": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.expandtabs": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.find": {"tf": 3}, "phml.nodes.PropertyName.partition": {"tf": 3}, "phml.nodes.PropertyName.index": {"tf": 3}, "phml.nodes.PropertyName.ljust": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.lower": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.lstrip": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.rfind": {"tf": 3}, "phml.nodes.PropertyName.rindex": {"tf": 3}, "phml.nodes.PropertyName.rjust": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.rstrip": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.rpartition": {"tf": 3}, "phml.nodes.PropertyName.splitlines": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.strip": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.swapcase": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.translate": {"tf": 3}, "phml.nodes.PropertyName.upper": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.startswith": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.endswith": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.removeprefix": {"tf": 2.6457513110645907}, "phml.nodes.PropertyName.removesuffix": {"tf": 2.6457513110645907}, "phml.nodes.PropertyName.isascii": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.islower": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isupper": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.istitle": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isspace": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isdecimal": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isdigit": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isnumeric": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isalpha": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isalnum": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isidentifier": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isprintable": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.zfill": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.format": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.format_map": {"tf": 2.8284271247461903}, "phml.nodes.PropertyName.maketrans": {"tf": 2.449489742783178}, "phml.nodes.AST.AST": {"tf": 2.449489742783178}, "phml.nodes.AST.AST.__init__": {"tf": 1.7320508075688772}, "phml.nodes.AST.AST.size": {"tf": 1.7320508075688772}, "phml.nodes.AST.AST.children": {"tf": 1.7320508075688772}, "phml.utils": {"tf": 2.23606797749979}, "phml.utils.locate": {"tf": 2.23606797749979}, "phml.utils.locate.find": {"tf": 2.23606797749979}, "phml.utils.locate.find.ancestor": {"tf": 5.291502622129181}, "phml.utils.locate.find.find": {"tf": 5.830951894845301}, "phml.utils.locate.find.find_all": {"tf": 5.5677643628300215}, "phml.utils.locate.find.find_after": {"tf": 5.477225575051661}, "phml.utils.locate.find.find_all_after": {"tf": 5.477225575051661}, "phml.utils.locate.find.find_all_before": {"tf": 5.477225575051661}, "phml.utils.locate.find.find_before": {"tf": 5.477225575051661}, "phml.utils.locate.find.find_all_between": {"tf": 7.211102550927978}, "phml.utils.locate.index": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index": {"tf": 2.449489742783178}, "phml.utils.locate.index.Index.__init__": {"tf": 6.082762530298219}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.add": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.remove": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.get": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.map": {"tf": 3.4641016151377544}, "phml.utils.locate.select": {"tf": 2.23606797749979}, "phml.utils.locate.select.query": {"tf": 9.643650760992955}, "phml.utils.locate.select.query_all": {"tf": 9.643650760992955}, "phml.utils.locate.select.matches": {"tf": 8.246211251235321}, "phml.utils.locate.select.parse_specifiers": {"tf": 8.18535277187245}, "phml.utils.misc": {"tf": 2.23606797749979}, "phml.utils.misc.depth": {"tf": 2.6457513110645907}, "phml.utils.misc.size": {"tf": 1.7320508075688772}, "phml.utils.misc.classes": {"tf": 2.23606797749979}, "phml.utils.misc.classes.classnames": {"tf": 8.774964387392123}, "phml.utils.misc.classes.ClassList": {"tf": 2.6457513110645907}, "phml.utils.misc.classes.ClassList.__init__": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList.contains": {"tf": 2.23606797749979}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 2.23606797749979}, "phml.utils.misc.classes.ClassList.add": {"tf": 2.23606797749979}, "phml.utils.misc.classes.ClassList.replace": {"tf": 2.23606797749979}, "phml.utils.misc.classes.ClassList.remove": {"tf": 2.23606797749979}, "phml.utils.misc.component": {"tf": 1.7320508075688772}, "phml.utils.misc.component.tag_from_file": {"tf": 3.4641016151377544}, "phml.utils.misc.component.filename_from_path": {"tf": 1.7320508075688772}, "phml.utils.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utils.misc.heading": {"tf": 1.7320508075688772}, "phml.utils.misc.heading.heading_rank": {"tf": 3.872983346207417}, "phml.utils.misc.inspect": {"tf": 2.23606797749979}, "phml.utils.misc.inspect.inspect": {"tf": 1.7320508075688772}, "phml.utils.misc.inspect.normalize_indent": {"tf": 7.937253933193772}, "phml.utils.transform": {"tf": 2.23606797749979}, "phml.utils.transform.extract": {"tf": 1.7320508075688772}, "phml.utils.transform.extract.to_string": {"tf": 5}, "phml.utils.transform.sanitize": {"tf": 2.23606797749979}, "phml.utils.transform.sanitize.sanatize": {"tf": 6.855654600401044}, "phml.utils.transform.sanitize.Schema": {"tf": 4.795831523312719}, "phml.utils.transform.sanitize.Schema.__init__": {"tf": 1.7320508075688772}, "phml.utils.transform.transform": {"tf": 2.23606797749979}, "phml.utils.transform.transform.filter_nodes": {"tf": 5.916079783099616}, "phml.utils.transform.transform.remove_nodes": {"tf": 5}, "phml.utils.transform.transform.map_nodes": {"tf": 10.816653826391969}, "phml.utils.transform.transform.find_and_replace": {"tf": 2.8284271247461903}, "phml.utils.transform.transform.shift_heading": {"tf": 2.449489742783178}, "phml.utils.transform.transform.replace_node": {"tf": 5.477225575051661}, "phml.utils.travel": {"tf": 2.23606797749979}, "phml.utils.travel.path": {"tf": 5.196152422706632}, "phml.utils.travel.walk": {"tf": 1.7320508075688772}, "phml.utils.travel.visit_children": {"tf": 1.7320508075688772}, "phml.utils.travel.visit_all_after": {"tf": 1.7320508075688772}, "phml.utils.validate": {"tf": 2.23606797749979}, "phml.utils.validate.test": {"tf": 2.23606797749979}, "phml.utils.validate.test.test": {"tf": 9.539392014169456}, "phml.utils.validate.validate": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.parent": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.literal": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.generated": {"tf": 4.898979485566356}, "phml.utils.validate.validate.has_property": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_heading": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_css_link": {"tf": 5.5677643628300215}, "phml.utils.validate.validate.is_css_style": {"tf": 5.0990195135927845}, "phml.utils.validate.validate.is_javascript": {"tf": 4.69041575982343}, "phml.utils.validate.validate.is_element": {"tf": 2.449489742783178}, "phml.utils.validate.validate.is_event_handler": {"tf": 2.6457513110645907}, "phml.virtual_python": {"tf": 12.12435565298214}, "phml.virtual_python.VirtualPython": {"tf": 1.7320508075688772}, "phml.virtual_python.VirtualPython.__init__": {"tf": 1.7320508075688772}, "phml.virtual_python.get_vp_result": {"tf": 2.449489742783178}, "phml.virtual_python.process_vp_blocks": {"tf": 6}, "phml.virtual_python.Import": {"tf": 1.7320508075688772}, "phml.virtual_python.Import.__init__": {"tf": 1.7320508075688772}, "phml.virtual_python.Import.from_node": {"tf": 4.795831523312719}, "phml.virtual_python.ImportFrom": {"tf": 1.7320508075688772}, "phml.virtual_python.ImportFrom.__init__": {"tf": 1.7320508075688772}, "phml.virtual_python.ImportFrom.from_node": {"tf": 4.795831523312719}}, "df": 222, "p": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.virtual_python": {"tf": 2.8284271247461903}}, "df": 2, "y": {"docs": {"phml": {"tf": 5.291502622129181}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 5.744562646538029}, "phml.Parser": {"tf": 1.7320508075688772}, "phml.core.Parser": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.virtual_python": {"tf": 3.7416573867739413}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 2}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 12}}}}}, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler": {"tf": 1.4142135623730951}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Parser": {"tf": 2}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 2}, "phml.Parser.parse": {"tf": 2}, "phml.AST": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.Compiler": {"tf": 1.4142135623730951}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Parser": {"tf": 2}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 2}, "phml.core.Parser.parse": {"tf": 2}, "phml.core.file_types": {"tf": 1}, "phml.nodes": {"tf": 1.4142135623730951}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils": {"tf": 1.4142135623730951}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 42, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 2}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 2}, "phml.nodes.Node": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}}, "df": 13, "d": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.Parser.load": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 10}, "r": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.parser": {"tf": 1.4142135623730951}, "phml.PHMLCore.ast": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 13, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.parser": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.file_types": {"tf": 1}, "phml.nodes.Position": {"tf": 1}}, "df": 5}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 2}, "phml.utils.validate.validate.parent": {"tf": 1}}, "df": 12}}}, "t": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 4}, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 11}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.load": {"tf": 1.7320508075688772}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1.7320508075688772}, "phml.core.Parser.load": {"tf": 1.7320508075688772}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 7, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 3}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.isprintable": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.find_before": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2}, "s": {"docs": {"phml": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 4}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Element": {"tf": 2}, "phml.nodes.Text": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 4}}}, "y": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 5}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.startswith": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.removeprefix": {"tf": 1.7320508075688772}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 6}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.nodes.Position": {"tf": 2}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1.7320508075688772}, "phml.virtual_python": {"tf": 1}}, "df": 8, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.Point": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Position": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 5, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "q": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1.4142135623730951}}, "df": 1}}, "h": {"2": {"docs": {"phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1.7320508075688772}, "phml.PHMLCore.write": {"tf": 1.7320508075688772}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1.7320508075688772}}, "df": 14, "t": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.Parent": {"tf": 1.4142135623730951}, "phml.nodes.Literal": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 6}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 10}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 3, "r": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"phml": {"tf": 2}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.utils.misc": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.heading": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}, "p": {"docs": {"phml.utils.travel": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.AST": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"phml.utils.misc.classes.ClassList": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.PHMLCore.render": {"tf": 1.7320508075688772}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler": {"tf": 1}, "phml.Parser": {"tf": 1.7320508075688772}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Parser": {"tf": 1.7320508075688772}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1.4142135623730951}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1.7320508075688772}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Comment.stringify": {"tf": 1.7320508075688772}, "phml.nodes.Text.stringify": {"tf": 1.7320508075688772}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 19, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 2}}}}}}, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.Compiler": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 4}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "y": {"docs": {"phml": {"tf": 2}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 7}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}}, "df": 3}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2.6457513110645907}, "phml.utils.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utils.locate.select.matches": {"tf": 2.6457513110645907}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 6}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.Parser": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.transform": {"tf": 1}}, "df": 1}}}}}}}}}, "y": {"docs": {"phml.utils.locate.find": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {"phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}}, "df": 2}}}, "s": {"docs": {"phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 15}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 8}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utils.locate.find": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.misc": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}}, "df": 3}}}, "y": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.utils.locate.select.query": {"tf": 2.23606797749979}, "phml.utils.locate.select.query_all": {"tf": 2.23606797749979}, "phml.utils.locate.select.matches": {"tf": 2.23606797749979}}, "df": 4, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.virtual_python": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.nodes.Point": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.splitlines": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"phml": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 6}}, "k": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1.7320508075688772}, "phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 26, "[": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.select.query_all": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 2.23606797749979}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Parent": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 6}}}}}, "#": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.utils.travel.path": {"tf": 1.4142135623730951}}, "df": 4}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}}, "df": 9}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "f": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}}, "df": 6}}, "n": {"docs": {"phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 5}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {"phml": {"tf": 1}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.nodes.Element": {"tf": 1}, "phml.virtual_python": {"tf": 1.7320508075688772}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 2}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"phml.utils.locate.find": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.file_types": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 8}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.load": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"phml": {"tf": 5.477225575051661}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.virtual_python": {"tf": 3.3166247903554}}, "df": 9}}, "t": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}}, "df": 6, "h": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 7}, "phml.PHMLCore": {"tf": 1.7320508075688772}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 5.196152422706632}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.PHMLCore.load": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 2.6457513110645907}, "phml.PHMLCore.write": {"tf": 3.1622776601683795}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 4.69041575982343}, "phml.Compiler.remove": {"tf": 1.7320508075688772}, "phml.Parser": {"tf": 3}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 2.23606797749979}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.AST": {"tf": 1}, "phml.AST.size": {"tf": 1.4142135623730951}, "phml.AST.children": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 4.69041575982343}, "phml.core.Compiler.remove": {"tf": 1.7320508075688772}, "phml.core.Parser": {"tf": 3}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 2.23606797749979}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.AST": {"tf": 2.23606797749979}, "phml.nodes.AST.size": {"tf": 1.4142135623730951}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node": {"tf": 1.7320508075688772}, "phml.nodes.Node.position": {"tf": 2.23606797749979}, "phml.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.nodes.Root": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 3.7416573867739413}, "phml.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 2.23606797749979}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1.7320508075688772}, "phml.nodes.Text.num_lines": {"tf": 1.4142135623730951}, "phml.nodes.Position": {"tf": 4.358898943540674}, "phml.nodes.Point": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName": {"tf": 2}, "phml.nodes.PropertyName.encode": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.replace": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.split": {"tf": 3.1622776601683795}, "phml.nodes.PropertyName.rsplit": {"tf": 3.4641016151377544}, "phml.nodes.PropertyName.join": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.capitalize": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 3.3166247903554}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 3.4641016151377544}, "phml.nodes.PropertyName.splitlines": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 2}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 2}, "phml.nodes.PropertyName.removesuffix": {"tf": 2}, "phml.nodes.PropertyName.isascii": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isupper": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isdecimal": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isdigit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isnumeric": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isalpha": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isalnum": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 2}, "phml.nodes.AST.AST": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 2.23606797749979}, "phml.utils.locate.find.find": {"tf": 2.23606797749979}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 2}, "phml.utils.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_before": {"tf": 2}, "phml.utils.locate.find.find_before": {"tf": 2.8284271247461903}, "phml.utils.locate.find.find_all_between": {"tf": 2.23606797749979}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 2}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 4}, "phml.utils.locate.select.query_all": {"tf": 4}, "phml.utils.locate.select.matches": {"tf": 3.7416573867739413}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 2}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 2}, "phml.utils.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utils.misc.component.filename_from_path": {"tf": 1.4142135623730951}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 2}, "phml.utils.transform.sanitize.sanatize": {"tf": 2.6457513110645907}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 2.8284271247461903}, "phml.utils.transform.transform.remove_nodes": {"tf": 2.23606797749979}, "phml.utils.transform.transform.map_nodes": {"tf": 2}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 2.23606797749979}, "phml.utils.travel.path": {"tf": 2.23606797749979}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 4.123105625617661}, "phml.utils.validate.validate.is_element": {"tf": 2}, "phml.virtual_python": {"tf": 2.8284271247461903}, "phml.virtual_python.VirtualPython": {"tf": 1.4142135623730951}, "phml.virtual_python.get_vp_result": {"tf": 2.23606797749979}, "phml.virtual_python.process_vp_blocks": {"tf": 2.23606797749979}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 140, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 18}}, "y": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 6}, "m": {"docs": {"phml": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 2}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 2}}, "n": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 11}, "i": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 4}, "phml.PHMLCore.add": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.builder": {"tf": 1}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 19}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 2.23606797749979}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1.4142135623730951}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 57}, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.Node": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {"phml": {"tf": 5.0990195135927845}, "phml.PHMLCore": {"tf": 1.4142135623730951}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 2.23606797749979}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1.4142135623730951}, "phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 2.23606797749979}, "phml.PHMLCore.write": {"tf": 3.1622776601683795}, "phml.Compiler": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 2}, "phml.Compiler.remove": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.Parser": {"tf": 2.449489742783178}, "phml.Parser.load": {"tf": 2.23606797749979}, "phml.Parser.parse": {"tf": 2.8284271247461903}, "phml.AST.children": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 2}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser": {"tf": 2.449489742783178}, "phml.core.Parser.load": {"tf": 2.23606797749979}, "phml.core.Parser.parse": {"tf": 2.8284271247461903}, "phml.nodes": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node": {"tf": 1.4142135623730951}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Parent": {"tf": 1.4142135623730951}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 2}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 3.1622776601683795}, "phml.utils.locate.index.Index.__init__": {"tf": 2.8284271247461903}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.map_nodes": {"tf": 2}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 2.23606797749979}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.virtual_python": {"tf": 2.23606797749979}, "phml.virtual_python.process_vp_blocks": {"tf": 1.7320508075688772}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 87, "o": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 2, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 9, "s": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 6}}}, "g": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 11, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Element": {"tf": 2.23606797749979}, "phml.nodes.Text": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"phml.utils.misc.heading": {"tf": 1}}, "df": 1}}, "b": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 2}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 25}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {"phml.Parser.ast": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Node": {"tf": 2.23606797749979}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 2}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 2}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 19}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utils.transform": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.classes": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}}, "df": 3}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.travel": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 3}}}, "l": {"docs": {"phml.utils.travel": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.classes": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Text": {"tf": 1.7320508075688772}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 2}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.7320508075688772}}, "df": 7, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 3}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 3}}, "df": 15, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.classes": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.validate.test": {"tf": 1}}, "df": 1}}, "s": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Text": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_css_style": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}}, "df": 19, "s": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.file_types": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 8}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 8}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1.7320508075688772}}, "df": 1, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}}}}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}}, "df": 4}}}, "i": {"docs": {"phml": {"tf": 2}, "phml.virtual_python": {"tf": 1.7320508075688772}}, "df": 2, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 2}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1.4142135623730951}}, "df": 1}, "d": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 2}}}}}}}}}, "n": {"docs": {"phml": {"tf": 4.358898943540674}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.AST.size": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Node": {"tf": 1.7320508075688772}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Position": {"tf": 1.7320508075688772}, "phml.nodes.Point": {"tf": 2}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isupper": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isdecimal": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isdigit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isnumeric": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isalpha": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isalnum": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 2}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1.4142135623730951}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 2.23606797749979}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 67, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 2, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "t": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 7, "o": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.parse": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 7}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}}, "df": 4}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 5}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Point": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.nodes.Position": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 2}}, "df": 10, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Point": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}}, "df": 7}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 4}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 9}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.utils": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.inspect": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1}}, "df": 2}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Element": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 3}}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"phml.utils.travel.path": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3, "[": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"phml": {"tf": 4.242640687119285}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.PHMLCore.remove": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.AST.children": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.nodes.AST.children": {"tf": 1.4142135623730951}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 2}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.expandtabs": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.ljust": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.rjust": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isupper": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isdecimal": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isdigit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isnumeric": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isalpha": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isalnum": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isidentifier": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isprintable": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.children": {"tf": 1.4142135623730951}, "phml.utils": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1.7320508075688772}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 73, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {"phml": {"tf": 4.58257569495584}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Element": {"tf": 2}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.removesuffix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isupper": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isdecimal": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isdigit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isnumeric": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isalpha": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isalnum": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 2.23606797749979}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 67}, "t": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.remove": {"tf": 1.7320508075688772}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 28, "s": {"docs": {"phml": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 9}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.AST": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1.4142135623730951}, "phml.virtual_python.Import.from_node": {"tf": 2.23606797749979}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 2.23606797749979}}, "df": 6, "s": {"docs": {"phml": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 3}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1}}, "df": 4}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {"phml": {"tf": 3.872983346207417}, "phml.PHMLCore.add": {"tf": 3}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 2.8284271247461903}, "phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 2}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 2}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 2.449489742783178}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 38, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}}, "df": 5}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 3}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 2}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.virtual_python": {"tf": 2.449489742783178}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.AST": {"tf": 1.4142135623730951}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 2}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {"phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 2}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 11, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 2}}}, "d": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.builder": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "y": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 15, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.builder.p": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"phml": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_after": {"tf": 2}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 2}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.validate": {"tf": 1}}, "df": 13, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 2}}, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 5}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.isprintable": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Parent": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.utils.locate.select.parse_specifiers": {"tf": 1.4142135623730951}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Parent": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}}, "df": 5}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.swapcase": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 5}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {"phml": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 2, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.add": {"tf": 3}, "phml.Compiler.add": {"tf": 3.1622776601683795}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 3.1622776601683795}, "phml.core.Compiler.remove": {"tf": 1}}, "df": 5, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.Compiler.remove": {"tf": 2}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Compiler.remove": {"tf": 2}, "phml.utils.misc.component.parse_component": {"tf": 1}}, "df": 7}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.core.Compiler": {"tf": 1}}, "df": 4, "d": {"docs": {"phml": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}, "r": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}}, "df": 9, "]": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.compiler": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.casefold": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Comment": {"tf": 1.4142135623730951}, "phml.nodes.Comment.stringify": {"tf": 1.4142135623730951}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1.7320508075688772}}, "df": 1}}}, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.classes.ClassList": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 2, "c": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core": {"tf": 1.4142135623730951}}, "df": 1}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.nodes.Point": {"tf": 1.4142135623730951}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 12}}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 9}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.count": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Comment": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.Point": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}}, "df": 18, "s": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.expandtabs": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.swapcase": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}}, "df": 19}}}}}}, "s": {"docs": {"phml.nodes.PropertyName.lstrip": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rstrip": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.strip": {"tf": 1.4142135623730951}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 5, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_children": {"tf": 1}}, "df": 14}}}}}, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.travel.walk": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.nodes.AST": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 12, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}, "s": {"docs": {"phml.utils.validate.test.test": {"tf": 2}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.PHMLCore.add": {"tf": 2.449489742783178}, "phml.Compiler.add": {"tf": 2.23606797749979}, "phml.Parser": {"tf": 2}, "phml.Parser.parse": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.core.Compiler.add": {"tf": 2.23606797749979}, "phml.core.Parser": {"tf": 2}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.Node": {"tf": 1.4142135623730951}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 26}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 9}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.capitalize": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 8, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isupper": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.istitle": {"tf": 1.7320508075688772}}, "df": 7}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.casefold": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 4}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.Parser.parser": {"tf": 1}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser.parser": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2.23606797749979}, "phml.utils.locate.select.query_all": {"tf": 2.23606797749979}, "phml.utils.locate.select.matches": {"tf": 2}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList": {"tf": 2}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 18, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 2}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}}, "df": 3}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.PHMLCore.render": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.Parser.parser": {"tf": 1}, "phml.core.Parser.parser": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 5}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.PHMLCore": {"tf": 1.4142135623730951}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.add": {"tf": 3}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 2.8284271247461903}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.core.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1.4142135623730951}, "phml.nodes.Root.stringify": {"tf": 1.4142135623730951}, "phml.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1.4142135623730951}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1.4142135623730951}, "phml.nodes.Position": {"tf": 3}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.nodes.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.locate.select": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 2}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 2.23606797749979}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1.7320508075688772}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 99, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Point": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 16, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Point": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 19, "s": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 12}}}, "r": {"docs": {"phml": {"tf": 3.3166247903554}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 48, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 6}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 2}, "phml.nodes.PropertyName.count": {"tf": 1}}, "df": 2}}}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.nodes.Parent": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.utils.misc": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 8, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}}, "df": 19}}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 14, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.misc.inspect": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 2.449489742783178}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1.7320508075688772}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.7320508075688772}}, "df": 8, "s": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.nodes": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.AST": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {"phml": {"tf": 5.196152422706632}, "phml.PHMLCore": {"tf": 2}, "phml.PHMLCore.parser": {"tf": 1}, "phml.PHMLCore.compiler": {"tf": 1}, "phml.PHMLCore.add": {"tf": 2.449489742783178}, "phml.PHMLCore.remove": {"tf": 1.7320508075688772}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 2.23606797749979}, "phml.Compiler.compile": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 2.23606797749979}, "phml.Parser.parse": {"tf": 2.8284271247461903}, "phml.builder": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 2.23606797749979}, "phml.core.Compiler.compile": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 2.23606797749979}, "phml.core.Parser.parse": {"tf": 2.8284271247461903}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.nodes.Root": {"tf": 2.23606797749979}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 2.449489742783178}, "phml.nodes.Literal": {"tf": 1.4142135623730951}, "phml.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.Position": {"tf": 1.7320508075688772}, "phml.nodes.Point": {"tf": 2.6457513110645907}, "phml.nodes.PropertyName": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.expandtabs": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.ljust": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.removesuffix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isspace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isdecimal": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isdigit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isnumeric": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 2}, "phml.nodes.AST": {"tf": 1}, "phml.utils": {"tf": 1.4142135623730951}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 3.1622776601683795}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.classes.ClassList.contains": {"tf": 1}, "phml.utils.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1.4142135623730951}, "phml.utils.transform": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 2.449489742783178}, "phml.utils.transform.transform.find_and_replace": {"tf": 2.449489742783178}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.travel.path": {"tf": 1.7320508075688772}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 2.23606797749979}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 2}, "phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 2}, "phml.utils.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}, "phml.virtual_python.VirtualPython": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1.7320508075688772}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.7320508075688772}}, "df": 131, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2}, "phml.Compiler.remove": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 2.8284271247461903}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 2}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 37, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 1}, "phml.utils": {"tf": 1}}, "df": 3, "s": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}}, "df": 3}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 8}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 4}, "g": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.nodes.PropertyName.isalnum": {"tf": 1.7320508075688772}}, "df": 1, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.PropertyName.isalpha": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}}}, "n": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 26, "d": {"docs": {"phml": {"tf": 4.123105625617661}, "phml.PHMLCore": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser": {"tf": 2.23606797749979}, "phml.Parser.load": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.builder": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser": {"tf": 2.23606797749979}, "phml.core.Parser.load": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1.7320508075688772}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.swapcase": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.nodes.AST": {"tf": 1.4142135623730951}, "phml.utils": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.Schema": {"tf": 2}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 2}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 82, "/": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}, "y": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 25, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"phml.utils.travel.path": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.misc.classes.ClassList.replace": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1.4142135623730951}}, "df": 1, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"phml": {"tf": 3.605551275463989}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Root": {"tf": 1.7320508075688772}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.virtual_python": {"tf": 1.7320508075688772}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 37, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.Parser": {"tf": 1.7320508075688772}, "phml.Parser.parser": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.Parser.load": {"tf": 2.23606797749979}, "phml.Parser.parse": {"tf": 2}, "phml.AST": {"tf": 1.4142135623730951}, "phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.7320508075688772}, "phml.core.Parser.parser": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.core.Parser.load": {"tf": 2.23606797749979}, "phml.core.Parser.parse": {"tf": 2}, "phml.nodes.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils": {"tf": 1.4142135623730951}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1.7320508075688772}, "phml.virtual_python.ImportFrom": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.7320508075688772}}, "df": 45}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "i": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1.7320508075688772}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}}, "df": 2}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.map": {"tf": 1}}, "df": 3}, "s": {"docs": {"phml.utils.locate.index.Index.map": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 9}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.misc.classes.ClassList.add": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {"phml.utils.locate.index.Index.add": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.PHMLCore.add": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 2.449489742783178}}, "df": 36}, "g": {"docs": {"phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 36}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 3, "s": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 6}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Node": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 5}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 20, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 3.4641016151377544}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 6, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.ast": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 8}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.remove": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 7}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.PHMLCore.add": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}}, "df": 4}}}}}}, "m": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 3.872983346207417}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.file_types": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 29, "m": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.render": {"tf": 2}, "phml.PHMLCore.write": {"tf": 1.7320508075688772}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 9, "s": {"docs": {"phml.Compiler": {"tf": 1}, "phml.core.Compiler": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}}, "df": 4}}}, "s": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Text": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 15}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml": {"tf": 2}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.virtual_python": {"tf": 1.7320508075688772}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 34}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query": {"tf": 2.8284271247461903}, "phml.utils.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utils.locate.select.matches": {"tf": 2.449489742783178}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}}, "df": 16, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.7320508075688772}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1.4142135623730951}, "phml.core": {"tf": 1}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 1.4142135623730951}, "phml.core.file_types": {"tf": 1}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.Point": {"tf": 2}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 16, "s": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 6}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 3, "s": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 4}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}}, "df": 11, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Element": {"tf": 2.8284271247461903}, "phml.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.nodes.Position": {"tf": 1.7320508075688772}, "phml.nodes.Point": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 8, "s": {"docs": {"phml.nodes.Position": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utils.misc.classes": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 11, "s": {"docs": {"phml": {"tf": 1}, "phml.AST": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}}, "df": 6}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 2}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 16}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1, "b": {"docs": {"phml": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 4}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 3.3166247903554}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.endswith": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.removeprefix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.removesuffix": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2.8284271247461903}, "phml.utils.locate.select.query_all": {"tf": 2.8284271247461903}, "phml.utils.locate.select.matches": {"tf": 2.449489742783178}, "phml.utils.locate.select.parse_specifiers": {"tf": 3.3166247903554}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python.VirtualPython": {"tf": 1}}, "df": 37, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.7320508075688772}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 26}}, "s": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 4}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1.7320508075688772}}, "df": 7}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 7}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 9}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.validate": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utils.locate.find.find": {"tf": 1}}, "df": 1}}, "s": {"docs": {"phml.utils.locate.select.query": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 2}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 2}}, "k": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 4}}, "d": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.find.ancestor": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.PHMLCore.write": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}}, "df": 2}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.Compiler.ast": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 5}, "s": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"phml.AST.size": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.component.filename_from_path": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.travel.path": {"tf": 1}}, "df": 18, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"phml": {"tf": 5.5677643628300215}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1.4142135623730951}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.virtual_python": {"tf": 3.3166247903554}}, "df": 11}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.travel.path": {"tf": 1.4142135623730951}, "phml.utils.travel.visit_all_after": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 31}, "s": {"docs": {"phml.utils.travel.path": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "d": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.nodes.AST": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.utils.misc": {"tf": 1}}, "df": 6}}}}}}}, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.Parser.parse": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 6, "s": {"docs": {"phml.PHMLCore": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}}, "df": 7}}}}}}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.isdigit": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.isdigit": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.isdecimal": {"tf": 1.7320508075688772}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 11, "s": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 2}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.write": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.find.find": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utils.misc.depth": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {"phml": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.nodes.Root.stringify": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.DocType": {"tf": 1.7320508075688772}, "phml.nodes.DocType.stringify": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "m": {"docs": {"phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "n": {"docs": {"phml.utils.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utils.misc.classes": {"tf": 1}}, "df": 2, "e": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 2, "n": {"docs": {"phml.utils.misc": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser.parse": {"tf": 2.449489742783178}, "phml.core.Parser.parse": {"tf": 2.449489742783178}, "phml.nodes": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 12, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}}, "df": 3}}}}}}}}}, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 4, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1.4142135623730951}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Node.type": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.PHMLCore.ast": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Element": {"tf": 1.4142135623730951}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 3.605551275463989}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.shift_heading": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 25, "s": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 11}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.core": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}}, "df": 5, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.classes": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 2}}}}}, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.virtual_python": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}}}}}, "r": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 4}}}, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 2}, "phml.PHMLCore.render": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.removesuffix": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.islower": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}, "phml.nodes.PropertyName.isspace": {"tf": 1}, "phml.nodes.PropertyName.isdecimal": {"tf": 1}, "phml.nodes.PropertyName.isdigit": {"tf": 1}, "phml.nodes.PropertyName.isnumeric": {"tf": 1}, "phml.nodes.PropertyName.isalpha": {"tf": 1}, "phml.nodes.PropertyName.isalnum": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 55, "s": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1.4142135623730951}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}, "phml.virtual_python.Import.from_node": {"tf": 1}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 35}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Position": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Node.type": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Element": {"tf": 1.7320508075688772}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.Position": {"tf": 2}, "phml.nodes.Point": {"tf": 2}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.virtual_python.VirtualPython": {"tf": 1}}, "df": 11}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.utils.misc.classes.ClassList.replace": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}}, "df": 9, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1.7320508075688772}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.replace": {"tf": 1.4142135623730951}}, "df": 4}, "s": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.virtual_python": {"tf": 2}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 11, "/": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.utils.locate.index.Index.map": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 4}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "d": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.ast": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.utils.misc.classes.ClassList.remove": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 10, "d": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 9}, "s": {"docs": {"phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.Parser.ast": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 7}}}}}}}}}, "l": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.select.matches": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.nodes": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 3}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.Position": {"tf": 1.7320508075688772}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}}, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1.7320508075688772}}, "df": 3}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.transform": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 3}}, "k": {"docs": {"phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 3}}}}, "w": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.Root": {"tf": 1.7320508075688772}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.AST": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}}, "df": 21, "s": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1.4142135623730951}}, "df": 1}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.rfind": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 3.605551275463989}, "phml.PHMLCore.add": {"tf": 2}, "phml.PHMLCore.remove": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.Compiler.add": {"tf": 1.7320508075688772}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.nodes.Element": {"tf": 2.449489742783178}, "phml.nodes.Element.start_tag": {"tf": 1.4142135623730951}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.index.Index.remove": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2.449489742783178}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1.7320508075688772}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.visit_children": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}, "phml.utils.validate.validate.is_heading": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_css_style": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_javascript": {"tf": 1.7320508075688772}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 41, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.builder": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Position": {"tf": 1}, "phml.utils.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.parse_specifiers": {"tf": 2.6457513110645907}, "phml.utils.misc.component.parse_component": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 13}, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.select.matches": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 2.8284271247461903}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Comment": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 2}, "phml.utils.misc.heading.heading_rank": {"tf": 1}, "phml.utils.misc.inspect.normalize_indent": {"tf": 1}}, "df": 12, "s": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {"phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.Compiler.compile": {"tf": 1}, "phml.core.Compiler.compile": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 3, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.nodes.Node": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}}, "df": 2, "d": {"docs": {"phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {"phml.utils.misc.inspect.normalize_indent": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.VirtualPython": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.remove_nodes": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName": {"tf": 2}, "phml.nodes.PropertyName.encode": {"tf": 2.23606797749979}}, "df": 2}}}, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {"phml.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.nodes.Position": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}}, "df": 12, "s": {"docs": {"phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}}, "df": 2, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1.4142135623730951}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 8}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.Position": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.locate.index.Index.map": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 21}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.core.Compiler": {"tf": 1}}, "df": 3}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.Node.type": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.isascii": {"tf": 1}, "phml.nodes.PropertyName.isprintable": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}}, "df": 15}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml.nodes.PropertyName": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.encode": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 3, "o": {"docs": {"phml.AST.children": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}}, "df": 16, "w": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.virtual_python": {"tf": 1}}, "df": 2}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "t": {"docs": {"phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.add": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 21, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 7}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 5}}}}}}, "n": {"docs": {"phml": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}}, "df": 3, "e": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1}, "phml.AST.children": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1}, "phml.nodes.AST.children": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}, "phml.nodes.AST.AST.children": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utils.validate.test.test": {"tf": 1.7320508075688772}}, "df": 26}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.remove": {"tf": 1.7320508075688772}, "phml.Compiler.remove": {"tf": 1}, "phml.Parser.ast": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser.ast": {"tf": 1}, "phml.nodes": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.nodes.DocType": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Literal": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.Position": {"tf": 1.7320508075688772}, "phml.nodes.AST": {"tf": 1.7320508075688772}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 2.23606797749979}, "phml.utils.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_after": {"tf": 2}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 2}, "phml.utils.locate.find.find_before": {"tf": 2.6457513110645907}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 2.6457513110645907}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect.inspect": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.map_nodes": {"tf": 3.4641016151377544}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.replace_node": {"tf": 2.23606797749979}, "phml.utils.travel": {"tf": 1}, "phml.utils.travel.path": {"tf": 2.449489742783178}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 3.3166247903554}, "phml.utils.validate.validate.validate": {"tf": 1}, "phml.utils.validate.validate.parent": {"tf": 1}, "phml.utils.validate.validate.literal": {"tf": 1}, "phml.utils.validate.validate.generated": {"tf": 2.23606797749979}, "phml.utils.validate.validate.is_css_link": {"tf": 1}, "phml.utils.validate.validate.is_css_style": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}}, "df": 51, "s": {"docs": {"phml.Compiler.remove": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Parent": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 2.23606797749979}, "phml.utils.locate.find.find": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all": {"tf": 2}, "phml.utils.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_before": {"tf": 2.23606797749979}, "phml.utils.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_between": {"tf": 2.23606797749979}, "phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 2}, "phml.utils.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utils.travel.path": {"tf": 2}, "phml.utils.validate": {"tf": 1.4142135623730951}, "phml.utils.validate.test": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.generated": {"tf": 1}}, "df": 34}, "[": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.locate.select.parse_specifiers": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}}, "#": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 9}, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.Root": {"tf": 1}, "phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.add": {"tf": 2.449489742783178}, "phml.Compiler.add": {"tf": 2.449489742783178}, "phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.add": {"tf": 2.449489742783178}, "phml.core.Compiler.remove": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.component.tag_from_file": {"tf": 1.7320508075688772}, "phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 15, "s": {"docs": {"phml.Compiler.remove": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 2}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.AST.size": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.AST.size": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Text.num_lines": {"tf": 1}, "phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.AST.AST.size": {"tf": 1}, "phml.utils.locate.find.ancestor": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.size": {"tf": 1}}, "df": 21}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.PropertyName.isnumeric": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isalnum": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Node": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.startswith": {"tf": 2}, "phml.nodes.PropertyName.endswith": {"tf": 2}, "phml.nodes.PropertyName.isidentifier": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format_map": {"tf": 1.4142135623730951}, "phml.utils.misc.depth": {"tf": 1}, "phml.utils.travel.walk": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1.4142135623730951}}, "df": 19, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Position": {"tf": 2}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.startswith": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.endswith": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 21, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.utils.locate.find.find": {"tf": 1}, "phml.utils.locate.find.find_all": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.travel.path": {"tf": 1}, "phml.utils.travel.visit_all_after": {"tf": 1}}, "df": 10}}}, "s": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.utils.validate.validate.is_event_handler": {"tf": 1}}, "df": 4, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}}, "df": 2}}}}}, "y": {"docs": {"phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1}, "phml.PHMLCore.parse": {"tf": 1.4142135623730951}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1.4142135623730951}, "phml.Compiler.add": {"tf": 1}, "phml.Compiler.remove": {"tf": 1.4142135623730951}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.Compiler.add": {"tf": 1}, "phml.core.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1.7320508075688772}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Element.start_tag": {"tf": 1}, "phml.nodes.Element.end_tag": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 1}, "phml.nodes.PropertyName.removesuffix": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utils.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.utils.transform.sanitize.Schema": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.is_element": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.7320508075688772}}, "df": 34, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root.stringify": {"tf": 1}, "phml.nodes.DocType.stringify": {"tf": 1}, "phml.nodes.Comment.stringify": {"tf": 1}, "phml.nodes.Text.stringify": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.split": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.rsplit": {"tf": 2}, "phml.nodes.PropertyName.join": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.casefold": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.lower": {"tf": 1}, "phml.nodes.PropertyName.lstrip": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rstrip": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.splitlines": {"tf": 1}, "phml.nodes.PropertyName.strip": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.removeprefix": {"tf": 2}, "phml.nodes.PropertyName.removesuffix": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isascii": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.islower": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isupper": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.istitle": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.isspace": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isdecimal": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isdigit": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.isnumeric": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isalpha": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isalnum": {"tf": 2.23606797749979}, "phml.nodes.PropertyName.isidentifier": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.isprintable": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.zfill": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.virtual_python.VirtualPython": {"tf": 1}}, "df": 56, "s": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.nodes.Literal.value": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.join": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}}, "df": 12}, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.removeprefix": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.virtual_python.Import": {"tf": 1}, "phml.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"phml.utils.transform.sanitize.Schema": {"tf": 1.4142135623730951}}, "df": 1}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "p": {"docs": {"phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}}, "df": 2}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.validate.is_css_style": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 6}}, "b": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.find": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.index": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.rfind": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.rindex": {"tf": 1.7320508075688772}}, "df": 5, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.format": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.format_map": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.replace": {"tf": 1}, "phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1.4142135623730951}}, "df": 6, "s": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.PHMLCore.render": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.casefold": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.PropertyName.endswith": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.removesuffix": {"tf": 2}, "phml.utils.misc.component.filename_from_path": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 2}, "phml.utils.locate.select.query_all": {"tf": 2}, "phml.utils.locate.select.matches": {"tf": 2}, "phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 5, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore": {"tf": 1}, "phml.PHMLCore.load": {"tf": 1.4142135623730951}, "phml.nodes.Node.position": {"tf": 1}, "phml.nodes.Literal.position": {"tf": 1}, "phml.nodes.Position": {"tf": 2.23606797749979}, "phml.nodes.Point": {"tf": 2}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 7}}}}, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.validate.test.test": {"tf": 1}, "phml.utils.validate.validate.has_property": {"tf": 1}}, "df": 2, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.validate.test.test": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.validate.test": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.nodes.Element.start_tag": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.locate.select": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.misc.classes": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.partition": {"tf": 2.449489742783178}, "phml.nodes.PropertyName.rpartition": {"tf": 2.449489742783178}}, "df": 4}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 3}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.Element": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}, "a": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 2}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}, "phml.utils.transform.transform.remove_nodes": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 9}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.Parent": {"tf": 1}, "phml.nodes.Position": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utils.transform.sanitize.Schema": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.transform.sanitize": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}, "phml.nodes.Node": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.map_nodes": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}}, "df": 8}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml.utils.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.utils.transform.extract.to_string": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.AST": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_after": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utils.locate.find.find_all_between": {"tf": 1}, "phml.utils.locate.select.parse_specifiers": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.utils.locate.find.find_after": {"tf": 1}, "phml.utils.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utils.locate.find.find_all_before": {"tf": 1}, "phml.utils.locate.find.find_before": {"tf": 1}}, "df": 4}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.utils.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.PHMLCore.render": {"tf": 2}, "phml.PHMLCore.write": {"tf": 2}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}}, "df": 5}}}, "n": {"docs": {"phml.nodes.Text": {"tf": 1.7320508075688772}, "phml.nodes.Position": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.startswith": {"tf": 1}, "phml.nodes.PropertyName.endswith": {"tf": 1}, "phml.utils.transform.transform.shift_heading": {"tf": 1}}, "df": 7}, "r": {"docs": {"phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.utils.locate.select.query": {"tf": 1.7320508075688772}, "phml.utils.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}}, "c": {"docs": {"phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.index.Index.get": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.title": {"tf": 1}}, "df": 2}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1.7320508075688772}, "phml.nodes.PropertyName.rsplit": {"tf": 1.4142135623730951}, "phml.utils.transform.transform.find_and_replace": {"tf": 1}}, "df": 3, "s": {"docs": {"phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 2}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.nodes.PropertyName.rsplit": {"tf": 1}}, "df": 1}}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"phml.nodes.Node": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"phml.nodes.PropertyName": {"tf": 1}}, "df": 1}}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}}, "df": 5}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.count": {"tf": 1}, "phml.nodes.PropertyName.find": {"tf": 1}, "phml.nodes.PropertyName.index": {"tf": 1}, "phml.nodes.PropertyName.rfind": {"tf": 1}, "phml.nodes.PropertyName.rindex": {"tf": 1}, "phml.utils.locate.find.find_all_between": {"tf": 1.4142135623730951}}, "df": 6}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "u": {"docs": {"phml": {"tf": 4.123105625617661}, "phml.Parser": {"tf": 1.4142135623730951}, "phml.core.Parser": {"tf": 1.4142135623730951}, "phml.nodes.AST": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.misc.depth": {"tf": 1.4142135623730951}, "phml.utils.validate": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 10, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.6457513110645907}}, "df": 1}}}}, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.DocType": {"tf": 1}, "phml.nodes.Element": {"tf": 1}, "phml.nodes.Text": {"tf": 1}, "phml.utils.misc.classes.classnames": {"tf": 2}, "phml.utils.misc.heading.heading_rank": {"tf": 1}}, "df": 5}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.nodes.Element": {"tf": 2}, "phml.utils.misc.inspect.normalize_indent": {"tf": 2}, "phml.utils.transform.transform.map_nodes": {"tf": 2}, "phml.virtual_python": {"tf": 2}}, "df": 5}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utils.locate.select": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utils.locate.select.query": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utils.locate.select.query_all": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.449489742783178}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "p": {"docs": {"phml": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.capitalize": {"tf": 1}, "phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.swapcase": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.upper": {"tf": 1}, "phml.nodes.PropertyName.isupper": {"tf": 1.7320508075688772}}, "df": 3, "d": {"docs": {"phml.nodes.PropertyName.title": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.PHMLCore.render": {"tf": 1}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.utils.locate.index.Index.__init__": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.virtual_python.process_vp_blocks": {"tf": 1}}, "df": 11, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}}, "df": 2}}}, "d": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.add": {"tf": 1}, "phml.PHMLCore.remove": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.Compiler.ast": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.core.Compiler": {"tf": 1}, "phml.core.Compiler.ast": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.nodes.Node.type": {"tf": 1}, "phml.nodes.Root": {"tf": 1}, "phml.nodes.Literal.get_ancestry": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.utils.locate.select.query": {"tf": 1.4142135623730951}, "phml.utils.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utils.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}}, "df": 19}, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}, "s": {"docs": {"phml.utils.locate.index.Index": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.nodes.PropertyName": {"tf": 1}, "phml.nodes.PropertyName.encode": {"tf": 1}, "phml.nodes.PropertyName.split": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.rsplit": {"tf": 1}, "phml.nodes.PropertyName.center": {"tf": 1}, "phml.nodes.PropertyName.expandtabs": {"tf": 1}, "phml.nodes.PropertyName.partition": {"tf": 1}, "phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}, "phml.nodes.PropertyName.rpartition": {"tf": 1}, "phml.nodes.PropertyName.translate": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1}, "phml.nodes.PropertyName.format_map": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}}, "df": 16}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"phml": {"tf": 2}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.PHMLCore.add": {"tf": 1}, "phml.Compiler.add": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.core.Compiler.add": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.misc.inspect": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.transform.sanitize": {"tf": 1}, "phml.utils.transform.transform": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate": {"tf": 1}, "phml.utils.validate.test": {"tf": 1}}, "df": 17}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.AST": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.nodes.AST": {"tf": 1}, "phml.nodes.AST.AST": {"tf": 1}, "phml.utils": {"tf": 1}, "phml.utils.locate.find": {"tf": 1}, "phml.utils.misc.classes.ClassList": {"tf": 1}, "phml.utils.misc.heading": {"tf": 1}, "phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utils.transform.transform": {"tf": 1}}, "df": 10}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utils.locate": {"tf": 1}, "phml.utils.locate.select": {"tf": 1}, "phml.utils.misc": {"tf": 1}, "phml.utils.misc.classes": {"tf": 1}, "phml.utils.transform": {"tf": 1}, "phml.utils.travel": {"tf": 1}, "phml.utils.validate": {"tf": 1}}, "df": 7}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.AST": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.Parser.load": {"tf": 1}, "phml.core.Parser.load": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Parent": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.nodes.Literal": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"phml.nodes.Position": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1.4142135623730951}, "phml.nodes.PropertyName.maketrans": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.translate": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.istitle": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.utils.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "+": {"0": {"0": {"0": {"0": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "7": {"docs": {}, "df": 0, "f": {"docs": {"phml.nodes.PropertyName.isascii": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.utils.transform.transform.filter_nodes": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.splitlines": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.PHMLCore.remove": {"tf": 1}, "phml.utils.locate.index.Index": {"tf": 2}, "phml.utils.locate.index.Index.__init__": {"tf": 1.7320508075688772}}, "df": 3, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.isidentifier": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.nodes.PropertyName.format": {"tf": 1.4142135623730951}, "phml.virtual_python": {"tf": 1}, "phml.virtual_python.get_vp_result": {"tf": 1}, "phml.virtual_python.process_vp_blocks": {"tf": 1.4142135623730951}}, "df": 8}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.PHMLCore.render": {"tf": 1.4142135623730951}, "phml.PHMLCore.write": {"tf": 1}, "phml.Compiler": {"tf": 1}, "phml.Parser": {"tf": 1}, "phml.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.Compiler": {"tf": 1}, "phml.core.Parser": {"tf": 1}, "phml.core.Parser.parse": {"tf": 1.4142135623730951}, "phml.nodes.Node": {"tf": 2}}, "df": 10}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.utils.transform.transform.replace_node": {"tf": 1}, "phml.utils.validate.test.test": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.nodes.PropertyName.ljust": {"tf": 1}, "phml.nodes.PropertyName.rjust": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.nodes.Node": {"tf": 1}, "phml.utils.locate.select.matches": {"tf": 1}, "phml.utils.validate.validate.is_javascript": {"tf": 1.7320508075688772}, "phml.virtual_python": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utils.locate.select.query": {"tf": 1}, "phml.utils.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"phml.nodes.PropertyName.join": {"tf": 1}, "phml.virtual_python": {"tf": 1}}, "df": 2}}}}, "x": {"docs": {"phml.nodes.PropertyName.maketrans": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.nodes.PropertyName.encode": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"phml.nodes.PropertyName.zfill": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();