
# Milvus Python SDK

[![version](https://img.shields.io/pypi/v/pymilvus-orm.svg?color=blue)](https://pypi.org/project/pymilvus-orm/)
[![Supported Python Versions](https://img.shields.io/pypi/pyversions/pymilvus-orm?logo=python&logoColor=blue)](https://pypi.org/project/pymilvus-orm/)
[![Downloads](https://pepy.tech/badge/pymilvus-orm)](https://pepy.tech/project/pymilvus-orm)
[![Downloads](https://pepy.tech/badge/pymilvus-orm/month)](https://pepy.tech/project/pymilvus-orm/month)
[![Downloads](https://pepy.tech/badge/pymilvus-orm/week)](https://pepy.tech/project/pymilvus-orm/week)
[![license](https://img.shields.io/hexpm/l/plug.svg?color=green)](https://github.com/milvus-io/pymilvus-orm/blob/master/LICENSE)
[![Mergify Status][mergify-status]][mergify]

[mergify]: https://mergify.io
[mergify-status]: https://img.shields.io/endpoint.svg?url=https://gh.mergify.io/badges/milvus-io/pymilvus-orm&style=plastic

Another Python SDK for [Milvus](https://github.com/milvus-io/milvus). To contribute code to this project, please read our [contribution guidelines](https://github.com/milvus-io/milvus/blob/master/CONTRIBUTING.md) first.


## Compatibility
The following collection shows Milvus versions and recommended PyMilvus ORM versions:

|Milvus version| Recommended PyMilvus ORM version |
|:-----:|:-----:|
| 2.x.x | 0.0.1 |


## Installation

You can install PyMilvus ORM via `pip3` for Python 3.6+:

```shell
$ pip3 install pymilvus-orm
```

You can install a specific version of PyMilvus ORM by:

```shell
$ pip3 install pymilvus-orm==0.0.1
```

You can upgrade PyMilvus ORM to the latest version by:

```shell
$ pip3 install --upgrade pymilvus-orm
```


## Documentation

Documentation is available online: https://pymilvus-orm.readthedocs.io/.


## Packages

### Released packages

The release of PyMilvus ORM is managed on GitHub, and GitHub Actions will package and upload each version to PyPI.

The release version number of PyMilvus ORM follows PEP440, the format is x.y.z, and the corresponding git tag name is vx.y.z (x/y/z are numbers from 0 to 9).

For example, after PyMilvus ORM 1.0.1 is released, a tag named v1.0.1 can be found on GitHub, and a package with version 1.0.1 can be downloaded on PyPI.

### Developing packages (Working in progress)

The commits on the development branch of each version will be packaged and uploaded to Test PyPI. Development branches refer to branches such as 1.0 and 1.1, and version releases are generated from the development branches, such as 1.0.1 and 1.0.2.

The package name generated by the development branch is x.y.z.dev<dist>, where <dist> is the number of commits that differ from the most recent release.

For example, after the release of 1.0.1, two commits were submitted on the 1.0 branch. At this time, the automatic packaging version number of the development branch is 1.0.1.dev2.

To install the package on test.pypi.org, you need to append the parameter --index-url after pip, for example:
```shell
$ python3 -m pip install --index-url https://test.pypi.org/simple/ pymilvus-orm
```


## License
[Apache License 2.0](LICENSE)
