r'''
# cdk8s+ (cdk8s-plus)

### High level constructs for Kubernetes

![Stability:Stable](https://img.shields.io/badge/stability-stable-success)

| k8s version | npm (JS/TS)                                         | PyPI (Python)                                   | Maven (Java)                                                      | Go                                                              |
| ----------- | --------------------------------------------------- | ----------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------- |
| 1.26.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-26) | [Link](https://pypi.org/project/cdk8s-plus-26/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-26) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.26) |
| 1.27.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-27) | [Link](https://pypi.org/project/cdk8s-plus-27/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-27) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.27) |
| 1.28.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-28) | [Link](https://pypi.org/project/cdk8s-plus-28/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-28) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.28) |

**cdk8s+** is a software development framework that provides high level
abstractions for authoring Kubernetes applications. Built on top of the auto
generated building blocks provided by [cdk8s](../cdk8s), this library includes a
hand crafted *construct* for each native kubernetes object, exposing richer
API's with reduced complexity.

## :books: Documentation

See [cdk8s.io](https://cdk8s.io/docs/latest/plus).

## :raised_hand: Contributing

If you'd like to add a new feature or fix a bug, please visit
[CONTRIBUTING.md](CONTRIBUTING.md)!

## :balance_scale: License

This project is distributed under the [Apache License, Version 2.0](./LICENSE).

This module is part of the [cdk8s project](https://github.com/cdk8s-team).
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import cdk8s as _cdk8s_d3d9af27
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AddDirectoryOptions",
    jsii_struct_bases=[],
    name_mapping={"exclude": "exclude", "key_prefix": "keyPrefix"},
)
class AddDirectoryOptions:
    def __init__(
        self,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``configmap.addDirectory()``.

        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6133395776f5ea193acd69e243f84a467a846621df2f12445e6bd62d4c6035a)
            check_type(argname="argument exclude", value=exclude, expected_type=type_hints["exclude"])
            check_type(argname="argument key_prefix", value=key_prefix, expected_type=type_hints["key_prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if exclude is not None:
            self._values["exclude"] = exclude
        if key_prefix is not None:
            self._values["key_prefix"] = key_prefix

    @builtins.property
    def exclude(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Glob patterns to exclude when adding files.

        :default: - include all files
        '''
        result = self._values.get("exclude")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def key_prefix(self) -> typing.Optional[builtins.str]:
        '''A prefix to add to all keys in the config map.

        :default: ""
        '''
        result = self._values.get("key_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDirectoryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ApiResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"api_group": "apiGroup", "resource_type": "resourceType"},
)
class ApiResourceOptions:
    def __init__(self, *, api_group: builtins.str, resource_type: builtins.str) -> None:
        '''Options for ``ApiResource``.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b7d0f4a45c746c1c1d4e75e1ce15d6da071648441e5aa84644c3390e3fcda7d)
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_group": api_group,
            "resource_type": resource_type,
        }

    @builtins.property
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        result = self._values.get("api_group")
        assert result is not None, "Required property 'api_group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AwsElasticBlockStoreVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAwsElasticBlockStore``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab401d8ca75caa74d7e8fda18d0c8d0b567ddfe42c2f675d1dd8547901c46d16)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.AzureDiskPersistentVolumeCachingMode")
class AzureDiskPersistentVolumeCachingMode(enum.Enum):
    '''Azure disk caching modes.'''

    NONE = "NONE"
    '''None.'''
    READ_ONLY = "READ_ONLY"
    '''ReadOnly.'''
    READ_WRITE = "READ_WRITE"
    '''ReadWrite.'''


@jsii.enum(jsii_type="cdk8s-plus-28.AzureDiskPersistentVolumeKind")
class AzureDiskPersistentVolumeKind(enum.Enum):
    '''Azure Disk kinds.'''

    SHARED = "SHARED"
    '''Multiple blob disks per storage account.'''
    DEDICATED = "DEDICATED"
    '''Single blob disk per storage account.'''
    MANAGED = "MANAGED"
    '''Azure managed data disk.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AzureDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "name": "name",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeOptions:
    def __init__(
        self,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAzureDisk``.

        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96029f50f86c511f1e55a1eac9146f23df2e1e67ba2ed467cfa90d5216a18c8d)
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.Capability")
class Capability(enum.Enum):
    '''Capability - complete list of POSIX capabilities.'''

    ALL = "ALL"
    '''ALL.'''
    AUDIT_CONTROL = "AUDIT_CONTROL"
    '''CAP_AUDIT_CONTROL.'''
    AUDIT_READ = "AUDIT_READ"
    '''CAP_AUDIT_READ.'''
    AUDIT_WRITE = "AUDIT_WRITE"
    '''CAP_AUDIT_WRITE.'''
    BLOCK_SUSPEND = "BLOCK_SUSPEND"
    '''CAP_BLOCK_SUSPEND.'''
    BPF = "BPF"
    '''CAP_BPF.'''
    CHECKPOINT_RESTORE = "CHECKPOINT_RESTORE"
    '''CAP_CHECKPOINT_RESTORE.'''
    CHOWN = "CHOWN"
    '''CAP_CHOWN.'''
    DAC_OVERRIDE = "DAC_OVERRIDE"
    '''CAP_DAC_OVERRIDE.'''
    DAC_READ_SEARCH = "DAC_READ_SEARCH"
    '''CAP_DAC_READ_SEARCH.'''
    FOWNER = "FOWNER"
    '''CAP_FOWNER.'''
    FSETID = "FSETID"
    '''CAP_FSETID.'''
    IPC_LOCK = "IPC_LOCK"
    '''CAP_IPC_LOCK.'''
    IPC_OWNER = "IPC_OWNER"
    '''CAP_IPC_OWNER.'''
    KILL = "KILL"
    '''CAP_KILL.'''
    LEASE = "LEASE"
    '''CAP_LEASE.'''
    LINUX_IMMUTABLE = "LINUX_IMMUTABLE"
    '''CAP_LINUX_IMMUTABLE.'''
    MAC_ADMIN = "MAC_ADMIN"
    '''CAP_MAC_ADMIN.'''
    MAC_OVERRIDE = "MAC_OVERRIDE"
    '''CAP_MAC_OVERRIDE.'''
    MKNOD = "MKNOD"
    '''CAP_MKNOD.'''
    NET_ADMIN = "NET_ADMIN"
    '''CAP_NET_ADMIN.'''
    NET_BIND_SERVICE = "NET_BIND_SERVICE"
    '''CAP_NET_BIND_SERVICE.'''
    NET_BROADCAST = "NET_BROADCAST"
    '''CAP_NET_BROADCAST.'''
    NET_RAW = "NET_RAW"
    '''CAP_NET_RAW.'''
    PERFMON = "PERFMON"
    '''CAP_PERFMON.'''
    SETGID = "SETGID"
    '''CAP_SETGID.'''
    SETFCAP = "SETFCAP"
    '''CAP_SETFCAP.'''
    SETPCAP = "SETPCAP"
    '''CAP_SETPCAP.'''
    SETUID = "SETUID"
    '''CAP_SETUID.'''
    SYS_ADMIN = "SYS_ADMIN"
    '''CAP_SYS_ADMIN.'''
    SYS_BOOT = "SYS_BOOT"
    '''CAP_SYS_BOOT.'''
    SYS_CHROOT = "SYS_CHROOT"
    '''CAP_SYS_CHROOT.'''
    SYS_MODULE = "SYS_MODULE"
    '''CAP_SYS_MODULE.'''
    SYS_NICE = "SYS_NICE"
    '''CAP_SYS_NICE.'''
    SYS_PACCT = "SYS_PACCT"
    '''CAP_SYS_PACCT.'''
    SYS_PTRACE = "SYS_PTRACE"
    '''CAP_SYS_PTRACE.'''
    SYS_RAWIO = "SYS_RAWIO"
    '''CAP_SYS_RAWIO.'''
    SYS_RESOURCE = "SYS_RESOURCE"
    '''CAP_SYS_RESOURCE.'''
    SYS_TIME = "SYS_TIME"
    '''CAP_SYS_TIME.'''
    SYS_TTY_CONFIG = "SYS_TTY_CONFIG"
    '''CAP_SYS_TTY_CONFIG.'''
    SYSLOG = "SYSLOG"
    '''CAP_SYSLOG.'''
    WAKE_ALARM = "WAKE_ALARM"
    '''CAP_WAKE_ALARM.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ClusterRolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "verbs": "verbs"},
)
class ClusterRolePolicyRule:
    def __init__(
        self,
        *,
        endpoints: typing.Sequence["IApiEndpoint"],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `ClusterRole.

        :param endpoints: Endpoints this rule applies to. Can be either api resources or non api resources.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__509905cd7f510cbe7a85eb5dcddc0f9df9b3f86e0ab6eb890342da99440e3859)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "verbs": verbs,
        }

    @builtins.property
    def endpoints(self) -> typing.List["IApiEndpoint"]:
        '''Endpoints this rule applies to.

        Can be either api resources
        or non api resources.
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List["IApiEndpoint"], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.ConcurrencyPolicy")
class ConcurrencyPolicy(enum.Enum):
    '''Concurrency policy for CronJobs.'''

    ALLOW = "ALLOW"
    '''This policy allows to run job concurrently.'''
    FORBID = "FORBID"
    '''This policy does not allow to run job concurrently.

    It does not let a new job to be scheduled if the previous one is not finished yet.
    '''
    REPLACE = "REPLACE"
    '''This policy replaces the currently running job if a new job is being scheduled.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ConfigMapVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union["PathMapping", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the ConfigMap-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15a1b9a702efe6ef252bb914d7f55baeff59da960f9df9af75bf44baa5a140b5)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, "PathMapping"]]:
        '''If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the ConfigMap, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "PathMapping"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.ConnectionScheme")
class ConnectionScheme(enum.Enum):
    HTTP = "HTTP"
    '''Use HTTP request for connecting to host.'''
    HTTPS = "HTTPS"
    '''Use HTTPS request for connecting to host.'''


class Container(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Container"):
    '''A single application container that you want to run within a pod.'''

    def __init__(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union["ContainerLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional["ContainerRestartPolicy"] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param restart_policy: Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always. Default: - no restart policy is defined and the pod restart policy is applied
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        props = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            restart_policy=restart_policy,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addPort")
    def add_port(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Add a port to expose from this container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        port = ContainerPort(
            number=number,
            host_ip=host_ip,
            host_port=host_port,
            name=name,
            protocol=protocol,
        )

        return typing.cast(None, jsii.invoke(self, "addPort", [port]))

    @jsii.member(jsii_name="mount")
    def mount(
        self,
        path: builtins.str,
        storage: "IStorage",
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Mount a volume to a specific path so that it is accessible by the container.

        Every pod that is configured to use this container will autmoatically have access to the volume.

        :param path: - The desired path in the container.
        :param storage: - The storage to mount.
        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f9a27b760c0464a2e60792a1f43799c0fa7e262f0195943d9da4d2057d5fb1f)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
        options = MountOptions(
            propagation=propagation,
            read_only=read_only,
            sub_path=sub_path,
            sub_path_expr=sub_path_expr,
        )

        return typing.cast(None, jsii.invoke(self, "mount", [path, storage, options]))

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> "Env":
        '''The environment of the container.'''
        return typing.cast("Env", jsii.get(self, "env"))

    @builtins.property
    @jsii.member(jsii_name="image")
    def image(self) -> builtins.str:
        '''The container image.'''
        return typing.cast(builtins.str, jsii.get(self, "image"))

    @builtins.property
    @jsii.member(jsii_name="imagePullPolicy")
    def image_pull_policy(self) -> "ImagePullPolicy":
        '''Image pull policy for this container.'''
        return typing.cast("ImagePullPolicy", jsii.get(self, "imagePullPolicy"))

    @builtins.property
    @jsii.member(jsii_name="mounts")
    def mounts(self) -> typing.List["VolumeMount"]:
        '''Volume mounts configured for this container.'''
        return typing.cast(typing.List["VolumeMount"], jsii.get(self, "mounts"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of the container.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ContainerPort"]:
        '''Ports exposed by this containers.

        Returns a copy, use ``addPort`` to modify.
        '''
        return typing.cast(typing.List["ContainerPort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> "ContainerSecurityContext":
        '''The security context of the container.'''
        return typing.cast("ContainerSecurityContext", jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="args")
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        :return: a copy of the arguments array, cannot be modified.
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "args"))

    @builtins.property
    @jsii.member(jsii_name="command")
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array (the command to execute when the container starts).

        :return: a copy of the entrypoint array, cannot be modified
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "command"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="portNumber")
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''The port number that was configured for this container.

        If undefined, either the container doesn't expose a port, or its
        port configuration is stored in the ``ports`` field.
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "portNumber"))

    @builtins.property
    @jsii.member(jsii_name="resources")
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        return typing.cast(typing.Optional["ContainerResources"], jsii.get(self, "resources"))

    @builtins.property
    @jsii.member(jsii_name="restartPolicy")
    def restart_policy(self) -> typing.Optional["ContainerRestartPolicy"]:
        '''The restart policy of the container.'''
        return typing.cast(typing.Optional["ContainerRestartPolicy"], jsii.get(self, "restartPolicy"))

    @builtins.property
    @jsii.member(jsii_name="workingDir")
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''The working directory inside the container.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "workingDir"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerLifecycle",
    jsii_struct_bases=[],
    name_mapping={"post_start": "postStart", "pre_stop": "preStop"},
)
class ContainerLifecycle:
    def __init__(
        self,
        *,
        post_start: typing.Optional["Handler"] = None,
        pre_stop: typing.Optional["Handler"] = None,
    ) -> None:
        '''Container lifecycle properties.

        :param post_start: This hook is executed immediately after a container is created. However, there is no guarantee that the hook will execute before the container ENTRYPOINT. Default: - No post start handler.
        :param pre_stop: This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others. A call to the PreStop hook fails if the container is already in a terminated or completed state and the hook must complete before the TERM signal to stop the container can be sent. The Pod's termination grace period countdown begins before the PreStop hook is executed, so regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. No parameters are passed to the handler. Default: - No pre stop handler.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0b29f92267aef7b5d7af1c90a78d326ec5f280fd79fc6ec689fc6f772199a43)
            check_type(argname="argument post_start", value=post_start, expected_type=type_hints["post_start"])
            check_type(argname="argument pre_stop", value=pre_stop, expected_type=type_hints["pre_stop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if post_start is not None:
            self._values["post_start"] = post_start
        if pre_stop is not None:
            self._values["pre_stop"] = pre_stop

    @builtins.property
    def post_start(self) -> typing.Optional["Handler"]:
        '''This hook is executed immediately after a container is created.

        However,
        there is no guarantee that the hook will execute before the container ENTRYPOINT.

        :default: - No post start handler.
        '''
        result = self._values.get("post_start")
        return typing.cast(typing.Optional["Handler"], result)

    @builtins.property
    def pre_stop(self) -> typing.Optional["Handler"]:
        '''This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others.

        A call to the PreStop hook fails if the container is already in a terminated or completed state
        and the hook must complete before the TERM signal to stop the container can be sent.
        The Pod's termination grace period countdown begins before the PreStop hook is executed,
        so regardless of the outcome of the handler, the container will eventually terminate
        within the Pod's termination grace period. No parameters are passed to the handler.

        :default: - No pre stop handler.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-termination
        '''
        result = self._values.get("pre_stop")
        return typing.cast(typing.Optional["Handler"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerLifecycle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerOpts",
    jsii_struct_bases=[],
    name_mapping={
        "args": "args",
        "command": "command",
        "env_from": "envFrom",
        "env_variables": "envVariables",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness": "liveness",
        "name": "name",
        "port": "port",
        "port_number": "portNumber",
        "ports": "ports",
        "readiness": "readiness",
        "resources": "resources",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "startup": "startup",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class ContainerOpts:
    def __init__(
        self,
        *,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional["ContainerRestartPolicy"] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Optional properties of a container.

        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param restart_policy: Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always. Default: - no restart policy is defined and the pod restart policy is applied
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = ContainerLifecycle(**lifecycle)
        if isinstance(resources, dict):
            resources = ContainerResources(**resources)
        if isinstance(security_context, dict):
            security_context = ContainerSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e9fd66602cf4c9c375c47c740bd831b3b1a4f98c8fa7c11b518596fb6f254a5)
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument env_variables", value=env_variables, expected_type=type_hints["env_variables"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness", value=liveness, expected_type=type_hints["liveness"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument port_number", value=port_number, expected_type=type_hints["port_number"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness", value=readiness, expected_type=type_hints["readiness"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup", value=startup, expected_type=type_hints["startup"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env_from is not None:
            self._values["env_from"] = env_from
        if env_variables is not None:
            self._values["env_variables"] = env_variables
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness is not None:
            self._values["liveness"] = liveness
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if port_number is not None:
            self._values["port_number"] = port_number
        if ports is not None:
            self._values["ports"] = ports
        if readiness is not None:
            self._values["readiness"] = readiness
        if resources is not None:
            self._values["resources"] = resources
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup is not None:
            self._values["startup"] = startup
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided.

        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.

        Cannot be updated.

        :default: []

        :see: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
        Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :default: - The docker image's ENTRYPOINT.
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFrom"]]:
        '''List of sources to populate environment variables in the container.

        When a key exists in multiple sources, the value associated with
        the last source will take precedence. Values defined by the ``envVariables`` property
        with a duplicate key will take precedence.

        :default: - No sources.
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFrom"]], result)

    @builtins.property
    def env_variables(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "EnvValue"]]:
        '''Environment variables to set in the container.

        :default: - No environment variables.
        '''
        result = self._values.get("env_variables")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "EnvValue"]], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional["ImagePullPolicy"]:
        '''Image pull policy for this container.

        :default: ImagePullPolicy.ALWAYS
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional["ImagePullPolicy"], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[ContainerLifecycle]:
        '''Describes actions that the management system should take in response to container lifecycle events.'''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[ContainerLifecycle], result)

    @builtins.property
    def liveness(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails.

        :default: - no liveness probe is defined
        '''
        result = self._values.get("liveness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :default: 'main'
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        This is a convinience property if all you need a single TCP numbered port.
        In case more advanced configuartion is required, use the ``ports`` property.

        This port is added to the list of ports mentioned in the ``ports`` property.

        :default: - Only the ports mentiond in the ``ports`` property are exposed.
        '''
        result = self._values.get("port_number")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ContainerPort"]]:
        '''List of ports to expose from this container.

        :default: - Only the port mentioned in the ``portNumber`` property is exposed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ContainerPort"]], result)

    @builtins.property
    def readiness(self) -> typing.Optional["Probe"]:
        '''Determines when the container is ready to serve traffic.

        :default: - no readiness probe is defined
        '''
        result = self._values.get("readiness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :default:

        cpu:
        request: 1000 millis
        limit: 1500 millis
        memory:
        request: 512 mebibytes
        limit: 2048 mebibytes

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ContainerResources"], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional["ContainerRestartPolicy"]:
        '''Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always.

        :default: - no restart policy is defined and the pod restart policy is applied

        :see: https://kubernetes.io/docs/concepts/workloads/pods/sidecar-containers/
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional["ContainerRestartPolicy"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["ContainerSecurityContextProps"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields override equivalent fields of the pod's security context.

        :default:

        ensureNonRoot: true
        privileged: false
        readOnlyRootFilesystem: true
        allowPrivilegeEscalation: false
        user: 25000
        group: 26000

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["ContainerSecurityContextProps"], result)

    @builtins.property
    def startup(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully

        :default:

        - If a port is provided, then knocks on that port
        to determine when the container is ready for readiness and
        liveness probe checks.
        Otherwise, no startup probe is defined.
        '''
        result = self._values.get("startup")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :default: - The container runtime's default.
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerOpts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "number": "number",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Represents a network port in a single container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f5648be012391ac53d6682a81ebc254ea286ea6157125d9afd43f9288d48c88)
            check_type(argname="argument number", value=number, expected_type=type_hints["number"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "number": number,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def number(self) -> jsii.Number:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.
        '''
        result = self._values.get("number")
        assert result is not None, "Required property 'number' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''What host IP to bind the external port to.

        :default: - 127.0.0.1.
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536.
        Most containers do not need this.

        :default: - auto generated by kubernetes and might change on restarts.
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name.
        Name for the port that can be referred to by services.

        :default: - port is not named.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional["Protocol"]:
        '''Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["Protocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerProps",
    jsii_struct_bases=[ContainerOpts],
    name_mapping={
        "args": "args",
        "command": "command",
        "env_from": "envFrom",
        "env_variables": "envVariables",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness": "liveness",
        "name": "name",
        "port": "port",
        "port_number": "portNumber",
        "ports": "ports",
        "readiness": "readiness",
        "resources": "resources",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "startup": "startup",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
        "image": "image",
    },
)
class ContainerProps(ContainerOpts):
    def __init__(
        self,
        *,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional["ContainerRestartPolicy"] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
        image: builtins.str,
    ) -> None:
        '''Properties for creating a container.

        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param restart_policy: Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always. Default: - no restart policy is defined and the pod restart policy is applied
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        :param image: Docker image name.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = ContainerLifecycle(**lifecycle)
        if isinstance(resources, dict):
            resources = ContainerResources(**resources)
        if isinstance(security_context, dict):
            security_context = ContainerSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7313903999d2253e1959c59ad5a0726c7685db45623f31da461de216479c7aa)
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument env_variables", value=env_variables, expected_type=type_hints["env_variables"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness", value=liveness, expected_type=type_hints["liveness"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument port_number", value=port_number, expected_type=type_hints["port_number"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness", value=readiness, expected_type=type_hints["readiness"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup", value=startup, expected_type=type_hints["startup"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image": image,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env_from is not None:
            self._values["env_from"] = env_from
        if env_variables is not None:
            self._values["env_variables"] = env_variables
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness is not None:
            self._values["liveness"] = liveness
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if port_number is not None:
            self._values["port_number"] = port_number
        if ports is not None:
            self._values["ports"] = ports
        if readiness is not None:
            self._values["readiness"] = readiness
        if resources is not None:
            self._values["resources"] = resources
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup is not None:
            self._values["startup"] = startup
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided.

        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.

        Cannot be updated.

        :default: []

        :see: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
        Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :default: - The docker image's ENTRYPOINT.
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFrom"]]:
        '''List of sources to populate environment variables in the container.

        When a key exists in multiple sources, the value associated with
        the last source will take precedence. Values defined by the ``envVariables`` property
        with a duplicate key will take precedence.

        :default: - No sources.
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFrom"]], result)

    @builtins.property
    def env_variables(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "EnvValue"]]:
        '''Environment variables to set in the container.

        :default: - No environment variables.
        '''
        result = self._values.get("env_variables")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "EnvValue"]], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional["ImagePullPolicy"]:
        '''Image pull policy for this container.

        :default: ImagePullPolicy.ALWAYS
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional["ImagePullPolicy"], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[ContainerLifecycle]:
        '''Describes actions that the management system should take in response to container lifecycle events.'''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[ContainerLifecycle], result)

    @builtins.property
    def liveness(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails.

        :default: - no liveness probe is defined
        '''
        result = self._values.get("liveness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :default: 'main'
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        This is a convinience property if all you need a single TCP numbered port.
        In case more advanced configuartion is required, use the ``ports`` property.

        This port is added to the list of ports mentioned in the ``ports`` property.

        :default: - Only the ports mentiond in the ``ports`` property are exposed.
        '''
        result = self._values.get("port_number")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ContainerPort]]:
        '''List of ports to expose from this container.

        :default: - Only the port mentioned in the ``portNumber`` property is exposed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ContainerPort]], result)

    @builtins.property
    def readiness(self) -> typing.Optional["Probe"]:
        '''Determines when the container is ready to serve traffic.

        :default: - no readiness probe is defined
        '''
        result = self._values.get("readiness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :default:

        cpu:
        request: 1000 millis
        limit: 1500 millis
        memory:
        request: 512 mebibytes
        limit: 2048 mebibytes

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ContainerResources"], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional["ContainerRestartPolicy"]:
        '''Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always.

        :default: - no restart policy is defined and the pod restart policy is applied

        :see: https://kubernetes.io/docs/concepts/workloads/pods/sidecar-containers/
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional["ContainerRestartPolicy"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["ContainerSecurityContextProps"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields override equivalent fields of the pod's security context.

        :default:

        ensureNonRoot: true
        privileged: false
        readOnlyRootFilesystem: true
        allowPrivilegeEscalation: false
        user: 25000
        group: 26000

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["ContainerSecurityContextProps"], result)

    @builtins.property
    def startup(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully

        :default:

        - If a port is provided, then knocks on that port
        to determine when the container is ready for readiness and
        liveness probe checks.
        Otherwise, no startup probe is defined.
        '''
        result = self._values.get("startup")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :default: - The container runtime's default.
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image(self) -> builtins.str:
        '''Docker image name.'''
        result = self._values.get("image")
        assert result is not None, "Required property 'image' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerResources",
    jsii_struct_bases=[],
    name_mapping={
        "cpu": "cpu",
        "ephemeral_storage": "ephemeralStorage",
        "memory": "memory",
    },
)
class ContainerResources:
    def __init__(
        self,
        *,
        cpu: typing.Optional[typing.Union["CpuResources", typing.Dict[builtins.str, typing.Any]]] = None,
        ephemeral_storage: typing.Optional[typing.Union["EphemeralStorageResources", typing.Dict[builtins.str, typing.Any]]] = None,
        memory: typing.Optional[typing.Union["MemoryResources", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CPU and memory compute resources.

        :param cpu: 
        :param ephemeral_storage: 
        :param memory: 
        '''
        if isinstance(cpu, dict):
            cpu = CpuResources(**cpu)
        if isinstance(ephemeral_storage, dict):
            ephemeral_storage = EphemeralStorageResources(**ephemeral_storage)
        if isinstance(memory, dict):
            memory = MemoryResources(**memory)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce7fa14e889e1fe1e907e645ad8dd844926ca88298c03ea44e17af23673f49fd)
            check_type(argname="argument cpu", value=cpu, expected_type=type_hints["cpu"])
            check_type(argname="argument ephemeral_storage", value=ephemeral_storage, expected_type=type_hints["ephemeral_storage"])
            check_type(argname="argument memory", value=memory, expected_type=type_hints["memory"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cpu is not None:
            self._values["cpu"] = cpu
        if ephemeral_storage is not None:
            self._values["ephemeral_storage"] = ephemeral_storage
        if memory is not None:
            self._values["memory"] = memory

    @builtins.property
    def cpu(self) -> typing.Optional["CpuResources"]:
        result = self._values.get("cpu")
        return typing.cast(typing.Optional["CpuResources"], result)

    @builtins.property
    def ephemeral_storage(self) -> typing.Optional["EphemeralStorageResources"]:
        result = self._values.get("ephemeral_storage")
        return typing.cast(typing.Optional["EphemeralStorageResources"], result)

    @builtins.property
    def memory(self) -> typing.Optional["MemoryResources"]:
        result = self._values.get("memory")
        return typing.cast(typing.Optional["MemoryResources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.ContainerRestartPolicy")
class ContainerRestartPolicy(enum.Enum):
    '''RestartPolicy defines the restart behavior of individual containers in a pod.

    This field may only be set for init containers, and the only allowed value is "Always".
    For non-init containers or when this field is not specified,
    the restart behavior is defined by the Pod's restart policy and the container type.
    Setting the RestartPolicy as "Always" for the init container will have the following effect:
    this init container will be continually restarted on exit until all regular containers have terminated.
    Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down.
    This lifecycle differs from normal init containers and is often referred to as a "sidecar" container.

    :see: https://kubernetes.io/docs/concepts/workloads/pods/sidecar-containers/
    '''

    ALWAYS = "ALWAYS"
    '''If an init container is created with its restartPolicy set to Always, it will start and remain running during the entire life of the Pod.

    For regular containers, this is ignored by Kubernetes.
    '''


class ContainerSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ContainerSecurityContext",
):
    '''Container security attributes and settings.'''

    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        capabilities: typing.Optional[typing.Union["ContainerSecutiryContextCapabilities", typing.Dict[builtins.str, typing.Any]]] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param capabilities: POSIX capabilities for running containers. Default: none
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        props = ContainerSecurityContextProps(
            allow_privilege_escalation=allow_privilege_escalation,
            capabilities=capabilities,
            ensure_non_root=ensure_non_root,
            group=group,
            privileged=privileged,
            read_only_root_filesystem=read_only_root_filesystem,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="privileged")
    def privileged(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "privileged"))

    @builtins.property
    @jsii.member(jsii_name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "readOnlyRootFilesystem"))

    @builtins.property
    @jsii.member(jsii_name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "allowPrivilegeEscalation"))

    @builtins.property
    @jsii.member(jsii_name="capabilities")
    def capabilities(self) -> typing.Optional["ContainerSecutiryContextCapabilities"]:
        return typing.cast(typing.Optional["ContainerSecutiryContextCapabilities"], jsii.get(self, "capabilities"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "allow_privilege_escalation": "allowPrivilegeEscalation",
        "capabilities": "capabilities",
        "ensure_non_root": "ensureNonRoot",
        "group": "group",
        "privileged": "privileged",
        "read_only_root_filesystem": "readOnlyRootFilesystem",
        "user": "user",
    },
)
class ContainerSecurityContextProps:
    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        capabilities: typing.Optional[typing.Union["ContainerSecutiryContextCapabilities", typing.Dict[builtins.str, typing.Any]]] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``ContainerSecurityContext``.

        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param capabilities: POSIX capabilities for running containers. Default: none
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        if isinstance(capabilities, dict):
            capabilities = ContainerSecutiryContextCapabilities(**capabilities)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e0d418ae7f772e2db7baa913596b1009c39755af3976d282ea3176cb04122b9)
            check_type(argname="argument allow_privilege_escalation", value=allow_privilege_escalation, expected_type=type_hints["allow_privilege_escalation"])
            check_type(argname="argument capabilities", value=capabilities, expected_type=type_hints["capabilities"])
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument privileged", value=privileged, expected_type=type_hints["privileged"])
            check_type(argname="argument read_only_root_filesystem", value=read_only_root_filesystem, expected_type=type_hints["read_only_root_filesystem"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if allow_privilege_escalation is not None:
            self._values["allow_privilege_escalation"] = allow_privilege_escalation
        if capabilities is not None:
            self._values["capabilities"] = capabilities
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if group is not None:
            self._values["group"] = group
        if privileged is not None:
            self._values["privileged"] = privileged
        if read_only_root_filesystem is not None:
            self._values["read_only_root_filesystem"] = read_only_root_filesystem
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        '''Whether a process can gain more privileges than its parent process.

        :default: false
        '''
        result = self._values.get("allow_privilege_escalation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def capabilities(self) -> typing.Optional["ContainerSecutiryContextCapabilities"]:
        '''POSIX capabilities for running containers.

        :default: none
        '''
        result = self._values.get("capabilities")
        return typing.cast(typing.Optional["ContainerSecutiryContextCapabilities"], result)

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default:

        -
        26000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def privileged(self) -> typing.Optional[builtins.bool]:
        '''Run container in privileged mode.

        Processes in privileged containers are essentially equivalent to root on the host.

        :default: false
        '''
        result = self._values.get("privileged")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def read_only_root_filesystem(self) -> typing.Optional[builtins.bool]:
        '''Whether this container has a read-only root filesystem.

        :default: true
        '''
        result = self._values.get("read_only_root_filesystem")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default:

        -
        25000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ContainerSecutiryContextCapabilities",
    jsii_struct_bases=[],
    name_mapping={"add": "add", "drop": "drop"},
)
class ContainerSecutiryContextCapabilities:
    def __init__(
        self,
        *,
        add: typing.Optional[typing.Sequence[Capability]] = None,
        drop: typing.Optional[typing.Sequence[Capability]] = None,
    ) -> None:
        '''
        :param add: Added capabilities.
        :param drop: Removed capabilities.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c1f562584c9ed43805796271abbb101d11195200042651a5d0ed6e159ec4297)
            check_type(argname="argument add", value=add, expected_type=type_hints["add"])
            check_type(argname="argument drop", value=drop, expected_type=type_hints["drop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if add is not None:
            self._values["add"] = add
        if drop is not None:
            self._values["drop"] = drop

    @builtins.property
    def add(self) -> typing.Optional[typing.List[Capability]]:
        '''Added capabilities.'''
        result = self._values.get("add")
        return typing.cast(typing.Optional[typing.List[Capability]], result)

    @builtins.property
    def drop(self) -> typing.Optional[typing.List[Capability]]:
        '''Removed capabilities.'''
        result = self._values.get("drop")
        return typing.cast(typing.Optional[typing.List[Capability]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerSecutiryContextCapabilities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Cpu(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Cpu"):
    '''Represents the amount of CPU.

    The amount can be passed as millis or units.
    '''

    @jsii.member(jsii_name="millis")
    @builtins.classmethod
    def millis(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__669bac4cf4c565a9ed4eb513496678fdaccb81887d1d1cf2b7aa0e007c46b6a7)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "millis", [amount]))

    @jsii.member(jsii_name="units")
    @builtins.classmethod
    def units(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__561d8a706134949048c21fd61950f2ce54c9246421c4d483254be027ad2a64f5)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "units", [amount]))

    @builtins.property
    @jsii.member(jsii_name="amount")
    def amount(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "amount"))

    @amount.setter
    def amount(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c02c9902622943f95cf64c9f8e9f9f278e625cec9c8787fd7e170b6343dad67b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "amount", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-28.CpuResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class CpuResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[Cpu] = None,
        request: typing.Optional[Cpu] = None,
    ) -> None:
        '''CPU request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31d9c95b7d50beee6381edeed727523b17d6cd8dd38fd2becff35bcf37272c26)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[Cpu]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[Cpu], result)

    @builtins.property
    def request(self) -> typing.Optional[Cpu]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[Cpu], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CpuResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.CsiVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "attributes": "attributes",
        "fs_type": "fsType",
        "name": "name",
        "read_only": "readOnly",
    },
)
class CsiVolumeOptions:
    def __init__(
        self,
        *,
        attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the CSI driver based volume.

        :param attributes: Any driver-specific attributes to pass to the CSI volume builder. Default: - undefined
        :param fs_type: The filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver, which will determine the default filesystem to apply. Default: - driver-dependent
        :param name: The volume name. Default: - auto-generated
        :param read_only: Whether the mounted volume should be read-only or not. Default: - false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6941c600c85f94ba718ec614f3f3af4048261c02f15cfa4aaa8522b80b997c87)
            check_type(argname="argument attributes", value=attributes, expected_type=type_hints["attributes"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if attributes is not None:
            self._values["attributes"] = attributes
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def attributes(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Any driver-specific attributes to pass to the CSI volume builder.

        :default: - undefined
        '''
        result = self._values.get("attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''The filesystem type to mount.

        Ex. "ext4", "xfs", "ntfs". If not provided,
        the empty value is passed to the associated CSI driver, which will
        determine the default filesystem to apply.

        :default: - driver-dependent
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Whether the mounted volume should be read-only or not.

        :default: - false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DeploymentExposeViaServiceOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "ports": "ports", "service_type": "serviceType"},
)
class DeploymentExposeViaServiceOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Options for ``Deployment.exposeViaService``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7e8320cb8b45e9d7425b7213f8e532d9fe228323225ac4c42abfb2ddb74bec3)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ServicePort"]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ServicePort"]], result)

    @builtins.property
    def service_type(self) -> typing.Optional["ServiceType"]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentExposeViaServiceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DeploymentStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.DeploymentStrategy",
):
    '''Deployment strategies.'''

    @jsii.member(jsii_name="recreate")
    @builtins.classmethod
    def recreate(cls) -> "DeploymentStrategy":
        '''All existing Pods are killed before new ones are created.

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#recreate-deployment
        '''
        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "recreate", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> "DeploymentStrategy":
        '''
        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        options = DeploymentStrategyRollingUpdateOptions(
            max_surge=max_surge, max_unavailable=max_unavailable
        )

        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DeploymentStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"max_surge": "maxSurge", "max_unavailable": "maxUnavailable"},
)
class DeploymentStrategyRollingUpdateOptions:
    def __init__(
        self,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> None:
        '''Options for ``DeploymentStrategy.rollingUpdate``.

        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ccf50a46c9720adbcffb1fe1ba7ef2d7189b13c56d4c6c2b3353227470a234b6)
            check_type(argname="argument max_surge", value=max_surge, expected_type=type_hints["max_surge"])
            check_type(argname="argument max_unavailable", value=max_unavailable, expected_type=type_hints["max_unavailable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if max_surge is not None:
            self._values["max_surge"] = max_surge
        if max_unavailable is not None:
            self._values["max_unavailable"] = max_unavailable

    @builtins.property
    def max_surge(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be scheduled above the desired number of pods.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding up.
        This can not be 0 if ``maxUnavailable`` is 0.

        Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update
        starts, such that the total number of old and new pods do not exceed 130% of desired pods.
        Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that
        total number of pods running at any time during the update is at most 130% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_surge")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    @builtins.property
    def max_unavailable(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be unavailable during the update.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding down.
        This can not be 0 if ``maxSurge`` is 0.

        Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired
        pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can
        be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total
        number of pods available at all times during the update is at least 70% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_unavailable")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DnsOption",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class DnsOption:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Custom DNS option.

        :param name: Option name.
        :param value: Option value. Default: - No value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__860536cbfb1a35c167d1218f2ca0ca84678b91b4d5dbaf521f74ff6c953c8336)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Option name.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Option value.

        :default: - No value.
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DnsOption(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.DnsPolicy")
class DnsPolicy(enum.Enum):
    '''Pod DNS policies.'''

    CLUSTER_FIRST = "CLUSTER_FIRST"
    '''Any DNS query that does not match the configured cluster domain suffix, such as "www.kubernetes.io", is forwarded to the upstream nameserver inherited from the node. Cluster administrators may have extra stub-domain and upstream DNS servers configured.'''
    CLUSTER_FIRST_WITH_HOST_NET = "CLUSTER_FIRST_WITH_HOST_NET"
    '''For Pods running with hostNetwork, you should explicitly set its DNS policy "ClusterFirstWithHostNet".'''
    DEFAULT = "DEFAULT"
    '''The Pod inherits the name resolution configuration from the node that the pods run on.'''
    NONE = "NONE"
    '''It allows a Pod to ignore DNS settings from the Kubernetes environment.

    All DNS settings are supposed to be provided using the dnsConfig
    field in the Pod Spec.
    '''


@jsii.enum(jsii_type="cdk8s-plus-28.EmptyDirMedium")
class EmptyDirMedium(enum.Enum):
    '''The medium on which to store the volume.'''

    DEFAULT = "DEFAULT"
    '''The default volume of the backing node.'''
    MEMORY = "MEMORY"
    '''Mount a tmpfs (RAM-backed filesystem) for you instead.

    While tmpfs is very
    fast, be aware that unlike disks, tmpfs is cleared on node reboot and any
    files you write will count against your Container's memory limit.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EmptyDirVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeOptions:
    def __init__(
        self,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Options for volumes populated with an empty directory.

        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f91342160b7b0e4343a6389ec7d787ff90bac8fb846b48d95907fe21f95f640)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[EmptyDirMedium]:
        '''By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment.

        However, you can set the emptyDir.medium field to
        ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed
        filesystem) for you instead. While tmpfs is very fast, be aware that unlike
        disks, tmpfs is cleared on node reboot and any files you write will count
        against your Container's memory limit.

        :default: EmptyDirMedium.DEFAULT
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[EmptyDirMedium], result)

    @builtins.property
    def size_limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Total amount of local storage required for this EmptyDir volume.

        The size
        limit is also applicable for memory medium. The maximum usage on memory
        medium EmptyDir would be the minimum value between the SizeLimit specified
        here and the sum of memory limits of all containers in a pod.

        :default: - limit is undefined
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Env(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Env"):
    '''Container environment variables.'''

    def __init__(
        self,
        sources: typing.Sequence["EnvFrom"],
        variables: typing.Mapping[builtins.str, "EnvValue"],
    ) -> None:
        '''
        :param sources: -
        :param variables: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2640bf216d4523143c85520f025efb7ae69aa784e2215693148e34d59d3686fe)
            check_type(argname="argument sources", value=sources, expected_type=type_hints["sources"])
            check_type(argname="argument variables", value=variables, expected_type=type_hints["variables"])
        jsii.create(self.__class__, self, [sources, variables])

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        prefix: typing.Optional[builtins.str] = None,
    ) -> "EnvFrom":
        '''Selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent
        the key-value pairs as environment variables.

        :param config_map: -
        :param prefix: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cabf653a52888c0eda3d7495d411d08280e39e456c611f2472bcb9c44a89d225)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromConfigMap", [config_map, prefix]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(cls, secr: "ISecret") -> "EnvFrom":
        '''Selects a Secret to populate the environment variables with.

        The contents of the target Secret's Data field will represent
        the key-value pairs as environment variables.

        :param secr: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d68d970ba9d6d1323aa609f2fce18ae149ae070d5e0d3fb00a8e283c3883bcba)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromSecret", [secr]))

    @jsii.member(jsii_name="addVariable")
    def add_variable(self, name: builtins.str, value: "EnvValue") -> None:
        '''Add a single variable by name and value.

        The variable value can come from various dynamic sources such a secrets of config maps.
        Use ``EnvValue.fromXXX`` to select sources.

        :param name: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__541404bc677a8b6e41089d7ea739bce4fafd627694d33dfbdbefa989bf1852b7)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addVariable", [name, value]))

    @jsii.member(jsii_name="copyFrom")
    def copy_from(self, from_: "EnvFrom") -> None:
        '''Add a collection of variables by copying from another source.

        Use ``Env.fromXXX`` functions to select sources.

        :param from_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ab44fbe3cff22e53ac6af3b242eca1537bd08afd263dc5821ef383fc64d3549)
            check_type(argname="argument from_", value=from_, expected_type=type_hints["from_"])
        return typing.cast(None, jsii.invoke(self, "copyFrom", [from_]))

    @builtins.property
    @jsii.member(jsii_name="sources")
    def sources(self) -> typing.List["EnvFrom"]:
        '''The list of sources used to populate the container environment, in addition to the ``variables``.

        Returns a copy. To add a source use ``container.env.copyFrom()``.
        '''
        return typing.cast(typing.List["EnvFrom"], jsii.get(self, "sources"))

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Mapping[builtins.str, "EnvValue"]:
        '''The environment variables for this container.

        Returns a copy. To add environment variables use ``container.env.addVariable()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, "EnvValue"], jsii.get(self, "variables"))


@jsii.enum(jsii_type="cdk8s-plus-28.EnvFieldPaths")
class EnvFieldPaths(enum.Enum):
    POD_NAME = "POD_NAME"
    '''The name of the pod.'''
    POD_NAMESPACE = "POD_NAMESPACE"
    '''The namespace of the pod.'''
    POD_UID = "POD_UID"
    '''The uid of the pod.'''
    POD_LABEL = "POD_LABEL"
    '''The labels of the pod.'''
    POD_ANNOTATION = "POD_ANNOTATION"
    '''The annotations of the pod.'''
    POD_IP = "POD_IP"
    '''The ipAddress of the pod.'''
    SERVICE_ACCOUNT_NAME = "SERVICE_ACCOUNT_NAME"
    '''The service account name of the pod.'''
    NODE_NAME = "NODE_NAME"
    '''The name of the node.'''
    NODE_IP = "NODE_IP"
    '''The ipAddress of the node.'''
    POD_IPS = "POD_IPS"
    '''The ipAddresess of the pod.'''


class EnvFrom(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.EnvFrom"):
    '''A collection of env variables defined in other resources.'''

    def __init__(
        self,
        config_map: typing.Optional["IConfigMap"] = None,
        prefix: typing.Optional[builtins.str] = None,
        sec: typing.Optional["ISecret"] = None,
    ) -> None:
        '''
        :param config_map: -
        :param prefix: -
        :param sec: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35287de5237a43b4c7d3b8e8e379fc1387744f880918195d196c9a1de4fd6c18)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument sec", value=sec, expected_type=type_hints["sec"])
        jsii.create(self.__class__, self, [config_map, prefix, sec])


class EnvValue(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.EnvValue"):
    '''Utility class for creating reading env values from various sources.'''

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value by reading a specific key inside a config map.

        :param config_map: - The config map.
        :param key: - The key to extract the value from.
        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__595af036657f37ff7c489a6ba390f05af7edff4a1722915b76da79723e65a768)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromConfigMapOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromConfigMap", [config_map, key, options]))

    @jsii.member(jsii_name="fromFieldRef")
    @builtins.classmethod
    def from_field_ref(
        cls,
        field_path: EnvFieldPaths,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a field reference.

        :param field_path: : The field reference.
        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30af4bae3c4085ce5d3cedec393a3c6ba681fe98d787b0b75a5b4eb74135c26c)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
        options = EnvValueFromFieldRefOptions(api_version=api_version, key=key)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromFieldRef", [field_path, options]))

    @jsii.member(jsii_name="fromProcess")
    @builtins.classmethod
    def from_process(
        cls,
        key: builtins.str,
        *,
        required: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value from a key in the current process environment.

        :param key: - The key to read.
        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc0b2eaf6f191004acdc5857766d35c708942b5ff60f551fd0debb299a433bf0)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromProcessOptions(required=required)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromProcess", [key, options]))

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(
        cls,
        resource: "ResourceFieldPaths",
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a resource.

        :param resource: : Resource to select the value from.
        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab39a42b20c3e539e3cc7773f52d269d55c6c3e3f88739a19899d72b6b306691)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        options = EnvValueFromResourceOptions(container=container, divisor=divisor)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromResource", [resource, options]))

    @jsii.member(jsii_name="fromSecretValue")
    @builtins.classmethod
    def from_secret_value(
        cls,
        secret_value: typing.Union["SecretValue", typing.Dict[builtins.str, typing.Any]],
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Defines an environment value from a secret JSON value.

        :param secret_value: The secret value (secrent + key).
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dcf5b7101b9514be0bee8518fd6b3c9c971542a3c1e013a05af9cc43183feb3d)
            check_type(argname="argument secret_value", value=secret_value, expected_type=type_hints["secret_value"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromSecretValue", [secret_value, options]))

    @jsii.member(jsii_name="fromValue")
    @builtins.classmethod
    def from_value(cls, value: builtins.str) -> "EnvValue":
        '''Create a value from the given argument.

        :param value: - The value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aab4dd5eb4729721e3687a4d2049701c46a28829db7565c8ff3ddf4424c0e5f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromValue", [value]))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))

    @builtins.property
    @jsii.member(jsii_name="valueFrom")
    def value_from(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "valueFrom"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EnvValueFromConfigMapOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromConfigMapOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an envionment variable value from a ConfigMap key.

        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0051f4fea66292948a3755ee3eb1290a7934c3d8b21fe571308419315a8ffc5)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromConfigMapOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EnvValueFromFieldRefOptions",
    jsii_struct_bases=[],
    name_mapping={"api_version": "apiVersion", "key": "key"},
)
class EnvValueFromFieldRefOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a field reference.

        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f1200d6fcc05c890ebbac5773c563bb9096d449a726648f70cc3091134634721)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if key is not None:
            self._values["key"] = key

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''Version of the schema the FieldPath is written in terms of.'''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''The key to select the pod label or annotation.'''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromFieldRefOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EnvValueFromProcessOptions",
    jsii_struct_bases=[],
    name_mapping={"required": "required"},
)
class EnvValueFromProcessOptions:
    def __init__(self, *, required: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from the process environment.

        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__561f9c865439ea5b0eaa2d4351c7493ef99c569858b2e32b14a8dd60fe0b4360)
            check_type(argname="argument required", value=required, expected_type=type_hints["required"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if required is not None:
            self._values["required"] = required

    @builtins.property
    def required(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the key must exist in the environment.

        If this is set to true, and the key does not exist, an error will thrown.

        :default: false
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromProcessOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EnvValueFromResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "divisor": "divisor"},
)
class EnvValueFromResourceOptions:
    def __init__(
        self,
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a resource.

        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c06f6c584bd7c01281f68059f75790badf5551351d59ba1bd392065d7536723b)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if container is not None:
            self._values["container"] = container
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def container(self) -> typing.Optional[Container]:
        '''The container to select the value from.'''
        result = self._values.get("container")
        return typing.cast(typing.Optional[Container], result)

    @builtins.property
    def divisor(self) -> typing.Optional[builtins.str]:
        '''The output format of the exposed resource.'''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EnvValueFromSecretOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromSecretOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from a Secret.

        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a18f21f0735388094a74f40fe3b84ff0dcea8a074601608fc8d271d8b59ff122)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the Secret or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromSecretOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.EphemeralStorageResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class EphemeralStorageResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Emphemeral storage request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f1c066357a15690da7eee0e6f8f9c57ea545eb5faf79d0b874031a789e6c3e9)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralStorageResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ExposeServiceViaIngressOptions",
    jsii_struct_bases=[],
    name_mapping={"ingress": "ingress", "path_type": "pathType"},
)
class ExposeServiceViaIngressOptions:
    def __init__(
        self,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional["HttpIngressPathType"] = None,
    ) -> None:
        '''Options for exposing a service using an ingress.

        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56befbf90adec805a7129b055560b550aaa160d687d7f16c2f946a90dae8e1db)
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional["HttpIngressPathType"]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional["HttpIngressPathType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeServiceViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.FromServiceAccountNameOptions",
    jsii_struct_bases=[],
    name_mapping={"namespace_name": "namespaceName"},
)
class FromServiceAccountNameOptions:
    def __init__(self, *, namespace_name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2770253d5361485728f125b073573f993d999308251f56fdd4a0093134b8197a)
            check_type(argname="argument namespace_name", value=namespace_name, expected_type=type_hints["namespace_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespace_name is not None:
            self._values["namespace_name"] = namespace_name

    @builtins.property
    def namespace_name(self) -> typing.Optional[builtins.str]:
        '''The name of the namespace the service account belongs to.

        :default: "default"
        '''
        result = self._values.get("namespace_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FromServiceAccountNameOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.FsGroupChangePolicy")
class FsGroupChangePolicy(enum.Enum):
    ON_ROOT_MISMATCH = "ON_ROOT_MISMATCH"
    '''Only change permissions and ownership if permission and ownership of root directory does not match with expected permissions of the volume.

    This could help shorten the time it takes to change ownership and permission of a volume
    '''
    ALWAYS = "ALWAYS"
    '''Always change permission and ownership of the volume when volume is mounted.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.GCEPersistentDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromGcePersistentDisk``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1843b88ab50cad3d6019b40a62aa0154aa20ef89929bb16af00e356c1d33ab0f)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Handler(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Handler"):
    '''Defines a specific action that should be taken.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(cls, command: typing.Sequence[builtins.str]) -> "Handler":
        '''Defines a handler based on a command which is executed within the container.

        :param command: The command to execute.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fbb87ef9b8437ae40167004acdc9a44b447f186936202e8bd329578f4eba26d)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        return typing.cast("Handler", jsii.sinvoke(cls, "fromCommand", [command]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c6c637f74480421612e9026ba1cc49f57a8b600ace080df97c6e829fe6aa6ee)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HandlerFromHttpGetOptions(port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        options = HandlerFromTcpSocketOptions(host=host, port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HandlerFromHttpGetOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class HandlerFromHttpGetOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``Handler.fromHttpGet``.

        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74b6f9346d8e6d0ea6961ec51fc227e13b85de32384ecf9070ba500e79dfdfa7)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromHttpGetOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HandlerFromTcpSocketOptions",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "port": "port"},
)
class HandlerFromTcpSocketOptions:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Handler.fromTcpSocket``.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9abca0d77c80a55188e2d8b4ecba14a9df3b2b9852290e797bc75f174d0f913)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromTcpSocketOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's /etc/hosts file.

        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__628c9f48ff1ce66cc71ed82213f8a301acbff8a4ab6494c78c9303715c42f41a)
            check_type(argname="argument hostnames", value=hostnames, expected_type=type_hints["hostnames"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "hostnames": hostnames,
            "ip": ip,
        }

    @builtins.property
    def hostnames(self) -> typing.List[builtins.str]:
        '''Hostnames for the chosen IP address.'''
        result = self._values.get("hostnames")
        assert result is not None, "Required property 'hostnames' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip(self) -> builtins.str:
        '''IP address of the host file entry.'''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HostPathVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeOptions:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional["HostPathVolumeType"] = None,
    ) -> None:
        '''Options for a HostPathVolume-based volume.

        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9e953d2711b0c5d4f2fe1fe57547f942778d4553967f728aa01b7529b32e5403)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''The path of the directory on the host.'''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional["HostPathVolumeType"]:
        '''The expected type of the path found on the host.

        :default: HostPathVolumeType.DEFAULT
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["HostPathVolumeType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.HostPathVolumeType")
class HostPathVolumeType(enum.Enum):
    '''Host path types.'''

    DEFAULT = "DEFAULT"
    '''Empty string (default) is for backward compatibility, which means that no checks will be performed before mounting the hostPath volume.'''
    DIRECTORY_OR_CREATE = "DIRECTORY_OR_CREATE"
    '''If nothing exists at the given path, an empty directory will be created there as needed with permission set to 0755, having the same group and ownership with Kubelet.'''
    DIRECTORY = "DIRECTORY"
    '''A directory must exist at the given path.'''
    FILE_OR_CREATE = "FILE_OR_CREATE"
    '''If nothing exists at the given path, an empty file will be created there as needed with permission set to 0644, having the same group and ownership with Kubelet.'''
    FILE = "FILE"
    '''A file must exist at the given path.'''
    SOCKET = "SOCKET"
    '''A UNIX socket must exist at the given path.'''
    CHAR_DEVICE = "CHAR_DEVICE"
    '''A character device must exist at the given path.'''
    BLOCK_DEVICE = "BLOCK_DEVICE"
    '''A block device must exist at the given path.'''


@jsii.enum(jsii_type="cdk8s-plus-28.HttpIngressPathType")
class HttpIngressPathType(enum.Enum):
    '''Specify how the path is matched against request paths.

    :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
    '''

    PREFIX = "PREFIX"
    '''Matches the URL path exactly.'''
    EXACT = "EXACT"
    '''Matches based on a URL path prefix split by '/'.'''
    IMPLEMENTATION_SPECIFIC = "IMPLEMENTATION_SPECIFIC"
    '''Matching is specified by the underlying IngressClass.'''


@jsii.interface(jsii_type="cdk8s-plus-28.IApiEndpoint")
class IApiEndpoint(typing_extensions.Protocol):
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        ...

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        ...


class _IApiEndpointProxy:
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IApiEndpoint"

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional["IApiResource"], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiEndpoint).__jsii_proxy_class__ = lambda : _IApiEndpointProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IApiResource")
class IApiResource(typing_extensions.Protocol):
    '''Represents a resource or collection of resources.'''

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        ...


class _IApiResourceProxy:
    '''Represents a resource or collection of resources.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IApiResource"

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiResource).__jsii_proxy_class__ = lambda : _IApiResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-28.INamespaceSelector")
class INamespaceSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select namespaces.'''

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _INamespaceSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select namespaces.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.INamespaceSelector"

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("NamespaceSelectorConfig", jsii.invoke(self, "toNamespaceSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INamespaceSelector).__jsii_proxy_class__ = lambda : _INamespaceSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-28.INetworkPolicyPeer")
class INetworkPolicyPeer(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Describes a peer to allow traffic to/from.'''

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        ...

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        ...


class _INetworkPolicyPeerProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Describes a peer to allow traffic to/from.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.INetworkPolicyPeer"

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        return typing.cast(typing.Optional["IPodSelector"], jsii.invoke(self, "toPodSelector", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INetworkPolicyPeer).__jsii_proxy_class__ = lambda : _INetworkPolicyPeerProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IPodSelector")
class IPodSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select pods.'''

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _IPodSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select pods.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IPodSelector"

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("PodSelectorConfig", jsii.invoke(self, "toPodSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPodSelector).__jsii_proxy_class__ = lambda : _IPodSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IResource")
class IResource(
    _constructs_77d1e7e8.IConstruct,
    IApiResource,
    typing_extensions.Protocol,
):
    '''Represents a resource.'''

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        ...


class _IResourceProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
    jsii.proxy_for(IApiResource), # type: ignore[misc]
):
    '''Represents a resource.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IResource"

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResource).__jsii_proxy_class__ = lambda : _IResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IRole")
class IRole(IResource, typing_extensions.Protocol):
    '''A reference to any Role or ClusterRole.'''

    pass


class _IRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''A reference to any Role or ClusterRole.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IRole).__jsii_proxy_class__ = lambda : _IRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IScalable")
class IScalable(typing_extensions.Protocol):
    '''Represents a scalable workload.'''

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        ...

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        ...

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        ...

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        ...


class _IScalableProxy:
    '''Represents a scalable workload.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IScalable"

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99877db5de28406b45faf3581f89b6c233302ee8087630abd4beeb0752f6cdb4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        return typing.cast("ScalingTarget", jsii.invoke(self, "toScalingTarget", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IScalable).__jsii_proxy_class__ = lambda : _IScalableProxy


@jsii.interface(jsii_type="cdk8s-plus-28.ISecret")
class ISecret(IResource, typing_extensions.Protocol):
    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: Secret's key.
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        ...


class _ISecretProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.ISecret"

    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: Secret's key.
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__212c7abd35fdfa0b06fdf92ddaf4e651e8b6058e6a71aa386755364cb6d33706)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast(EnvValue, jsii.invoke(self, "envValue", [key, options]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISecret).__jsii_proxy_class__ = lambda : _ISecretProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IStorage")
class IStorage(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents a piece of storage in the cluster.'''

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        ...


class _IStorageProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents a piece of storage in the cluster.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IStorage"

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IStorage).__jsii_proxy_class__ = lambda : _IStorageProxy


@jsii.interface(jsii_type="cdk8s-plus-28.ISubject")
class ISubject(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can be used as a role binding subject.'''

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        ...


class _ISubjectProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can be used as a role binding subject.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.ISubject"

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        return typing.cast("SubjectConfiguration", jsii.invoke(self, "toSubjectConfiguration", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISubject).__jsii_proxy_class__ = lambda : _ISubjectProxy


@jsii.enum(jsii_type="cdk8s-plus-28.ImagePullPolicy")
class ImagePullPolicy(enum.Enum):
    ALWAYS = "ALWAYS"
    '''Every time the kubelet launches a container, the kubelet queries the container image registry to resolve the name to an image digest.

    If the kubelet has a container image with that exact
    digest cached locally, the kubelet uses its cached image; otherwise, the kubelet downloads
    (pulls) the image with the resolved digest, and uses that image to launch the container.

    Default is Always if ImagePullPolicy is omitted and either the image tag is :latest or
    the image tag is omitted.
    '''
    IF_NOT_PRESENT = "IF_NOT_PRESENT"
    '''The image is pulled only if it is not already present locally.

    Default is IfNotPresent if ImagePullPolicy is omitted and the image tag is present but
    not :latest
    '''
    NEVER = "NEVER"
    '''The image is assumed to exist locally.

    No attempt is made to pull the image.
    '''


class IngressBackend(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.IngressBackend"):
    '''The backend for an ingress path.'''

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(cls, resource: IResource) -> "IngressBackend":
        '''A Resource backend is an ObjectRef to another Kubernetes resource within the same namespace as the Ingress object.

        A common usage for a Resource backend is to ingress data to an object
        storage backend with static assets.

        :param resource: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__11294cf303f41ea6b4638c49898e061a31fb1b0cebcd6fb5d27735ccc1c4f91f)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromResource", [resource]))

    @jsii.member(jsii_name="fromService")
    @builtins.classmethod
    def from_service(
        cls,
        serv: "Service",
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "IngressBackend":
        '''A Kubernetes ``Service`` to use as the backend for this path.

        :param serv: The service object.
        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2aa704bedd0d2300c35861c7b67f6d8a326105388e43654aee0bee190c64ed51)
            check_type(argname="argument serv", value=serv, expected_type=type_hints["serv"])
        options = ServiceIngressBackendOptions(port=port)

        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromService", [serv, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.IngressRule",
    jsii_struct_bases=[],
    name_mapping={
        "backend": "backend",
        "host": "host",
        "path": "path",
        "path_type": "pathType",
    },
)
class IngressRule:
    def __init__(
        self,
        *,
        backend: IngressBackend,
        host: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match,
        then routed to the backend associated with the matching path.

        :param backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. Default: - If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        :param path: Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. Default: - If unspecified, the path defaults to a catch all sending traffic to the backend.
        :param path_type: Specify how the path is matched against request paths. By default, path types will be matched by prefix.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__649af66cfc3e9c4e001eb4eb55487f7752a930f1da895167230bfc31b654df76)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
        }
        if host is not None:
            self._values["host"] = host
        if path is not None:
            self._values["path"] = path
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def backend(self) -> IngressBackend:
        '''Backend defines the referenced service endpoint to which the traffic will be forwarded to.'''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast(IngressBackend, result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as
        defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
        can only apply to the IP in the Spec of the parent Ingress. 2. The ``:``
        delimiter is not respected because ports are not allowed. Currently the
        port of an Ingress is implicitly :80 for http and :443 for https. Both
        these may change in the future. Incoming requests are matched against the
        host before the IngressRuleValue.

        :default:

        - If the host is unspecified, the Ingress routes all traffic based
        on the specified IngressRuleValue.
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.

        :default:

        - If unspecified, the path defaults to a catch all sending traffic
        to the backend.
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''Specify how the path is matched against request paths.

        By default, path
        types will be matched by prefix.

        :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret": "secret"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret: typing.Optional[ISecret] = None,
    ) -> None:
        '''Represents the TLS configuration mapping that is passed to the ingress controller for SSL termination.

        :param hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the TLS Secret. Default: - If unspecified, it defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress.
        :param secret: Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing. Default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c391712067ca09d537e58bb603a880a1a79bf828e76f0c3056d810180543fcf9)
            check_type(argname="argument hosts", value=hosts, expected_type=type_hints["hosts"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret is not None:
            self._values["secret"] = secret

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hosts are a list of hosts included in the TLS certificate.

        The values in
        this list must match the name/s used in the TLS Secret.

        :default:

        - If unspecified, it defaults to the wildcard host setting for
        the loadbalancer controller fulfilling this Ingress.
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret(self) -> typing.Optional[ISecret]:
        '''Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443.

        If the SNI host in a listener conflicts with
        the "Host" header field used by an IngressRule, the SNI host is used for
        termination and value of the Host header is used for routing.

        :default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        result = self._values.get("secret")
        return typing.cast(typing.Optional[ISecret], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabelExpression(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.LabelExpression",
):
    '''Represents a query that can be performed against resources with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__655c530c4bb2d854822dfc94a3a4e0f42e29de9a9d7ed98d17e5402b26081d7e)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c66c837e8f9190d4c795d739ac05a2939a5d9492dd882b806b0ff9ff07ba537)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2eab37ecec0f881b48edde0d0050d48f3c9399fd6d5488dd121e6ae5662f8f1a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04be216de2ad3666e5ceeceb9a8bbf2776db55f76b2b965f341e9998d8bacb04)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "notIn", [key, values]))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property
    @jsii.member(jsii_name="operator")
    def operator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operator"))

    @builtins.property
    @jsii.member(jsii_name="values")
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "values"))


class LabelSelector(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.LabelSelector"):
    '''Match a resource by labels.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> "LabelSelector":
        '''
        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        options = LabelSelectorOptions(expressions=expressions, labels=labels)

        return typing.cast("LabelSelector", jsii.sinvoke(cls, "of", [options]))

    @jsii.member(jsii_name="isEmpty")
    def is_empty(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isEmpty", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.LabelSelectorOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels"},
)
class LabelSelectorOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Options for ``LabelSelector.of``.

        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea8bc4663bcddbd92549ea53a08ed83fe06d99b5b437d78707e3d56cb69a4c82)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expression based label matchers.'''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Strict label matchers.'''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.LabelSelectorRequirement",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class LabelSelectorRequirement:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.

        :param key: The label key that the selector applies to.
        :param operator: Represents a key's relationship to a set of values.
        :param values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6cb402249db0d54ed6aae293d0717d729cbb2a98559301d02bdc0e7e2cd96123)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''The label key that the selector applies to.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''Represents a key's relationship to a set of values.'''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of string values.

        If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist,
        the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorRequirement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabeledNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.LabeledNode"):
    '''A node that is matched by label selectors.'''

    def __init__(self, label_selector: typing.Sequence["NodeLabelQuery"]) -> None:
        '''
        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__585c696434fa7a0a775a447d810777600610b6bc14df26e312fb97c2cabf15ac)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        jsii.create(self.__class__, self, [label_selector])

    @builtins.property
    @jsii.member(jsii_name="labelSelector")
    def label_selector(self) -> typing.List["NodeLabelQuery"]:
        return typing.cast(typing.List["NodeLabelQuery"], jsii.get(self, "labelSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.MemoryResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class MemoryResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Memory request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d866de9c4ae3a03caf8d8c2b6b9c47f05b34376a42484075ca7718701dce9d69)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MemoryResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Metric(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Metric"):
    '''A metric condition that HorizontalPodAutoscaler's scale on.'''

    @jsii.member(jsii_name="containerCpu")
    @builtins.classmethod
    def container_cpu(cls, *, container: Container, target: "MetricTarget") -> "Metric":
        '''Metric that tracks the CPU of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerCpu", [options]))

    @jsii.member(jsii_name="containerEphemeralStorage")
    @builtins.classmethod
    def container_ephemeral_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the local ephemeral storage of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerEphemeralStorage", [options]))

    @jsii.member(jsii_name="containerMemory")
    @builtins.classmethod
    def container_memory(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the Memory of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerMemory", [options]))

    @jsii.member(jsii_name="containerStorage")
    @builtins.classmethod
    def container_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the volume size of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerStorage", [options]))

    @jsii.member(jsii_name="external")
    @builtins.classmethod
    def external(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A global metric that is not associated with any Kubernetes object.

        Allows for autoscaling based on information coming from components running outside of
        the cluster.

        Use case:

        - Scale up when the length of an SQS queue is greater than 10 messages.
        - Scale down when an outside load balancer's queries are less than 10000 per second.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "external", [options]))

    @jsii.member(jsii_name="object")
    @builtins.classmethod
    def object(
        cls,
        *,
        object: IResource,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''Metric that describes a metric of a kubernetes object.

        Use case:

        - Scale on a Kubernetes Ingress's hits-per-second metric.

        :param object: Resource where the metric can be found.
        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricObjectOptions(
            object=object, name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "object", [options]))

    @jsii.member(jsii_name="pods")
    @builtins.classmethod
    def pods(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A pod metric that will be averaged across all pods of the current scale target.

        Use case:

        - Average CPU utilization across all pods
        - Transactions processed per second across all pods

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "pods", [options]))

    @jsii.member(jsii_name="resourceCpu")
    @builtins.classmethod
    def resource_cpu(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available CPU of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when CPU is above 40%.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1853750dbae3eb335d0e4f7ffb9c121812e176e05c3c915cc93b266e9cc18d56)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceCpu", [target]))

    @jsii.member(jsii_name="resourceEphemeralStorage")
    @builtins.classmethod
    def resource_ephemeral_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Ephemeral Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f1a204146ffd95e81af5325c4098d20963321a20d07483377f26db1f3c2754f)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceEphemeralStorage", [target]))

    @jsii.member(jsii_name="resourceMemory")
    @builtins.classmethod
    def resource_memory(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Memory of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when Memory is above 512MB.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e9a722c77ca679931d0f26919e4d398e320e54ef55d94ab3e1dcc7978715464)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceMemory", [target]))

    @jsii.member(jsii_name="resourceStorage")
    @builtins.classmethod
    def resource_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ddae7310b13e3eda44ef83d953df311a8b5a4e0c1ae4b1b6face88ab390f93d)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceStorage", [target]))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.MetricContainerResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "target": "target"},
)
class MetricContainerResourceOptions:
    def __init__(self, *, container: Container, target: "MetricTarget") -> None:
        '''Options for ``Metric.containerResource()``.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__186ac7e48b2a1e2b8105073055aa3f244da995a51888acabafb6b3417736ea4e)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "target": target,
        }

    @builtins.property
    def container(self) -> Container:
        '''Container where the metric can be found.'''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(Container, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''Target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricContainerResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.MetricOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
    },
)
class MetricOptions:
    def __init__(
        self,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> None:
        '''Base options for a Metric.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a09cbd02ea7a86fbb25a2a9e14a76c18ed725f82f9d16fae3c56c2ad8a25b71c)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MetricTarget(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.MetricTarget"):
    '''A metric condition that will trigger scaling behavior when satisfied.

    Example::

        MetricTarget.averageUtilization(70); // 70% average utilization
    '''

    @jsii.member(jsii_name="averageUtilization")
    @builtins.classmethod
    def average_utilization(cls, average_utilization: jsii.Number) -> "MetricTarget":
        '''Target a percentage value across all relevant pods.

        :param average_utilization: The percentage of the utilization metric. e.g. ``50`` for 50%.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68faedbdf2d601102adaa0aaa1d7dfe9cd5747c5aa9864212d078944fccec220)
            check_type(argname="argument average_utilization", value=average_utilization, expected_type=type_hints["average_utilization"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageUtilization", [average_utilization]))

    @jsii.member(jsii_name="averageValue")
    @builtins.classmethod
    def average_value(cls, average_value: jsii.Number) -> "MetricTarget":
        '''Target the average value across all relevant pods.

        :param average_value: The average metric value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae1f3080d6131006723cb39f190df8cb9026beaef7ef15093f8d6ff9186189e3)
            check_type(argname="argument average_value", value=average_value, expected_type=type_hints["average_value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageValue", [average_value]))

    @jsii.member(jsii_name="value")
    @builtins.classmethod
    def value(cls, value: jsii.Number) -> "MetricTarget":
        '''Target a specific target value.

        :param value: The target value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc2c2654c553b25ca70a39c0728947788cd7f051ff0ed5392239bfefb7a562d6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "value", [value]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.MountOptions",
    jsii_struct_bases=[],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
    },
)
class MountOptions:
    def __init__(
        self,
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for mounts.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d5ff157785afef7ad130b449f1e91b67445f38f816ee2d77bd14824f032e230)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional["MountPropagation"]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional["MountPropagation"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MountOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.MountPropagation")
class MountPropagation(enum.Enum):
    NONE = "NONE"
    '''This volume mount will not receive any subsequent mounts that are mounted to this volume or any of its subdirectories by the host.

    In similar
    fashion, no mounts created by the Container will be visible on the host.

    This is the default mode.

    This mode is equal to ``private`` mount propagation as described in the Linux
    kernel documentation
    '''
    HOST_TO_CONTAINER = "HOST_TO_CONTAINER"
    '''This volume mount will receive all subsequent mounts that are mounted to this volume or any of its subdirectories.

    In other words, if the host mounts anything inside the volume mount, the
    Container will see it mounted there.

    Similarly, if any Pod with Bidirectional mount propagation to the same
    volume mounts anything there, the Container with HostToContainer mount
    propagation will see it.

    This mode is equal to ``rslave`` mount propagation as described in the Linux
    kernel documentation
    '''
    BIDIRECTIONAL = "BIDIRECTIONAL"
    '''This volume mount behaves the same the HostToContainer mount.

    In addition,
    all volume mounts created by the Container will be propagated back to the
    host and to all Containers of all Pods that use the same volume

    A typical use case for this mode is a Pod with a FlexVolume or CSI driver
    or a Pod that needs to mount something on the host using a hostPath volume.

    This mode is equal to ``rshared`` mount propagation as described in the Linux
    kernel documentation

    Caution: Bidirectional mount propagation can be dangerous. It can damage
    the host operating system and therefore it is allowed only in privileged
    Containers. Familiarity with Linux kernel behavior is strongly recommended.
    In addition, any volume mounts created by Containers in Pods must be
    destroyed (unmounted) by the Containers on termination.
    '''


class NamedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.NamedNode"):
    '''A node that is matched by its name.'''

    def __init__(self, name: builtins.str) -> None:
        '''
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6de3c21115a1357eb16de5ea73bb10672dbaa622d4b8f8f509a7a69fcf690e7)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [name])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NamespaceSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "names": "names"},
)
class NamespaceSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: typing.Optional[LabelSelector] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Configuration for selecting namespaces.

        :param label_selector: A selector to select namespaces by labels.
        :param names: A list of names to select namespaces by names.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26d90411b7814353ce7de34bd8ff6522fd375797c10360d2d62f1fac75912fc0)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to select namespaces by labels.'''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of names to select namespaces by names.'''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespaces(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.Namespaces",
):
    '''Represents a group of namespaces.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param names: -
        :param labels: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8ca0186187b24dd223c4229751ac0cd01c8863e123c15aea630cddcd338710b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        jsii.create(self.__class__, self, [scope, id, expressions, names, labels])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "Namespaces":
        '''Select all namespaces.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15ef10936507df76034462367f02c12100a38659efe57dfdbd94a9f38ca1ca22)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("Namespaces", jsii.sinvoke(cls, "all", [scope, id]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "Namespaces":
        '''Select specific namespaces.

        :param scope: -
        :param id: -
        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08d864884f99a19a1a37085a600d66df642b4635141198dfb035c5ad91968c20)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = NamespacesSelectOptions(
            expressions=expressions, labels=labels, names=names
        )

        return typing.cast("Namespaces", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NamespacesSelectOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels", "names": "names"},
)
class NamespacesSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Options for ``Namespaces.select``.

        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cab23699fb502dd681f3088810da05930bd149b118613ae40c22f943738f191d)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Namespaces must satisfy these selectors.

        The selectors query labels, just like the ``labels`` property, but they
        provide a more advanced matching mechanism.

        :default: - no selector requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the namespaces must have.

        This is equivalent to using an 'Is' selector.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Namespaces names must be one of these.

        :default: - no name requirements.
        '''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespacesSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyAddEgressRuleOptions",
    jsii_struct_bases=[],
    name_mapping={"ports": "ports"},
)
class NetworkPolicyAddEgressRuleOptions:
    def __init__(
        self,
        *,
        ports: typing.Optional[typing.Sequence["NetworkPolicyPort"]] = None,
    ) -> None:
        '''Options for ``NetworkPolicy.addEgressRule``.

        :param ports: Ports the rule should allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6be05049eed62d24feecfe7f50df5b9e67107fcd18cf5656b14cc148157d2ebe)
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["NetworkPolicyPort"]]:
        '''Ports the rule should allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["NetworkPolicyPort"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyAddEgressRuleOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INetworkPolicyPeer)
class NetworkPolicyIpBlock(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.NetworkPolicyIpBlock",
):
    '''Describes a particular CIDR (Ex.

    "192.168.1.1/24","2001:db9::/64") that is
    allowed to the pods matched by a network policy selector.
    The except entry describes CIDRs that should not be included within this rule.
    '''

    @jsii.member(jsii_name="anyIpv4")
    @builtins.classmethod
    def any_ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv4 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__652671b755a58785993b20160586de265718cb2f6ca2c5b33391fc769f982887)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv4", [scope, id]))

    @jsii.member(jsii_name="anyIpv6")
    @builtins.classmethod
    def any_ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv6 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4362aa55d6764ea944017ba122d5e66d2e127cc75459881f0eb1c842ba97e926)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv6", [scope, id]))

    @jsii.member(jsii_name="ipv4")
    @builtins.classmethod
    def ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv4 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e4e5390a21d9b019918aee06a4c71e2ad6f6c8c99f590471d42c6fe73bfc769)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv4", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="ipv6")
    @builtins.classmethod
    def ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv6 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d56e1a52444ab105e1d4ca0572da4b2964bf9ce867b2ac475b3f5795e00c40f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv6", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @builtins.property
    @jsii.member(jsii_name="cidr")
    def cidr(self) -> builtins.str:
        '''A string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".'''
        return typing.cast(builtins.str, jsii.get(self, "cidr"))

    @builtins.property
    @jsii.member(jsii_name="except")
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64". Except values will be rejected if they are outside the CIDR range.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "except"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyPeerConfig",
    jsii_struct_bases=[],
    name_mapping={"ip_block": "ipBlock", "pod_selector": "podSelector"},
)
class NetworkPolicyPeerConfig:
    def __init__(
        self,
        *,
        ip_block: typing.Optional[NetworkPolicyIpBlock] = None,
        pod_selector: typing.Optional[typing.Union["PodSelectorConfig", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for network peers.

        A peer can either by an ip block, or a selection of pods, not both.

        :param ip_block: The ip block this peer represents.
        :param pod_selector: The pod selector this peer represents.
        '''
        if isinstance(pod_selector, dict):
            pod_selector = PodSelectorConfig(**pod_selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f493c13c2276756933112de5b05cbc7e3a9408839719a594ce294c7894c1d4b)
            check_type(argname="argument ip_block", value=ip_block, expected_type=type_hints["ip_block"])
            check_type(argname="argument pod_selector", value=pod_selector, expected_type=type_hints["pod_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ip_block is not None:
            self._values["ip_block"] = ip_block
        if pod_selector is not None:
            self._values["pod_selector"] = pod_selector

    @builtins.property
    def ip_block(self) -> typing.Optional[NetworkPolicyIpBlock]:
        '''The ip block this peer represents.'''
        result = self._values.get("ip_block")
        return typing.cast(typing.Optional[NetworkPolicyIpBlock], result)

    @builtins.property
    def pod_selector(self) -> typing.Optional["PodSelectorConfig"]:
        '''The pod selector this peer represents.'''
        result = self._values.get("pod_selector")
        return typing.cast(typing.Optional["PodSelectorConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPeerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicyPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.NetworkPolicyPort",
):
    '''Describes a port to allow traffic on.'''

    @jsii.member(jsii_name="allTcp")
    @builtins.classmethod
    def all_tcp(cls) -> "NetworkPolicyPort":
        '''Any TCP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allTcp", []))

    @jsii.member(jsii_name="allUdp")
    @builtins.classmethod
    def all_udp(cls) -> "NetworkPolicyPort":
        '''Any UDP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allUdp", []))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> "NetworkPolicyPort":
        '''Custom port configuration.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        props = NetworkPolicyPortProps(end_port=end_port, port=port, protocol=protocol)

        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "of", [props]))

    @jsii.member(jsii_name="tcp")
    @builtins.classmethod
    def tcp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct TCP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__455c14acc576190bb26e55347df6550c50020035084aa2ad7eacf66e578da832)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcp", [port]))

    @jsii.member(jsii_name="tcpRange")
    @builtins.classmethod
    def tcp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A TCP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__32d450a3a399bf071e13fe5b6f403fd577f90ea774520d95b3b53d41a0b4bcc1)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcpRange", [start_port, end_port]))

    @jsii.member(jsii_name="udp")
    @builtins.classmethod
    def udp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct UDP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0686130b86193e3f426357d512d37c75884d7b2056222186f9b130ee6136829)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udp", [port]))

    @jsii.member(jsii_name="udpRange")
    @builtins.classmethod
    def udp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A UDP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2afd97b867b766ba10ab31e9d0e9d5d94b8d2340cffe69c826c86bb02cfb45d)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udpRange", [start_port, end_port]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyPortProps",
    jsii_struct_bases=[],
    name_mapping={"end_port": "endPort", "port": "port", "protocol": "protocol"},
)
class NetworkPolicyPortProps:
    def __init__(
        self,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> None:
        '''Properties for ``NetworkPolicyPort``.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f65042b9bd390e5c497dd73a09f3966c995503ebf01f049cbe2df05d6347bd0)
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if end_port is not None:
            self._values["end_port"] = end_port
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def end_port(self) -> typing.Optional[jsii.Number]:
        '''End port (relative to ``port``).

        Only applies if ``port`` is defined.
        Use this to specify a port range, rather that a specific one.

        :default: - not a port range.
        '''
        result = self._values.get("end_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''Specific port number.

        :default: - all ports are allowed.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional["NetworkProtocol"]:
        '''Protocol.

        :default: NetworkProtocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["NetworkProtocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPortProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyRule",
    jsii_struct_bases=[],
    name_mapping={"peer": "peer", "ports": "ports"},
)
class NetworkPolicyRule:
    def __init__(
        self,
        *,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Describes a rule allowing traffic from / to pods matched by a network policy selector.

        :param peer: Peer this rule interacts with.
        :param ports: The ports of the rule. Default: - traffic is allowed on all ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d24d702e5e1c1e01bac908719e32e6a4eb7f905aa015c6e563c12f4477aba7ab)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "peer": peer,
        }
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def peer(self) -> INetworkPolicyPeer:
        '''Peer this rule interacts with.'''
        result = self._values.get("peer")
        assert result is not None, "Required property 'peer' is missing"
        return typing.cast(INetworkPolicyPeer, result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''The ports of the rule.

        :default: - traffic is allowed on all ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyTraffic",
    jsii_struct_bases=[],
    name_mapping={"default": "default", "rules": "rules"},
)
class NetworkPolicyTraffic:
    def __init__(
        self,
        *,
        default: typing.Optional["NetworkPolicyTrafficDefault"] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[NetworkPolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Describes how the network policy should configure egress / ingress traffic.

        :param default: Specifies the default behavior of the policy when no rules are defined. Default: - unset, the policy does not change the behavior.
        :param rules: List of rules to be applied to the selected pods. If empty, the behavior of the policy is dictated by the ``default`` property. Default: - no rules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb56860e57da49ad1d8a36205eed7b12c5ce4d3157de214f92c03e02dc6acfe0)
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default is not None:
            self._values["default"] = default
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def default(self) -> typing.Optional["NetworkPolicyTrafficDefault"]:
        '''Specifies the default behavior of the policy when no rules are defined.

        :default: - unset, the policy does not change the behavior.
        '''
        result = self._values.get("default")
        return typing.cast(typing.Optional["NetworkPolicyTrafficDefault"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[NetworkPolicyRule]]:
        '''List of rules to be applied to the selected pods.

        If empty, the behavior of the policy is dictated by the ``default`` property.

        :default: - no rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyTraffic(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.NetworkPolicyTrafficDefault")
class NetworkPolicyTrafficDefault(enum.Enum):
    '''Default behaviors of network traffic in policies.'''

    DENY = "DENY"
    '''The policy denies all traffic.

    Since rules are additive, additional rules or policies can allow
    specific traffic.
    '''
    ALLOW = "ALLOW"
    '''The policy allows all traffic (either ingress or egress).

    Since rules are additive, no additional rule or policies can
    subsequently deny the traffic.
    '''


@jsii.enum(jsii_type="cdk8s-plus-28.NetworkProtocol")
class NetworkProtocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NfsVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "server": "server", "read_only": "readOnly"},
)
class NfsVolumeOptions:
    def __init__(
        self,
        *,
        path: builtins.str,
        server: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the NFS based volume.

        :param path: Path that is exported by the NFS server.
        :param server: Server is the hostname or IP address of the NFS server.
        :param read_only: If set to true, will force the NFS export to be mounted with read-only permissions. Default: - false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__860cf921d089d9f415c2eee8ba57655d22bb2402dce6917fbaaae038ed2b016d)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument server", value=server, expected_type=type_hints["server"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
            "server": server,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def path(self) -> builtins.str:
        '''Path that is exported by the NFS server.'''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def server(self) -> builtins.str:
        '''Server is the hostname or IP address of the NFS server.'''
        result = self._values.get("server")
        assert result is not None, "Required property 'server' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''If set to true, will force the NFS export to be mounted with read-only permissions.

        :default: - false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NfsVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Node(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Node"):
    '''Represents a node in the cluster.'''

    def __init__(self) -> None:
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="labeled")
    @builtins.classmethod
    def labeled(cls, *label_selector: "NodeLabelQuery") -> LabeledNode:
        '''Match a node by its labels.

        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__324ca6384df7164a6d17f14da4352f36a091db076ca26c745e343adae590e9fa)
            check_type(argname="argument label_selector", value=label_selector, expected_type=typing.Tuple[type_hints["label_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(LabeledNode, jsii.sinvoke(cls, "labeled", [*label_selector]))

    @jsii.member(jsii_name="named")
    @builtins.classmethod
    def named(cls, node_name: builtins.str) -> NamedNode:
        '''Match a node by its name.

        :param node_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99995c8b4db210232d67c8c9f1d99b2d6f3457ca9c39100c7a4f3b575ecdc480)
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
        return typing.cast(NamedNode, jsii.sinvoke(cls, "named", [node_name]))

    @jsii.member(jsii_name="tainted")
    @builtins.classmethod
    def tainted(cls, *taint_selector: "NodeTaintQuery") -> "TaintedNode":
        '''Match a node by its taints.

        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c505a1e72343fb9e0672250758afc2e71494eda20ab988d5376a6da144250a6)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=typing.Tuple[type_hints["taint_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("TaintedNode", jsii.sinvoke(cls, "tainted", [*taint_selector]))


class NodeLabelQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.NodeLabelQuery"):
    '''Represents a query that can be performed against nodes with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92a1392c9fe06e243d58ac42e4350f1d0f9b4230cc6ea86266a74f455fd1a51a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9de3c13c61fad9aaefbd458664009cf8ecb38df2828db398cfe64ebd1f8a8ed)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="gt")
    @builtins.classmethod
    def gt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to greater than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aaac7e9c86337b05725e59c66829402346a7a7c21ab7e68c0a9cade30f524762)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "gt", [key, values]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60dc4d4091fec82a4eba45039cd8b5bfee89c019cb5b7bcafe0558b42cb4c22a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(cls, key: builtins.str, value: builtins.str) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to equal ``value``.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55925763b7f24c9ed37fada329ab5f864a5f6901c21004da453495736af77ab5)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "is", [key, value]))

    @jsii.member(jsii_name="lt")
    @builtins.classmethod
    def lt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to less than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fd10cb9f9a3082f5b5e5e4b717e9e40bc13ae5dfcdd49facaea252f198a43dc8)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "lt", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc11b6de600f3746502e68affa364c850f57c46ae9bbe7242199d7ae6e23847b)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "notIn", [key, values]))


class NodeTaintQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.NodeTaintQuery"):
    '''Taint queries that can be perfomed against nodes.'''

    @jsii.member(jsii_name="any")
    @builtins.classmethod
    def any(cls) -> "NodeTaintQuery":
        '''Matches any taint.'''
        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "any", []))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(
        cls,
        key: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a tain with any value of a specific key.

        :param key: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18278474ada2e57d378092debac451be599f2a3e650f559178e4e3a31b286ccf)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "exists", [key, options]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(
        cls,
        key: builtins.str,
        value: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a taint with a specific key and value.

        :param key: -
        :param value: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64fe12c0c4aaff471022a276f43f10d481394b7f10252a44e524cfc9b6b015d9)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "is", [key, value, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NodeTaintQueryOptions",
    jsii_struct_bases=[],
    name_mapping={"effect": "effect", "evict_after": "evictAfter"},
)
class NodeTaintQueryOptions:
    def __init__(
        self,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``NodeTaintQuery``.

        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ed22e7269943fc75c39a447838b632dc6e45ee8ef6aeb64c74c5aea09a0da6d1)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument evict_after", value=evict_after, expected_type=type_hints["evict_after"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if evict_after is not None:
            self._values["evict_after"] = evict_after

    @builtins.property
    def effect(self) -> typing.Optional["TaintEffect"]:
        '''The taint effect to match.

        :default: - all effects are matched.
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional["TaintEffect"], result)

    @builtins.property
    def evict_after(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node.

        Only applies for the ``NO_EXECUTE`` effect.

        :default: - bound forever.
        '''
        result = self._values.get("evict_after")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NodeTaintQueryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiEndpoint)
class NonApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.NonApiResource"):
    '''Factory for creating non api resources.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, url: builtins.str) -> "NonApiResource":
        '''
        :param url: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58677daea9b38757c2948dc08af3192aec03657dd61a7d19ca3a5ac332c015c4)
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
        return typing.cast("NonApiResource", jsii.sinvoke(cls, "of", [url]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PathMapping",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "mode": "mode"},
)
class PathMapping:
    def __init__(
        self,
        *,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Maps a string key to a path within a volume.

        :param path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e3f2a83d2864fb337d87bbfe44cfb7b1dc4fb13066bf5f0565cb4c0cd05229f)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def path(self) -> builtins.str:
        '''The relative path of the file to map the key to.

        May not be an absolute
        path. May not contain the path element '..'. May not start with the string
        '..'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits to use on this file, must be a value between 0 and 0777.

        If not specified, the volume defaultMode will be used. This might be
        in conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PathMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PercentOrAbsolute(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.PercentOrAbsolute",
):
    '''Union like class repsenting either a ration in percents or an absolute number.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, num: jsii.Number) -> "PercentOrAbsolute":
        '''Absolute number.

        :param num: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88f6dd09af71b82b8d2bf967d4ce50062cad9317a77a3b18dac6c9747654d58d)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "absolute", [num]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, percent: jsii.Number) -> "PercentOrAbsolute":
        '''Percent ratio.

        :param percent: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c987eee2891422e7f01a62c4314f5ce1fe9cbf85b6ffbead72a798d138b7ea4b)
            check_type(argname="argument percent", value=percent, expected_type=type_hints["percent"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "percent", [percent]))

    @jsii.member(jsii_name="isZero")
    def is_zero(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isZero", []))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.enum(jsii_type="cdk8s-plus-28.PersistentVolumeAccessMode")
class PersistentVolumeAccessMode(enum.Enum):
    '''Access Modes.'''

    READ_WRITE_ONCE = "READ_WRITE_ONCE"
    '''The volume can be mounted as read-write by a single node.

    ReadWriteOnce access mode still can allow multiple pods to access
    the volume when the pods are running on the same node.
    '''
    READ_ONLY_MANY = "READ_ONLY_MANY"
    '''The volume can be mounted as read-only by many nodes.'''
    READ_WRITE_MANY = "READ_WRITE_MANY"
    '''The volume can be mounted as read-write by many nodes.'''
    READ_WRITE_ONCE_POD = "READ_WRITE_ONCE_POD"
    '''The volume can be mounted as read-write by a single Pod.

    Use ReadWriteOncePod access mode if you want to ensure that
    only one pod across whole cluster can read that PVC or write to it.
    This is only supported for CSI volumes and Kubernetes version 1.22+.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PersistentVolumeClaimVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "read_only": "readOnly"},
)
class PersistentVolumeClaimVolumeOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for a PersistentVolumeClaim-based volume.

        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6099905c28d0f7f5d30df59fe34d7786dfd886df089576d38836dcabb4a2f889)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - Derived from the PVC name.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Will force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.PersistentVolumeMode")
class PersistentVolumeMode(enum.Enum):
    '''Volume Modes.'''

    FILE_SYSTEM = "FILE_SYSTEM"
    '''Volume is ounted into Pods into a directory.

    If the volume is backed by a block device and the device is empty,
    Kubernetes creates a filesystem on the device before mounting it
    for the first time.
    '''
    BLOCK = "BLOCK"
    '''Use a volume as a raw block device.

    Such volume is presented into a Pod as a block device,
    without any filesystem on it. This mode is useful to provide a Pod the fastest possible way
    to access a volume, without any filesystem layer between the Pod
    and the volume. On the other hand, the application running in
    the Pod must know how to handle a raw block device
    '''


@jsii.enum(jsii_type="cdk8s-plus-28.PersistentVolumeReclaimPolicy")
class PersistentVolumeReclaimPolicy(enum.Enum):
    '''Reclaim Policies.'''

    RETAIN = "RETAIN"
    '''The Retain reclaim policy allows for manual reclamation of the resource.

    When the PersistentVolumeClaim is deleted, the PersistentVolume still exists and the
    volume is considered "released". But it is not yet available for another claim
    because the previous claimant's data remains on the volume.
    An administrator can manually reclaim the volume with the following steps:

    1. Delete the PersistentVolume. The associated storage asset in external
       infrastructure (such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume) still exists after the PV is deleted.
    2. Manually clean up the data on the associated storage asset accordingly.
    3. Manually delete the associated storage asset.

    If you want to reuse the same storage asset, create a new PersistentVolume
    with the same storage asset definition.
    '''
    DELETE = "DELETE"
    '''For volume plugins that support the Delete reclaim policy, deletion removes both the PersistentVolume object from Kubernetes, as well as the associated storage asset in the external infrastructure, such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume.

    Volumes that were dynamically provisioned inherit the reclaim policy of their StorageClass, which defaults to Delete.
    The administrator should configure the StorageClass according to users' expectations; otherwise,
    the PV must be edited or patched after it is created
    '''


class PodConnections(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.PodConnections"):
    '''Controls network isolation rules for inter-pod communication.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83fdec57dd4547b913b316e5de4d1c239b228f7f2ef13f360c8dde147e8ec935)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="allowFrom")
    def allow_from(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from the peer to this pod.

        By default, this will create an ingress network policy for this pod, and an egress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            redis.connections.allowFrom(web, { isolation: Isolation.PEER })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            redis.connections.allowFrom(web, { isolation: Isolation.POD })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c626e166dab0b77df13ea7e845206bafce6fa58d10fcf8173e27253c1a9b029)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowFromOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowFrom", [peer, options]))

    @jsii.member(jsii_name="allowTo")
    def allow_to(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from this pod to the peer.

        By default, this will create an egress network policy for this pod, and an ingress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            web.connections.allowTo(redis, { isolation: Isolation.POD })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            web.connections.allowTo(redis, { isolation: Isolation.PEER })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__07a4840e7feddbe3de69e64786abba64fa6e77b897cc8e702f730bfc21938273)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowToOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowTo", [peer, options]))

    @jsii.member(jsii_name="isolate")
    def isolate(self) -> None:
        '''Sets the default network policy for Pod/Workload to have all egress and ingress connections as disabled.'''
        return typing.cast(None, jsii.invoke(self, "isolate", []))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodConnectionsAllowFromOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowFromOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowFrom``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b92ca03da29390f031b2ab47dd41ea10c03f5cda7f2509512ed0497860cb8f0b)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow incoming traffic to.

        :default: - The pod ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowFromOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodConnectionsAllowToOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowToOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowTo``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__25f8c0655a65b539b3ed26d88603e5a6556009a0927add917c1eb682f83fa62a)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowToOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.PodConnectionsIsolation")
class PodConnectionsIsolation(enum.Enum):
    '''Isolation determines which policies are created when allowing connections from a a pod / workload to peers.'''

    POD = "POD"
    '''Only creates network policies that select the pod.'''
    PEER = "PEER"
    '''Only creates network policies that select the peer.'''


class PodDns(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.PodDns"):
    '''Holds dns settings of the pod.'''

    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        props = PodDnsProps(
            hostname=hostname,
            hostname_as_fqdn=hostname_as_fqdn,
            nameservers=nameservers,
            options=options,
            policy=policy,
            searches=searches,
            subdomain=subdomain,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addNameserver")
    def add_nameserver(self, *nameservers: builtins.str) -> None:
        '''Add a nameserver.

        :param nameservers: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53472d993adfa0e08e327a11bca6944785390a66742c80483d82ac2c8ead0799)
            check_type(argname="argument nameservers", value=nameservers, expected_type=typing.Tuple[type_hints["nameservers"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addNameserver", [*nameservers]))

    @jsii.member(jsii_name="addOption")
    def add_option(self, *options: DnsOption) -> None:
        '''Add a custom option.

        :param options: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41ff9293c7b373f773c543c6b20e9bcaff3a8c8d1eaa19c27a0eb74d38a38fe9)
            check_type(argname="argument options", value=options, expected_type=typing.Tuple[type_hints["options"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addOption", [*options]))

    @jsii.member(jsii_name="addSearch")
    def add_search(self, *searches: builtins.str) -> None:
        '''Add a search domain.

        :param searches: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__338f6a3f61de5cf08c22c4529066ee579584cecc56a4ce5f227ae1380865b0bc)
            check_type(argname="argument searches", value=searches, expected_type=typing.Tuple[type_hints["searches"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSearch", [*searches]))

    @builtins.property
    @jsii.member(jsii_name="hostnameAsFQDN")
    def hostname_as_fqdn(self) -> builtins.bool:
        '''Whether or not the pods hostname is set to its FQDN.'''
        return typing.cast(builtins.bool, jsii.get(self, "hostnameAsFQDN"))

    @builtins.property
    @jsii.member(jsii_name="nameservers")
    def nameservers(self) -> typing.List[builtins.str]:
        '''Nameservers defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "nameservers"))

    @builtins.property
    @jsii.member(jsii_name="options")
    def options(self) -> typing.List[DnsOption]:
        '''Custom dns options defined for this pod.'''
        return typing.cast(typing.List[DnsOption], jsii.get(self, "options"))

    @builtins.property
    @jsii.member(jsii_name="policy")
    def policy(self) -> DnsPolicy:
        '''The DNS policy of this pod.'''
        return typing.cast(DnsPolicy, jsii.get(self, "policy"))

    @builtins.property
    @jsii.member(jsii_name="searches")
    def searches(self) -> typing.List[builtins.str]:
        '''Search domains defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "searches"))

    @builtins.property
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> typing.Optional[builtins.str]:
        '''The configured hostname of the pod.

        Undefined means its set to a system-defined value.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "hostname"))

    @builtins.property
    @jsii.member(jsii_name="subdomain")
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''The configured subdomain of the pod.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subdomain"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodDnsProps",
    jsii_struct_bases=[],
    name_mapping={
        "hostname": "hostname",
        "hostname_as_fqdn": "hostnameAsFQDN",
        "nameservers": "nameservers",
        "options": "options",
        "policy": "policy",
        "searches": "searches",
        "subdomain": "subdomain",
    },
)
class PodDnsProps:
    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for ``PodDns``.

        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d314e640804147b8c9ea57a090625b9b9d9b779cf53f9a57819d916d6da6a87b)
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument hostname_as_fqdn", value=hostname_as_fqdn, expected_type=type_hints["hostname_as_fqdn"])
            check_type(argname="argument nameservers", value=nameservers, expected_type=type_hints["nameservers"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument policy", value=policy, expected_type=type_hints["policy"])
            check_type(argname="argument searches", value=searches, expected_type=type_hints["searches"])
            check_type(argname="argument subdomain", value=subdomain, expected_type=type_hints["subdomain"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hostname is not None:
            self._values["hostname"] = hostname
        if hostname_as_fqdn is not None:
            self._values["hostname_as_fqdn"] = hostname_as_fqdn
        if nameservers is not None:
            self._values["nameservers"] = nameservers
        if options is not None:
            self._values["options"] = options
        if policy is not None:
            self._values["policy"] = policy
        if searches is not None:
            self._values["searches"] = searches
        if subdomain is not None:
            self._values["subdomain"] = subdomain

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''Specifies the hostname of the Pod.

        :default: - Set to a system-defined value.
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hostname_as_fqdn(self) -> typing.Optional[builtins.bool]:
        '''If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).

        In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
        In Windows containers, this means setting the registry value of hostname for the registry
        key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN.
        If a pod does not have FQDN, this has no effect.

        :default: false
        '''
        result = self._values.get("hostname_as_fqdn")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def nameservers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses that will be used as DNS servers for the Pod.

        There can be at most 3 IP addresses specified.
        When the policy is set to "NONE", the list must contain at least one IP address,
        otherwise this property is optional.
        The servers listed will be combined to the base nameservers generated from
        the specified DNS policy with duplicate addresses removed.
        '''
        result = self._values.get("nameservers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.List[DnsOption]]:
        '''List of objects where each object may have a name property (required) and a value property (optional).

        The contents in this property
        will be merged to the options generated from the specified DNS policy.
        Duplicate entries are removed.
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.List[DnsOption]], result)

    @builtins.property
    def policy(self) -> typing.Optional[DnsPolicy]:
        '''Set DNS policy for the pod.

        If policy is set to ``None``, other configuration must be supplied.

        :default: DnsPolicy.CLUSTER_FIRST
        '''
        result = self._values.get("policy")
        return typing.cast(typing.Optional[DnsPolicy], result)

    @builtins.property
    def searches(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of DNS search domains for hostname lookup in the Pod.

        When specified, the provided list will be merged into the base
        search domain names generated from the chosen DNS policy.
        Duplicate domain names are removed.

        Kubernetes allows for at most 6 search domains.
        '''
        result = self._values.get("searches")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''If specified, the fully qualified Pod hostname will be "...svc.".

        :default: - No subdomain.
        '''
        result = self._values.get("subdomain")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodDnsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.PodManagementPolicy")
class PodManagementPolicy(enum.Enum):
    '''Controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.

    The default policy is ``OrderedReady``, where pods are created in increasing order
    (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before
    continuing. When scaling down, the pods are removed in the opposite order.

    The alternative policy is ``Parallel`` which will create pods in parallel to match the
    desired scale without waiting, and on scale down will delete all pods at once.
    '''

    ORDERED_READY = "ORDERED_READY"
    PARALLEL = "PARALLEL"


class PodScheduling(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.PodScheduling"):
    '''Controls the pod scheduling strategy.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__943b32aaf2f4b3f4221dc74299d5c17d22540cfbced0cabb280022a0e7c82065)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="assign")
    def assign(self, node: NamedNode) -> None:
        '''Assign this pod a specific node by name.

        The scheduler ignores the Pod, and the kubelet on the named node
        tries to place the Pod on that node. Overrules any affinity rules of the pod.

        Some limitations of static assignment are:

        - If the named node does not exist, the Pod will not run, and in some
          cases may be automatically deleted.
        - If the named node does not have the resources to accommodate the Pod,
          the Pod will fail and its reason will indicate why, for example OutOfmemory or OutOfcpu.
        - Node names in cloud environments are not always predictable or stable.

        Will throw is the pod is already assigned to named node.

        Under the hood, this method utilizes the ``nodeName`` property.

        :param node: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9acf743098108adeb69df22aa0e83fab7eea8cd5c49dcc5fc6d87af612c9ec1)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "assign", [node]))

    @jsii.member(jsii_name="attract")
    def attract(
        self,
        node: LabeledNode,
        *,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Attract this pod to a node matched by selectors. You can select a node by using ``Node.labeled()``.

        Attracting to multiple nodes (i.e invoking this method multiple times) acts as
        an OR condition, meaning the pod will be assigned to either one of the nodes.

        Under the hood, this method utilizes the ``nodeAffinity`` property.

        :param node: -
        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea96dc925c96a82a2907341584acff1ea45369d5806350bf85a25bc7299d51ad)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        options = PodSchedulingAttractOptions(weight=weight)

        return typing.cast(None, jsii.invoke(self, "attract", [node, options]))

    @jsii.member(jsii_name="colocate")
    def colocate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Co-locate this pod with a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Co-locating with multiple selections ((i.e invoking this method multiple times)) acts as
        an AND condition. meaning the pod will be assigned to a node that satisfies all
        selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAffinity`` property.

        :param selector: -
        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72a3da8cf2dfcd5fcdc247ff96c0bf57ee50acddb6206d66bb355d00117c6dd7)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingColocateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "colocate", [selector, options]))

    @jsii.member(jsii_name="separate")
    def separate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Seperate this pod from a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Seperating from multiple selections acts as an AND condition. meaning the pod
        will not be assigned to a node that satisfies all selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAntiAffinity`` property.

        :param selector: -
        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__07b262df67dd9f063d9135e8ec0bda3806a36d0fcfb85d1696372a4c1c982def)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingSeparateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "separate", [selector, options]))

    @jsii.member(jsii_name="tolerate")
    def tolerate(self, node: "TaintedNode") -> None:
        '''Allow this pod to tolerate taints matching these tolerations.

        You can put multiple taints on the same node and multiple tolerations on the same pod.
        The way Kubernetes processes multiple taints and tolerations is like a filter: start with
        all of a node's taints, then ignore the ones for which the pod has a matching toleration;
        the remaining un-ignored taints have the indicated effects on the pod. In particular:

        - if there is at least one un-ignored taint with effect NoSchedule then Kubernetes will
          not schedule the pod onto that node
        - if there is no un-ignored taint with effect NoSchedule but there is at least one un-ignored
          taint with effect PreferNoSchedule then Kubernetes will try to not schedule the pod onto the node
        - if there is at least one un-ignored taint with effect NoExecute then the pod will be evicted from
          the node (if it is already running on the node), and will not be scheduled onto the node (if it is
          not yet running on the node).

        Under the hood, this method utilizes the ``tolerations`` property.

        :param node: -

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae13ee0ca481322c9ba387ffc8c4a694cc1cbc6eaf4076d0c9637aaf98a70d7d)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "tolerate", [node]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodSchedulingAttractOptions",
    jsii_struct_bases=[],
    name_mapping={"weight": "weight"},
)
class PodSchedulingAttractOptions:
    def __init__(self, *, weight: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``PodScheduling.attract``.

        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__617f1d53b7777ffeaa53367e3ffb3fe1faef7b848ee2653689eeb32dca4331f8)
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the attraction is optional (soft), with this weight score.

        :default: - no weight. assignment is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingAttractOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodSchedulingColocateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingColocateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.colocate``.

        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db2c46852c45299507caebb9f4a1a0207ec022478481268f38fda963a875f71f)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to coloate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the co-location is optional (soft), with this weight score.

        :default: - no weight. co-location is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingColocateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodSchedulingSeparateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingSeparateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.separate``.

        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__108b330be0433658b66008b0b13f6dd41b08b0c48da26f2f61895a857af84121)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to separate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the separation is optional (soft), with this weight score.

        :default: - no weight. separation is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingSeparateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PodSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.PodSecurityContext",
):
    '''Holds pod-level security attributes and common container settings.'''

    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        props = PodSecurityContextProps(
            ensure_non_root=ensure_non_root,
            fs_group=fs_group,
            fs_group_change_policy=fs_group_change_policy,
            group=group,
            sysctls=sysctls,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="fsGroupChangePolicy")
    def fs_group_change_policy(self) -> FsGroupChangePolicy:
        return typing.cast(FsGroupChangePolicy, jsii.get(self, "fsGroupChangePolicy"))

    @builtins.property
    @jsii.member(jsii_name="sysctls")
    def sysctls(self) -> typing.List["Sysctl"]:
        return typing.cast(typing.List["Sysctl"], jsii.get(self, "sysctls"))

    @builtins.property
    @jsii.member(jsii_name="fsGroup")
    def fs_group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "fsGroup"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "ensure_non_root": "ensureNonRoot",
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "group": "group",
        "sysctls": "sysctls",
        "user": "user",
    },
)
class PodSecurityContextProps:
    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``PodSecurityContext``.

        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef35fee550055441d64c343db9745b5f068f977b94a0d9a1ec3e2f059f65816d)
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if group is not None:
            self._values["group"] = group
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''Modify the ownership and permissions of pod volumes to this GID.

        :default: - Volume ownership is not changed.
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[FsGroupChangePolicy]:
        '''Defines behavior of changing ownership and permission of the volume before being exposed inside Pod.

        This field will only apply to volume types which support fsGroup based ownership(and permissions).
        It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.

        :default: FsGroupChangePolicy.ALWAYS
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[FsGroupChangePolicy], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default: - Group configured by container runtime
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sysctls(self) -> typing.Optional[typing.List["Sysctl"]]:
        '''Sysctls hold a list of namespaced sysctls used for the pod.

        Pods with unsupported sysctls (by the container runtime) might fail to launch.

        :default: - No sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["Sysctl"]], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default: - User specified in image metadata
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "namespaces": "namespaces"},
)
class PodSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: LabelSelector,
        namespaces: typing.Optional[typing.Union[NamespaceSelectorConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for selecting pods, optionally in particular namespaces.

        :param label_selector: A selector to select pods by labels.
        :param namespaces: Configuration for selecting which namepsaces are the pods allowed to be in.
        '''
        if isinstance(namespaces, dict):
            namespaces = NamespaceSelectorConfig(**namespaces)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf4988124db449cdf6106956707a252de9a416355c9e800c2bcf75301c8a03fd)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "label_selector": label_selector,
        }
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def label_selector(self) -> LabelSelector:
        '''A selector to select pods by labels.'''
        result = self._values.get("label_selector")
        assert result is not None, "Required property 'label_selector' is missing"
        return typing.cast(LabelSelector, result)

    @builtins.property
    def namespaces(self) -> typing.Optional[NamespaceSelectorConfig]:
        '''Configuration for selecting which namepsaces are the pods allowed to be in.'''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[NamespaceSelectorConfig], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector)
class Pods(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.Pods",
):
    '''Represents a group of pods.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[INamespaceSelector] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param labels: -
        :param namespaces: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36a42161d7e9d26550f9361e7a06eefb3097f9cbd6cf38ef5e4e45a074f7af93)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        jsii.create(self.__class__, self, [scope, id, expressions, labels, namespaces])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select all pods.

        :param scope: -
        :param id: -
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47e931054429b955d212e7848dbd350b5741a34c1c75b3c4bbfcfe56c6f93999)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsAllOptions(namespaces=namespaces)

        return typing.cast("Pods", jsii.sinvoke(cls, "all", [scope, id, options]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select pods in the cluster with various selectors.

        :param scope: -
        :param id: -
        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c2916fdeea35dbef17131b798959251c51aba66e39a944df4ba361549e9440b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsSelectOptions(
            expressions=expressions, labels=labels, namespaces=namespaces
        )

        return typing.cast("Pods", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''
        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''
        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodsAllOptions",
    jsii_struct_bases=[],
    name_mapping={"namespaces": "namespaces"},
)
class PodsAllOptions:
    def __init__(self, *, namespaces: typing.Optional[Namespaces] = None) -> None:
        '''Options for ``Pods.all``.

        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__049a90349320c8c63b0245d1d5fa9b461b16de1c6f488795536f381051d899a9)
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsAllOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodsSelectOptions",
    jsii_struct_bases=[],
    name_mapping={
        "expressions": "expressions",
        "labels": "labels",
        "namespaces": "namespaces",
    },
)
class PodsSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> None:
        '''Options for ``Pods.select``.

        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__340a9873f7127591db7880c321be2754d1a4a2785823549e6943b9d93ddf2ecf)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expressions the pods must satisify.

        :default: - no expressions requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the pods must have.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Probe(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Probe"):
    '''Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(
        cls,
        command: typing.Sequence[builtins.str],
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on a command which is executed within the container.

        :param command: The command to execute.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33fc293d369521cc6e1818e852953a365b18dbf2feae961c244de16053041d67)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        options = CommandProbeOptions(
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromCommand", [command, options]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9692b2a84438685e12c46fd68a82e328f694e7a93efc05a28d590d7520e4ca3a)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HttpGetProbeOptions(
            host=host,
            port=port,
            scheme=scheme,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        options = TcpSocketProbeOptions(
            host=host,
            port=port,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ProbeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class ProbeOptions:
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Probe options.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51a0d9d21f2bb97938134aded193351ca5c3fbaae2067c1f319a04079915a21c)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.Protocol")
class Protocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


class Replicas(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Replicas"):
    '''The amount of replicas that will change.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The amount of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2fc6a9f73bd20141fa833342d3461c3d87effab78c9f6f36ea8de9082d509060)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "absolute", [value]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The percentage of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53e02a57500b309aabecfccd79425a9df4c75cb9f07eecaeaa4a0d4ffd64ab37)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "percent", [value]))


@jsii.implements(IResource, IApiResource, IApiEndpoint)
class Resource(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-28.Resource",
):
    '''Base class for all Kubernetes objects in stdk8s.

    Represents a single
    resource.
    '''

    def __init__(self, scope: _constructs_77d1e7e8.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b35facc4de0975aeb510f6c2e40b5c2d77c4adcc0be89fc5fabb86a3c1650748)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. "authorization.k8s.io").'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    @abc.abstractmethod
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "metadata"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of this API object.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="permissions")
    def permissions(self) -> "ResourcePermissions":
        return typing.cast("ResourcePermissions", jsii.get(self, "permissions"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    @abc.abstractmethod
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))


class _ResourceProxy(Resource):
    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Resource).__jsii_proxy_class__ = lambda : _ResourceProxy


@jsii.enum(jsii_type="cdk8s-plus-28.ResourceFieldPaths")
class ResourceFieldPaths(enum.Enum):
    CPU_LIMIT = "CPU_LIMIT"
    '''CPU limit of the container.'''
    MEMORY_LIMIT = "MEMORY_LIMIT"
    '''Memory limit of the container.'''
    CPU_REQUEST = "CPU_REQUEST"
    '''CPU request of the container.'''
    MEMORY_REQUEST = "MEMORY_REQUEST"
    '''Memory request of the container.'''
    STORAGE_LIMIT = "STORAGE_LIMIT"
    '''Ephemeral storage limit of the container.'''
    STORAGE_REQUEST = "STORAGE_REQUEST"
    '''Ephemeral storage request of the container.'''


class ResourcePermissions(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ResourcePermissions",
):
    '''Controls permissions for operations on resources.'''

    def __init__(self, instance: Resource) -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f1850a6dfb14d535df2eb41a397fb86e5612799509d2398fc3c161cdd3686ae4)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="grantRead")
    def grant_read(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f8c79b9feabd99bffe780b1c24094545f578d3511b442aeb152ec84bf3f4b807)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantRead", [*subjects]))

    @jsii.member(jsii_name="grantReadWrite")
    def grant_read_write(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read and write this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__925d87bcd4e631cb9d441a741f6dbd27965d90304f4d549dc0183575ae372530)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantReadWrite", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> Resource:
        return typing.cast(Resource, jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ResourceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata"},
)
class ResourceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Initialization properties for resources.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8740ca29d3847f8f8f05599f678a8f87ee3a03a67442ef506992a202a86763f8)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.RestartPolicy")
class RestartPolicy(enum.Enum):
    '''Restart policy for all containers within the pod.'''

    ALWAYS = "ALWAYS"
    '''Always restart the pod after it exits.'''
    ON_FAILURE = "ON_FAILURE"
    '''Only restart if the pod exits with a non-zero exit code.'''
    NEVER = "NEVER"
    '''Never restart the pod.'''


@jsii.implements(IRole)
class Role(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Role"):
    '''Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        rules: typing.Optional[typing.Sequence[typing.Union["RolePolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7c8bf90897cc6b3f0bdc6f3e6e91758dde2b879714f3ef6195f19bfd60aa3ac)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleProps(rules=rules, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromRoleName")
    @builtins.classmethod
    def from_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df4d2a5d79c711e53ba24819751bf5ff1c71f4573268aaa77ba2ca2df18e1949)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IRole, jsii.sinvoke(cls, "fromRoleName", [scope, id, name]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *resources: IApiResource,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param resources: The resource(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__619606559fa7e43b80ebf1964d81574ff5653ab69084121593d6a3200186742a)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *resources]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *resources: IApiResource) -> None:
        '''Add "create" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6043784b9e8810d4f7565b923ca0a8c757aecb2c0de5bdf66c0970dca2e0bea)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*resources]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *resources: IApiResource) -> None:
        '''Add "delete" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a13a43b9bff22f75720d940ecbbc5ab174663e456119db301d5f4cae2d17f88e)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*resources]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *resources: IApiResource) -> None:
        '''Add "deletecollection" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06512bb17de24bf84cf05b8f31b87b5ed39168bf7ae349439883ce42d9be22b2)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*resources]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *resources: IApiResource) -> None:
        '''Add "get" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__593eb905806140027a67bb7dd1d567759ea2a9785114f9ec020ee7e7a2366ada)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*resources]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *resources: IApiResource) -> None:
        '''Add "list" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c53ffedeac24df85df6bd541560b98e06dd8db3e34d8817f76ef03ea0e420cc)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*resources]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *resources: IApiResource) -> None:
        '''Add "patch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d76c75977e653da0803324e19173e73a30bc95e9b2bab84403f3d16463d9403f)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*resources]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *resources: IApiResource) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b347295045a862fe2df0a0eba7fb8e2c9be3de6affdd8febebd7a3a420ea33d)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*resources]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *resources: IApiResource) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb3d9dfdf6f1ec095c2d61e97e4ad3b83914c06d83b06e936eb0cb524d478ed4)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*resources]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *resources: IApiResource) -> None:
        '''Add "update" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0fd1595bf4c27772a599779f82aceee9cfce0828db73aa0c60e6debfce238cb)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*resources]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *resources: IApiResource) -> None:
        '''Add "watch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70c63acb27e08a269677753e890009db6c5a4e27ab3a653c2a885d079901cdce)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*resources]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> "RoleBinding":
        '''Create a RoleBinding that binds the permissions in this Role to a list of subjects, that will only apply this role's namespace.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce91574b45af5c47b8b821ab83361fe0c3a514045714fed4e850eb1a1d7e3e53)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "bind", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List["RolePolicyRule"]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List["RolePolicyRule"], jsii.get(self, "rules"))


class RoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.RoleBinding",
):
    '''A RoleBinding grants permissions within a specific namespace to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: IRole,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__87fe083db45eec58fa74f3ca974f48bf1662a2c6203f060e2c4a4177e58f6086)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__381cf1caeafe2d0dca69072cda692660a28209b04e007da59694c81b4fa46c7d)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> IRole:
        return typing.cast(IRole, jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.RoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class RoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: IRole,
    ) -> None:
        '''Properties for ``RoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8f16c638138acd63e27dfe2f9d3da0b9cce68f9d131dc797113f9e3a26b105b)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> IRole:
        '''The role to bind to.

        A RoleBinding can reference a Role or a ClusterRole.
        '''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast(IRole, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.RolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"resources": "resources", "verbs": "verbs"},
)
class RolePolicyRule:
    def __init__(
        self,
        *,
        resources: typing.Sequence[IApiResource],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `Role.

        :param resources: Resources this rule applies to.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__954ca48818e0ceaad4907e6b6dea21a66c55f8c90e7c91456c4390795665ae88)
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "resources": resources,
            "verbs": verbs,
        }

    @builtins.property
    def resources(self) -> typing.List[IApiResource]:
        '''Resources this rule applies to.'''
        result = self._values.get("resources")
        assert result is not None, "Required property 'resources' is missing"
        return typing.cast(typing.List[IApiResource], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.RoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "rules": "rules"},
)
class RoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[RolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Role``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70646a59861277c5f53aaf93fc2eb8cac2dd48ae5dff7c28a5846d5e8a2c2884)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[RolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[RolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ScalingPolicy",
    jsii_struct_bases=[],
    name_mapping={"replicas": "replicas", "duration": "duration"},
)
class ScalingPolicy:
    def __init__(
        self,
        *,
        replicas: Replicas,
        duration: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''
        :param replicas: The type and quantity of replicas to change.
        :param duration: The amount of time the scaling policy has to continue scaling before the target metric must be revalidated. Must be greater than 0 seconds and no longer than 30 minutes. Default: - 15 seconds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a0732bd91dcc0654cc27d69174c2074091242621d5a64ace8f66339f8a25cdf9)
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument duration", value=duration, expected_type=type_hints["duration"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "replicas": replicas,
        }
        if duration is not None:
            self._values["duration"] = duration

    @builtins.property
    def replicas(self) -> Replicas:
        '''The type and quantity of replicas to change.'''
        result = self._values.get("replicas")
        assert result is not None, "Required property 'replicas' is missing"
        return typing.cast(Replicas, result)

    @builtins.property
    def duration(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The amount of time the scaling policy has to continue scaling before the target metric must be revalidated.

        Must be greater than 0 seconds and no longer than 30 minutes.

        :default: - 15 seconds
        '''
        result = self._values.get("duration")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ScalingRules",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "stabilization_window": "stabilizationWindow",
        "strategy": "strategy",
    },
)
class ScalingRules:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[ScalingPolicy, typing.Dict[builtins.str, typing.Any]]]] = None,
        stabilization_window: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        strategy: typing.Optional["ScalingStrategy"] = None,
    ) -> None:
        '''Defines the scaling behavior for one direction.

        :param policies: The scaling policies. Default: - Scale up - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds - Scale down - Decrease to minReplica count
        :param stabilization_window: Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur. Minimum duration is 1 second, max is 1 hour. Default: - On scale down no stabilization is performed. - On scale up stabilization is performed for 5 minutes.
        :param strategy: The strategy to use when scaling. Default: MAX_CHANGE
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__843324ee70367d3727baf1b9f3e228788749ed4e096492925923b9c36de71286)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument stabilization_window", value=stabilization_window, expected_type=type_hints["stabilization_window"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if stabilization_window is not None:
            self._values["stabilization_window"] = stabilization_window
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[ScalingPolicy]]:
        '''The scaling policies.

        :default:

        - Scale up

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds

        - Scale down

        - Decrease to minReplica count
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[ScalingPolicy]], result)

    @builtins.property
    def stabilization_window(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur.

        Minimum duration is 1 second, max is 1 hour.

        :default:

        - On scale down no stabilization is performed.
        - On scale up stabilization is performed for 5 minutes.

        Example::

            stabilizationWindow: Duration.minutes(30)
            // Autoscaler considers the last 30 minutes of metrics when deciding whether to scale.
        '''
        result = self._values.get("stabilization_window")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def strategy(self) -> typing.Optional["ScalingStrategy"]:
        '''The strategy to use when scaling.

        :default: MAX_CHANGE
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["ScalingStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.ScalingStrategy")
class ScalingStrategy(enum.Enum):
    MAX_CHANGE = "MAX_CHANGE"
    '''Use the policy that provisions the most changes.'''
    MIN_CHANGE = "MIN_CHANGE"
    '''Use the policy that provisions the least amount of changes.'''
    DISABLED = "DISABLED"
    '''(deprecated) Disables scaling in this direction.

    :deprecated: - Omit the ScalingRule instead

    :stability: deprecated
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ScalingTarget",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "containers": "containers",
        "kind": "kind",
        "name": "name",
        "replicas": "replicas",
    },
)
class ScalingTarget:
    def __init__(
        self,
        *,
        api_version: builtins.str,
        containers: typing.Sequence[Container],
        kind: builtins.str,
        name: builtins.str,
        replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties used to configure the target of an Autoscaler.

        :param api_version: The object's API version (e.g. "authorization.k8s.io/v1").
        :param containers: Container definitions associated with the target.
        :param kind: The object kind (e.g. "Deployment").
        :param name: The Kubernetes name of this resource.
        :param replicas: The fixed number of replicas defined on the target. This is used for validation purposes as Scalable targets should not have a fixed number of replicas.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9afaeaae81cba19201a2349019a52c7f9247d067427e5efb8715acfb5694727)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_version": api_version,
            "containers": containers,
            "kind": kind,
            "name": name,
        }
        if replicas is not None:
            self._values["replicas"] = replicas

    @builtins.property
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        result = self._values.get("api_version")
        assert result is not None, "Required property 'api_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def containers(self) -> typing.List[Container]:
        '''Container definitions associated with the target.'''
        result = self._values.get("containers")
        assert result is not None, "Required property 'containers' is missing"
        return typing.cast(typing.List[Container], result)

    @builtins.property
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''The fixed number of replicas defined on the target.

        This is used
        for validation purposes as Scalable targets should not have a
        fixed number of replicas.
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingTarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISecret)
class Secret(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Secret"):
    '''Kubernetes Secrets let you store and manage sensitive information, such as passwords, OAuth tokens, and ssh keys.

    Storing confidential information in a
    Secret is safer and more flexible than putting it verbatim in a Pod
    definition or in a container image.

    :see: https://kubernetes.io/docs/concepts/configuration/secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0c86a2015930579e2d89203ab8d742bc400ce8cb08b87576ff685ecad899070)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SecretProps(
            string_data=string_data, type=type, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromSecretName")
    @builtins.classmethod
    def from_secret_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> ISecret:
        '''Imports a secret from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f412f98e415ef4f6506db3a0868778167e9fd0b5d22a9374e2afaba663a8d0c0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(ISecret, jsii.sinvoke(cls, "fromSecretName", [scope, id, name]))

    @jsii.member(jsii_name="addStringData")
    def add_string_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a string data field to the secert.

        :param key: Key.
        :param value: Value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__186b21045f9345fed1e36503a837f4b864c4a26892364f99e6d1edd08bb8e82d)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addStringData", [key, value]))

    @jsii.member(jsii_name="envValue")
    def env_value(
        self,
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> EnvValue:
        '''Returns EnvValue object from a secret's key.

        :param key: -
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__149c893f653f22b7d47f06c7772f1bf69cd79dbb30504d1bde35e6e31fceb48a)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast(EnvValue, jsii.invoke(self, "envValue", [key, options]))

    @jsii.member(jsii_name="getStringData")
    def get_string_data(self, key: builtins.str) -> typing.Optional[builtins.str]:
        '''Gets a string data by key or undefined.

        :param key: Key.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e34209f8a7120aac7d49fb5e149cf92ae560e303c9684e9dd14a44ca7c760c79)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getStringData", [key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not the secret is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.SecretValue",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "secret": "secret"},
)
class SecretValue:
    def __init__(self, *, key: builtins.str, secret: ISecret) -> None:
        '''Represents a specific value in JSON secret.

        :param key: The JSON key.
        :param secret: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27933b70efae44ea15caae669e4579b176041b63c7009720b8ab7ef109f3b9b4)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "secret": secret,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''The JSON key.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def secret(self) -> ISecret:
        '''The secret.'''
        result = self._values.get("secret")
        assert result is not None, "Required property 'secret' is missing"
        return typing.cast(ISecret, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.SecretVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class SecretVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the Secret-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20062f3550643cfa89dda325d484bbc79e90fb6ad653deae6f030c8226d4de22)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, PathMapping]]:
        '''If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the secret, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, PathMapping]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the secret or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Service(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Service"):
    '''An abstract way to expose an application running on a set of Pods as a network service.

    With Kubernetes you don't need to modify your application to use an unfamiliar service discovery mechanism.
    Kubernetes gives Pods their own IP addresses and a single DNS name for a set of Pods, and can load-balance across them.

    For example, consider a stateless image-processing backend which is running with 3 replicas. Those replicas are fungible—frontends do not care which backend they use.
    While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that,
    nor should they need to keep track of the set of backends themselves.
    The Service abstraction enables this decoupling.

    If you're able to use Kubernetes APIs for service discovery in your application, you can query the API server for Endpoints,
    that get updated whenever the set of Pods in a Service changes. For non-native applications, Kubernetes offers ways to place a network port
    or load balancer in between your application and the backend Pods.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef15c4cfa8df13f4d9448222d6c9a7809a8fdb30e73678c4c32203e75f4325b0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceProps(
            cluster_ip=cluster_ip,
            external_i_ps=external_i_ps,
            external_name=external_name,
            load_balancer_source_ranges=load_balancer_source_ranges,
            ports=ports,
            selector=selector,
            type=type,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="bind")
    def bind(
        self,
        port: jsii.Number,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Configure a port the service will bind to.

        This method can be called multiple times.

        :param port: The port definition.
        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79ae0bfd688d407076e95eb9890d1df12c6ec9a62b7253be9077dcd485d73892)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        options = ServiceBindOptions(
            name=name, node_port=node_port, protocol=protocol, target_port=target_port
        )

        return typing.cast(None, jsii.invoke(self, "bind", [port, options]))

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> "Ingress":
        '''Expose a service via an ingress using the specified path.

        :param path: The path to expose the service under.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX

        :return: The ``Ingress`` resource that was used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c5a081e81ef736e84a0cd8edfb0968875385174affdc2f3b379dacf39ebf7e3a)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeServiceViaIngressOptions(ingress=ingress, path_type=path_type)

        return typing.cast("Ingress", jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="select")
    def select(self, selector: IPodSelector) -> None:
        '''Require this service to select pods matching the selector.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c883c8a62280e5703c392654d052b7cf8be30a1193a4db18c74ea1dbd0642a7c)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        return typing.cast(None, jsii.invoke(self, "select", [selector]))

    @jsii.member(jsii_name="selectLabel")
    def select_label(self, key: builtins.str, value: builtins.str) -> None:
        '''Require this service to select pods with this label.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4a941067b3c70493a0879b8e3abe3bed6949f237158813cf8b4e5f0933e1118)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "selectLabel", [key, value]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> jsii.Number:
        '''Return the first port of the service.'''
        return typing.cast(jsii.Number, jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ServicePort"]:
        '''Ports for this service.

        Use ``bind()`` to bind additional service ports.
        '''
        return typing.cast(typing.List["ServicePort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> "ServiceType":
        '''Determines how the Service is exposed.'''
        return typing.cast("ServiceType", jsii.get(self, "type"))

    @builtins.property
    @jsii.member(jsii_name="clusterIP")
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterIP"))

    @builtins.property
    @jsii.member(jsii_name="externalName")
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used for EXTERNAL_NAME types.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "externalName"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServiceAccountProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_token": "automountToken",
        "secrets": "secrets",
    },
)
class ServiceAccountProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
    ) -> None:
        '''Properties for initialization of ``ServiceAccount``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f6692c3cb5d4c4aa57cd57c71a6385bcbff4d9305ed5238622dfcb837d1e49d7)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_token", value=automount_token, expected_type=type_hints["automount_token"])
            check_type(argname="argument secrets", value=secrets, expected_type=type_hints["secrets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_token is not None:
            self._values["automount_token"] = automount_token
        if secrets is not None:
            self._values["secrets"] = secrets

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether pods running as this service account should have an API token automatically mounted.

        Can be overridden at the pod level.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secrets(self) -> typing.Optional[typing.List[ISecret]]:
        '''List of secrets allowed to be used by pods running using this ServiceAccount.

        :see: https://kubernetes.io/docs/concepts/configuration/secret
        '''
        result = self._values.get("secrets")
        return typing.cast(typing.Optional[typing.List[ISecret]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ServiceAccountTokenSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ServiceAccountTokenSecret",
):
    '''Create a secret for a service account token.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        service_account: "IServiceAccount",
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param service_account: The service account to store a secret for.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8f6a598e5e54455e92bae17ab117f320e3b71119eb816e329879fbfe8255495)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountTokenSecretProps(
            service_account=service_account, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServiceBindOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
    },
)
class ServiceBindOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Service.bind``.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0c0c6643ea6339657f8ee9c73fdc4b8ac83aed07ee694c3e480484ce3e93a5a)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceBindOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServiceIngressBackendOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class ServiceIngressBackendOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for setting up backends for ingress rules.

        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db7b0ddaf352f435a3a11097fcbf3a8f1d7ad0536ccfffff857c28200a7c5f4f)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port to use to access the service.

        - This option will fail if the service does not expose any ports.
        - If the service exposes multiple ports, this option must be specified.
        - If the service exposes a single port, this option is optional and if
          specified, it must be the same port exposed by the service.

        :default: - if the service exposes a single port, this port will be used.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceIngressBackendOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServicePort",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class ServicePort(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: jsii.Number,
    ) -> None:
        '''Definition of a service port.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cc0ad7065c1757e5fbc3528265b5e4792f5039fd97fd3dc69aa3dd6a64c3714)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> jsii.Number:
        '''The port number the service will bind to.'''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServicePort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServiceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "cluster_ip": "clusterIP",
        "external_i_ps": "externalIPs",
        "external_name": "externalName",
        "load_balancer_source_ranges": "loadBalancerSourceRanges",
        "ports": "ports",
        "selector": "selector",
        "type": "type",
    },
)
class ServiceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Properties for ``Service``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cdebc3169db7a6c6f9bbfbac9d9b3ac77f6943194923f6e8f437e8085612dc05)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument cluster_ip", value=cluster_ip, expected_type=type_hints["cluster_ip"])
            check_type(argname="argument external_i_ps", value=external_i_ps, expected_type=type_hints["external_i_ps"])
            check_type(argname="argument external_name", value=external_name, expected_type=type_hints["external_name"])
            check_type(argname="argument load_balancer_source_ranges", value=load_balancer_source_ranges, expected_type=type_hints["load_balancer_source_ranges"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if cluster_ip is not None:
            self._values["cluster_ip"] = cluster_ip
        if external_i_ps is not None:
            self._values["external_i_ps"] = external_i_ps
        if external_name is not None:
            self._values["external_name"] = external_name
        if load_balancer_source_ranges is not None:
            self._values["load_balancer_source_ranges"] = load_balancer_source_ranges
        if ports is not None:
            self._values["ports"] = ports
        if selector is not None:
            self._values["selector"] = selector
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.

        If an address is specified manually and is not in use by others, it
        will be allocated to the service; otherwise, creation of the service will
        fail. This field can not be changed through updates. Valid values are
        "None", empty string (""), or a valid IP address. "None" can be specified
        for headless services when proxying is not required. Only applies to types
        ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.

        :default: - Automatically assigned.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        '''
        result = self._values.get("cluster_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def external_i_ps(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses for which nodes in the cluster will also accept traffic for this service.

        These IPs are not managed by Kubernetes. The user
        is responsible for ensuring that traffic arrives at a node with this IP. A
        common example is external load-balancers that are not part of the
        Kubernetes system.

        :default: - No external IPs.
        '''
        result = self._values.get("external_i_ps")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used when ServiceType.EXTERNAL_NAME is set.

        :default: - No external name.
        '''
        result = self._values.get("external_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def load_balancer_source_ranges(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.

        More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        '''
        result = self._values.get("load_balancer_source_ranges")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports this service binds to.

        If the selector of the service is a managed pod / workload,
        its ports will are automatically extracted and used as the default value.
        Otherwise, no ports are bound.

        :default: - either the selector ports, or none.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods should the service select and route to.

        You can pass one of the following:

        - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...)
        - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified.

        :default:

        - unset, the service is assumed to have an external process managing
        its endpoints, which Kubernetes will not modify.

        Example::

            // select the pods of a specific deployment
            const backend = new kplus.Deployment(this, 'Backend', ...);
            new kplus.Service(this, 'Service', { selector: backend });
            
            // select all pods labeled with the `tier=backend` label
            const backend = kplus.Pod.labeled({ tier: 'backend' });
            new kplus.Service(this, 'Service', { selector: backend });
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    @builtins.property
    def type(self) -> typing.Optional["ServiceType"]:
        '''Determines how the Service is exposed.

        More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types

        :default: ServiceType.ClusterIP
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.ServiceType")
class ServiceType(enum.Enum):
    '''For some parts of your application (for example, frontends) you may want to expose a Service onto an external IP address, that's outside of your cluster.

    Kubernetes ServiceTypes allow you to specify what kind of Service you want.
    The default is ClusterIP.
    '''

    CLUSTER_IP = "CLUSTER_IP"
    '''Exposes the Service on a cluster-internal IP.

    Choosing this value makes the Service only reachable from within the cluster.
    This is the default ServiceType
    '''
    NODE_PORT = "NODE_PORT"
    '''Exposes the Service on each Node's IP at a static port (the NodePort).

    A ClusterIP Service, to which the NodePort Service routes, is automatically created.
    You'll be able to contact the NodePort Service, from outside the cluster,
    by requesting :.
    '''
    LOAD_BALANCER = "LOAD_BALANCER"
    '''Exposes the Service externally using a cloud provider's load balancer.

    NodePort and ClusterIP Services, to which the external load balancer routes,
    are automatically created.
    '''
    EXTERNAL_NAME = "EXTERNAL_NAME"
    '''Maps the Service to the contents of the externalName field (e.g. foo.bar.example.com), by returning a CNAME record with its value. No proxying of any kind is set up.

    .. epigraph::

       Note: You need either kube-dns version 1.7 or CoreDNS version 0.0.8 or higher to use the ExternalName type.
    '''


class SshAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.SshAuthSecret",
):
    '''Create a secret for ssh authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        ssh_private_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param ssh_private_key: The SSH private key to use.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__861c867839f44477d85b9c6b8a58e80d8d8c95c158df052f10fa419ccdf64691)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SshAuthSecretProps(
            ssh_private_key=ssh_private_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class StatefulSetUpdateStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.StatefulSetUpdateStrategy",
):
    '''StatefulSet update strategies.'''

    @jsii.member(jsii_name="onDelete")
    @builtins.classmethod
    def on_delete(cls) -> "StatefulSetUpdateStrategy":
        '''The controller will not automatically update the Pods in a StatefulSet.

        Users must manually delete Pods to cause the controller to create new Pods
        that reflect modifications.
        '''
        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "onDelete", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        partition: typing.Optional[jsii.Number] = None,
    ) -> "StatefulSetUpdateStrategy":
        '''The controller will delete and recreate each Pod in the StatefulSet.

        It will proceed in the same order as Pod termination (from the largest ordinal to the smallest),
        updating each Pod one at a time. The Kubernetes control plane waits until an updated
        Pod is Running and Ready prior to updating its predecessor.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        options = StatefulSetUpdateStrategyRollingUpdateOptions(partition=partition)

        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.StatefulSetUpdateStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"partition": "partition"},
)
class StatefulSetUpdateStrategyRollingUpdateOptions:
    def __init__(self, *, partition: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``StatefulSetUpdateStrategy.rollingUpdate``.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a46c33c06041dfade17481446e371761288f1b8f2bcb76900448362c59f58136)
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if partition is not None:
            self._values["partition"] = partition

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version.

        If the partition is greater than replicas, updates to the pod template will not be propagated to Pods.
        In most cases you will not need to use a partition, but they are useful if you want to stage an
        update, roll out a canary, or perform a phased roll out.

        :default: 0

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#partitions
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StatefulSetUpdateStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.SubjectConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "name": "name",
        "api_group": "apiGroup",
        "namespace": "namespace",
    },
)
class SubjectConfiguration:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Subject contains a reference to the object or user identities a role binding applies to.

        This can either hold a direct API object reference, or a value
        for non-objects such as user and group names.

        :param kind: Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
        :param name: Name of the object being referenced.
        :param api_group: APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
        :param namespace: Namespace of the referenced object. If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d654295c7963e91cc1624c118a2c04ea6f306bfc6ab0578fe120f4dacf22ec60)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of object being referenced.

        Values defined by this API group are
        "User", "Group", and "ServiceAccount". If the Authorizer does not
        recognized the kind value, the Authorizer should report an error.
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the object being referenced.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''APIGroup holds the API group of the referenced subject.

        Defaults to "" for
        ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User
        and Group subjects.
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Namespace of the referenced object.

        If the object kind is non-namespace,
        such as "User" or "Group", and this value is not empty the Authorizer
        should report an error.
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SubjectConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.Sysctl",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class Sysctl:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''Sysctl defines a kernel parameter to be set.

        :param name: Name of a property to set.
        :param value: Value of a property to set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__181c4946eeda33b70b17ee5da5366c73cda7791647f4c6db8fa6fcbc142b95c2)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of a property to set.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Value of a property to set.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Sysctl(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-28.TaintEffect")
class TaintEffect(enum.Enum):
    '''Taint effects.'''

    NO_SCHEDULE = "NO_SCHEDULE"
    '''This means that no pod will be able to schedule onto the node unless it has a matching toleration.'''
    PREFER_NO_SCHEDULE = "PREFER_NO_SCHEDULE"
    '''This is a "preference" or "soft" version of ``NO_SCHEDULE`` -- the system will try to avoid placing a pod that does not tolerate the taint on the node, but it is not required.'''
    NO_EXECUTE = "NO_EXECUTE"
    '''This affects pods that are already running on the node as follows:.

    - Pods that do not tolerate the taint are evicted immediately.
    - Pods that tolerate the taint without specifying ``duration`` remain bound forever.
    - Pods that tolerate the taint with a specified ``duration`` remain bound for
      the specified amount of time.
    '''


class TaintedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.TaintedNode"):
    '''A node that is matched by taint selectors.'''

    def __init__(self, taint_selector: typing.Sequence[NodeTaintQuery]) -> None:
        '''
        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__211acc4475383bfb628120dce89539ee511227c3abf71a4b9af44716d6382bd7)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=type_hints["taint_selector"])
        jsii.create(self.__class__, self, [taint_selector])

    @builtins.property
    @jsii.member(jsii_name="taintSelector")
    def taint_selector(self) -> typing.List[NodeTaintQuery]:
        return typing.cast(typing.List[NodeTaintQuery], jsii.get(self, "taintSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.TcpSocketProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "host": "host",
        "port": "port",
    },
)
class TcpSocketProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Probe.fromTcpSocket()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55b209b3b818edbf1eb336517a9e86221c1da7bdcd24dbf016567fb89c27302e)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TcpSocketProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TlsSecret(Secret, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.TlsSecret"):
    '''Create a secret for storing a TLS certificate and its associated key.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        tls_cert: builtins.str,
        tls_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1288c4823faf70f43a3e93c2657608b59b37a7b5fbac658b4695b0eba8417855)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = TlsSecretProps(
            tls_cert=tls_cert, tls_key=tls_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class Topology(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Topology"):
    '''Available topology domains.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(cls, key: builtins.str) -> "Topology":
        '''Custom key for the node label that the system uses to denote the topology domain.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a9fa97e9b65b9d7fdd7b08179eedc119fed5569bd74b872770f5af6f6c4eaf9)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("Topology", jsii.sinvoke(cls, "custom", [key]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HOSTNAME")
    def HOSTNAME(cls) -> "Topology":
        '''A hostname represents a single node in the cluster.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetesiohostname
        '''
        return typing.cast("Topology", jsii.sget(cls, "HOSTNAME"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REGION")
    def REGION(cls) -> "Topology":
        '''A region represents a larger domain, made up of one or more zones.

        It is uncommon
        for Kubernetes clusters to span multiple regions. While the exact definition of a
        zone or region is left to infrastructure implementations, common properties of a region
        include higher network latency between them than within them, non-zero cost for network
        traffic between them, and failure independence from other zones or regions.

        For example, nodes within a region might share power infrastructure (e.g. a UPS or generator), but
        nodes in different regions typically would not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesioregion
        '''
        return typing.cast("Topology", jsii.sget(cls, "REGION"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ZONE")
    def ZONE(cls) -> "Topology":
        '''A zone represents a logical failure domain.

        It is common for Kubernetes clusters to
        span multiple zones for increased availability. While the exact definition of a zone is
        left to infrastructure implementations, common properties of a zone include very low
        network latency within a zone, no-cost network traffic within a zone, and failure
        independence from other zones. For example, nodes within a zone might share a network
        switch, but nodes in different zones should not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesiozone
        '''
        return typing.cast("Topology", jsii.sget(cls, "ZONE"))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))


@jsii.implements(ISubject)
class User(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.User",
):
    '''Represents a user.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "User":
        '''Reference a user in the cluster by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5850a1d64b2697fc0f63286d43db3850498b2ee973b00c3d26681b823d217cf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("User", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


@jsii.implements(IStorage)
class Volume(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.Volume",
):
    '''Volume represents a named volume in a pod that may be accessed by any container in the pod.

    Docker also has a concept of volumes, though it is somewhat looser and less
    managed. In Docker, a volume is simply a directory on disk or in another
    Container. Lifetimes are not managed and until very recently there were only
    local-disk-backed volumes. Docker now provides volume drivers, but the
    functionality is very limited for now (e.g. as of Docker 1.7 only one volume
    driver is allowed per Container and there is no way to pass parameters to
    volumes).

    A Kubernetes volume, on the other hand, has an explicit lifetime - the same
    as the Pod that encloses it. Consequently, a volume outlives any Containers
    that run within the Pod, and data is preserved across Container restarts. Of
    course, when a Pod ceases to exist, the volume will cease to exist, too.
    Perhaps more importantly than this, Kubernetes supports many types of
    volumes, and a Pod can use any number of them simultaneously.

    At its core, a volume is just a directory, possibly with some data in it,
    which is accessible to the Containers in a Pod. How that directory comes to
    be, the medium that backs it, and the contents of it are determined by the
    particular volume type used.

    To use a volume, a Pod specifies what volumes to provide for the Pod (the
    .spec.volumes field) and where to mount those into Containers (the
    .spec.containers[*].volumeMounts field).

    A process in a container sees a filesystem view composed from their Docker
    image and volumes. The Docker image is at the root of the filesystem
    hierarchy, and any volumes are mounted at the specified paths within the
    image. Volumes can not mount onto other volumes
    '''

    @jsii.member(jsii_name="fromAwsElasticBlockStore")
    @builtins.classmethod
    def from_aws_elastic_block_store(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_id: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts an Amazon Web Services (AWS) EBS volume into your pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of an EBS volume are
        persisted and the volume is unmounted. This means that an EBS volume can be pre-populated with data,
        and that data can be shared between pods.

        There are some restrictions when using an awsElasticBlockStore volume:

        - the nodes on which pods are running must be AWS EC2 instances.
        - those instances need to be in the same region and availability zone as the EBS volume.
        - EBS only supports a single EC2 instance mounting a volume.

        :param scope: -
        :param id: -
        :param volume_id: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cc588e89cde2d9472c587e24ee96bf6ae0191a2cd2a058042f9fdd1a4975c95)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
        options = AwsElasticBlockStoreVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAwsElasticBlockStore", [scope, id, volume_id, options]))

    @jsii.member(jsii_name="fromAzureDisk")
    @builtins.classmethod
    def from_azure_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Microsoft Azure Data Disk into a pod.

        :param scope: -
        :param id: -
        :param disk_name: -
        :param disk_uri: -
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0152a1aea92362fe450815943cd82c251e3dd7929ee584fd986ca42f9b99fd8e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
        options = AzureDiskVolumeOptions(
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            name=name,
            read_only=read_only,
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAzureDisk", [scope, id, disk_name, disk_uri, options]))

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        config_map: "IConfigMap",
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a ConfigMap.

        The configMap resource provides a way to inject configuration data into
        Pods. The data stored in a ConfigMap object can be referenced in a volume
        of type configMap and then consumed by containerized applications running
        in a Pod.

        When referencing a configMap object, you can simply provide its name in the
        volume to reference it. You can also customize the path to use for a
        specific entry in the ConfigMap.

        :param scope: -
        :param id: -
        :param config_map: The config map to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__05900aa6c2c8163941bfd505eb6208e29841ae64b172e9140bb9418f0a3705c1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
        options = ConfigMapVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromConfigMap", [scope, id, config_map, options]))

    @jsii.member(jsii_name="fromCsi")
    @builtins.classmethod
    def from_csi(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        driver: builtins.str,
        *,
        attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a CSI driver, for example the Secrets Store CSI Driver: https://secrets-store-csi-driver.sigs.k8s.io/introduction.html. Which in turn needs an associated provider to source the secrets, such as the AWS Secrets Manager and Systems Manager Parameter Store provider: https://aws.github.io/secrets-store-csi-driver-provider-aws/.

        :param scope: -
        :param id: -
        :param driver: The name of the CSI driver to use to populate the volume.
        :param attributes: Any driver-specific attributes to pass to the CSI volume builder. Default: - undefined
        :param fs_type: The filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver, which will determine the default filesystem to apply. Default: - driver-dependent
        :param name: The volume name. Default: - auto-generated
        :param read_only: Whether the mounted volume should be read-only or not. Default: - false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d11da660401e22f88475cc3b16020780c8b54e720b4cb95349868aa46dbb9e59)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument driver", value=driver, expected_type=type_hints["driver"])
        options = CsiVolumeOptions(
            attributes=attributes, fs_type=fs_type, name=name, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromCsi", [scope, id, driver, options]))

    @jsii.member(jsii_name="fromEmptyDir")
    @builtins.classmethod
    def from_empty_dir(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> "Volume":
        '''An emptyDir volume is first created when a Pod is assigned to a Node, and exists as long as that Pod is running on that node.

        As the name says, it is
        initially empty. Containers in the Pod can all read and write the same
        files in the emptyDir volume, though that volume can be mounted at the same
        or different paths in each Container. When a Pod is removed from a node for
        any reason, the data in the emptyDir is deleted forever.

        :param scope: -
        :param id: -
        :param name: -
        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined

        :see: http://kubernetes.io/docs/user-guide/volumes#emptydir
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd1de98ae420a87ee41c3361bebf4cc8434c4c96fd660ddef3e4bc4862e6ffaa)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = EmptyDirVolumeOptions(medium=medium, size_limit=size_limit)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromEmptyDir", [scope, id, name, options]))

    @jsii.member(jsii_name="fromGcePersistentDisk")
    @builtins.classmethod
    def from_gce_persistent_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        pd_name: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Google Compute Engine (GCE) persistent disk (PD) into your Pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of a PD are
        preserved and the volume is merely unmounted. This means that a PD can be pre-populated
        with data, and that data can be shared between pods.

        There are some restrictions when using a gcePersistentDisk:

        - the nodes on which Pods are running must be GCE VMs
        - those VMs need to be in the same GCE project and zone as the persistent disk

        :param scope: -
        :param id: -
        :param pd_name: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__238ea0c83c6d839f13bfeb7789e4985a33e1ad9e95d2e3159356008592985a2f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
        options = GCEPersistentDiskVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromGcePersistentDisk", [scope, id, pd_name, options]))

    @jsii.member(jsii_name="fromHostPath")
    @builtins.classmethod
    def from_host_path(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        path: builtins.str,
        type: typing.Optional[HostPathVolumeType] = None,
    ) -> "Volume":
        '''Used to mount a file or directory from the host node's filesystem into a Pod.

        This is not something that most Pods will need, but it offers a powerful
        escape hatch for some applications.

        :param scope: -
        :param id: -
        :param name: -
        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#hostpath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b80049e11999ed09c205f0a353e926adc048b4b43b2229e285265aa9304b4a22)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = HostPathVolumeOptions(path=path, type=type)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromHostPath", [scope, id, name, options]))

    @jsii.member(jsii_name="fromNfs")
    @builtins.classmethod
    def from_nfs(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        path: builtins.str,
        server: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Used to mount an NFS share into a Pod.

        :param scope: -
        :param id: -
        :param name: -
        :param path: Path that is exported by the NFS server.
        :param server: Server is the hostname or IP address of the NFS server.
        :param read_only: If set to true, will force the NFS export to be mounted with read-only permissions. Default: - false

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#nfs
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__446708ddd6f1610a72887a70c85f4901a1fa081912bfce0415cd5c09b435774a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = NfsVolumeOptions(path=path, server=server, read_only=read_only)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromNfs", [scope, id, name, options]))

    @jsii.member(jsii_name="fromPersistentVolumeClaim")
    @builtins.classmethod
    def from_persistent_volume_claim(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim: "IPersistentVolumeClaim",
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Used to mount a PersistentVolume into a Pod.

        PersistentVolumeClaims are a way for users to "claim" durable storage (such as a GCE PersistentDisk or an iSCSI volume)
        without knowing the details of the particular cloud environment.

        :param scope: -
        :param id: -
        :param claim: -
        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e20491d4b6a9b7fd43e8b4a0d163950848bc5539b7b9d15796df9781c69ed2e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        options = PersistentVolumeClaimVolumeOptions(name=name, read_only=read_only)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromPersistentVolumeClaim", [scope, id, claim, options]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        secr: ISecret,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a Secret.

        A secret volume is used to pass sensitive information, such as passwords, to Pods.
        You can store secrets in the Kubernetes API and mount them as files for use by pods
        without coupling to Kubernetes directly.

        secret volumes are backed by tmpfs (a RAM-backed filesystem)
        so they are never written to non-volatile storage.

        :param scope: -
        :param id: -
        :param secr: The secret to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#secret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__928ed5a9bb70b01bc5d03e489c4c882dc6d0028fb4a04770c94265ea0548587b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        options = SecretVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromSecret", [scope, id, secr, options]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.VolumeMount",
    jsii_struct_bases=[MountOptions],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
        "path": "path",
        "volume": "volume",
    },
)
class VolumeMount(MountOptions):
    def __init__(
        self,
        *,
        propagation: typing.Optional[MountPropagation] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
        path: builtins.str,
        volume: Volume,
    ) -> None:
        '''Mount a volume from the pod to the container.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        :param path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param volume: The volume to mount.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e4c956e1481b04f7c81b0b2cb04263661b399a52e4ea98d2e8fbe5ca7380b00c)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
            "volume": volume,
        }
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional[MountPropagation]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional[MountPropagation], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> builtins.str:
        '''Path within the container at which the volume should be mounted.

        Must not
        contain ':'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume(self) -> Volume:
        '''The volume to mount.'''
        result = self._values.get("volume")
        assert result is not None, "Required property 'volume' is missing"
        return typing.cast(Volume, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VolumeMount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class WorkloadScheduling(
    PodScheduling,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.WorkloadScheduling",
):
    '''Controls the pod scheduling strategy of this workload.

    It offers some additional API's on top of the core pod scheduling.
    '''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d330f2233e4539f4248bf955a867c4fecfe780d7dfc471365b139c1fb51aee03)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="spread")
    def spread(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Spread the pods in this workload by the topology key.

        A spread is a separation of the pod from itself and is used to
        balance out pod replicas across a given topology.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        options = WorkloadSchedulingSpreadOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "spread", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.WorkloadSchedulingSpreadOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class WorkloadSchedulingSpreadOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``WorkloadScheduling.spread``.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf324b0c07978999e57bff9c569cb7512f30e1941f77d0c4ebdb5a1176e2b274)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional[Topology]:
        '''Which topology to spread on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional[Topology], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the spread is optional, with this weight score.

        :default: - no weight. spread is assumed to be required.
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadSchedulingSpreadOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector, INetworkPolicyPeer, ISubject)
class AbstractPod(
    Resource,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-28.AbstractPod",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efff5dd986cf1092cc410fffc9a8233bdff8776d143bbbbbf091e2ded0e02afc)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AbstractPodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addContainer")
    def add_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional[ContainerRestartPolicy] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param restart_policy: Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always. Default: - no restart policy is defined and the pod restart policy is applied
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            restart_policy=restart_policy,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addContainer", [cont]))

    @jsii.member(jsii_name="addHostAlias")
    def add_host_alias(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''
        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        host_alias = HostAlias(hostnames=hostnames, ip=ip)

        return typing.cast(None, jsii.invoke(self, "addHostAlias", [host_alias]))

    @jsii.member(jsii_name="addInitContainer")
    def add_init_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        restart_policy: typing.Optional[ContainerRestartPolicy] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param restart_policy: Kubelet will start init containers with restartPolicy=Always in the order with other init containers, but instead of waiting for its completion, it will wait for the container startup completion Currently, only accepted value is Always. Default: - no restart policy is defined and the pod restart policy is applied
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            restart_policy=restart_policy,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addInitContainer", [cont]))

    @jsii.member(jsii_name="addVolume")
    def add_volume(self, vol: Volume) -> None:
        '''
        :param vol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63ac5ae57b9ad993e8508236b77f9802efb5c90da440eb6604fb11e7afe8101e)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "addVolume", [vol]))

    @jsii.member(jsii_name="attachContainer")
    def attach_container(self, cont: Container) -> None:
        '''
        :param cont: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84198b7b2db449ad83a59f2447ef999b71b8e92463a6c17a73904ff8ac0ab4ad)
            check_type(argname="argument cont", value=cont, expected_type=type_hints["cont"])
        return typing.cast(None, jsii.invoke(self, "attachContainer", [cont]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="automountServiceAccountToken")
    def automount_service_account_token(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "automountServiceAccountToken"))

    @builtins.property
    @jsii.member(jsii_name="containers")
    def containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "containers"))

    @builtins.property
    @jsii.member(jsii_name="dns")
    def dns(self) -> PodDns:
        return typing.cast(PodDns, jsii.get(self, "dns"))

    @builtins.property
    @jsii.member(jsii_name="hostAliases")
    def host_aliases(self) -> typing.List[HostAlias]:
        return typing.cast(typing.List[HostAlias], jsii.get(self, "hostAliases"))

    @builtins.property
    @jsii.member(jsii_name="initContainers")
    def init_containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "initContainers"))

    @builtins.property
    @jsii.member(jsii_name="isolate")
    def _isolate(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "isolate"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    @abc.abstractmethod
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        ...

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> PodSecurityContext:
        return typing.cast(PodSecurityContext, jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="volumes")
    def volumes(self) -> typing.List[Volume]:
        return typing.cast(typing.List[Volume], jsii.get(self, "volumes"))

    @builtins.property
    @jsii.member(jsii_name="dockerRegistryAuth")
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        return typing.cast(typing.Optional[ISecret], jsii.get(self, "dockerRegistryAuth"))

    @builtins.property
    @jsii.member(jsii_name="hostNetwork")
    def host_network(self) -> typing.Optional[builtins.bool]:
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "hostNetwork"))

    @builtins.property
    @jsii.member(jsii_name="restartPolicy")
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        return typing.cast(typing.Optional[RestartPolicy], jsii.get(self, "restartPolicy"))

    @builtins.property
    @jsii.member(jsii_name="serviceAccount")
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        return typing.cast(typing.Optional["IServiceAccount"], jsii.get(self, "serviceAccount"))

    @builtins.property
    @jsii.member(jsii_name="terminationGracePeriod")
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "terminationGracePeriod"))


class _AbstractPodProxy(
    AbstractPod,
    jsii.proxy_for(Resource), # type: ignore[misc]
):
    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, AbstractPod).__jsii_proxy_class__ = lambda : _AbstractPodProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AbstractPodProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
    },
)
class AbstractPodProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``AbstractPod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72d8a661c300275e2df4409e4dc86c9130d1dd6e0e91feb2c2b3ef0515ecc045)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional["IServiceAccount"], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AbstractPodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AddDeploymentOptions",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class AddDeploymentOptions(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options to add a deployment to a service.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to. Default: - Copied from the first container of the deployment.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__496241d777d393ab6c3d81761a89aa2bfed050446ae2cb278091996f56bdb50e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will bind to.

        :default: - Copied from the first container of the deployment.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDeploymentOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiResource, IApiEndpoint)
class ApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.ApiResource"):
    '''Represents information about an API resource type.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(
        cls,
        *,
        api_group: builtins.str,
        resource_type: builtins.str,
    ) -> "ApiResource":
        '''API resource information for a custom resource type.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        options = ApiResourceOptions(api_group=api_group, resource_type=resource_type)

        return typing.cast("ApiResource", jsii.sinvoke(cls, "custom", [options]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="API_SERVICES")
    def API_SERVICES(cls) -> "ApiResource":
        '''API resource information for APIService.'''
        return typing.cast("ApiResource", jsii.sget(cls, "API_SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="BINDINGS")
    def BINDINGS(cls) -> "ApiResource":
        '''API resource information for Binding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CERTIFICATE_SIGNING_REQUESTS")
    def CERTIFICATE_SIGNING_REQUESTS(cls) -> "ApiResource":
        '''API resource information for CertificateSigningRequest.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CERTIFICATE_SIGNING_REQUESTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLE_BINDINGS")
    def CLUSTER_ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for ClusterRoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLES")
    def CLUSTER_ROLES(cls) -> "ApiResource":
        '''API resource information for ClusterRole.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="COMPONENT_STATUSES")
    def COMPONENT_STATUSES(cls) -> "ApiResource":
        '''API resource information for ComponentStatus.'''
        return typing.cast("ApiResource", jsii.sget(cls, "COMPONENT_STATUSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONFIG_MAPS")
    def CONFIG_MAPS(cls) -> "ApiResource":
        '''API resource information for ConfigMap.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONFIG_MAPS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONTROLLER_REVISIONS")
    def CONTROLLER_REVISIONS(cls) -> "ApiResource":
        '''API resource information for ControllerRevision.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONTROLLER_REVISIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CRON_JOBS")
    def CRON_JOBS(cls) -> "ApiResource":
        '''API resource information for CronJob.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CRON_JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_DRIVERS")
    def CSI_DRIVERS(cls) -> "ApiResource":
        '''API resource information for CSIDriver.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_DRIVERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_NODES")
    def CSI_NODES(cls) -> "ApiResource":
        '''API resource information for CSINode.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_STORAGE_CAPACITIES")
    def CSI_STORAGE_CAPACITIES(cls) -> "ApiResource":
        '''API resource information for CSIStorageCapacity.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_STORAGE_CAPACITIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CUSTOM_RESOURCE_DEFINITIONS")
    def CUSTOM_RESOURCE_DEFINITIONS(cls) -> "ApiResource":
        '''API resource information for CustomResourceDefinition.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CUSTOM_RESOURCE_DEFINITIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DAEMON_SETS")
    def DAEMON_SETS(cls) -> "ApiResource":
        '''API resource information for DaemonSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DAEMON_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DEPLOYMENTS")
    def DEPLOYMENTS(cls) -> "ApiResource":
        '''API resource information for Deployment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DEPLOYMENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINT_SLICES")
    def ENDPOINT_SLICES(cls) -> "ApiResource":
        '''API resource information for EndpointSlice.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINT_SLICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINTS")
    def ENDPOINTS(cls) -> "ApiResource":
        '''API resource information for Endpoints.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="EVENTS")
    def EVENTS(cls) -> "ApiResource":
        '''API resource information for Event.'''
        return typing.cast("ApiResource", jsii.sget(cls, "EVENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="FLOW_SCHEMAS")
    def FLOW_SCHEMAS(cls) -> "ApiResource":
        '''API resource information for FlowSchema.'''
        return typing.cast("ApiResource", jsii.sget(cls, "FLOW_SCHEMAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HORIZONTAL_POD_AUTOSCALERS")
    def HORIZONTAL_POD_AUTOSCALERS(cls) -> "ApiResource":
        '''API resource information for HorizontalPodAutoscaler.'''
        return typing.cast("ApiResource", jsii.sget(cls, "HORIZONTAL_POD_AUTOSCALERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESS_CLASSES")
    def INGRESS_CLASSES(cls) -> "ApiResource":
        '''API resource information for IngressClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESS_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESSES")
    def INGRESSES(cls) -> "ApiResource":
        '''API resource information for Ingress.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="JOBS")
    def JOBS(cls) -> "ApiResource":
        '''API resource information for Job.'''
        return typing.cast("ApiResource", jsii.sget(cls, "JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LEASES")
    def LEASES(cls) -> "ApiResource":
        '''API resource information for Lease.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LEASES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIMIT_RANGES")
    def LIMIT_RANGES(cls) -> "ApiResource":
        '''API resource information for LimitRange.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LIMIT_RANGES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LOCAL_SUBJECT_ACCESS_REVIEWS")
    def LOCAL_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for LocalSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LOCAL_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MUTATING_WEBHOOK_CONFIGURATIONS")
    def MUTATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for MutatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "MUTATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAMESPACES")
    def NAMESPACES(cls) -> "ApiResource":
        '''API resource information for Namespace.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NAMESPACES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NETWORK_POLICIES")
    def NETWORK_POLICIES(cls) -> "ApiResource":
        '''API resource information for NetworkPolicy.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NETWORK_POLICIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NODES")
    def NODES(cls) -> "ApiResource":
        '''API resource information for Node.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUME_CLAIMS")
    def PERSISTENT_VOLUME_CLAIMS(cls) -> "ApiResource":
        '''API resource information for PersistentVolumeClaim.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUME_CLAIMS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUMES")
    def PERSISTENT_VOLUMES(cls) -> "ApiResource":
        '''API resource information for PersistentVolume.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUMES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_DISRUPTION_BUDGETS")
    def POD_DISRUPTION_BUDGETS(cls) -> "ApiResource":
        '''API resource information for PodDisruptionBudget.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_DISRUPTION_BUDGETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_TEMPLATES")
    def POD_TEMPLATES(cls) -> "ApiResource":
        '''API resource information for PodTemplate.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_TEMPLATES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PODS")
    def PODS(cls) -> "ApiResource":
        '''API resource information for Pod.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PODS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_CLASSES")
    def PRIORITY_CLASSES(cls) -> "ApiResource":
        '''API resource information for PriorityClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_LEVEL_CONFIGURATIONS")
    def PRIORITY_LEVEL_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for PriorityLevelConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_LEVEL_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICA_SETS")
    def REPLICA_SETS(cls) -> "ApiResource":
        '''API resource information for ReplicaSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICA_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICATION_CONTROLLERS")
    def REPLICATION_CONTROLLERS(cls) -> "ApiResource":
        '''API resource information for ReplicationController.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICATION_CONTROLLERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RESOURCE_QUOTAS")
    def RESOURCE_QUOTAS(cls) -> "ApiResource":
        '''API resource information for ResourceQuota.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RESOURCE_QUOTAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLE_BINDINGS")
    def ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for RoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLES")
    def ROLES(cls) -> "ApiResource":
        '''API resource information for Role.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RUNTIME_CLASSES")
    def RUNTIME_CLASSES(cls) -> "ApiResource":
        '''API resource information for RuntimeClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RUNTIME_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SECRETS")
    def SECRETS(cls) -> "ApiResource":
        '''API resource information for Secret.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SECRETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_ACCESS_REVIEWS")
    def SELF_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_RULES_REVIEWS")
    def SELF_SUBJECT_RULES_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectRulesReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_RULES_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICE_ACCOUNTS")
    def SERVICE_ACCOUNTS(cls) -> "ApiResource":
        '''API resource information for ServiceAccount.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICE_ACCOUNTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICES")
    def SERVICES(cls) -> "ApiResource":
        '''API resource information for Service.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STATEFUL_SETS")
    def STATEFUL_SETS(cls) -> "ApiResource":
        '''API resource information for StatefulSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STATEFUL_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STORAGE_CLASSES")
    def STORAGE_CLASSES(cls) -> "ApiResource":
        '''API resource information for StorageClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STORAGE_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SUBJECT_ACCESS_REVIEWS")
    def SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="TOKEN_REVIEWS")
    def TOKEN_REVIEWS(cls) -> "ApiResource":
        '''API resource information for TokenReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "TOKEN_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VALIDATING_WEBHOOK_CONFIGURATIONS")
    def VALIDATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for ValidatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VALIDATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VOLUME_ATTACHMENTS")
    def VOLUME_ATTACHMENTS(cls) -> "ApiResource":
        '''API resource information for VolumeAttachment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VOLUME_ATTACHMENTS"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class BasicAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.BasicAuthSecret",
):
    '''Create a secret for basic authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        password: builtins.str,
        username: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f2b278d6cae87420f45114f10764d2f4ab3f8a6c5e35a7a2327c332720fb135)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = BasicAuthSecretProps(
            password=password,
            username=username,
            immutable=immutable,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])


class ClusterRoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ClusterRoleBinding",
):
    '''A ClusterRoleBinding grants permissions cluster-wide to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: "IClusterRole",
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ed16d46644b54f889a2c00bf7a6d7d490599b1c85afa4a031fb4bc3b03e62de)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c77e266e99d964d4fbb502744173f566694cbcad19fe11d3d81687fbeafe86e0)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> "IClusterRole":
        return typing.cast("IClusterRole", jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ClusterRoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class ClusterRoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: "IClusterRole",
    ) -> None:
        '''Properties for ``ClusterRoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7c4cbec76f7856b07beaab53894d54de572a1a161186ff01b23f09b4ed94c5a)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> "IClusterRole":
        '''The role to bind to.'''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast("IClusterRole", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ClusterRoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "aggregation_labels": "aggregationLabels",
        "rules": "rules",
    },
)
class ClusterRoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``ClusterRole``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1fea8a449e2aef5c76c6fb139f7638e7d7b8c92db308463f406147e0f4df7e9f)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument aggregation_labels", value=aggregation_labels, expected_type=type_hints["aggregation_labels"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if aggregation_labels is not None:
            self._values["aggregation_labels"] = aggregation_labels
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def aggregation_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.'''
        result = self._values.get("aggregation_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[ClusterRolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[ClusterRolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.CommandProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class CommandProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``Probe.fromCommand()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e685a781eb40736900259f2d8d0cfb548a6cc70dede9cd4ae8026add18bcd4f)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommandProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.CommonSecretProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable"},
)
class CommonSecretProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Common properties for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da24a13e3a0cb946ee71ced2b6e67066df38e0fc28a6a37b6be140e9bba49e69)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommonSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ConfigMapProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "binary_data": "binaryData",
        "data": "data",
        "immutable": "immutable",
    },
)
class ConfigMapProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for initialization of ``ConfigMap``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6d9121a83f83d4797252421f10d82f41b918834a55a0977893b0fca8a45e134)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument binary_data", value=binary_data, expected_type=type_hints["binary_data"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'.
        BinaryData can contain byte sequences that are not in the UTF-8 range. The
        keys stored in BinaryData must not overlap with the ones in the Data field,
        this is enforced during validation process.

        You can also add binary data using ``configMap.addBinaryData()``.
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values
        with non-UTF-8 byte sequences must use the BinaryData field. The keys
        stored in Data must not overlap with the keys in the BinaryData field, this
        is enforced during validation process.

        You can also add data using ``configMap.addData()``.
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DockerConfigSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.DockerConfigSecret",
):
    '''Create a secret for storing credentials for accessing a container image registry.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        data: typing.Mapping[builtins.str, typing.Any],
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fa44640bf9912b0406ed974563324f369da3132efd634cf5549183e31f98af6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DockerConfigSecretProps(
            data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DockerConfigSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable", "data": "data"},
)
class DockerConfigSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        data: typing.Mapping[builtins.str, typing.Any],
    ) -> None:
        '''Options for ``DockerConfigSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aec46644c2691a6530e62fa91f22d4036c36b979e6543436ff11e4ec39842f0e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data": data,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def data(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.

        :see: https://docs.docker.com/engine/reference/commandline/cli/#sample-configuration-file
        '''
        result = self._values.get("data")
        assert result is not None, "Required property 'data' is missing"
        return typing.cast(typing.Mapping[builtins.str, typing.Any], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DockerConfigSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ExposeDeploymentViaIngressOptions",
    jsii_struct_bases=[
        DeploymentExposeViaServiceOptions, ExposeServiceViaIngressOptions
    ],
    name_mapping={
        "name": "name",
        "ports": "ports",
        "service_type": "serviceType",
        "ingress": "ingress",
        "path_type": "pathType",
    },
)
class ExposeDeploymentViaIngressOptions(
    DeploymentExposeViaServiceOptions,
    ExposeServiceViaIngressOptions,
):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Options for exposing a deployment via an ingress.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f5dedaa1abe96f330a551c21cb30df6e834ea473777830c382c88274a72799d)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def service_type(self) -> typing.Optional[ServiceType]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional[ServiceType], result)

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeDeploymentViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISubject)
class Group(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.Group",
):
    '''Represents a group.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "Group":
        '''Reference a group by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__866eefca00f55bda8e0168835f00c278c8eaecbd9d8dae3d6f3125e33a3996e4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("Group", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


class HorizontalPodAutoscaler(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.HorizontalPodAutoscaler",
):
    '''A HorizontalPodAutoscaler scales a workload up or down in response to a metric change.

    This allows your services to scale up when demand is high and scale down
    when they are no longer needed.

    Typical use cases for HorizontalPodAutoscaler:

    - When Memory usage is above 70%, scale up the number of replicas to meet the demand.
    - When CPU usage is below 30%, scale down the number of replicas to save resources.
    - When a service is experiencing a spike in traffic, scale up the number of replicas
      to meet the demand. Then, when the traffic subsides, scale down the number of
      replicas to save resources.

    The autoscaler uses the following algorithm to determine the number of replicas to scale:

    ``desiredReplicas = ceil[currentReplicas * ( currentMetricValue / desiredMetricValue )]``

    HorizontalPodAutoscaler's can be used to with any ``Scalable`` workload:

    - Deployment
    - StatefulSet

    **Targets that already have a replica count defined:**

    Remove any replica counts from the target resource before associating with a
    HorizontalPodAutoscaler. If this isn't done, then any time a change to that object is applied,
    Kubernetes will scale the current number of Pods to the value of the target.replicas key. This
    may not be desired and could lead to unexpected behavior.

    :see: https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#implicit-maintenance-mode-deactivation

    Example::

        const backend = new kplus.Deployment(this, 'Backend', ...);
        
        const hpa = new kplus.HorizontalPodAutoscaler(chart, 'Hpa', {
         target: backend,
         maxReplicas: 10,
         scaleUp: {
           policies: [
             {
               replicas: kplus.Replicas.absolute(3),
               duration: Duration.minutes(5),
             },
           ],
         },
        });
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f6c63851bc8df12835760257ae2098ec6a605ba70fe4e8366bcb5ae2ea907c8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = HorizontalPodAutoscalerProps(
            max_replicas=max_replicas,
            target=target,
            metrics=metrics,
            min_replicas=min_replicas,
            scale_down=scale_down,
            scale_up=scale_up,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="maxReplicas")
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        return typing.cast(jsii.Number, jsii.get(self, "maxReplicas"))

    @builtins.property
    @jsii.member(jsii_name="minReplicas")
    def min_replicas(self) -> jsii.Number:
        '''The minimum number of replicas that can be scaled down to.'''
        return typing.cast(jsii.Number, jsii.get(self, "minReplicas"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scaleDown")
    def scale_down(self) -> ScalingRules:
        '''The scaling behavior when scaling down.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleDown"))

    @builtins.property
    @jsii.member(jsii_name="scaleUp")
    def scale_up(self) -> ScalingRules:
        '''The scaling behavior when scaling up.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleUp"))

    @builtins.property
    @jsii.member(jsii_name="target")
    def target(self) -> IScalable:
        '''The workload to scale up or down.'''
        return typing.cast(IScalable, jsii.get(self, "target"))

    @builtins.property
    @jsii.member(jsii_name="metrics")
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.'''
        return typing.cast(typing.Optional[typing.List[Metric]], jsii.get(self, "metrics"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HorizontalPodAutoscalerProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "max_replicas": "maxReplicas",
        "target": "target",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
        "scale_down": "scaleDown",
        "scale_up": "scaleUp",
    },
)
class HorizontalPodAutoscalerProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for HorizontalPodAutoscaler.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(scale_down, dict):
            scale_down = ScalingRules(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = ScalingRules(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2ecf647d33e3bf3b0434964b1fc39f6aee5d317cd55243f50a46a3653e0bd17)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target(self) -> IScalable:
        '''The workload to scale up or down.

        Scalable workload types:

        - Deployment
        - StatefulSet
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(IScalable, result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.

        :default:

        - If metrics are not provided, then the target resource
        constraints (e.g. cpu limit) will be used as scaling metrics.
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List[Metric]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''The minimum number of replicas that can be scaled down to.

        Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and
        at least one Object or External metric is configured.

        :default: 1
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scale_down(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling down.

        :default: - Scale down to minReplica count with a 5 minute stabilization window.
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional[ScalingRules], result)

    @builtins.property
    def scale_up(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling up.

        :default:

        - Is the higher of:

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional[ScalingRules], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.HttpGetProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "host": "host",
        "port": "port",
        "scheme": "scheme",
    },
)
class HttpGetProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
    ) -> None:
        '''Options for ``Probe.fromHttpGet()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80e03488477c65b388c872b8bbd4a9298419a4614b489e18f041f4986e34f7bf)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scheme(self) -> typing.Optional[ConnectionScheme]:
        '''Scheme to use for connecting to the host (HTTP or HTTPS).

        :default: ConnectionScheme.HTTP
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[ConnectionScheme], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="cdk8s-plus-28.IClusterRole")
class IClusterRole(IResource, typing_extensions.Protocol):
    '''Represents a cluster-level role.'''

    pass


class _IClusterRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a cluster-level role.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IClusterRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IClusterRole).__jsii_proxy_class__ = lambda : _IClusterRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IConfigMap")
class IConfigMap(IResource, typing_extensions.Protocol):
    '''Represents a config map.'''

    pass


class _IConfigMapProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a config map.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IConfigMap"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IConfigMap).__jsii_proxy_class__ = lambda : _IConfigMapProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IPersistentVolume")
class IPersistentVolume(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IPersistentVolume"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolume).__jsii_proxy_class__ = lambda : _IPersistentVolumeProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IPersistentVolumeClaim")
class IPersistentVolumeClaim(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeClaimProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IPersistentVolumeClaim"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolumeClaim).__jsii_proxy_class__ = lambda : _IPersistentVolumeClaimProxy


@jsii.interface(jsii_type="cdk8s-plus-28.IServiceAccount")
class IServiceAccount(IResource, ISubject, typing_extensions.Protocol):
    pass


class _IServiceAccountProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
    jsii.proxy_for(ISubject), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-28.IServiceAccount"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IServiceAccount).__jsii_proxy_class__ = lambda : _IServiceAccountProxy


class Ingress(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Ingress"):
    '''Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

    An Ingress can be configured to give services
    externally-reachable urls, load balance traffic, terminate SSL, offer name
    based virtual hosting etc.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        class_name: typing.Optional[builtins.str] = None,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param class_name: Class Name for this ingress. This field is a reference to an IngressClass resource that contains additional Ingress configuration, including the name of the Ingress controller.
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15db337e0da9e1470ab9e2f14253d01f8ba965829236974c30852efc7a54bb8a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = IngressProps(
            class_name=class_name,
            default_backend=default_backend,
            rules=rules,
            tls=tls,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addDefaultBackend")
    def add_default_backend(self, backend: IngressBackend) -> None:
        '''Defines the default backend for this ingress.

        A default backend capable of
        servicing requests that don't match any rule.

        :param backend: The backend to use for requests that do not match any rule.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b38b29f5bea2be2bf5905edc8e55af46c145dd7ffb97c1f22c1916b6a78afacf)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addDefaultBackend", [backend]))

    @jsii.member(jsii_name="addHostDefaultBackend")
    def add_host_default_backend(
        self,
        host: builtins.str,
        backend: IngressBackend,
    ) -> None:
        '''Specify a default backend for a specific host name.

        This backend will be used as a catch-all for requests
        targeted to this host name (the ``Host`` header matches this value).

        :param host: The host name to match.
        :param backend: The backend to route to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__adedee11dd5f73547c380a3b29e46f5bf57778f4c9eb6cc9c8ca79cda0910b8c)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addHostDefaultBackend", [host, backend]))

    @jsii.member(jsii_name="addHostRule")
    def add_host_rule(
        self,
        host: builtins.str,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests to a specific host and a specific HTTP path (the ``Host`` header matches this value).

        :param host: The host name.
        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__daee657051e6ca5d880655dd994840b3b0579705406d624918311e82ac8b21c1)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addHostRule", [host, path, backend, path_type]))

    @jsii.member(jsii_name="addRule")
    def add_rule(
        self,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests sent to a specific HTTP path.

        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__69159617785657871c479f19ba2735e8d84edaf05d4906b2e7a91eb1af30c799)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addRule", [path, backend, path_type]))

    @jsii.member(jsii_name="addRules")
    def add_rules(self, *rules: IngressRule) -> None:
        '''Adds rules to this ingress.

        :param rules: The rules to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__314230cafbc355af7a0266627923c7e07cf51574599677b4f3516b2860ea8c34)
            check_type(argname="argument rules", value=rules, expected_type=typing.Tuple[type_hints["rules"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addRules", [*rules]))

    @jsii.member(jsii_name="addTls")
    def add_tls(
        self,
        tls: typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''
        :param tls: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2205c54157db923a9282be4acc01de5845a161931d62d2217b5eb7c4bc16950)
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        return typing.cast(None, jsii.invoke(self, "addTls", [tls]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.IngressProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "class_name": "className",
        "default_backend": "defaultBackend",
        "rules": "rules",
        "tls": "tls",
    },
)
class IngressProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        class_name: typing.Optional[builtins.str] = None,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Ingress``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param class_name: Class Name for this ingress. This field is a reference to an IngressClass resource that contains additional Ingress configuration, including the name of the Ingress controller.
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc6a9bb213e6fe434df2de3db55df311b8557b037adec4b61d46e70ca1d05fcb)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument class_name", value=class_name, expected_type=type_hints["class_name"])
            check_type(argname="argument default_backend", value=default_backend, expected_type=type_hints["default_backend"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if class_name is not None:
            self._values["class_name"] = class_name
        if default_backend is not None:
            self._values["default_backend"] = default_backend
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def class_name(self) -> typing.Optional[builtins.str]:
        '''Class Name for this ingress.

        This field is a reference to an IngressClass resource that contains
        additional Ingress configuration, including the name of the Ingress controller.
        '''
        result = self._values.get("class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def default_backend(self) -> typing.Optional[IngressBackend]:
        '''The default backend services requests that do not match any rule.

        Using this option or the ``addDefaultBackend()`` method is equivalent to
        adding a rule with both ``path`` and ``host`` undefined.
        '''
        result = self._values.get("default_backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''Routing rules for this ingress.

        Each rule must define an ``IngressBackend`` that will receive the requests
        that match this rule. If both ``host`` and ``path`` are not specifiec, this
        backend will be used as the default backend of the ingress.

        You can also add rules later using ``addRule()``, ``addHostRule()``,
        ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List[IngressTls]]:
        '''TLS settings for this ingress.

        Using this option tells the ingress controller to expose a TLS endpoint.
        Currently the Ingress only supports a single TLS port, 443. If multiple
        members of this list specify different hosts, they will be multiplexed on
        the same port according to the hostname specified through the SNI TLS
        extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List[IngressTls]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.MetricObjectOptions",
    jsii_struct_bases=[MetricOptions],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
        "object": "object",
    },
)
class MetricObjectOptions(MetricOptions):
    def __init__(
        self,
        *,
        name: builtins.str,
        target: MetricTarget,
        label_selector: typing.Optional[LabelSelector] = None,
        object: IResource,
    ) -> None:
        '''Options for ``Metric.object()``.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        :param object: Resource where the metric can be found.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95a5d7267d67a915c75a63c2ca6f8fd7241f90101e311abd919e6543ad8be3e6)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument object", value=object, expected_type=type_hints["object"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
            "object": object,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> MetricTarget:
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(MetricTarget, result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def object(self) -> IResource:
        '''Resource where the metric can be found.'''
        result = self._values.get("object")
        assert result is not None, "Required property 'object' is missing"
        return typing.cast(IResource, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricObjectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespace(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Namespace"):
    '''In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.

    Names of resources need to be unique within a namespace, but not across namespaces.
    Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
    not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ffcea6bff37f617609bfbb2c1276aa287cc7cca2e15e5306a4feef57fc853a4f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NamespaceProps(metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAME_LABEL")
    def NAME_LABEL(cls) -> builtins.str:
        '''
        :see: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "NAME_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NamespaceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata"},
)
class NamespaceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for ``Namespace``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bb6abb1e43a3e1b74d0577e2a96744567a7ae6005241f08fb9d17965e27c81d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicy(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.NetworkPolicy",
):
    '''Control traffic flow at the IP address or port level (OSI layer 3 or 4), network policies are an application-centric construct which allow you to specify how a pod is allowed to communicate with various network peers.

    - Outgoing traffic is allowed if there are no network policies selecting
      the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic matches at least one egress rule across all of the
      network policies that select the pod.
    - Incoming traffic is allowed to a pod if there are no network policies
      selecting the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic source is the pod's local node,
      OR if the traffic matches at least one ingress rule across all of
      the network policies that select the pod.

    Network policies do not conflict; they are additive.
    If any policy or policies apply to a given pod for a given
    direction, the connections allowed in that direction from
    that pod is the union of what the applicable policies allow.
    Thus, order of evaluation does not affect the policy result.

    For a connection from a source pod to a destination pod to be allowed,
    both the egress policy on the source pod and the ingress policy on the
    destination pod need to allow the connection.
    If either side does not allow the connection, it will not happen.

    :see: https://kubernetes.io/docs/concepts/services-networking/network-policies/#networkpolicy-resource
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6f7dafa0908d111e6dc8e0ca31ec8f1599f9139babe5e861d6cde2aff04c213)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NetworkPolicyProps(
            egress=egress, ingress=ingress, selector=selector, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addEgressRule")
    def add_egress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow outgoing traffic to the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74f1f43b66662dc3fb51264bc5be22a03dfc036dac5915b20259bd9c75e85faa)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addEgressRule", [peer, ports]))

    @jsii.member(jsii_name="addIngressRule")
    def add_ingress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow incoming traffic from the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9281d337cbee6891e0df1f77e17a5d1c30cd92e8283948920491d1071fb171b)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addIngressRule", [peer, ports]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.NetworkPolicyProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "egress": "egress",
        "ingress": "ingress",
        "selector": "selector",
    },
)
class NetworkPolicyProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
    ) -> None:
        '''Properties for ``NetworkPolicy``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(egress, dict):
            egress = NetworkPolicyTraffic(**egress)
        if isinstance(ingress, dict):
            ingress = NetworkPolicyTraffic(**ingress)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72796de7282319b8ac155a70f65ff45a0133057024a06189d82b3fc9ee271309)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument egress", value=egress, expected_type=type_hints["egress"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if egress is not None:
            self._values["egress"] = egress
        if ingress is not None:
            self._values["ingress"] = ingress
        if selector is not None:
            self._values["selector"] = selector

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def egress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Egress traffic configuration.

        :default: - the policy doesn't change egress behavior of the pods it selects.
        '''
        result = self._values.get("egress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def ingress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Ingress traffic configuration.

        :default: - the policy doesn't change ingress behavior of the pods it selects.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods does this policy object applies to.

        This can either be a single pod / workload, or a grouping of pods selected
        via the ``Pods.select`` function. Rules is applied to any pods selected by this property.
        Multiple network policies can select the same set of pods.
        In this case, the rules for each are combined additively.

        Note that

        :default: - will select all pods in the namespace of the policy.
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPersistentVolume, IStorage)
class PersistentVolume(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.PersistentVolume",
):
    '''A PersistentVolume (PV) is a piece of storage in the cluster that has been provisioned by an administrator or dynamically provisioned using Storage Classes.

    It is a resource in the cluster just like a node is a cluster resource.
    PVs are volume plugins like Volumes, but have a lifecycle independent of any
    individual Pod that uses the PV. This API object captures the details of the
    implementation of the storage, be that NFS, iSCSI, or a
    cloud-provider-specific storage system.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80686c17c74143e6696a4c10f8a88c6857fc94dfe2ef85c668b14d47f149a6d5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeProps(
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromPersistentVolumeName")
    @builtins.classmethod
    def from_persistent_volume_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_name: builtins.str,
    ) -> IPersistentVolume:
        '''Imports a pv from the cluster as a reference.

        :param scope: -
        :param id: -
        :param volume_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__230a5cf48f0c219ba44b652851b0c2192390d21715a3267278b70da9fb055481)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_name", value=volume_name, expected_type=type_hints["volume_name"])
        return typing.cast(IPersistentVolume, jsii.sinvoke(cls, "fromPersistentVolumeName", [scope, id, volume_name]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> Volume:
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast(Volume, jsii.invoke(self, "asVolume", []))

    @jsii.member(jsii_name="bind")
    def bind(self, claim: IPersistentVolumeClaim) -> None:
        '''Bind a volume to a specific claim.

        Note that you must also bind the claim to the volume.

        :param claim: The PVC to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1c6f33f6a5cf693d2d59705d86a76d2f5626e64001a95fbeedd5b5a359fa8e4)
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        return typing.cast(None, jsii.invoke(self, "bind", [claim]))

    @jsii.member(jsii_name="reserve")
    def reserve(self) -> "PersistentVolumeClaim":
        '''Reserve a ``PersistentVolume`` by creating a ``PersistentVolumeClaim`` that is wired to claim this volume.

        Note that this method will throw in case the volume is already claimed.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#reserving-a-persistentvolume
        '''
        return typing.cast("PersistentVolumeClaim", jsii.invoke(self, "reserve", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="mode")
    def mode(self) -> PersistentVolumeMode:
        '''Volume mode of this volume.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "mode"))

    @builtins.property
    @jsii.member(jsii_name="reclaimPolicy")
    def reclaim_policy(self) -> PersistentVolumeReclaimPolicy:
        '''Reclaim policy of this volume.'''
        return typing.cast(PersistentVolumeReclaimPolicy, jsii.get(self, "reclaimPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="claim")
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''PVC this volume is bound to.

        Undefined means this volume is not yet
        claimed by any PVC.
        '''
        return typing.cast(typing.Optional[IPersistentVolumeClaim], jsii.get(self, "claim"))

    @builtins.property
    @jsii.member(jsii_name="mountOptions")
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Mount options of this volume.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "mountOptions"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage size of this volume.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class this volume belongs to.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))


@jsii.implements(IPersistentVolumeClaim)
class PersistentVolumeClaim(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.PersistentVolumeClaim",
):
    '''A PersistentVolumeClaim (PVC) is a request for storage by a user.

    It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
    Pods can request specific levels of resources (CPU and Memory).
    Claims can request specific size and access modes
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2d0c9a87c83576d8fc4d7aa13301e7656a7f5fea2db21ae487827b2bde48efb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeClaimProps(
            access_modes=access_modes,
            storage=storage,
            storage_class_name=storage_class_name,
            volume=volume,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClaimName")
    @builtins.classmethod
    def from_claim_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim_name: builtins.str,
    ) -> IPersistentVolumeClaim:
        '''Imports a pvc from the cluster as a reference.

        :param scope: -
        :param id: -
        :param claim_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c873bf51b3a1aa35b04ac7e754d950042fcf278f25ec1a9a3f3dcc89e8295ae7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim_name", value=claim_name, expected_type=type_hints["claim_name"])
        return typing.cast(IPersistentVolumeClaim, jsii.sinvoke(cls, "fromClaimName", [scope, id, claim_name]))

    @jsii.member(jsii_name="bind")
    def bind(self, vol: IPersistentVolume) -> None:
        '''Bind a claim to a specific volume.

        Note that you must also bind the volume to the claim.

        :param vol: The PV to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb250fc0742d3c8796551d5e955ad0b5ba4ed1f19ad732bab5e0b78f41074bf0)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "bind", [vol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="volumeMode")
    def volume_mode(self) -> PersistentVolumeMode:
        '''Volume mode requirement of this claim.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "volumeMode"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage requirement of this claim.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class requirment of this claim.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))

    @builtins.property
    @jsii.member(jsii_name="volume")
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''PV this claim is bound to.

        Undefined means the claim is not bound
        to any specific volume.
        '''
        return typing.cast(typing.Optional[IPersistentVolume], jsii.get(self, "volume"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PersistentVolumeClaimProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume": "volume",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeClaimProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolumeClaim``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bfe13acab7fb89d0f1907fb411ad60d8fb5f8bde2c46a28992f53def1096637)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume is not None:
            self._values["volume"] = volume
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains the access modes the volume should support.

        :default: - No access modes requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Minimum storage size the volume should have.

        :default: - No storage requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:.

        - If the admission plugin is turned on, the storage class marked as default will be used.
        - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class.

        :default: - Not set.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''The PersistentVolume backing this claim.

        The control plane still checks that storage class, access modes,
        and requested storage size on the volume are valid.

        Note that in order to guarantee a proper binding, the volume should
        also define a ``claimRef`` referring to this claim. Otherwise, the volume may be
        claimed be other pvc's before it gets a chance to bind to this one.

        If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily
        create a bi-directional bounded claim.

        :default: - No specific volume binding.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding.
        '''
        result = self._values.get("volume")
        return typing.cast(typing.Optional[IPersistentVolume], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PersistentVolumeProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__705bd37828ee24f568313ee1aa4790573bfe134075792dd83c469f41ae71d8b4)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Pod(AbstractPod, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Pod"):
    '''Pod is a collection of containers that can run on a host.

    This resource is
    created by clients and scheduled onto hosts.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f78727832575ca7601b6a2dc2400238a1937f06746d668b06b19296cffb719d2)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="ADDRESS_LABEL")
    def ADDRESS_LABEL(cls) -> builtins.str:
        '''This label is autoamtically added by cdk8s to any pod.

        It provides
        a unique and stable identifier for the pod.
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "ADDRESS_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> PodScheduling:
        return typing.cast(PodScheduling, jsii.get(self, "scheduling"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.PodProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
    },
)
class PodProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``Pod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99808c3346bba4a516dbb87de8787fe147750067f3478c6acb25d67e58aaf5b2)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.SecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "string_data": "stringData",
        "type": "type",
    },
)
class SecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f6f7cc7c399e414ac0bcdcdbb633460637598d57fad6bc5fa2c01fb91d382de)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument string_data", value=string_data, expected_type=type_hints["string_data"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable
        if string_data is not None:
            self._values["string_data"] = string_data
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def string_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''stringData allows specifying non-binary secret data in string form.

        It is
        provided as a write-only convenience method. All keys and values are merged
        into the data field on write, overwriting any existing values. It is never
        output when reading from the API.
        '''
        result = self._values.get("string_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Optional type associated with the secret.

        Used to facilitate programmatic
        handling of secret data by various controllers.

        :default: undefined - Don't set a type.
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IServiceAccount, ISubject)
class ServiceAccount(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ServiceAccount",
):
    '''A service account provides an identity for processes that run in a Pod.

    When you (a human) access the cluster (for example, using kubectl), you are
    authenticated by the apiserver as a particular User Account (currently this
    is usually admin, unless your cluster administrator has customized your
    cluster). Processes in containers inside pods can also contact the apiserver.
    When they do, they are authenticated as a particular Service Account (for
    example, default).

    :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a11b518d2a9cbbb1b9b04fce01b115605aec0453a41ecae3a229c7887ad6d384)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountProps(
            automount_token=automount_token, secrets=secrets, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromServiceAccountName")
    @builtins.classmethod
    def from_service_account_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        namespace_name: typing.Optional[builtins.str] = None,
    ) -> IServiceAccount:
        '''Imports a service account from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: The name of the service account resource.
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d1b779eeb118f39c620f6deacf25830f53ad6a3b1e49fd2600323f0f9ef46729)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = FromServiceAccountNameOptions(namespace_name=namespace_name)

        return typing.cast(IServiceAccount, jsii.sinvoke(cls, "fromServiceAccountName", [scope, id, name, options]))

    @jsii.member(jsii_name="addSecret")
    def add_secret(self, secr: ISecret) -> None:
        '''Allow a secret to be accessed by pods using this service account.

        :param secr: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66a7d949766b4313d6a920cc8ae147c7e1cccee4ad7f38d3805640cb9cafebe3)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast(None, jsii.invoke(self, "addSecret", [secr]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="automountToken")
    def automount_token(self) -> builtins.bool:
        '''Whether or not a token is automatically mounted for this service account.'''
        return typing.cast(builtins.bool, jsii.get(self, "automountToken"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="secrets")
    def secrets(self) -> typing.List[ISecret]:
        '''List of secrets allowed to be used by pods running using this service account.

        Returns a copy. To add a secret, use ``addSecret()``.
        '''
        return typing.cast(typing.List[ISecret], jsii.get(self, "secrets"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.ServiceAccountTokenSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "service_account": "serviceAccount",
    },
)
class ServiceAccountTokenSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        service_account: IServiceAccount,
    ) -> None:
        '''Options for ``ServiceAccountTokenSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param service_account: The service account to store a secret for.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2b5dcba70502c523334defbe01c40c9df9931713cce37a4d1897d2a1fa72151)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "service_account": service_account,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def service_account(self) -> IServiceAccount:
        '''The service account to store a secret for.'''
        result = self._values.get("service_account")
        assert result is not None, "Required property 'service_account' is missing"
        return typing.cast(IServiceAccount, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountTokenSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.SshAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "ssh_private_key": "sshPrivateKey",
    },
)
class SshAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        ssh_private_key: builtins.str,
    ) -> None:
        '''Options for ``SshAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param ssh_private_key: The SSH private key to use.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bca6f27f0aab0321fbb14c876622c57050d0b1ccda461d4e04c79e07ed388fb)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument ssh_private_key", value=ssh_private_key, expected_type=type_hints["ssh_private_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "ssh_private_key": ssh_private_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ssh_private_key(self) -> builtins.str:
        '''The SSH private key to use.'''
        result = self._values.get("ssh_private_key")
        assert result is not None, "Required property 'ssh_private_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SshAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.TlsSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "tls_cert": "tlsCert",
        "tls_key": "tlsKey",
    },
)
class TlsSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        tls_cert: builtins.str,
        tls_key: builtins.str,
    ) -> None:
        '''Options for ``TlsSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b73b953a6e73e619ad4ab6f1e04150c930065d5245ef5b89b606e610f6fbe30)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument tls_cert", value=tls_cert, expected_type=type_hints["tls_cert"])
            check_type(argname="argument tls_key", value=tls_key, expected_type=type_hints["tls_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "tls_cert": tls_cert,
            "tls_key": tls_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def tls_cert(self) -> builtins.str:
        '''The TLS cert.'''
        result = self._values.get("tls_cert")
        assert result is not None, "Required property 'tls_cert' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def tls_key(self) -> builtins.str:
        '''The TLS key.'''
        result = self._values.get("tls_key")
        assert result is not None, "Required property 'tls_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TlsSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Workload(
    AbstractPod,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-28.Workload",
):
    '''A workload is an application running on Kubernetes.

    Whether your workload is a single
    component or several that work together, on Kubernetes you run it inside a set of pods.
    In Kubernetes, a Pod represents a set of running containers on your cluster.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57fe3424b4c77ffe2705e0b5aa6980d85d242b43f906b4b23ee26cbd54a7dd21)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = WorkloadProps(
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="select")
    def select(self, *selectors: LabelSelector) -> None:
        '''Configure selectors for this workload.

        :param selectors: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2cec6a9fc74909116a5ea4f223069fb0fa9204b394c20a657358818d807a9768)
            check_type(argname="argument selectors", value=selectors, expected_type=typing.Tuple[type_hints["selectors"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "select", [*selectors]))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="matchExpressions")
    def match_expressions(self) -> typing.List[LabelSelectorRequirement]:
        '''The expression matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add expression matchers.
        '''
        return typing.cast(typing.List[LabelSelectorRequirement], jsii.get(self, "matchExpressions"))

    @builtins.property
    @jsii.member(jsii_name="matchLabels")
    def match_labels(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The label matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add label matchers.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "matchLabels"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        '''The metadata of pods in this workload.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> WorkloadScheduling:
        return typing.cast(WorkloadScheduling, jsii.get(self, "scheduling"))


class _WorkloadProxy(
    Workload,
    jsii.proxy_for(AbstractPod), # type: ignore[misc]
):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Workload).__jsii_proxy_class__ = lambda : _WorkloadProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-28.WorkloadProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
    },
)
class WorkloadProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``Workload``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60036db11efcdc090493a019715a708abeab3df467dcf94f93d4f7bc8d82f12e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AwsElasticBlockStorePersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.AwsElasticBlockStorePersistentVolume",
):
    '''Represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66657bc422c87d3212cfc74f5d5ce04d8266ff6010cbb700b18ae45b8ffdc1ba)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AwsElasticBlockStorePersistentVolumeProps(
            volume_id=volume_id,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="volumeId")
    def volume_id(self) -> builtins.str:
        '''Volume id of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "volumeId"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AwsElasticBlockStorePersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStorePersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AwsElasticBlockStorePersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b08fd80ce07e27e5eb75a9ae994302324ae8fc39f1c3ced0e7e13ef2fe7af120)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''Unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStorePersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AzureDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.AzureDiskPersistentVolume",
):
    '''AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b55c4ae1cc85c155ad6ca61c27edcb4bb57ff7244d0eb544b446c93e3df5f874)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AzureDiskPersistentVolumeProps(
            disk_name=disk_name,
            disk_uri=disk_uri,
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="azureKind")
    def azure_kind(self) -> AzureDiskPersistentVolumeKind:
        '''Azure kind of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeKind, jsii.get(self, "azureKind"))

    @builtins.property
    @jsii.member(jsii_name="cachingMode")
    def caching_mode(self) -> AzureDiskPersistentVolumeCachingMode:
        '''Caching mode of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeCachingMode, jsii.get(self, "cachingMode"))

    @builtins.property
    @jsii.member(jsii_name="diskName")
    def disk_name(self) -> builtins.str:
        '''Disk name of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskName"))

    @builtins.property
    @jsii.member(jsii_name="diskUri")
    def disk_uri(self) -> builtins.str:
        '''Disk URI of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskUri"))

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.AzureDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AzureDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f67836815477b42bfd7281c57c39e7f82b422a72f6907dbc82e87b716684f6c)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''The Name of the data disk in the blob storage.'''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''The URI the data disk in the blob storage.'''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-28.BasicAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "password": "password",
        "username": "username",
    },
)
class BasicAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        password: builtins.str,
        username: builtins.str,
    ) -> None:
        '''Options for ``BasicAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12c61ecf7654820c809323040d37e1f12e1785f6946d0de7c996a2872380ece3)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "password": password,
            "username": username,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> builtins.str:
        '''The password or token for authentication.'''
        result = self._values.get("password")
        assert result is not None, "Required property 'password' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def username(self) -> builtins.str:
        '''The user name for authentication.'''
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BasicAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IClusterRole, IRole)
class ClusterRole(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.ClusterRole",
):
    '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8539ef19a83063267be12e2d3c885821fea671f7d3f65903266f96e4ffdf94c4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleProps(
            aggregation_labels=aggregation_labels, rules=rules, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClusterRoleName")
    @builtins.classmethod
    def from_cluster_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IClusterRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__846f4e4ae2012f517e6b7f5a2ae85be58fb80d714c07b70b48f4820dc45254ef)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IClusterRole, jsii.sinvoke(cls, "fromClusterRoleName", [scope, id, name]))

    @jsii.member(jsii_name="aggregate")
    def aggregate(self, key: builtins.str, value: builtins.str) -> None:
        '''Aggregate rules from roles matching this label selector.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e4831a53802d9295576a1a731f7a72106d08a95a3a7c5e0f94eb08116318710)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "aggregate", [key, value]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *endpoints: IApiEndpoint,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param endpoints: The endpoints(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__097a3c60430eb4e1bc635db062a5eebff7ec4c74cc3f98530dee5512257215ae)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *endpoints]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *endpoints: IApiEndpoint) -> None:
        '''Add "create" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb20c12a6443111f6316544bddd5aaf419fc0e9009af05a18b23b43378d8718b)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*endpoints]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *endpoints: IApiEndpoint) -> None:
        '''Add "delete" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a81af276823c11593368bb69a679a4270df3280258c8a75bdeecefbb9c272b4)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*endpoints]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *endpoints: IApiEndpoint) -> None:
        '''Add "deletecollection" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7cd96e92bf14de647a20bf527be30b4738ee4ffabca9d4699bc8e2c2df52b3fe)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*endpoints]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6febf6999dc36ae610466b40d9915911a2e63e7db1dd3104c98396da985eed45)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*endpoints]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *endpoints: IApiEndpoint) -> None:
        '''Add "list" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__494128b8cd0ae69727f4a4219e8efbff3eb010089c58e1d669d4e2091bd84f66)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*endpoints]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "patch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3ee06ba1869e9bb8633cded3cbbd09e36785e19a23d7b62702ea19d36a5a8d7)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*endpoints]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8f3822e70e492f5dbe1df21944933c46e280242dee9f24a7efc20508f1c1f90)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*endpoints]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08a0fbd455456052554b4f15475844f56f6489a891ae61864e7ee920cafcd0e6)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*endpoints]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *endpoints: IApiEndpoint) -> None:
        '''Add "update" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f7ada749b83d43b914577111ba6069931948aeca486a20f11c5c8ec5ac5ba97)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*endpoints]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "watch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0937102c819109f2718ee5a8c7482b33b7e202d746aa3b9e3dfcdcacf5d4388b)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*endpoints]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> ClusterRoleBinding:
        '''Create a ClusterRoleBinding that binds the permissions in this ClusterRole to a list of subjects, without namespace restrictions.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d1872e9ee0c3165c937e06c905087b0aa015ac2e59faddb54d6f58e01f96a3a)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(ClusterRoleBinding, jsii.invoke(self, "bind", [*subjects]))

    @jsii.member(jsii_name="bindInNamespace")
    def bind_in_namespace(
        self,
        namespace: builtins.str,
        *subjects: ISubject,
    ) -> RoleBinding:
        '''Create a RoleBinding that binds the permissions in this ClusterRole to a list of subjects, that will only apply to the given namespace.

        :param namespace: the namespace to limit permissions to.
        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__873a22302224513da2885a452bbe3ba34d4ae76e3db736429fc4d6e1bc9554f2)
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(RoleBinding, jsii.invoke(self, "bindInNamespace", [namespace, *subjects]))

    @jsii.member(jsii_name="combine")
    def combine(self, rol: "ClusterRole") -> None:
        '''Combines the rules of the argument ClusterRole into this ClusterRole using aggregation labels.

        :param rol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__934058556e71a9370fc8eb2f72b78eaed19433121fa9ce9f8af4c702fea95c0a)
            check_type(argname="argument rol", value=rol, expected_type=type_hints["rol"])
        return typing.cast(None, jsii.invoke(self, "combine", [rol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List[ClusterRolePolicyRule]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List[ClusterRolePolicyRule], jsii.get(self, "rules"))


@jsii.implements(IConfigMap)
class ConfigMap(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.ConfigMap"):
    '''ConfigMap holds configuration data for pods to consume.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d99faca6a1a4d9f06cb8517b57b0133b7977d9b7f7303179ca4ef8927b0e908)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromConfigMapName")
    @builtins.classmethod
    def from_config_map_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IConfigMap:
        '''Represents a ConfigMap created elsewhere.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c91b18b45046c1c3d2c7bbee276b51f4aca5585185d7f481d330303b84a430f9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IConfigMap, jsii.sinvoke(cls, "fromConfigMapName", [scope, id, name]))

    @jsii.member(jsii_name="addBinaryData")
    def add_binary_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a binary data entry to the config map.

        BinaryData can contain byte
        sequences that are not in the UTF-8 range.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__251e2d729e9bfd7b68dc90eb6b7a114ec85ab17d8b019a4a35cfa2d927d5f118)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addBinaryData", [key, value]))

    @jsii.member(jsii_name="addData")
    def add_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a data entry to the config map.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8e4fc8c3b731ccbd93eb4d91c7a5657b7e7ef61cf72147be771afb57eec2943)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addData", [key, value]))

    @jsii.member(jsii_name="addDirectory")
    def add_directory(
        self,
        local_dir: builtins.str,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a directory to the ConfigMap.

        :param local_dir: A path to a local directory.
        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2ce0d3cf2dc54af1585d238e73176350830bc35cf050abc42285f54a54bd8cd)
            check_type(argname="argument local_dir", value=local_dir, expected_type=type_hints["local_dir"])
        options = AddDirectoryOptions(exclude=exclude, key_prefix=key_prefix)

        return typing.cast(None, jsii.invoke(self, "addDirectory", [local_dir, options]))

    @jsii.member(jsii_name="addFile")
    def add_file(
        self,
        local_file: builtins.str,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a file to the ConfigMap.

        :param local_file: The path to the local file.
        :param key: The ConfigMap key (default to the file name).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aea093099bbf0a0217e97a48b74ac47f4b69bc64e511ac65c2d3fe070cb3ed0c)
            check_type(argname="argument local_file", value=local_file, expected_type=type_hints["local_file"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(None, jsii.invoke(self, "addFile", [local_file, key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="binaryData")
    def binary_data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The binary data associated with this config map.

        Returns a copy. To add data records, use ``addBinaryData()`` or ``addData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "binaryData"))

    @builtins.property
    @jsii.member(jsii_name="data")
    def data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The data associated with this config map.

        Returns an copy. To add data records, use ``addData()`` or ``addBinaryData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "data"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not this config map is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class CronJob(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.CronJob"):
    '''A CronJob is responsible for creating a Job and scheduling it based on provided cron schedule.

    This helps running Jobs in a recurring manner.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        schedule: _cdk8s_d3d9af27.Cron,
        concurrency_policy: typing.Optional[ConcurrencyPolicy] = None,
        failed_jobs_retained: typing.Optional[jsii.Number] = None,
        starting_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        successful_jobs_retained: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        time_zone: typing.Optional[builtins.str] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param schedule: Specifies the time in which the job would run again. This is defined as a cron expression in the CronJob resource.
        :param concurrency_policy: Specifies the concurrency policy for the job. Default: ConcurrencyPolicy.Forbid
        :param failed_jobs_retained: Specifies the number of failed jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 1
        :param starting_deadline: Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed. This deadline specifies how much time can pass after a schedule point, for which kubernetes can still start the job. For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after the scheduled time. Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10 seconds is not allowed, as it may cause your job to never be scheduled. In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason). This property also controls what time interval should kubernetes consider when counting for missed schedules. For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00, and its ``startingDeadline`` field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00, the job will not start as the number of missed jobs which missed their schedule is greater than 100. However, if ``startingDeadline`` is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus start a new execution at 10:22:00. Default: Duration.seconds(10)
        :param successful_jobs_retained: Specifies the number of successful jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 3
        :param suspend: Specifies if the cron job should be suspended. Only applies to future executions, current ones are remained untouched. Default: false
        :param time_zone: Specifies the timezone for the job. This helps aligining the schedule to follow the specified timezone. Default: - Timezone of kube-controller-manager process.
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6bc05f27034bcc950a238442673d1416de77d58e753207e70c07011eab4dff70)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CronJobProps(
            schedule=schedule,
            concurrency_policy=concurrency_policy,
            failed_jobs_retained=failed_jobs_retained,
            starting_deadline=starting_deadline,
            successful_jobs_retained=successful_jobs_retained,
            suspend=suspend,
            time_zone=time_zone,
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="concurrencyPolicy")
    def concurrency_policy(self) -> builtins.str:
        '''The policy used by this cron job to determine the concurrency mode in which to schedule jobs.'''
        return typing.cast(builtins.str, jsii.get(self, "concurrencyPolicy"))

    @builtins.property
    @jsii.member(jsii_name="failedJobsRetained")
    def failed_jobs_retained(self) -> jsii.Number:
        '''The number of failed jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "failedJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''Represents the resource type.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> _cdk8s_d3d9af27.Cron:
        '''The schedule this cron job is scheduled to run in.'''
        return typing.cast(_cdk8s_d3d9af27.Cron, jsii.get(self, "schedule"))

    @builtins.property
    @jsii.member(jsii_name="startingDeadline")
    def starting_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The time by which the running cron job needs to schedule the next job execution.

        The job is considered as failed if it misses this deadline.
        '''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "startingDeadline"))

    @builtins.property
    @jsii.member(jsii_name="successfulJobsRetained")
    def successful_jobs_retained(self) -> jsii.Number:
        '''The number of successful jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "successfulJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="suspend")
    def suspend(self) -> builtins.bool:
        '''Whether or not the cron job is currently suspended or not.'''
        return typing.cast(builtins.bool, jsii.get(self, "suspend"))

    @builtins.property
    @jsii.member(jsii_name="timeZone")
    def time_zone(self) -> typing.Optional[builtins.str]:
        '''The timezone which this cron job would follow to schedule jobs.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "timeZone"))


class DaemonSet(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.DaemonSet"):
    '''A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.

    As nodes are added to the cluster, Pods are added to them.
    As nodes are removed from the cluster, those Pods are garbage collected.
    Deleting a DaemonSet will clean up the Pods it created.

    Some typical uses of a DaemonSet are:

    - running a cluster storage daemon on every node
    - running a logs collection daemon on every node
    - running a node monitoring daemon on every node

    In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
    A more complex setup might use multiple DaemonSets for a single type of daemon,
    but with different flags and/or different memory and cpu requests for different hardware types.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e1a9915585250ae6557d98658ea259b2e5b2c4acdd1c5df5caca4a69734e1865)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DaemonSetProps(
            min_ready_seconds=min_ready_seconds,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReadySeconds")
    def min_ready_seconds(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minReadySeconds"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DaemonSetProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready_seconds": "minReadySeconds",
    },
)
class DaemonSetProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``DaemonSet``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f70670ec3b0aa5b49df0824d55618091cfba2e2423981d3d640ebfbaa7b404b)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        :default: 0
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class Deployment(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.Deployment",
):
    '''A Deployment provides declarative updates for Pods and ReplicaSets.

    You describe a desired state in a Deployment, and the Deployment Controller changes the actual
    state to the desired state at a controlled rate. You can define Deployments to create new ReplicaSets, or to remove
    existing Deployments and adopt all their resources with new Deployments.
    .. epigraph::

       Note: Do not manage ReplicaSets owned by a Deployment. Consider opening an issue in the main Kubernetes repository if your use case is not covered below.

    Use Case

    The following are typical use cases for Deployments:

    - Create a Deployment to rollout a ReplicaSet. The ReplicaSet creates Pods in the background.
      Check the status of the rollout to see if it succeeds or not.
    - Declare the new state of the Pods by updating the PodTemplateSpec of the Deployment.
      A new ReplicaSet is created and the Deployment manages moving the Pods from the old ReplicaSet to the new one at a controlled rate.
      Each new ReplicaSet updates the revision of the Deployment.
    - Rollback to an earlier Deployment revision if the current state of the Deployment is not stable.
      Each rollback updates the revision of the Deployment.
    - Scale up the Deployment to facilitate more load.
    - Pause the Deployment to apply multiple fixes to its PodTemplateSpec and then resume it to start a new rollout.
    - Use the status of the Deployment as an indicator that a rollout has stuck.
    - Clean up older ReplicaSets that you don't need anymore.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bc0f90969bacdabae6b30957b01e297892a9792492622b736b802dbc7e0e579)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DeploymentProps(
            min_ready=min_ready,
            progress_deadline=progress_deadline,
            replicas=replicas,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional[Ingress] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> Ingress:
        '''Expose a deployment via an ingress.

        This will first expose the deployment with a service, and then expose the service via an ingress.

        :param path: The ingress path to register under.
        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7dad2f5778dfe111b4838354711ebc6a6a9b1de2b6a9b6c47ce8b79a1ebd98e2)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeDeploymentViaIngressOptions(
            name=name,
            ports=ports,
            service_type=service_type,
            ingress=ingress,
            path_type=path_type,
        )

        return typing.cast(Ingress, jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="exposeViaService")
    def expose_via_service(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
    ) -> Service:
        '''Expose a deployment via a service.

        This is equivalent to running ``kubectl expose deployment <deployment-name>``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        options = DeploymentExposeViaServiceOptions(
            name=name, ports=ports, service_type=service_type
        )

        return typing.cast(Service, jsii.invoke(self, "exposeViaService", [options]))

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="progressDeadline")
    def progress_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "progressDeadline"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> DeploymentStrategy:
        return typing.cast(DeploymentStrategy, jsii.get(self, "strategy"))

    @builtins.property
    @jsii.member(jsii_name="replicas")
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "replicas"))

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15764259b5b43e0462bbb3aeb76b40160024e01210009da9cb8065608b2cd8c6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-28.DeploymentProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready": "minReady",
        "progress_deadline": "progressDeadline",
        "replicas": "replicas",
        "strategy": "strategy",
    },
)
class DeploymentProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
    ) -> None:
        '''Properties for ``Deployment``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__430e07b2a46922fcda8f0adcb19d767b6599fc268f6ee1b5e0673a59b5ba3c3e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready", value=min_ready, expected_type=type_hints["min_ready"])
            check_type(argname="argument progress_deadline", value=progress_deadline, expected_type=type_hints["progress_deadline"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready is not None:
            self._values["min_ready"] = min_ready
        if progress_deadline is not None:
            self._values["progress_deadline"] = progress_deadline
        if replicas is not None:
            self._values["replicas"] = replicas
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Zero means the pod will be considered available as soon as it is ready.

        :default: Duration.seconds(0)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds
        '''
        result = self._values.get("min_ready")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def progress_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue
        to process failed deployments and a condition with a ProgressDeadlineExceeded
        reason will be surfaced in the deployment status.

        Note that progress will not be estimated during the time a deployment is paused.

        :default: Duration.seconds(600)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#progress-deadline-seconds
        '''
        result = self._values.get("progress_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        :default: 2
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional[DeploymentStrategy]:
        '''Specifies the strategy used to replace old Pods by new ones.

        :default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional[DeploymentStrategy], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class GCEPersistentDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.GCEPersistentDiskPersistentVolume",
):
    '''GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    Provisioned by an admin.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b95cf98d26abb1129ecb31e32e447f22fd398330bc7bf8a7450181a8ca837834)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = GCEPersistentDiskPersistentVolumeProps(
            pd_name=pd_name,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="pdName")
    def pd_name(self) -> builtins.str:
        '''PD resource in GCE of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "pdName"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.GCEPersistentDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``GCEPersistentDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e47d7c2fb71d9bd8edb805956c94b0f178bf6072924b5187301f509b3f1874a)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "pd_name": pd_name,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''Unique name of the PD resource in GCE.

        Used to identify the disk in GCE.

        :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Job(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-28.Job"):
    '''A Job creates one or more Pods and ensures that a specified number of them successfully terminate.

    As pods successfully complete,
    the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
    Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
    The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
    You can also use a Job to run multiple Pods in parallel.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e779fd90109ea0e25c223edc8bb8117687b4ca8bac6d19c21c581cd318f1355)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = JobProps(
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="activeDeadline")
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Duration before job is terminated.

        If undefined, there is no deadline.
        '''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "activeDeadline"))

    @builtins.property
    @jsii.member(jsii_name="backoffLimit")
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Number of retries before marking failed.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "backoffLimit"))

    @builtins.property
    @jsii.member(jsii_name="ttlAfterFinished")
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''TTL before the job is deleted after it is finished.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "ttlAfterFinished"))


@jsii.data_type(
    jsii_type="cdk8s-plus-28.JobProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "host_network": "hostNetwork",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "termination_grace_period": "terminationGracePeriod",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "active_deadline": "activeDeadline",
        "backoff_limit": "backoffLimit",
        "ttl_after_finished": "ttlAfterFinished",
    },
)
class JobProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Properties for ``Job``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d789b2fe1193a2d2149d46636d539a71190538f608cd0e641070f85b8475731)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument host_network", value=host_network, expected_type=type_hints["host_network"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument termination_grace_period", value=termination_grace_period, expected_type=type_hints["termination_grace_period"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument active_deadline", value=active_deadline, expected_type=type_hints["active_deadline"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument ttl_after_finished", value=ttl_after_finished, expected_type=type_hints["ttl_after_finished"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if host_network is not None:
            self._values["host_network"] = host_network
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if termination_grace_period is not None:
            self._values["termination_grace_period"] = termination_grace_period
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if active_deadline is not None:
            self._values["active_deadline"] = active_deadline
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if ttl_after_finished is not None:
            self._values["ttl_after_finished"] = ttl_after_finished

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[ISecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[ISecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def host_network(self) -> typing.Optional[builtins.bool]:
        '''Host network for the pod.

        :default: false
        '''
        result = self._values.get("host_network")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def termination_grace_period(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Grace period until the pod is terminated.

        :default: Duration.seconds(30)
        '''
        result = self._values.get("termination_grace_period")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Specifies the duration the job may be active before the system tries to terminate it.

        :default: - If unset, then there is no deadline.
        '''
        result = self._values.get("active_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        :default: - If not set, system defaults to 6.
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, after the Job finishes, it is eligible to
        be automatically deleted. When the Job is being deleted, its lifecycle
        guarantees (e.g. finalizers) will be honored. If this field is set to zero,
        the Job becomes eligible to be deleted immediately after it finishes. This
        field is alpha-level and is only honored by servers that enable the
        ``TTLAfterFinished`` feature.

        :default: - If this field is unset, the Job won't be automatically deleted.
        '''
        result = self._values.get("ttl_after_finished")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class StatefulSet(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-28.StatefulSet",
):
    '''StatefulSet is the workload API object used to manage stateful applications.

    Manages the deployment and scaling of a set of Pods, and provides guarantees
    about the ordering and uniqueness of these Pods.

    Like a Deployment, a StatefulSet manages Pods that are based on an identical
    container spec. Unlike a Deployment, a StatefulSet maintains a sticky identity
    for each of their Pods. These pods are created from the same spec, but are not
    interchangeable: each has a persistent identifier that it maintains across any
    rescheduling.

    If you want to use storage volumes to provide persistence for your workload, you
    can use a StatefulSet as part of the solution. Although individual Pods in a StatefulSet
    are susceptible to failure, the persistent Pod identifiers make it easier to match existing
    volumes to the new Pods that replace any that have failed.


    Using StatefulSets

    StatefulSets are valuable for applications that require one or more of the following.

    - Stable, unique network identifiers.
    - Stable, persistent storage.
    - Ordered, graceful deployment and scaling.
    - Ordered, automated rolling updates.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_management_policy: typing.Optional[PodManagementPolicy] = None,
        replicas: typing.Optional[jsii.Number] = None,
        service: typing.Optional[Service] = None,
        strategy: typing.Optional[StatefulSetUpdateStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[ISecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        host_network: typing.Optional[builtins.bool] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        termination_grace_period: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Default: Duration.seconds(0)
        :param pod_management_policy: Pod management policy to use for this statefulset. Default: PodManagementPolicy.ORDERED_READY
        :param replicas: Number of desired pods. Default: 1
        :param service: Service to associate with the statefulset. Default: - A new headless service will be created.
        :param strategy: Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. Default: - RollingUpdate with partition set to 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param host_network: Host network for the pod. Default: false
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param termination_grace_period: Grace period until the pod is terminated. Default: Duration.seconds(30)
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c0d28ae84afa9886781e077fbaf89f6f403c66a6ed5308960e44aa750a1ff40)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = StatefulSetProps(
            min_ready=min_ready,
            pod_management_policy=pod_management_policy,
            replicas=replicas,
            service=service,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            host_network=host_network,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            termination_grace_period=termination_grace_period,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="podManagementPolicy")
    def pod_management_policy(self) -> PodManagementPolicy:
        '''Management policy to use for the set.'''
        return typing.cast(PodManagementPolicy, jsii.get(self, "podManagementPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, 