# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deepl_scraper_pp2']

package_data = \
{'': ['*']}

install_requires = \
['about-time>=4.2.1,<5.0.0',
 'fastapi>=0.89.1,<0.90.0',
 'get-ppbrowser>=0.1.3,<0.2.0',
 'logzero>=1.6.3,<2.0.0',
 'nest-asyncio>=1.5.6,<2.0.0',
 'pyquery>=1.4.3,<2.0.0',
 'uvicorn>=0.13.4,<0.14.0']

setup_kwargs = {
    'name': 'deepl-scraper-pp2',
    'version': '0.1.0a1',
    'description': 'scrape deepl via pyppeteer2 with para info',
    'long_description': '# deepl-scraper-pp2\n[![tests](https://github.com/ffreemt/deepl-scraper-pyppeteer2/actions/workflows/routine-tests.yml/badge.svg)][![python](https://img.shields.io/static/v1?label=python+&message=3.8.3%2B&color=blue)](https://img.shields.io/static/v1?label=python+&message=3.8.3%2B&color=blue)[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)[![PyPI version](https://badge.fury.io/py/deepl-scraper-pp2.svg)](https://badge.fury.io/py/deepl-scraper-pp2)\n\nscrape deepl using pyppeteer2 with para info, cross platform (Windows/MacOS/Linux)\n\n## Intro\n`deepl-scraper-pp2` is more or less deepl-scraper-pp. `deepl-scraper-pp2` however preserves newlines in the translated text. Hence, it will make life easier when trying to process large chunks of text. `deepl-scraper-pp2` is originally intended for `deepl-tr-webui` but can be used elsewhere as well.\n\n## Installation\n\n```bash\npip install deepl-scraper-pp2\n# pip install deepl-scraper-pp2  # upgrade to the latest version\n```\nor\n```bash\npoetry add deepl-scraper-pp2\n# poetry add deepl-scraper-pp2@latest  # upgrade to the latest version\n```\n\nor clone the repo (``git clone https://github.com/ffreemt/deepl-scraper-pyppeteer2.git``) and install from it.\n\n## Usage\n\n### in `python`\n\n```python\nimport asyncio\nfrom deepl_scraper_pp2.deepl_tr import deepl_tr\n\nprint(asyncio.run(deepl_tr("test 1 \\n\\n test 2"))\n\n# \'测试1 \\n\\n  测试2\'\n```\n\n### Or start a local server\n```bash\nuvicorn deepl_scraper_pp2.deepl_server:app\n\n# or\npython -m deepl_scraper_pp2.run_uvicorn\n```\n\n#### and consume the REST API\n```python\nres = requests.post(\n  "http://127.0.0.1:8000/text",\n  json={\n    "text": "test 1\\n\\ntest2",\n    "to_lang": "zh"},\n    headers={"accept": "application/json", "Content-Type": "application/json"}\n)\nprint(res.json())\n# {\'q\': {\'text\': \'test 1\\n\\ntest2\', \'from_lang\': None, \'to_lang\': \'zh\', \'description\': None}, \'result\': \'测试1\\n\\n测试2\'}\n```\n\nConsult [http://127.0.0.1:8000/docs](http://127.0.0.1:8000/docs) for details.\n\n## Disclaimer\n\nThe pypi is beta and will likely remain beta -- use it at your own peril.\n\n<!---\n\nIn [367]: doc0("div.lmt__textarea.lmt__textarea_dummydiv").text()\nOut[367]: \'test you are me new lines 试探你是我 新行\'\n\n# doc0("div#target-dummydiv").text()\nIn [371]: doc0("#target-dummydiv").text()\nOut[371]: \'试探你是我 新行\'\n\nIn [394]: doc0("#target-dummydiv").html()\nOut[394]: \'试探你是我\\n新行\\n\\n\'\n\n# doc0("button.lmt__translations_as_text__text_btn").text()\nIn [369]: doc0(".lmt__translations_as_text__text_btn").text()\nOut[369]: \'试探你是我 新行\'\nIn [369]: doc0(".lmt__translations_as_text__text_btn").html()\n\n\nIn [388]: re.findall(r"<button class=\\"lmt__translations_as_text__text_btn[\\s\\S]*?>[\\s\\S]*?<\\/button>", text0)\nOut[388]: [\'<button class="lmt__translations_as_text__text_btn">试探你是我\\n新行</button>\']\n\nre.findall(r"<div id=\\"target-dummydiv[\\s\\S]*?>[\\s\\S]*?<\\/div>", text0)\n[\'<div id="target-dummydiv" class="lmt__textarea lmt__textarea_dummydiv">试探你是我\\n新行\\n\\n</div>\']\n\n\nextract format:  no need of html.escape\n\ntextarea = await page.wait_for_selector(\'//textarea\', timeout=1 * 1000)\n\nre.findall(r\'lmt__translations_as_text__text_btn">([\\s\\S]+?)<\\/button>\', doc.html())\n  re.findall(r\'lmt__translations_as_text__text_btn">([\\s\\S]+?)<\\/button>\', await page.content())\n\n===\nfrom get_pwbrowser import get_pwbrowser\n\nbrowser = await get_pwbrowser(headless=False)\ncontext = await browser.new_context()\npage = await context.new_page()\n\nurl = \'https://translate.google.cn/?sl=auto&tl=zh-CN&op=translate\'\nurl = \'https://www.deepl.com/translator\'\nawait page.goto(url)  # 10 s\n\ntextarea = await page.wait_for_selector(\'//textarea\', timeout=1 * 1000)\n\nsel_btn = "button.lmt__clear_text_button"\n\nwith CodeTimer():\n    for text in [\' test 1 \' * 10, \' test 2 \' * 10, \' test 3\' *10]:\n        # await textarea.fill(\'a\')\n        # await textarea.fill(\'a\')\n\n        # await page.evaluate(f\'() => document.querySelectorAll("{sel_btn}")\')\n\n        _ = await is_visible(sel_btn, page)\n        if _:\n            clear_button = await page.wait_for_selector(f"{sel_btn}", timeout=1000)\n            await clear_button.click()\n        await textarea.fill(text)\n\n        idx = 0\n        flag = False\n        ulimit = 1 / 0.1\n        while not flag and idx < ulimit:\n            idx += 1\n            content = await page.content()\n            doc = pq(content)\n\n            flag = re.findall(r\'lmt__translations_as_text__text_btn\', doc.html())\n            logger.debug(flag)\n            if flag:\n                break\n            await asyncio.sleep(0.1)\n        logger.info("loop: %s", idx)\n\n        res = re.findall(r\'lmt__translations_as_text__text_btn">([\\s\\S]+?)<\\/button>\', await page.content())\n        print(res)\n        # does not work for long text!\n\n# https://stackoverflow.com/questions/47712679/how-can-i-check-that-an-element-is-visible-with-puppeteer-and-pure-javascript\nselector = \'button.lmt__clear_text_button\'\n\nlet elem = document.querySelector(selector);\nconst style = getComputedStyle(elem);\nconst rect1 = elem.getBoundingClientRect();\nstyle.visibility !== \'hidden\' && !!(rect1.bottom || rect1.top || rect1.height || rect1.width);\n\n# ==\nconst element_is_visible = await page.evaluate(() => {\n  const element = document.querySelector(\'button.lmt__clear_text_button\');\n  const style = getComputedStyle(element);\n  const rect = element.getBoundingClientRect();\n\n  return style.visibility !== \'hidden\' && !!(rect.bottom || rect.top || rect.height || rect.width);\n});\n\nawait textarea.fill(text)\n\nstr_ = f"""const element = document.querySelector(\'{sel_btn}\');\n  const style = getComputedStyle(element);\n  const rect = element.getBoundingClientRect();\n  return style.visibility !== \'hidden\' && !!(rect.bottom || rect.top || rect.height || rect.width);"""\n# visibility\nvisibility = await page.evaluate(f\'() => {{{str_}}}\')\nprint(\'visibility\', visibility)\n\nif visibility:\n    cbtn= await page.wait_for_selector(f"{sel_btn}", timeout=1000)\n    await cbtn.click(timeout=1000, no_wait_after=True)\n\nasync def is_visible(selector, page):\n    _ = f"""const element = document.querySelector(\'{selector}\'); if (element === null) return false;\n  const style = getComputedStyle(element);\n  const rect = element.getBoundingClientRect();\n  return style.visibility !== \'hidden\' && !!(rect.bottom || rect.top || rect.height || rect.width);"""\n    return await page.evaluate(f\'() => {{{_}}}\')\n\nasync def console_run(js, page):\n    _ = f\'() => {js}\'\n    print(_)\n    return await page.evaluate(_)\n\n--->',
    'author': 'freemt',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ffreemt/deepl-scraper-pyppeteer2',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.3,<4.0.0',
}


setup(**setup_kwargs)
