# cloudreactor-python-api-client

[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/CloudReactor/cloudreactor-python-api-client/CI)](https://github.com/CloudReactor/cloudreactor-python-api-client/actions/workflows/ci.yml)
[![Codecov](https://img.shields.io/codecov/c/github/CloudReactor/cloudreactor-python-api-client)](https://app.codecov.io/github/CloudReactor/cloudreactor-python-api-client)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![PyPI](https://img.shields.io/pypi/v/cloudreactor-api-client)](https://pypi.org/project/cloudreactor-api-client/)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/cloudreactor-api-client)
[![PyPI - License](https://img.shields.io/pypi/l/cloudreactor-api-client)](https://opensource.org/licenses/BSD-2-Clause)
![Snyk Vulnerabilities for GitHub Repo](https://img.shields.io/snyk/vulnerabilities/github/CloudReactor/cloudreactor-python-api-client)


Python client for the CloudReactor API

## Overview

This python package allows python applications to programmatically
create, monitor, and manage Tasks and Workflows in
[CloudReactor](https://cloudreactor.io/). Most
notably, you can start and stop Tasks and Workflows by creating Task
Executions and Workflow Executions.

See the [CloudReactor landing page](https://www.cloudreactor.io/) to see the
benefits of monitoring and managing your tasks with CloudReactor.

## Installation

Get this package from PyPI:

```bash
pip install cloudreactor_api_client
```

## Usage

First, create a client:

```python
from cloudreactor_api_client import AuthenticatedClient

client = AuthenticatedClient(base_url="https://api.cloudreactor.io/api/v1",
    token="YOUR_API_KEY")

```

To start a Task, create a Task Execution:

```python
from cloudreactor_api_client.api.task_executions import (
    task_executions_create
)
from cloudreactor_api_client.models import (
    TaskExecution,
    TaskExecutionStatus
)

# Identify the Task by name. Alternatively, you can specifiy the "uuid".
task_dict = {"name": "HappyTask"}

task_execution = TaskExecution.from_dict({
    "task": task_dict,
    "status": TaskExecutionStatus.MANUALLY_STARTED
})

response = task_executions_create.sync_detailed(client=client,
    json_body=task_execution)

parsed_task_execution = response.parsed

print(f"Task Execution {parsed_task_execution.uuid} started!")

```

More details on how to use API clients in general (async mode, disabling SSL)
can be found in the generated [README](https://github.com/CloudReactor/cloudreactor-python-api-client/blob/master/cloudreactor-api-client/README-generated.md).


## License

This software is licensed under the BSD 2-Clause License.
See `LICENSE` for details.

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/jtsay362"><img src="https://avatars0.githubusercontent.com/u/1079646?s=460&v=4?s=80" width="80px;" alt=""/><br /><sub><b>Jeff Tsay</b></sub></a><br /><a href="https://github.com/CloudReactor/cloudreactor-api-client/commits?author=jtsay362" title="Code">💻</a> <a href="https://github.com/CloudReactor/cloudreactor-procwrapper/commits?author=jtsay362" title="Documentation">📖</a> <a href="#infra-jtsay362" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-jtsay362" title="Maintenance">🚧</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

## Credits

Code generated by [openapi-python-client](https://github.com/openapi-generators/openapi-python-client)
