---

author: gk
version: 20200601

---

# Generating Markdown - While Testing Contained Claims

[![Build Status](https://travis-ci.org/axiros/pytest2md.svg?branch=master)](https://travis-ci.org/axiros/pytest2md) [![codecov](https://codecov.io/gh/axiros/pytest2md/branch/master/graph/badge.svg)](https://codecov.io/gh/axiros/pytest2md)[![PyPI    version][pypisvg]][pypi] [![][blacksvg]][black]

[blacksvg]: https://img.shields.io/badge/code%20style-black-000000.svg
[black]: https://github.com/ambv/black
[pypisvg]: https://img.shields.io/pypi/v/pytest2md.svg
[pypi]: https://badge.fury.io/py/pytest2md

<!-- badges: http://thomas-cokelaer.info/blog/2014/08/1013/ -->


<!-- only hoster for this repo is github, so we fix the links: -->
<!-- md_links_for: github -->

[TOC]

Few things are more annoying than stuff which does not work as announced,
especially when you find out only after an invest of time and energy.

Documentation is often prone to produce such situations, since hard to keep
100% in sync with the code evolution.

<!-- autogen tutorial -->
<!-- autogen tutorial -->

# Tips

- Skip "inner" functions, except matching ones: `export P2RUN=my_func_name_match`

- Turn off stdout redirection: `export P2MFG=true` (for breakpoints in tested modules)

- Local Renderer:

    pip install grip

to get a local github compliant markdown renderer, reloading after changes of the generated markdown.

- Using fixtures with unittest style test classes

Create a `conftest.py` like:

```python
root@localhost tests]# cat conftest.py
import pytest
import pytest2md as p2m


@pytest.fixture(scope='class')
def write_md(request):
    def fin():
        request.cls.p2m.write_markdown(with_source_ref=True, make_toc=False)

    request.addfinalizer(fin)

```

then use like:

```
@pytest.mark.usefixtures('write_md')
class TestDevUsage(unittest.TestCase):
    p2m = p2m # on module level: p2m.P2M(__file__, fn_target_md='README.md')

    (...)

```




# Isolation

None. If you would screw up your host running pytest normally, then you will
get the same result, when running markdown generating tests.

----

[Here](https://github.com/axiros/pycond) is a bigger tutorial, from `pytest2md`.



