import zigpy.types as zigpy_t

FLAG = zigpy_t.uint8_t(0x14)


class FrameType(zigpy_t.enum2):
    INFORMATION = 1
    SUPERVISORY = 2
    UNNUMBERED = 3


class EndpointId(zigpy_t.enum8):
    SYSTEM = 0
    SECURITY = 1
    BLUETOOTH = 2
    RAIL_DOWNSTREAM = 3
    RAIL_UPSTREAM = 4
    ZIGBEE = 5
    ZWAVE = 6
    CONNECT = 7
    GPIO = 8
    OPENTHREAD = 9
    WISUN = 10
    WIFI = 11
    DOT15_4 = 12
    CLI = 13
    BLUETOOTH_RCP = 14
    ACP = 15


class UnnumberedFrameType(zigpy_t.enum8):
    INFORMATION = 0x00
    POLL_FINAL = 0x04
    RESET_SEQ = 0x31
    ACKNOWLEDGE = 0x0E
    UNKNOWN = 0xFF


class UnnumberedFrameCommandId(zigpy_t.enum8):
    NOOP = 0x00
    RESET = 0x01
    PROP_VALUE_GET = 0x02
    PROP_VALUE_SET = 0x03
    PROP_VALUE_IS = 0x06
    INVALID = 0xFF


class PropertyId(zigpy_t.enum32):
    LAST_STATUS = 0x0000
    PROTOCOL_VERSION = 0x0001
    CAPABILITIES = 0x0002
    SECONDARY_CPC_VERSION = 0x0003
    SECONDARY_APP_VERSION = 0x0004
    RX_CAPABILITY = 0x0020
    FC_VALIDATION_VALUE = 0x0030
    BOOTLOADER_INFO = 0x0200
    BOOTLOADER_REBOOT_MODE = 0x0202
    SECURITY_STATE = 0x0301
    CORE_DEBUG_COUNTERS = 0x0400
    UFRAME_PROCESSING = 0x0500
    ENTER_IRQ = 0x0600

    ENDPOINT_STATE_0 = 0x1000
    ENDPOINT_STATE_1 = 0x1001
    ENDPOINT_STATE_2 = 0x1002
    ENDPOINT_STATE_3 = 0x1003
    ENDPOINT_STATE_4 = 0x1004
    ENDPOINT_STATE_5 = 0x1005
    ENDPOINT_STATE_6 = 0x1006
    ENDPOINT_STATE_7 = 0x1007
    ENDPOINT_STATE_8 = 0x1008
    ENDPOINT_STATE_9 = 0x1009
    ENDPOINT_STATE_10 = 0x100A
    ENDPOINT_STATE_11 = 0x100B
    ENDPOINT_STATE_12 = 0x100C
    ENDPOINT_STATE_13 = 0x100D
    ENDPOINT_STATE_14 = 0x100E
    ENDPOINT_STATE_15 = 0x100F
    ENDPOINT_STATE_16 = 0x1010
    ENDPOINT_STATE_17 = 0x1011
    ENDPOINT_STATE_18 = 0x1012
    ENDPOINT_STATE_19 = 0x1013
    ENDPOINT_STATE_20 = 0x1014
    ENDPOINT_STATE_21 = 0x1015
    ENDPOINT_STATE_22 = 0x1016
    ENDPOINT_STATE_23 = 0x1017
    ENDPOINT_STATE_24 = 0x1018
    ENDPOINT_STATE_25 = 0x1019
    ENDPOINT_STATE_26 = 0x101A
    ENDPOINT_STATE_27 = 0x101B
    ENDPOINT_STATE_28 = 0x101C
    ENDPOINT_STATE_29 = 0x101D
    ENDPOINT_STATE_30 = 0x101E
    ENDPOINT_STATE_31 = 0x101F
    ENDPOINT_STATE_32 = 0x1020
    ENDPOINT_STATE_33 = 0x1021
    ENDPOINT_STATE_34 = 0x1022
    ENDPOINT_STATE_35 = 0x1023
    ENDPOINT_STATE_36 = 0x1024
    ENDPOINT_STATE_37 = 0x1025
    ENDPOINT_STATE_38 = 0x1026
    ENDPOINT_STATE_39 = 0x1027
    ENDPOINT_STATE_40 = 0x1028
    ENDPOINT_STATE_41 = 0x1029
    ENDPOINT_STATE_42 = 0x102A
    ENDPOINT_STATE_43 = 0x102B
    ENDPOINT_STATE_44 = 0x102C
    ENDPOINT_STATE_45 = 0x102D
    ENDPOINT_STATE_46 = 0x102E
    ENDPOINT_STATE_47 = 0x102F
    ENDPOINT_STATE_48 = 0x1030
    ENDPOINT_STATE_49 = 0x1031
    ENDPOINT_STATE_50 = 0x1032
    ENDPOINT_STATE_51 = 0x1033
    ENDPOINT_STATE_52 = 0x1034
    ENDPOINT_STATE_53 = 0x1035
    ENDPOINT_STATE_54 = 0x1036
    ENDPOINT_STATE_55 = 0x1037
    ENDPOINT_STATE_56 = 0x1038
    ENDPOINT_STATE_57 = 0x1039
    ENDPOINT_STATE_58 = 0x103A
    ENDPOINT_STATE_59 = 0x103B
    ENDPOINT_STATE_60 = 0x103C
    ENDPOINT_STATE_61 = 0x103D
    ENDPOINT_STATE_62 = 0x103E
    ENDPOINT_STATE_63 = 0x103F
    ENDPOINT_STATE_64 = 0x1040
    ENDPOINT_STATE_65 = 0x1041
    ENDPOINT_STATE_66 = 0x1042
    ENDPOINT_STATE_67 = 0x1043
    ENDPOINT_STATE_68 = 0x1044
    ENDPOINT_STATE_69 = 0x1045
    ENDPOINT_STATE_70 = 0x1046
    ENDPOINT_STATE_71 = 0x1047
    ENDPOINT_STATE_72 = 0x1048
    ENDPOINT_STATE_73 = 0x1049
    ENDPOINT_STATE_74 = 0x104A
    ENDPOINT_STATE_75 = 0x104B
    ENDPOINT_STATE_76 = 0x104C
    ENDPOINT_STATE_77 = 0x104D
    ENDPOINT_STATE_78 = 0x104E
    ENDPOINT_STATE_79 = 0x104F
    ENDPOINT_STATE_80 = 0x1050
    ENDPOINT_STATE_81 = 0x1051
    ENDPOINT_STATE_82 = 0x1052
    ENDPOINT_STATE_83 = 0x1053
    ENDPOINT_STATE_84 = 0x1054
    ENDPOINT_STATE_85 = 0x1055
    ENDPOINT_STATE_86 = 0x1056
    ENDPOINT_STATE_87 = 0x1057
    ENDPOINT_STATE_88 = 0x1058
    ENDPOINT_STATE_89 = 0x1059
    ENDPOINT_STATE_90 = 0x105A
    ENDPOINT_STATE_91 = 0x105B
    ENDPOINT_STATE_92 = 0x105C
    ENDPOINT_STATE_93 = 0x105D
    ENDPOINT_STATE_94 = 0x105E
    ENDPOINT_STATE_95 = 0x105F
    ENDPOINT_STATE_96 = 0x1060
    ENDPOINT_STATE_97 = 0x1061
    ENDPOINT_STATE_98 = 0x1062
    ENDPOINT_STATE_99 = 0x1063
    ENDPOINT_STATE_100 = 0x1064
    ENDPOINT_STATE_101 = 0x1065
    ENDPOINT_STATE_102 = 0x1066
    ENDPOINT_STATE_103 = 0x1067
    ENDPOINT_STATE_104 = 0x1068
    ENDPOINT_STATE_105 = 0x1069
    ENDPOINT_STATE_106 = 0x106A
    ENDPOINT_STATE_107 = 0x106B
    ENDPOINT_STATE_108 = 0x106C
    ENDPOINT_STATE_109 = 0x106D
    ENDPOINT_STATE_110 = 0x106E
    ENDPOINT_STATE_111 = 0x106F
    ENDPOINT_STATE_112 = 0x1070
    ENDPOINT_STATE_113 = 0x1071
    ENDPOINT_STATE_114 = 0x1072
    ENDPOINT_STATE_115 = 0x1073
    ENDPOINT_STATE_116 = 0x1074
    ENDPOINT_STATE_117 = 0x1075
    ENDPOINT_STATE_118 = 0x1076
    ENDPOINT_STATE_119 = 0x1077
    ENDPOINT_STATE_120 = 0x1078
    ENDPOINT_STATE_121 = 0x1079
    ENDPOINT_STATE_122 = 0x107A
    ENDPOINT_STATE_123 = 0x107B
    ENDPOINT_STATE_124 = 0x107C
    ENDPOINT_STATE_125 = 0x107D
    ENDPOINT_STATE_126 = 0x107E
    ENDPOINT_STATE_127 = 0x107F
    ENDPOINT_STATE_128 = 0x1080
    ENDPOINT_STATE_129 = 0x1081
    ENDPOINT_STATE_130 = 0x1082
    ENDPOINT_STATE_131 = 0x1083
    ENDPOINT_STATE_132 = 0x1084
    ENDPOINT_STATE_133 = 0x1085
    ENDPOINT_STATE_134 = 0x1086
    ENDPOINT_STATE_135 = 0x1087
    ENDPOINT_STATE_136 = 0x1088
    ENDPOINT_STATE_137 = 0x1089
    ENDPOINT_STATE_138 = 0x108A
    ENDPOINT_STATE_139 = 0x108B
    ENDPOINT_STATE_140 = 0x108C
    ENDPOINT_STATE_141 = 0x108D
    ENDPOINT_STATE_142 = 0x108E
    ENDPOINT_STATE_143 = 0x108F
    ENDPOINT_STATE_144 = 0x1090
    ENDPOINT_STATE_145 = 0x1091
    ENDPOINT_STATE_146 = 0x1092
    ENDPOINT_STATE_147 = 0x1093
    ENDPOINT_STATE_148 = 0x1094
    ENDPOINT_STATE_149 = 0x1095
    ENDPOINT_STATE_150 = 0x1096
    ENDPOINT_STATE_151 = 0x1097
    ENDPOINT_STATE_152 = 0x1098
    ENDPOINT_STATE_153 = 0x1099
    ENDPOINT_STATE_154 = 0x109A
    ENDPOINT_STATE_155 = 0x109B
    ENDPOINT_STATE_156 = 0x109C
    ENDPOINT_STATE_157 = 0x109D
    ENDPOINT_STATE_158 = 0x109E
    ENDPOINT_STATE_159 = 0x109F
    ENDPOINT_STATE_160 = 0x10A0
    ENDPOINT_STATE_161 = 0x10A1
    ENDPOINT_STATE_162 = 0x10A2
    ENDPOINT_STATE_163 = 0x10A3
    ENDPOINT_STATE_164 = 0x10A4
    ENDPOINT_STATE_165 = 0x10A5
    ENDPOINT_STATE_166 = 0x10A6
    ENDPOINT_STATE_167 = 0x10A7
    ENDPOINT_STATE_168 = 0x10A8
    ENDPOINT_STATE_169 = 0x10A9
    ENDPOINT_STATE_170 = 0x10AA
    ENDPOINT_STATE_171 = 0x10AB
    ENDPOINT_STATE_172 = 0x10AC
    ENDPOINT_STATE_173 = 0x10AD
    ENDPOINT_STATE_174 = 0x10AE
    ENDPOINT_STATE_175 = 0x10AF
    ENDPOINT_STATE_176 = 0x10B0
    ENDPOINT_STATE_177 = 0x10B1
    ENDPOINT_STATE_178 = 0x10B2
    ENDPOINT_STATE_179 = 0x10B3
    ENDPOINT_STATE_180 = 0x10B4
    ENDPOINT_STATE_181 = 0x10B5
    ENDPOINT_STATE_182 = 0x10B6
    ENDPOINT_STATE_183 = 0x10B7
    ENDPOINT_STATE_184 = 0x10B8
    ENDPOINT_STATE_185 = 0x10B9
    ENDPOINT_STATE_186 = 0x10BA
    ENDPOINT_STATE_187 = 0x10BB
    ENDPOINT_STATE_188 = 0x10BC
    ENDPOINT_STATE_189 = 0x10BD
    ENDPOINT_STATE_190 = 0x10BE
    ENDPOINT_STATE_191 = 0x10BF
    ENDPOINT_STATE_192 = 0x10C0
    ENDPOINT_STATE_193 = 0x10C1
    ENDPOINT_STATE_194 = 0x10C2
    ENDPOINT_STATE_195 = 0x10C3
    ENDPOINT_STATE_196 = 0x10C4
    ENDPOINT_STATE_197 = 0x10C5
    ENDPOINT_STATE_198 = 0x10C6
    ENDPOINT_STATE_199 = 0x10C7
    ENDPOINT_STATE_200 = 0x10C8
    ENDPOINT_STATE_201 = 0x10C9
    ENDPOINT_STATE_202 = 0x10CA
    ENDPOINT_STATE_203 = 0x10CB
    ENDPOINT_STATE_204 = 0x10CC
    ENDPOINT_STATE_205 = 0x10CD
    ENDPOINT_STATE_206 = 0x10CE
    ENDPOINT_STATE_207 = 0x10CF
    ENDPOINT_STATE_208 = 0x10D0
    ENDPOINT_STATE_209 = 0x10D1
    ENDPOINT_STATE_210 = 0x10D2
    ENDPOINT_STATE_211 = 0x10D3
    ENDPOINT_STATE_212 = 0x10D4
    ENDPOINT_STATE_213 = 0x10D5
    ENDPOINT_STATE_214 = 0x10D6
    ENDPOINT_STATE_215 = 0x10D7
    ENDPOINT_STATE_216 = 0x10D8
    ENDPOINT_STATE_217 = 0x10D9
    ENDPOINT_STATE_218 = 0x10DA
    ENDPOINT_STATE_219 = 0x10DB
    ENDPOINT_STATE_220 = 0x10DC
    ENDPOINT_STATE_221 = 0x10DD
    ENDPOINT_STATE_222 = 0x10DE
    ENDPOINT_STATE_223 = 0x10DF
    ENDPOINT_STATE_224 = 0x10E0
    ENDPOINT_STATE_225 = 0x10E1
    ENDPOINT_STATE_226 = 0x10E2
    ENDPOINT_STATE_227 = 0x10E3
    ENDPOINT_STATE_228 = 0x10E4
    ENDPOINT_STATE_229 = 0x10E5
    ENDPOINT_STATE_230 = 0x10E6
    ENDPOINT_STATE_231 = 0x10E7
    ENDPOINT_STATE_232 = 0x10E8
    ENDPOINT_STATE_233 = 0x10E9
    ENDPOINT_STATE_234 = 0x10EA
    ENDPOINT_STATE_235 = 0x10EB
    ENDPOINT_STATE_236 = 0x10EC
    ENDPOINT_STATE_237 = 0x10ED
    ENDPOINT_STATE_238 = 0x10EE
    ENDPOINT_STATE_239 = 0x10EF
    ENDPOINT_STATE_240 = 0x10F0
    ENDPOINT_STATE_241 = 0x10F1
    ENDPOINT_STATE_242 = 0x10F2
    ENDPOINT_STATE_243 = 0x10F3
    ENDPOINT_STATE_244 = 0x10F4
    ENDPOINT_STATE_245 = 0x10F5
    ENDPOINT_STATE_246 = 0x10F6
    ENDPOINT_STATE_247 = 0x10F7
    ENDPOINT_STATE_248 = 0x10F8
    ENDPOINT_STATE_249 = 0x10F9
    ENDPOINT_STATE_250 = 0x10FA
    ENDPOINT_STATE_251 = 0x10FB
    ENDPOINT_STATE_252 = 0x10FC
    ENDPOINT_STATE_253 = 0x10FD
    ENDPOINT_STATE_254 = 0x10FE
    ENDPOINT_STATE_255 = 0x10FF

    # Aggregates all endpoint state information into a single field.
    ENDPOINT_STATES = 0x1100


class RebootMode(zigpy_t.enum32):
    APPLICATION = 0
    BOOTLOADER = 1


class Status(zigpy_t.enum32):
    # Operation has completed successfully.
    OK = 0
    # Operation has failed for some undefined reason.
    FAILURE = 1
    # The given operation has not been implemented.
    UNIMPLEMENTED = 2
    # An argument to the given operation is invalid.
    INVALID_ARGUMENT = 3
    # The given operation is invalid for the current state of the device.
    INVALID_STATE = 4
    # The given command is not recognized.
    INVALID_COMMAND = 5
    # The given Spinel interface is not supported.
    INVALID_INTERFACE = 6
    # An internal runtime error has occurred.
    INTERNAL_ERROR = 7
    # A security or authentication error has occurred.
    SECURITY_ERROR = 8
    # An error has occurred while parsing the command.
    PARSE_ERROR = 9
    # The operation is in progress and will be completed asynchronously.
    IN_PROGRESS = 10
    # The operation has been prevented due to memory pressure.
    NOMEM = 11
    # The device is currently performing a mutually exclusive operation.
    BUSY = 12
    # The given property is not recognized.
    PROP_NOT_FOUND = 13
    # The packet was dropped.
    PACKET_DROPPED = 14
    # The result of the operation is empty.
    EMPTY = 15
    # The command was too large to fit in the internal buffer.
    CMD_TOO_BIG = 16
    # The packet was not acknowledged.
    NO_ACK = 17
    # The packet was not sent due to a CCA failure.
    CCA_FAILURE = 18
    # The operation is already in progress or the property was already set to the given
    # value.
    ALREADY = 19
    # The given item could not be found in the property.
    ITEM_NOT_FOUND = 20
    # The given command cannot be performed on this property.
    INVALID_COMMAND_FOR_PROP = 21
    # 22-111 : RESERVED
    RESET_POWER_ON = 112
    RESET_EXTERNAL = 113
    RESET_SOFTWARE = 114
    RESET_FAULT = 115
    RESET_CRASH = 116
    RESET_ASSERT = 117
    RESET_OTHER = 118
    RESET_UNKNOWN = 119
    RESET_WATCHDOG = 120
