(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_systemverilog_systemverilog_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/systemverilog/systemverilog.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/systemverilog/systemverilog.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/systemverilog/systemverilog.ts
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"],
    ["begin", "end"],
    ["case", "endcase"],
    ["casex", "endcase"],
    ["casez", "endcase"],
    ["checker", "endchecker"],
    ["class", "endclass"],
    ["clocking", "endclocking"],
    ["config", "endconfig"],
    ["function", "endfunction"],
    ["generate", "endgenerate"],
    ["group", "endgroup"],
    ["interface", "endinterface"],
    ["module", "endmodule"],
    ["package", "endpackage"],
    ["primitive", "endprimitive"],
    ["program", "endprogram"],
    ["property", "endproperty"],
    ["specify", "endspecify"],
    ["sequence", "endsequence"],
    ["table", "endtable"],
    ["task", "endtask"]
  ],
  autoClosingPairs: [
    { open: "[", close: "]" },
    { open: "{", close: "}" },
    { open: "(", close: ")" },
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["string"] }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  folding: {
    offSide: false,
    markers: {
      start: new RegExp("^(?:\\s*|.*(?!\\/[\\/\\*])[^\\w])(?:begin|case(x|z)?|class|clocking|config|covergroup|function|generate|interface|module|package|primitive|property|program|sequence|specify|table|task)\\b"),
      end: new RegExp("^(?:\\s*|.*(?!\\/[\\/\\*])[^\\w])(?:end|endcase|endclass|endclocking|endconfig|endgroup|endfunction|endgenerate|endinterface|endmodule|endpackage|endprimitive|endproperty|endprogram|endsequence|endspecify|endtable|endtask)\\b")
    }
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".sv",
  brackets: [
    { token: "delimiter.curly", open: "{", close: "}" },
    { token: "delimiter.parenthesis", open: "(", close: ")" },
    { token: "delimiter.square", open: "[", close: "]" },
    { token: "delimiter.angle", open: "<", close: ">" }
  ],
  keywords: [
    "accept_on",
    "alias",
    "always",
    "always_comb",
    "always_ff",
    "always_latch",
    "and",
    "assert",
    "assign",
    "assume",
    "automatic",
    "before",
    "begin",
    "bind",
    "bins",
    "binsof",
    "bit",
    "break",
    "buf",
    "bufif0",
    "bufif1",
    "byte",
    "case",
    "casex",
    "casez",
    "cell",
    "chandle",
    "checker",
    "class",
    "clocking",
    "cmos",
    "config",
    "const",
    "constraint",
    "context",
    "continue",
    "cover",
    "covergroup",
    "coverpoint",
    "cross",
    "deassign",
    "default",
    "defparam",
    "design",
    "disable",
    "dist",
    "do",
    "edge",
    "else",
    "end",
    "endcase",
    "endchecker",
    "endclass",
    "endclocking",
    "endconfig",
    "endfunction",
    "endgenerate",
    "endgroup",
    "endinterface",
    "endmodule",
    "endpackage",
    "endprimitive",
    "endprogram",
    "endproperty",
    "endspecify",
    "endsequence",
    "endtable",
    "endtask",
    "enum",
    "event",
    "eventually",
    "expect",
    "export",
    "extends",
    "extern",
    "final",
    "first_match",
    "for",
    "force",
    "foreach",
    "forever",
    "fork",
    "forkjoin",
    "function",
    "generate",
    "genvar",
    "global",
    "highz0",
    "highz1",
    "if",
    "iff",
    "ifnone",
    "ignore_bins",
    "illegal_bins",
    "implements",
    "implies",
    "import",
    "incdir",
    "include",
    "initial",
    "inout",
    "input",
    "inside",
    "instance",
    "int",
    "integer",
    "interconnect",
    "interface",
    "intersect",
    "join",
    "join_any",
    "join_none",
    "large",
    "let",
    "liblist",
    "library",
    "local",
    "localparam",
    "logic",
    "longint",
    "macromodule",
    "matches",
    "medium",
    "modport",
    "module",
    "nand",
    "negedge",
    "nettype",
    "new",
    "nexttime",
    "nmos",
    "nor",
    "noshowcancelled",
    "not",
    "notif0",
    "notif1",
    "null",
    "or",
    "output",
    "package",
    "packed",
    "parameter",
    "pmos",
    "posedge",
    "primitive",
    "priority",
    "program",
    "property",
    "protected",
    "pull0",
    "pull1",
    "pulldown",
    "pullup",
    "pulsestyle_ondetect",
    "pulsestyle_onevent",
    "pure",
    "rand",
    "randc",
    "randcase",
    "randsequence",
    "rcmos",
    "real",
    "realtime",
    "ref",
    "reg",
    "reject_on",
    "release",
    "repeat",
    "restrict",
    "return",
    "rnmos",
    "rpmos",
    "rtran",
    "rtranif0",
    "rtranif1",
    "s_always",
    "s_eventually",
    "s_nexttime",
    "s_until",
    "s_until_with",
    "scalared",
    "sequence",
    "shortint",
    "shortreal",
    "showcancelled",
    "signed",
    "small",
    "soft",
    "solve",
    "specify",
    "specparam",
    "static",
    "string",
    "strong",
    "strong0",
    "strong1",
    "struct",
    "super",
    "supply0",
    "supply1",
    "sync_accept_on",
    "sync_reject_on",
    "table",
    "tagged",
    "task",
    "this",
    "throughout",
    "time",
    "timeprecision",
    "timeunit",
    "tran",
    "tranif0",
    "tranif1",
    "tri",
    "tri0",
    "tri1",
    "triand",
    "trior",
    "trireg",
    "type",
    "typedef",
    "union",
    "unique",
    "unique0",
    "unsigned",
    "until",
    "until_with",
    "untyped",
    "use",
    "uwire",
    "var",
    "vectored",
    "virtual",
    "void",
    "wait",
    "wait_order",
    "wand",
    "weak",
    "weak0",
    "weak1",
    "while",
    "wildcard",
    "wire",
    "with",
    "within",
    "wor",
    "xnor",
    "xor"
  ],
  builtin_gates: [
    "and",
    "nand",
    "nor",
    "or",
    "xor",
    "xnor",
    "buf",
    "not",
    "bufif0",
    "bufif1",
    "notif1",
    "notif0",
    "cmos",
    "nmos",
    "pmos",
    "rcmos",
    "rnmos",
    "rpmos",
    "tran",
    "tranif1",
    "tranif0",
    "rtran",
    "rtranif1",
    "rtranif0"
  ],
  operators: [
    "=",
    "+=",
    "-=",
    "*=",
    "/=",
    "%=",
    "&=",
    "|=",
    "^=",
    "<<=",
    ">>+",
    "<<<=",
    ">>>=",
    "?",
    ":",
    "+",
    "-",
    "!",
    "~",
    "&",
    "~&",
    "|",
    "~|",
    "^",
    "~^",
    "^~",
    "+",
    "-",
    "*",
    "/",
    "%",
    "==",
    "!=",
    "===",
    "!==",
    "==?",
    "!=?",
    "&&",
    "||",
    "**",
    "<",
    "<=",
    ">",
    ">=",
    "&",
    "|",
    "^",
    ">>",
    "<<",
    ">>>",
    "<<<",
    "++",
    "--",
    "->",
    "<->",
    "inside",
    "dist",
    "::",
    "+:",
    "-:",
    "*>",
    "&&&",
    "|->",
    "|=>",
    "#=#"
  ],
  symbols: /[=><!~?:&|+\-*\/\^%#]+/,
  escapes: /%%|\\(?:[antvf\\"']|x[0-9A-Fa-f]{1,2}|[0-7]{1,3})/,
  identifier: /(?:[a-zA-Z_][a-zA-Z0-9_$\.]*|\\\S+ )/,
  systemcall: /[$][a-zA-Z0-9_]+/,
  timeunits: /s|ms|us|ns|ps|fs/,
  tokenizer: {
    root: [
      [
        /^(\s*)(@identifier)/,
        [
          "",
          {
            cases: {
              "@builtin_gates": {
                token: "keyword.$2",
                next: "@module_instance"
              },
              table: {
                token: "keyword.$2",
                next: "@table"
              },
              "@keywords": { token: "keyword.$2" },
              "@default": {
                token: "identifier",
                next: "@module_instance"
              }
            }
          }
        ]
      ],
      [/^\s*`include/, { token: "keyword.directive.include", next: "@include" }],
      [/^\s*`\s*\w+/, "keyword"],
      { include: "@identifier_or_keyword" },
      { include: "@whitespace" },
      [/\(\*.*\*\)/, "annotation"],
      [/@systemcall/, "variable.predefined"],
      [/[{}()\[\]]/, "@brackets"],
      [/[<>](?!@symbols)/, "@brackets"],
      [
        /@symbols/,
        {
          cases: {
            "@operators": "delimiter",
            "@default": ""
          }
        }
      ],
      { include: "@numbers" },
      [/[;,.]/, "delimiter"],
      { include: "@strings" }
    ],
    identifier_or_keyword: [
      [
        /@identifier/,
        {
          cases: {
            "@keywords": { token: "keyword.$0" },
            "@default": "identifier"
          }
        }
      ]
    ],
    numbers: [
      [/\d+?[\d_]*(?:\.[\d_]+)?[eE][\-+]?\d+/, "number.float"],
      [/\d+?[\d_]*\.[\d_]+(?:\s*@timeunits)?/, "number.float"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[dD]\s*[0-9xXzZ?]+?[0-9xXzZ?_]*/, "number"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[bB]\s*[0-1xXzZ?]+?[0-1xXzZ?_]*/, "number.binary"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[oO]\s*[0-7xXzZ?]+?[0-7xXzZ?_]*/, "number.octal"],
      [/(?:\d+?[\d_]*\s*)?'[sS]?[hH]\s*[0-9a-fA-FxXzZ?]+?[0-9a-fA-FxXzZ?_]*/, "number.hex"],
      [/1step/, "number"],
      [/[\dxXzZ]+?[\dxXzZ_]*(?:\s*@timeunits)?/, "number"],
      [/'[01xXzZ]+/, "number"]
    ],
    module_instance: [
      { include: "@whitespace" },
      [/(#?)(\()/, ["", { token: "@brackets", next: "@port_connection" }]],
      [/@identifier\s*[;={}\[\],]/, { token: "@rematch", next: "@pop" }],
      [/@symbols|[;={}\[\],]/, { token: "@rematch", next: "@pop" }],
      [/@identifier/, "type"],
      [/;/, "delimiter", "@pop"]
    ],
    port_connection: [
      { include: "@identifier_or_keyword" },
      { include: "@whitespace" },
      [/@systemcall/, "variable.predefined"],
      { include: "@numbers" },
      { include: "@strings" },
      [/[,]/, "delimiter"],
      [/\(/, "@brackets", "@port_connection"],
      [/\)/, "@brackets", "@pop"]
    ],
    whitespace: [
      [/[ \t\r\n]+/, ""],
      [/\/\*/, "comment", "@comment"],
      [/\/\/.*$/, "comment"]
    ],
    comment: [
      [/[^\/*]+/, "comment"],
      [/\*\//, "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    strings: [
      [/"([^"\\]|\\.)*$/, "string.invalid"],
      [/"/, "string", "@string"]
    ],
    string: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, "string", "@pop"]
    ],
    include: [
      [
        /(\s*)(")([\w*\/*]*)(.\w*)(")/,
        [
          "",
          "string.include.identifier",
          "string.include.identifier",
          "string.include.identifier",
          { token: "string.include.identifier", next: "@pop" }
        ]
      ],
      [
        /(\s*)(<)([\w*\/*]*)(.\w*)(>)/,
        [
          "",
          "string.include.identifier",
          "string.include.identifier",
          "string.include.identifier",
          { token: "string.include.identifier", next: "@pop" }
        ]
      ]
    ],
    table: [
      { include: "@whitespace" },
      [/[()]/, "@brackets"],
      [/[:;]/, "delimiter"],
      [/[01\-*?xXbBrRfFpPnN]/, "variable.predefined"],
      ["endtable", "keyword.endtable", "@pop"]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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