(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_ruby_ruby_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/ruby/ruby.js":
/*!************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/ruby/ruby.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/ruby/ruby.ts
var conf = {
  comments: {
    lineComment: "#",
    blockComment: ["=begin", "=end"]
  },
  brackets: [
    ["(", ")"],
    ["{", "}"],
    ["[", "]"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  indentationRules: {
    increaseIndentPattern: new RegExp(`^\\s*((begin|class|(private|protected)\\s+def|def|else|elsif|ensure|for|if|module|rescue|unless|until|when|while|case)|([^#]*\\sdo\\b)|([^#]*=\\s*(case|if|unless)))\\b([^#\\{;]|("|'|/).*\\4)*(#.*)?$`),
    decreaseIndentPattern: new RegExp("^\\s*([}\\]]([,)]?\\s*(#|$)|\\.[a-zA-Z_]\\w*\\b)|(end|rescue|ensure|else|elsif|when)\\b)")
  }
};
var language = {
  tokenPostfix: ".ruby",
  keywords: [
    "__LINE__",
    "__ENCODING__",
    "__FILE__",
    "BEGIN",
    "END",
    "alias",
    "and",
    "begin",
    "break",
    "case",
    "class",
    "def",
    "defined?",
    "do",
    "else",
    "elsif",
    "end",
    "ensure",
    "for",
    "false",
    "if",
    "in",
    "module",
    "next",
    "nil",
    "not",
    "or",
    "redo",
    "rescue",
    "retry",
    "return",
    "self",
    "super",
    "then",
    "true",
    "undef",
    "unless",
    "until",
    "when",
    "while",
    "yield"
  ],
  keywordops: ["::", "..", "...", "?", ":", "=>"],
  builtins: [
    "require",
    "public",
    "private",
    "include",
    "extend",
    "attr_reader",
    "protected",
    "private_class_method",
    "protected_class_method",
    "new"
  ],
  declarations: [
    "module",
    "class",
    "def",
    "case",
    "do",
    "begin",
    "for",
    "if",
    "while",
    "until",
    "unless"
  ],
  linedecls: ["def", "case", "do", "begin", "for", "if", "while", "until", "unless"],
  operators: [
    "^",
    "&",
    "|",
    "<=>",
    "==",
    "===",
    "!~",
    "=~",
    ">",
    ">=",
    "<",
    "<=",
    "<<",
    ">>",
    "+",
    "-",
    "*",
    "/",
    "%",
    "**",
    "~",
    "+@",
    "-@",
    "[]",
    "[]=",
    "`",
    "+=",
    "-=",
    "*=",
    "**=",
    "/=",
    "^=",
    "%=",
    "<<=",
    ">>=",
    "&=",
    "&&=",
    "||=",
    "|="
  ],
  brackets: [
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "[", close: "]", token: "delimiter.square" }
  ],
  symbols: /[=><!~?:&|+\-*\/\^%\.]+/,
  escape: /(?:[abefnrstv\\"'\n\r]|[0-7]{1,3}|x[0-9A-Fa-f]{1,2}|u[0-9A-Fa-f]{4})/,
  escapes: /\\(?:C\-(@escape|.)|c(@escape|.)|@escape)/,
  decpart: /\d(_?\d)*/,
  decimal: /0|@decpart/,
  delim: /[^a-zA-Z0-9\s\n\r]/,
  heredelim: /(?:\w+|'[^']*'|"[^"]*"|`[^`]*`)/,
  regexpctl: /[(){}\[\]\$\^|\-*+?\.]/,
  regexpesc: /\\(?:[AzZbBdDfnrstvwWn0\\\/]|@regexpctl|c[A-Z]|x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4})?/,
  tokenizer: {
    root: [
      [
        /^(\s*)([a-z_]\w*[!?=]?)/,
        [
          "white",
          {
            cases: {
              "for|until|while": {
                token: "keyword.$2",
                next: "@dodecl.$2"
              },
              "@declarations": {
                token: "keyword.$2",
                next: "@root.$2"
              },
              end: { token: "keyword.$S2", next: "@pop" },
              "@keywords": "keyword",
              "@builtins": "predefined",
              "@default": "identifier"
            }
          }
        ]
      ],
      [
        /[a-z_]\w*[!?=]?/,
        {
          cases: {
            "if|unless|while|until": {
              token: "keyword.$0x",
              next: "@modifier.$0x"
            },
            for: { token: "keyword.$2", next: "@dodecl.$2" },
            "@linedecls": { token: "keyword.$0", next: "@root.$0" },
            end: { token: "keyword.$S2", next: "@pop" },
            "@keywords": "keyword",
            "@builtins": "predefined",
            "@default": "identifier"
          }
        }
      ],
      [/[A-Z][\w]*[!?=]?/, "constructor.identifier"],
      [/\$[\w]*/, "global.constant"],
      [/@[\w]*/, "namespace.instance.identifier"],
      [/@@@[\w]*/, "namespace.class.identifier"],
      [/<<[-~](@heredelim).*/, { token: "string.heredoc.delimiter", next: "@heredoc.$1" }],
      [/[ \t\r\n]+<<(@heredelim).*/, { token: "string.heredoc.delimiter", next: "@heredoc.$1" }],
      [/^<<(@heredelim).*/, { token: "string.heredoc.delimiter", next: "@heredoc.$1" }],
      { include: "@whitespace" },
      [/"/, { token: "string.d.delim", next: '@dstring.d."' }],
      [/'/, { token: "string.sq.delim", next: "@sstring.sq" }],
      [/%([rsqxwW]|Q?)/, { token: "@rematch", next: "pstring" }],
      [/`/, { token: "string.x.delim", next: "@dstring.x.`" }],
      [/:(\w|[$@])\w*[!?=]?/, "string.s"],
      [/:"/, { token: "string.s.delim", next: '@dstring.s."' }],
      [/:'/, { token: "string.s.delim", next: "@sstring.s" }],
      [/\/(?=(\\\/|[^\/\n])+\/)/, { token: "regexp.delim", next: "@regexp" }],
      [/[{}()\[\]]/, "@brackets"],
      [
        /@symbols/,
        {
          cases: {
            "@keywordops": "keyword",
            "@operators": "operator",
            "@default": ""
          }
        }
      ],
      [/[;,]/, "delimiter"],
      [/0[xX][0-9a-fA-F](_?[0-9a-fA-F])*/, "number.hex"],
      [/0[_oO][0-7](_?[0-7])*/, "number.octal"],
      [/0[bB][01](_?[01])*/, "number.binary"],
      [/0[dD]@decpart/, "number"],
      [
        /@decimal((\.@decpart)?([eE][\-+]?@decpart)?)/,
        {
          cases: {
            $1: "number.float",
            "@default": "number"
          }
        }
      ]
    ],
    dodecl: [
      [/^/, { token: "", switchTo: "@root.$S2" }],
      [
        /[a-z_]\w*[!?=]?/,
        {
          cases: {
            end: { token: "keyword.$S2", next: "@pop" },
            do: { token: "keyword", switchTo: "@root.$S2" },
            "@linedecls": {
              token: "@rematch",
              switchTo: "@root.$S2"
            },
            "@keywords": "keyword",
            "@builtins": "predefined",
            "@default": "identifier"
          }
        }
      ],
      { include: "@root" }
    ],
    modifier: [
      [/^/, "", "@pop"],
      [
        /[a-z_]\w*[!?=]?/,
        {
          cases: {
            end: { token: "keyword.$S2", next: "@pop" },
            "then|else|elsif|do": {
              token: "keyword",
              switchTo: "@root.$S2"
            },
            "@linedecls": {
              token: "@rematch",
              switchTo: "@root.$S2"
            },
            "@keywords": "keyword",
            "@builtins": "predefined",
            "@default": "identifier"
          }
        }
      ],
      { include: "@root" }
    ],
    sstring: [
      [/[^\\']+/, "string.$S2"],
      [/\\\\|\\'|\\$/, "string.$S2.escape"],
      [/\\./, "string.$S2.invalid"],
      [/'/, { token: "string.$S2.delim", next: "@pop" }]
    ],
    dstring: [
      [/[^\\`"#]+/, "string.$S2"],
      [/#/, "string.$S2.escape", "@interpolated"],
      [/\\$/, "string.$S2.escape"],
      [/@escapes/, "string.$S2.escape"],
      [/\\./, "string.$S2.escape.invalid"],
      [
        /[`"]/,
        {
          cases: {
            "$#==$S3": { token: "string.$S2.delim", next: "@pop" },
            "@default": "string.$S2"
          }
        }
      ]
    ],
    heredoc: [
      [
        /^(\s*)(@heredelim)$/,
        {
          cases: {
            "$2==$S2": ["string.heredoc", { token: "string.heredoc.delimiter", next: "@pop" }],
            "@default": ["string.heredoc", "string.heredoc"]
          }
        }
      ],
      [/.*/, "string.heredoc"]
    ],
    interpolated: [
      [/\$\w*/, "global.constant", "@pop"],
      [/@\w*/, "namespace.class.identifier", "@pop"],
      [/@@@\w*/, "namespace.instance.identifier", "@pop"],
      [
        /[{]/,
        {
          token: "string.escape.curly",
          switchTo: "@interpolated_compound"
        }
      ],
      ["", "", "@pop"]
    ],
    interpolated_compound: [
      [/[}]/, { token: "string.escape.curly", next: "@pop" }],
      { include: "@root" }
    ],
    pregexp: [
      { include: "@whitespace" },
      [
        /[^\(\{\[\\]/,
        {
          cases: {
            "$#==$S3": { token: "regexp.delim", next: "@pop" },
            "$#==$S2": { token: "regexp.delim", next: "@push" },
            "~[)}\\]]": "@brackets.regexp.escape.control",
            "~@regexpctl": "regexp.escape.control",
            "@default": "regexp"
          }
        }
      ],
      { include: "@regexcontrol" }
    ],
    regexp: [
      { include: "@regexcontrol" },
      [/[^\\\/]/, "regexp"],
      ["/[ixmp]*", { token: "regexp.delim" }, "@pop"]
    ],
    regexcontrol: [
      [
        /(\{)(\d+(?:,\d*)?)(\})/,
        [
          "@brackets.regexp.escape.control",
          "regexp.escape.control",
          "@brackets.regexp.escape.control"
        ]
      ],
      [
        /(\[)(\^?)/,
        ["@brackets.regexp.escape.control", { token: "regexp.escape.control", next: "@regexrange" }]
      ],
      [/(\()(\?[:=!])/, ["@brackets.regexp.escape.control", "regexp.escape.control"]],
      [/\(\?#/, { token: "regexp.escape.control", next: "@regexpcomment" }],
      [/[()]/, "@brackets.regexp.escape.control"],
      [/@regexpctl/, "regexp.escape.control"],
      [/\\$/, "regexp.escape"],
      [/@regexpesc/, "regexp.escape"],
      [/\\\./, "regexp.invalid"],
      [/#/, "regexp.escape", "@interpolated"]
    ],
    regexrange: [
      [/-/, "regexp.escape.control"],
      [/\^/, "regexp.invalid"],
      [/\\$/, "regexp.escape"],
      [/@regexpesc/, "regexp.escape"],
      [/[^\]]/, "regexp"],
      [/\]/, "@brackets.regexp.escape.control", "@pop"]
    ],
    regexpcomment: [
      [/[^)]+/, "comment"],
      [/\)/, { token: "regexp.escape.control", next: "@pop" }]
    ],
    pstring: [
      [/%([qws])\(/, { token: "string.$1.delim", switchTo: "@qstring.$1.(.)" }],
      [/%([qws])\[/, { token: "string.$1.delim", switchTo: "@qstring.$1.[.]" }],
      [/%([qws])\{/, { token: "string.$1.delim", switchTo: "@qstring.$1.{.}" }],
      [/%([qws])</, { token: "string.$1.delim", switchTo: "@qstring.$1.<.>" }],
      [/%([qws])(@delim)/, { token: "string.$1.delim", switchTo: "@qstring.$1.$2.$2" }],
      [/%r\(/, { token: "regexp.delim", switchTo: "@pregexp.(.)" }],
      [/%r\[/, { token: "regexp.delim", switchTo: "@pregexp.[.]" }],
      [/%r\{/, { token: "regexp.delim", switchTo: "@pregexp.{.}" }],
      [/%r</, { token: "regexp.delim", switchTo: "@pregexp.<.>" }],
      [/%r(@delim)/, { token: "regexp.delim", switchTo: "@pregexp.$1.$1" }],
      [/%(x|W|Q?)\(/, { token: "string.$1.delim", switchTo: "@qqstring.$1.(.)" }],
      [/%(x|W|Q?)\[/, { token: "string.$1.delim", switchTo: "@qqstring.$1.[.]" }],
      [/%(x|W|Q?)\{/, { token: "string.$1.delim", switchTo: "@qqstring.$1.{.}" }],
      [/%(x|W|Q?)</, { token: "string.$1.delim", switchTo: "@qqstring.$1.<.>" }],
      [/%(x|W|Q?)(@delim)/, { token: "string.$1.delim", switchTo: "@qqstring.$1.$2.$2" }],
      [/%([rqwsxW]|Q?)./, { token: "invalid", next: "@pop" }],
      [/./, { token: "invalid", next: "@pop" }]
    ],
    qstring: [
      [/\\$/, "string.$S2.escape"],
      [/\\./, "string.$S2.escape"],
      [
        /./,
        {
          cases: {
            "$#==$S4": { token: "string.$S2.delim", next: "@pop" },
            "$#==$S3": { token: "string.$S2.delim", next: "@push" },
            "@default": "string.$S2"
          }
        }
      ]
    ],
    qqstring: [[/#/, "string.$S2.escape", "@interpolated"], { include: "@qstring" }],
    whitespace: [
      [/[ \t\r\n]+/, ""],
      [/^\s*=begin\b/, "comment", "@comment"],
      [/#.*$/, "comment"]
    ],
    comment: [
      [/[^=]+/, "comment"],
      [/^\s*=begin\b/, "comment.invalid"],
      [/^\s*=end\b.*/, "comment", "@pop"],
      [/[=]/, "comment"]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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