# modelcatalog-api
This is the API of the Software Description Ontology at [https://w3id.org/okn/o/sdm](https://w3id.org/okn/o/sdm)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1.5.0
- Package version: 3.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/mintproject/model-catalog-python-api-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/mintproject/model-catalog-python-api-client.git`)

Then import the package:
```python
import modelcatalog 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import modelcatalog
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import modelcatalog
from modelcatalog.rest import ApiException
from pprint import pprint


# Defining host is optional and default to https://api.models.mint.isi.edu/v1.5.0
configuration.host = "https://api.models.mint.isi.edu/v1.5.0"
# Create an instance of the API class
api_instance = modelcatalog.CausalDiagramApi(modelcatalog.ApiClient(configuration))
username = 'username_example' # str | Name of the user graph to query (optional)
label = 'label_example' # str | Filter by label (optional)
page = 1 # int | Page number (optional) (default to 1)
per_page = 100 # int | Items per page (optional) (default to 100)

try:
    # List all instances of CausalDiagram
    api_response = api_instance.causaldiagrams_get(username=username, label=label, page=page, per_page=per_page)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CausalDiagramApi->causaldiagrams_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.models.mint.isi.edu/v1.5.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CausalDiagramApi* | [**causaldiagrams_get**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_get) | **GET** /causaldiagrams | List all instances of CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_id_delete**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_delete) | **DELETE** /causaldiagrams/{id} | Delete an existing CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_id_get**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_get) | **GET** /causaldiagrams/{id} | Get a single CausalDiagram by its id
*CausalDiagramApi* | [**causaldiagrams_id_put**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_id_put) | **PUT** /causaldiagrams/{id} | Update an existing CausalDiagram
*CausalDiagramApi* | [**causaldiagrams_post**](docs/endpoints/CausalDiagramApi.md#causaldiagrams_post) | **POST** /causaldiagrams | Create one CausalDiagram
*ConfigurationSetupApi* | [**configurationsetups_get**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_get) | **GET** /configurationsetups | List all instances of ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_id_delete**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_delete) | **DELETE** /configurationsetups/{id} | Delete an existing ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_id_get**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_get) | **GET** /configurationsetups/{id} | Get a single ConfigurationSetup by its id
*ConfigurationSetupApi* | [**configurationsetups_id_put**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_id_put) | **PUT** /configurationsetups/{id} | Update an existing ConfigurationSetup
*ConfigurationSetupApi* | [**configurationsetups_post**](docs/endpoints/ConfigurationSetupApi.md#configurationsetups_post) | **POST** /configurationsetups | Create one ConfigurationSetup
*ConfigurationSetupApi* | [**custom_configurationsetups_id_get**](docs/endpoints/ConfigurationSetupApi.md#custom_configurationsetups_id_get) | **GET** /custom/configurationsetups/{id} | Get a ModelConfigurationSetup
*DataTransformationApi* | [**datatransformations_get**](docs/endpoints/DataTransformationApi.md#datatransformations_get) | **GET** /datatransformations | List all instances of DataTransformation
*DataTransformationApi* | [**datatransformations_id_delete**](docs/endpoints/DataTransformationApi.md#datatransformations_id_delete) | **DELETE** /datatransformations/{id} | Delete an existing DataTransformation
*DataTransformationApi* | [**datatransformations_id_get**](docs/endpoints/DataTransformationApi.md#datatransformations_id_get) | **GET** /datatransformations/{id} | Get a single DataTransformation by its id
*DataTransformationApi* | [**datatransformations_id_put**](docs/endpoints/DataTransformationApi.md#datatransformations_id_put) | **PUT** /datatransformations/{id} | Update an existing DataTransformation
*DataTransformationApi* | [**datatransformations_post**](docs/endpoints/DataTransformationApi.md#datatransformations_post) | **POST** /datatransformations | Create one DataTransformation
*DataTransformationSetupApi* | [**datatransformationsetups_get**](docs/endpoints/DataTransformationSetupApi.md#datatransformationsetups_get) | **GET** /datatransformationsetups | List all instances of DataTransformationSetup
*DataTransformationSetupApi* | [**datatransformationsetups_id_delete**](docs/endpoints/DataTransformationSetupApi.md#datatransformationsetups_id_delete) | **DELETE** /datatransformationsetups/{id} | Delete an existing DataTransformationSetup
*DataTransformationSetupApi* | [**datatransformationsetups_id_get**](docs/endpoints/DataTransformationSetupApi.md#datatransformationsetups_id_get) | **GET** /datatransformationsetups/{id} | Get a single DataTransformationSetup by its id
*DataTransformationSetupApi* | [**datatransformationsetups_id_put**](docs/endpoints/DataTransformationSetupApi.md#datatransformationsetups_id_put) | **PUT** /datatransformationsetups/{id} | Update an existing DataTransformationSetup
*DataTransformationSetupApi* | [**datatransformationsetups_post**](docs/endpoints/DataTransformationSetupApi.md#datatransformationsetups_post) | **POST** /datatransformationsetups | Create one DataTransformationSetup
*DatasetSpecificationApi* | [**datasetspecifications_get**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_get) | **GET** /datasetspecifications | List all instances of DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_id_delete**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_delete) | **DELETE** /datasetspecifications/{id} | Delete an existing DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_id_get**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_get) | **GET** /datasetspecifications/{id} | Get a single DatasetSpecification by its id
*DatasetSpecificationApi* | [**datasetspecifications_id_put**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_id_put) | **PUT** /datasetspecifications/{id} | Update an existing DatasetSpecification
*DatasetSpecificationApi* | [**datasetspecifications_post**](docs/endpoints/DatasetSpecificationApi.md#datasetspecifications_post) | **POST** /datasetspecifications | Create one DatasetSpecification
*EmpiricalModelApi* | [**empiricalmodels_get**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_get) | **GET** /empiricalmodels | List all instances of EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_id_delete**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_delete) | **DELETE** /empiricalmodels/{id} | Delete an existing EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_id_get**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_get) | **GET** /empiricalmodels/{id} | Get a single EmpiricalModel by its id
*EmpiricalModelApi* | [**empiricalmodels_id_put**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_id_put) | **PUT** /empiricalmodels/{id} | Update an existing EmpiricalModel
*EmpiricalModelApi* | [**empiricalmodels_post**](docs/endpoints/EmpiricalModelApi.md#empiricalmodels_post) | **POST** /empiricalmodels | Create one EmpiricalModel
*EmulatorApi* | [**emulators_get**](docs/endpoints/EmulatorApi.md#emulators_get) | **GET** /emulators | List all instances of Emulator
*EmulatorApi* | [**emulators_id_delete**](docs/endpoints/EmulatorApi.md#emulators_id_delete) | **DELETE** /emulators/{id} | Delete an existing Emulator
*EmulatorApi* | [**emulators_id_get**](docs/endpoints/EmulatorApi.md#emulators_id_get) | **GET** /emulators/{id} | Get a single Emulator by its id
*EmulatorApi* | [**emulators_id_put**](docs/endpoints/EmulatorApi.md#emulators_id_put) | **PUT** /emulators/{id} | Update an existing Emulator
*EmulatorApi* | [**emulators_post**](docs/endpoints/EmulatorApi.md#emulators_post) | **POST** /emulators | Create one Emulator
*EquationApi* | [**equations_get**](docs/endpoints/EquationApi.md#equations_get) | **GET** /equations | List all instances of Equation
*EquationApi* | [**equations_id_delete**](docs/endpoints/EquationApi.md#equations_id_delete) | **DELETE** /equations/{id} | Delete an existing Equation
*EquationApi* | [**equations_id_get**](docs/endpoints/EquationApi.md#equations_id_get) | **GET** /equations/{id} | Get a single Equation by its id
*EquationApi* | [**equations_id_put**](docs/endpoints/EquationApi.md#equations_id_put) | **PUT** /equations/{id} | Update an existing Equation
*EquationApi* | [**equations_post**](docs/endpoints/EquationApi.md#equations_post) | **POST** /equations | Create one Equation
*FundingInformationApi* | [**fundinginformations_get**](docs/endpoints/FundingInformationApi.md#fundinginformations_get) | **GET** /fundinginformations | List all instances of FundingInformation
*FundingInformationApi* | [**fundinginformations_id_delete**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_delete) | **DELETE** /fundinginformations/{id} | Delete an existing FundingInformation
*FundingInformationApi* | [**fundinginformations_id_get**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_get) | **GET** /fundinginformations/{id} | Get a single FundingInformation by its id
*FundingInformationApi* | [**fundinginformations_id_put**](docs/endpoints/FundingInformationApi.md#fundinginformations_id_put) | **PUT** /fundinginformations/{id} | Update an existing FundingInformation
*FundingInformationApi* | [**fundinginformations_post**](docs/endpoints/FundingInformationApi.md#fundinginformations_post) | **POST** /fundinginformations | Create one FundingInformation
*GeoCoordinatesApi* | [**geocoordinatess_get**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_get) | **GET** /geocoordinatess | List all instances of GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_id_delete**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_delete) | **DELETE** /geocoordinatess/{id} | Delete an existing GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_id_get**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_get) | **GET** /geocoordinatess/{id} | Get a single GeoCoordinates by its id
*GeoCoordinatesApi* | [**geocoordinatess_id_put**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_id_put) | **PUT** /geocoordinatess/{id} | Update an existing GeoCoordinates
*GeoCoordinatesApi* | [**geocoordinatess_post**](docs/endpoints/GeoCoordinatesApi.md#geocoordinatess_post) | **POST** /geocoordinatess | Create one GeoCoordinates
*GeoShapeApi* | [**geoshapes_get**](docs/endpoints/GeoShapeApi.md#geoshapes_get) | **GET** /geoshapes | List all instances of GeoShape
*GeoShapeApi* | [**geoshapes_id_delete**](docs/endpoints/GeoShapeApi.md#geoshapes_id_delete) | **DELETE** /geoshapes/{id} | Delete an existing GeoShape
*GeoShapeApi* | [**geoshapes_id_get**](docs/endpoints/GeoShapeApi.md#geoshapes_id_get) | **GET** /geoshapes/{id} | Get a single GeoShape by its id
*GeoShapeApi* | [**geoshapes_id_put**](docs/endpoints/GeoShapeApi.md#geoshapes_id_put) | **PUT** /geoshapes/{id} | Update an existing GeoShape
*GeoShapeApi* | [**geoshapes_post**](docs/endpoints/GeoShapeApi.md#geoshapes_post) | **POST** /geoshapes | Create one GeoShape
*GridApi* | [**grids_get**](docs/endpoints/GridApi.md#grids_get) | **GET** /grids | List all instances of Grid
*GridApi* | [**grids_id_delete**](docs/endpoints/GridApi.md#grids_id_delete) | **DELETE** /grids/{id} | Delete an existing Grid
*GridApi* | [**grids_id_get**](docs/endpoints/GridApi.md#grids_id_get) | **GET** /grids/{id} | Get a single Grid by its id
*GridApi* | [**grids_id_put**](docs/endpoints/GridApi.md#grids_id_put) | **PUT** /grids/{id} | Update an existing Grid
*GridApi* | [**grids_post**](docs/endpoints/GridApi.md#grids_post) | **POST** /grids | Create one Grid
*HybridModelApi* | [**hybridmodels_get**](docs/endpoints/HybridModelApi.md#hybridmodels_get) | **GET** /hybridmodels | List all instances of HybridModel
*HybridModelApi* | [**hybridmodels_id_delete**](docs/endpoints/HybridModelApi.md#hybridmodels_id_delete) | **DELETE** /hybridmodels/{id} | Delete an existing HybridModel
*HybridModelApi* | [**hybridmodels_id_get**](docs/endpoints/HybridModelApi.md#hybridmodels_id_get) | **GET** /hybridmodels/{id} | Get a single HybridModel by its id
*HybridModelApi* | [**hybridmodels_id_put**](docs/endpoints/HybridModelApi.md#hybridmodels_id_put) | **PUT** /hybridmodels/{id} | Update an existing HybridModel
*HybridModelApi* | [**hybridmodels_post**](docs/endpoints/HybridModelApi.md#hybridmodels_post) | **POST** /hybridmodels | Create one HybridModel
*ImageApi* | [**images_get**](docs/endpoints/ImageApi.md#images_get) | **GET** /images | List all instances of Image
*ImageApi* | [**images_id_delete**](docs/endpoints/ImageApi.md#images_id_delete) | **DELETE** /images/{id} | Delete an existing Image
*ImageApi* | [**images_id_get**](docs/endpoints/ImageApi.md#images_id_get) | **GET** /images/{id} | Get a single Image by its id
*ImageApi* | [**images_id_put**](docs/endpoints/ImageApi.md#images_id_put) | **PUT** /images/{id} | Update an existing Image
*ImageApi* | [**images_post**](docs/endpoints/ImageApi.md#images_post) | **POST** /images | Create one Image
*InterventionApi* | [**interventions_get**](docs/endpoints/InterventionApi.md#interventions_get) | **GET** /interventions | List all instances of Intervention
*InterventionApi* | [**interventions_id_delete**](docs/endpoints/InterventionApi.md#interventions_id_delete) | **DELETE** /interventions/{id} | Delete an existing Intervention
*InterventionApi* | [**interventions_id_get**](docs/endpoints/InterventionApi.md#interventions_id_get) | **GET** /interventions/{id} | Get a single Intervention by its id
*InterventionApi* | [**interventions_id_put**](docs/endpoints/InterventionApi.md#interventions_id_put) | **PUT** /interventions/{id} | Update an existing Intervention
*InterventionApi* | [**interventions_post**](docs/endpoints/InterventionApi.md#interventions_post) | **POST** /interventions | Create one Intervention
*ModelApi* | [**custom_model_index_get**](docs/endpoints/ModelApi.md#custom_model_index_get) | **GET** /custom/model/index | Get a Model
*ModelApi* | [**custom_model_intervention_get**](docs/endpoints/ModelApi.md#custom_model_intervention_get) | **GET** /custom/model/intervention | Get a Model
*ModelApi* | [**custom_model_region_get**](docs/endpoints/ModelApi.md#custom_model_region_get) | **GET** /custom/model/region | Get a Model
*ModelApi* | [**custom_models_standard_variable_get**](docs/endpoints/ModelApi.md#custom_models_standard_variable_get) | **GET** /custom/models/standard_variable | Get a list of models
*ModelApi* | [**custom_models_variable_get**](docs/endpoints/ModelApi.md#custom_models_variable_get) | **GET** /custom/models/variable | Get a list of Model
*ModelApi* | [**models_get**](docs/endpoints/ModelApi.md#models_get) | **GET** /models | List all instances of Model
*ModelApi* | [**models_id_delete**](docs/endpoints/ModelApi.md#models_id_delete) | **DELETE** /models/{id} | Delete an existing Model
*ModelApi* | [**models_id_get**](docs/endpoints/ModelApi.md#models_id_get) | **GET** /models/{id} | Get a single Model by its id
*ModelApi* | [**models_id_put**](docs/endpoints/ModelApi.md#models_id_put) | **PUT** /models/{id} | Update an existing Model
*ModelApi* | [**models_post**](docs/endpoints/ModelApi.md#models_post) | **POST** /models | Create one Model
*ModelConfigurationApi* | [**custom_modelconfigurations_id_get**](docs/endpoints/ModelConfigurationApi.md#custom_modelconfigurations_id_get) | **GET** /custom/modelconfigurations/{id} | Get a ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_get**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_get) | **GET** /modelconfigurations | List all instances of ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_id_delete**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_delete) | **DELETE** /modelconfigurations/{id} | Delete an existing ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_id_get**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_get) | **GET** /modelconfigurations/{id} | Get a single ModelConfiguration by its id
*ModelConfigurationApi* | [**modelconfigurations_id_put**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_id_put) | **PUT** /modelconfigurations/{id} | Update an existing ModelConfiguration
*ModelConfigurationApi* | [**modelconfigurations_post**](docs/endpoints/ModelConfigurationApi.md#modelconfigurations_post) | **POST** /modelconfigurations | Create one ModelConfiguration
*ModelConfigurationSetupApi* | [**custom_modelconfigurationsetups_id_get**](docs/endpoints/ModelConfigurationSetupApi.md#custom_modelconfigurationsetups_id_get) | **GET** /custom/modelconfigurationsetups/{id} | Get a ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**custom_modelconfigurationsetups_variable_get**](docs/endpoints/ModelConfigurationSetupApi.md#custom_modelconfigurationsetups_variable_get) | **GET** /custom/modelconfigurationsetups/variable | Get a list  Model
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_get**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_get) | **GET** /modelconfigurationsetups | List all instances of ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_delete**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_delete) | **DELETE** /modelconfigurationsetups/{id} | Delete an existing ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_get**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_get) | **GET** /modelconfigurationsetups/{id} | Get a single ModelConfigurationSetup by its id
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_id_put**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_id_put) | **PUT** /modelconfigurationsetups/{id} | Update an existing ModelConfigurationSetup
*ModelConfigurationSetupApi* | [**modelconfigurationsetups_post**](docs/endpoints/ModelConfigurationSetupApi.md#modelconfigurationsetups_post) | **POST** /modelconfigurationsetups | Create one ModelConfigurationSetup
*NumericalIndexApi* | [**numericalindexs_get**](docs/endpoints/NumericalIndexApi.md#numericalindexs_get) | **GET** /numericalindexs | List all instances of NumericalIndex
*NumericalIndexApi* | [**numericalindexs_id_delete**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_delete) | **DELETE** /numericalindexs/{id} | Delete an existing NumericalIndex
*NumericalIndexApi* | [**numericalindexs_id_get**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_get) | **GET** /numericalindexs/{id} | Get a single NumericalIndex by its id
*NumericalIndexApi* | [**numericalindexs_id_put**](docs/endpoints/NumericalIndexApi.md#numericalindexs_id_put) | **PUT** /numericalindexs/{id} | Update an existing NumericalIndex
*NumericalIndexApi* | [**numericalindexs_post**](docs/endpoints/NumericalIndexApi.md#numericalindexs_post) | **POST** /numericalindexs | Create one NumericalIndex
*OrganizationApi* | [**organizations_get**](docs/endpoints/OrganizationApi.md#organizations_get) | **GET** /organizations | List all instances of Organization
*OrganizationApi* | [**organizations_id_delete**](docs/endpoints/OrganizationApi.md#organizations_id_delete) | **DELETE** /organizations/{id} | Delete an existing Organization
*OrganizationApi* | [**organizations_id_get**](docs/endpoints/OrganizationApi.md#organizations_id_get) | **GET** /organizations/{id} | Get a single Organization by its id
*OrganizationApi* | [**organizations_id_put**](docs/endpoints/OrganizationApi.md#organizations_id_put) | **PUT** /organizations/{id} | Update an existing Organization
*OrganizationApi* | [**organizations_post**](docs/endpoints/OrganizationApi.md#organizations_post) | **POST** /organizations | Create one Organization
*ParameterApi* | [**parameters_get**](docs/endpoints/ParameterApi.md#parameters_get) | **GET** /parameters | List all instances of Parameter
*ParameterApi* | [**parameters_id_delete**](docs/endpoints/ParameterApi.md#parameters_id_delete) | **DELETE** /parameters/{id} | Delete an existing Parameter
*ParameterApi* | [**parameters_id_get**](docs/endpoints/ParameterApi.md#parameters_id_get) | **GET** /parameters/{id} | Get a single Parameter by its id
*ParameterApi* | [**parameters_id_put**](docs/endpoints/ParameterApi.md#parameters_id_put) | **PUT** /parameters/{id} | Update an existing Parameter
*ParameterApi* | [**parameters_post**](docs/endpoints/ParameterApi.md#parameters_post) | **POST** /parameters | Create one Parameter
*PersonApi* | [**persons_get**](docs/endpoints/PersonApi.md#persons_get) | **GET** /persons | List all instances of Person
*PersonApi* | [**persons_id_delete**](docs/endpoints/PersonApi.md#persons_id_delete) | **DELETE** /persons/{id} | Delete an existing Person
*PersonApi* | [**persons_id_get**](docs/endpoints/PersonApi.md#persons_id_get) | **GET** /persons/{id} | Get a single Person by its id
*PersonApi* | [**persons_id_put**](docs/endpoints/PersonApi.md#persons_id_put) | **PUT** /persons/{id} | Update an existing Person
*PersonApi* | [**persons_post**](docs/endpoints/PersonApi.md#persons_post) | **POST** /persons | Create one Person
*PointBasedGridApi* | [**pointbasedgrids_get**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_get) | **GET** /pointbasedgrids | List all instances of PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_id_delete**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_delete) | **DELETE** /pointbasedgrids/{id} | Delete an existing PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_id_get**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_get) | **GET** /pointbasedgrids/{id} | Get a single PointBasedGrid by its id
*PointBasedGridApi* | [**pointbasedgrids_id_put**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_id_put) | **PUT** /pointbasedgrids/{id} | Update an existing PointBasedGrid
*PointBasedGridApi* | [**pointbasedgrids_post**](docs/endpoints/PointBasedGridApi.md#pointbasedgrids_post) | **POST** /pointbasedgrids | Create one PointBasedGrid
*ProcessApi* | [**processs_get**](docs/endpoints/ProcessApi.md#processs_get) | **GET** /processs | List all instances of Process
*ProcessApi* | [**processs_id_delete**](docs/endpoints/ProcessApi.md#processs_id_delete) | **DELETE** /processs/{id} | Delete an existing Process
*ProcessApi* | [**processs_id_get**](docs/endpoints/ProcessApi.md#processs_id_get) | **GET** /processs/{id} | Get a single Process by its id
*ProcessApi* | [**processs_id_put**](docs/endpoints/ProcessApi.md#processs_id_put) | **PUT** /processs/{id} | Update an existing Process
*ProcessApi* | [**processs_post**](docs/endpoints/ProcessApi.md#processs_post) | **POST** /processs | Create one Process
*RegionApi* | [**regions_get**](docs/endpoints/RegionApi.md#regions_get) | **GET** /regions | List all instances of Region
*RegionApi* | [**regions_id_delete**](docs/endpoints/RegionApi.md#regions_id_delete) | **DELETE** /regions/{id} | Delete an existing Region
*RegionApi* | [**regions_id_get**](docs/endpoints/RegionApi.md#regions_id_get) | **GET** /regions/{id} | Get a single Region by its id
*RegionApi* | [**regions_id_put**](docs/endpoints/RegionApi.md#regions_id_put) | **PUT** /regions/{id} | Update an existing Region
*RegionApi* | [**regions_post**](docs/endpoints/RegionApi.md#regions_post) | **POST** /regions | Create one Region
*SampleCollectionApi* | [**samplecollections_get**](docs/endpoints/SampleCollectionApi.md#samplecollections_get) | **GET** /samplecollections | List all instances of SampleCollection
*SampleCollectionApi* | [**samplecollections_id_delete**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_delete) | **DELETE** /samplecollections/{id} | Delete an existing SampleCollection
*SampleCollectionApi* | [**samplecollections_id_get**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_get) | **GET** /samplecollections/{id} | Get a single SampleCollection by its id
*SampleCollectionApi* | [**samplecollections_id_put**](docs/endpoints/SampleCollectionApi.md#samplecollections_id_put) | **PUT** /samplecollections/{id} | Update an existing SampleCollection
*SampleCollectionApi* | [**samplecollections_post**](docs/endpoints/SampleCollectionApi.md#samplecollections_post) | **POST** /samplecollections | Create one SampleCollection
*SampleExecutionApi* | [**sampleexecutions_get**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_get) | **GET** /sampleexecutions | List all instances of SampleExecution
*SampleExecutionApi* | [**sampleexecutions_id_delete**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_delete) | **DELETE** /sampleexecutions/{id} | Delete an existing SampleExecution
*SampleExecutionApi* | [**sampleexecutions_id_get**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_get) | **GET** /sampleexecutions/{id} | Get a single SampleExecution by its id
*SampleExecutionApi* | [**sampleexecutions_id_put**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_id_put) | **PUT** /sampleexecutions/{id} | Update an existing SampleExecution
*SampleExecutionApi* | [**sampleexecutions_post**](docs/endpoints/SampleExecutionApi.md#sampleexecutions_post) | **POST** /sampleexecutions | Create one SampleExecution
*SampleResourceApi* | [**sampleresources_get**](docs/endpoints/SampleResourceApi.md#sampleresources_get) | **GET** /sampleresources | List all instances of SampleResource
*SampleResourceApi* | [**sampleresources_id_delete**](docs/endpoints/SampleResourceApi.md#sampleresources_id_delete) | **DELETE** /sampleresources/{id} | Delete an existing SampleResource
*SampleResourceApi* | [**sampleresources_id_get**](docs/endpoints/SampleResourceApi.md#sampleresources_id_get) | **GET** /sampleresources/{id} | Get a single SampleResource by its id
*SampleResourceApi* | [**sampleresources_id_put**](docs/endpoints/SampleResourceApi.md#sampleresources_id_put) | **PUT** /sampleresources/{id} | Update an existing SampleResource
*SampleResourceApi* | [**sampleresources_post**](docs/endpoints/SampleResourceApi.md#sampleresources_post) | **POST** /sampleresources | Create one SampleResource
*SoftwareApi* | [**softwares_get**](docs/endpoints/SoftwareApi.md#softwares_get) | **GET** /softwares | List all instances of Software
*SoftwareApi* | [**softwares_id_delete**](docs/endpoints/SoftwareApi.md#softwares_id_delete) | **DELETE** /softwares/{id} | Delete an existing Software
*SoftwareApi* | [**softwares_id_get**](docs/endpoints/SoftwareApi.md#softwares_id_get) | **GET** /softwares/{id} | Get a single Software by its id
*SoftwareApi* | [**softwares_id_put**](docs/endpoints/SoftwareApi.md#softwares_id_put) | **PUT** /softwares/{id} | Update an existing Software
*SoftwareApi* | [**softwares_post**](docs/endpoints/SoftwareApi.md#softwares_post) | **POST** /softwares | Create one Software
*SoftwareConfigurationApi* | [**softwareconfigurations_get**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_get) | **GET** /softwareconfigurations | List all instances of SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_id_delete**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_delete) | **DELETE** /softwareconfigurations/{id} | Delete an existing SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_id_get**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_get) | **GET** /softwareconfigurations/{id} | Get a single SoftwareConfiguration by its id
*SoftwareConfigurationApi* | [**softwareconfigurations_id_put**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_id_put) | **PUT** /softwareconfigurations/{id} | Update an existing SoftwareConfiguration
*SoftwareConfigurationApi* | [**softwareconfigurations_post**](docs/endpoints/SoftwareConfigurationApi.md#softwareconfigurations_post) | **POST** /softwareconfigurations | Create one SoftwareConfiguration
*SoftwareImageApi* | [**softwareimages_get**](docs/endpoints/SoftwareImageApi.md#softwareimages_get) | **GET** /softwareimages | List all instances of SoftwareImage
*SoftwareImageApi* | [**softwareimages_id_delete**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_delete) | **DELETE** /softwareimages/{id} | Delete an existing SoftwareImage
*SoftwareImageApi* | [**softwareimages_id_get**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_get) | **GET** /softwareimages/{id} | Get a single SoftwareImage by its id
*SoftwareImageApi* | [**softwareimages_id_put**](docs/endpoints/SoftwareImageApi.md#softwareimages_id_put) | **PUT** /softwareimages/{id} | Update an existing SoftwareImage
*SoftwareImageApi* | [**softwareimages_post**](docs/endpoints/SoftwareImageApi.md#softwareimages_post) | **POST** /softwareimages | Create one SoftwareImage
*SoftwareVersionApi* | [**softwareversions_get**](docs/endpoints/SoftwareVersionApi.md#softwareversions_get) | **GET** /softwareversions | List all instances of SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_id_delete**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_delete) | **DELETE** /softwareversions/{id} | Delete an existing SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_id_get**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_get) | **GET** /softwareversions/{id} | Get a single SoftwareVersion by its id
*SoftwareVersionApi* | [**softwareversions_id_put**](docs/endpoints/SoftwareVersionApi.md#softwareversions_id_put) | **PUT** /softwareversions/{id} | Update an existing SoftwareVersion
*SoftwareVersionApi* | [**softwareversions_post**](docs/endpoints/SoftwareVersionApi.md#softwareversions_post) | **POST** /softwareversions | Create one SoftwareVersion
*SourceCodeApi* | [**sourcecodes_get**](docs/endpoints/SourceCodeApi.md#sourcecodes_get) | **GET** /sourcecodes | List all instances of SourceCode
*SourceCodeApi* | [**sourcecodes_id_delete**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_delete) | **DELETE** /sourcecodes/{id} | Delete an existing SourceCode
*SourceCodeApi* | [**sourcecodes_id_get**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_get) | **GET** /sourcecodes/{id} | Get a single SourceCode by its id
*SourceCodeApi* | [**sourcecodes_id_put**](docs/endpoints/SourceCodeApi.md#sourcecodes_id_put) | **PUT** /sourcecodes/{id} | Update an existing SourceCode
*SourceCodeApi* | [**sourcecodes_post**](docs/endpoints/SourceCodeApi.md#sourcecodes_post) | **POST** /sourcecodes | Create one SourceCode
*SpatialResolutionApi* | [**spatialresolutions_get**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_get) | **GET** /spatialresolutions | List all instances of SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_id_delete**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_delete) | **DELETE** /spatialresolutions/{id} | Delete an existing SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_id_get**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_get) | **GET** /spatialresolutions/{id} | Get a single SpatialResolution by its id
*SpatialResolutionApi* | [**spatialresolutions_id_put**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_id_put) | **PUT** /spatialresolutions/{id} | Update an existing SpatialResolution
*SpatialResolutionApi* | [**spatialresolutions_post**](docs/endpoints/SpatialResolutionApi.md#spatialresolutions_post) | **POST** /spatialresolutions | Create one SpatialResolution
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_get**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_get) | **GET** /spatiallydistributedgrids | List all instances of SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_delete**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_delete) | **DELETE** /spatiallydistributedgrids/{id} | Delete an existing SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_get**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_get) | **GET** /spatiallydistributedgrids/{id} | Get a single SpatiallyDistributedGrid by its id
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_id_put**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_id_put) | **PUT** /spatiallydistributedgrids/{id} | Update an existing SpatiallyDistributedGrid
*SpatiallyDistributedGridApi* | [**spatiallydistributedgrids_post**](docs/endpoints/SpatiallyDistributedGridApi.md#spatiallydistributedgrids_post) | **POST** /spatiallydistributedgrids | Create one SpatiallyDistributedGrid
*StandardVariableApi* | [**standardvariables_get**](docs/endpoints/StandardVariableApi.md#standardvariables_get) | **GET** /standardvariables | List all instances of StandardVariable
*StandardVariableApi* | [**standardvariables_id_delete**](docs/endpoints/StandardVariableApi.md#standardvariables_id_delete) | **DELETE** /standardvariables/{id} | Delete an existing StandardVariable
*StandardVariableApi* | [**standardvariables_id_get**](docs/endpoints/StandardVariableApi.md#standardvariables_id_get) | **GET** /standardvariables/{id} | Get a single StandardVariable by its id
*StandardVariableApi* | [**standardvariables_id_put**](docs/endpoints/StandardVariableApi.md#standardvariables_id_put) | **PUT** /standardvariables/{id} | Update an existing StandardVariable
*StandardVariableApi* | [**standardvariables_post**](docs/endpoints/StandardVariableApi.md#standardvariables_post) | **POST** /standardvariables | Create one StandardVariable
*TheoryGuidedModelApi* | [**theory_guidedmodels_get**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_get) | **GET** /theory-guidedmodels | List all instances of Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_delete**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_delete) | **DELETE** /theory-guidedmodels/{id} | Delete an existing Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_get**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_get) | **GET** /theory-guidedmodels/{id} | Get a single Theory-GuidedModel by its id
*TheoryGuidedModelApi* | [**theory_guidedmodels_id_put**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_id_put) | **PUT** /theory-guidedmodels/{id} | Update an existing Theory-GuidedModel
*TheoryGuidedModelApi* | [**theory_guidedmodels_post**](docs/endpoints/TheoryGuidedModelApi.md#theory_guidedmodels_post) | **POST** /theory-guidedmodels | Create one Theory-GuidedModel
*TimeIntervalApi* | [**timeintervals_get**](docs/endpoints/TimeIntervalApi.md#timeintervals_get) | **GET** /timeintervals | List all instances of TimeInterval
*TimeIntervalApi* | [**timeintervals_id_delete**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_delete) | **DELETE** /timeintervals/{id} | Delete an existing TimeInterval
*TimeIntervalApi* | [**timeintervals_id_get**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_get) | **GET** /timeintervals/{id} | Get a single TimeInterval by its id
*TimeIntervalApi* | [**timeintervals_id_put**](docs/endpoints/TimeIntervalApi.md#timeintervals_id_put) | **PUT** /timeintervals/{id} | Update an existing TimeInterval
*TimeIntervalApi* | [**timeintervals_post**](docs/endpoints/TimeIntervalApi.md#timeintervals_post) | **POST** /timeintervals | Create one TimeInterval
*UnitApi* | [**units_get**](docs/endpoints/UnitApi.md#units_get) | **GET** /units | List all instances of Unit
*UnitApi* | [**units_id_delete**](docs/endpoints/UnitApi.md#units_id_delete) | **DELETE** /units/{id} | Delete an existing Unit
*UnitApi* | [**units_id_get**](docs/endpoints/UnitApi.md#units_id_get) | **GET** /units/{id} | Get a single Unit by its id
*UnitApi* | [**units_id_put**](docs/endpoints/UnitApi.md#units_id_put) | **PUT** /units/{id} | Update an existing Unit
*UnitApi* | [**units_post**](docs/endpoints/UnitApi.md#units_post) | **POST** /units | Create one Unit
*VariableApi* | [**variables_get**](docs/endpoints/VariableApi.md#variables_get) | **GET** /variables | List all instances of Variable
*VariableApi* | [**variables_id_delete**](docs/endpoints/VariableApi.md#variables_id_delete) | **DELETE** /variables/{id} | Delete an existing Variable
*VariableApi* | [**variables_id_get**](docs/endpoints/VariableApi.md#variables_id_get) | **GET** /variables/{id} | Get a single Variable by its id
*VariableApi* | [**variables_id_put**](docs/endpoints/VariableApi.md#variables_id_put) | **PUT** /variables/{id} | Update an existing Variable
*VariableApi* | [**variables_post**](docs/endpoints/VariableApi.md#variables_post) | **POST** /variables | Create one Variable
*VariablePresentationApi* | [**variablepresentations_get**](docs/endpoints/VariablePresentationApi.md#variablepresentations_get) | **GET** /variablepresentations | List all instances of VariablePresentation
*VariablePresentationApi* | [**variablepresentations_id_delete**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_delete) | **DELETE** /variablepresentations/{id} | Delete an existing VariablePresentation
*VariablePresentationApi* | [**variablepresentations_id_get**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_get) | **GET** /variablepresentations/{id} | Get a single VariablePresentation by its id
*VariablePresentationApi* | [**variablepresentations_id_put**](docs/endpoints/VariablePresentationApi.md#variablepresentations_id_put) | **PUT** /variablepresentations/{id} | Update an existing VariablePresentation
*VariablePresentationApi* | [**variablepresentations_post**](docs/endpoints/VariablePresentationApi.md#variablepresentations_post) | **POST** /variablepresentations | Create one VariablePresentation
*VisualizationApi* | [**visualizations_get**](docs/endpoints/VisualizationApi.md#visualizations_get) | **GET** /visualizations | List all instances of Visualization
*VisualizationApi* | [**visualizations_id_delete**](docs/endpoints/VisualizationApi.md#visualizations_id_delete) | **DELETE** /visualizations/{id} | Delete an existing Visualization
*VisualizationApi* | [**visualizations_id_get**](docs/endpoints/VisualizationApi.md#visualizations_id_get) | **GET** /visualizations/{id} | Get a single Visualization by its id
*VisualizationApi* | [**visualizations_id_put**](docs/endpoints/VisualizationApi.md#visualizations_id_put) | **PUT** /visualizations/{id} | Update an existing Visualization
*VisualizationApi* | [**visualizations_post**](docs/endpoints/VisualizationApi.md#visualizations_post) | **POST** /visualizations | Create one Visualization
*DefaultApi* | [**user_login_post**](docs/endpoints/DefaultApi.md#user_login_post) | **POST** /user/login | 


## Documentation For Models

 - [CausalDiagram](docs/endpoints/CausalDiagram.md)
 - [ConfigurationSetup](docs/endpoints/ConfigurationSetup.md)
 - [DataTransformation](docs/endpoints/DataTransformation.md)
 - [DataTransformationSetup](docs/endpoints/DataTransformationSetup.md)
 - [DatasetSpecification](docs/endpoints/DatasetSpecification.md)
 - [EmpiricalModel](docs/endpoints/EmpiricalModel.md)
 - [Emulator](docs/endpoints/Emulator.md)
 - [Equation](docs/endpoints/Equation.md)
 - [FundingInformation](docs/endpoints/FundingInformation.md)
 - [GeoCoordinates](docs/endpoints/GeoCoordinates.md)
 - [GeoShape](docs/endpoints/GeoShape.md)
 - [Grid](docs/endpoints/Grid.md)
 - [HybridModel](docs/endpoints/HybridModel.md)
 - [Image](docs/endpoints/Image.md)
 - [Intervention](docs/endpoints/Intervention.md)
 - [Model](docs/endpoints/Model.md)
 - [ModelConfiguration](docs/endpoints/ModelConfiguration.md)
 - [ModelConfigurationSetup](docs/endpoints/ModelConfigurationSetup.md)
 - [NumericalIndex](docs/endpoints/NumericalIndex.md)
 - [Organization](docs/endpoints/Organization.md)
 - [Parameter](docs/endpoints/Parameter.md)
 - [Person](docs/endpoints/Person.md)
 - [PointBasedGrid](docs/endpoints/PointBasedGrid.md)
 - [Process](docs/endpoints/Process.md)
 - [Region](docs/endpoints/Region.md)
 - [SampleCollection](docs/endpoints/SampleCollection.md)
 - [SampleExecution](docs/endpoints/SampleExecution.md)
 - [SampleResource](docs/endpoints/SampleResource.md)
 - [Software](docs/endpoints/Software.md)
 - [SoftwareConfiguration](docs/endpoints/SoftwareConfiguration.md)
 - [SoftwareImage](docs/endpoints/SoftwareImage.md)
 - [SoftwareVersion](docs/endpoints/SoftwareVersion.md)
 - [SourceCode](docs/endpoints/SourceCode.md)
 - [SpatialResolution](docs/endpoints/SpatialResolution.md)
 - [SpatiallyDistributedGrid](docs/endpoints/SpatiallyDistributedGrid.md)
 - [StandardVariable](docs/endpoints/StandardVariable.md)
 - [TheoryGuidedModel](docs/endpoints/TheoryGuidedModel.md)
 - [TimeInterval](docs/endpoints/TimeInterval.md)
 - [Unit](docs/endpoints/Unit.md)
 - [User](docs/endpoints/User.md)
 - [Variable](docs/endpoints/Variable.md)
 - [VariablePresentation](docs/endpoints/VariablePresentation.md)
 - [Visualization](docs/endpoints/Visualization.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (JWT)


## Author




