"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IPAMdministrator = exports.IPAMAdministratorProvider = exports.OrganizationAccount = exports.OrganizationAccountProvider = exports.OrganizationOU = exports.OrganizationOUProvider = exports.processOUObj = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
;
;
/**
 * @function processOUObj
 * Function to process an OrgObject and create the corresponding AWS resources
 *
 * @param {Construct} this The construct resources will be added to.
 * @param {custom_resources.Provider} ouProvider The custom resource provider for managing OUs
 * @param {custom_resources.Provider} accountProvider The custom resource provider for managing accounts
 * @param {OUObject} obj The OrgObject to process.
 * @param {string | OrganizationOU} parent The parent of the OrgObject. This is either a string, like for the org root, or an OrganizationOU object from the same stack.
 */
function processOUObj(ouProvider, accountProvider, obj, parent) {
    var _g, _h;
    const parentStr = parent instanceof OrganizationOU ? parent.resource.ref : parent;
    let id = (_g = obj.id) !== null && _g !== void 0 ? _g : obj.properties.name;
    const ou = new OrganizationOU(this, id, {
        provider: ouProvider,
        parent: parentStr,
        name: obj.properties.name,
        importOnDuplicate: obj.properties.importOnDuplicate,
        allowRecreateOnUpdate: obj.properties.allowRecreateOnUpdate,
    });
    (_h = obj.accounts) === null || _h === void 0 ? void 0 : _h.forEach((account) => {
        new OrganizationAccount(this, `${account.name}-${account.email.replace(/[^a-zA-Z ]/g, '')}`, {
            provider: accountProvider,
            parent: ou,
            name: account.name,
            email: account.email,
            importOnDuplicate: account.importOnDuplicate,
            allowMove: account.allowMove,
            disableDelete: account.disableDelete,
        });
    });
    obj.children.forEach(child => {
        processOUObj.call(this, ouProvider, accountProvider, child, ou);
    });
}
exports.processOUObj = processOUObj;
/**
 * The provider for OU custom resources
 *
 * This creates a lambda function that handles custom resource requests for creating/updating/deleting OUs.
 */
class OrganizationOUProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let role;
        if (!props.role) {
            role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
                assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            });
            let policy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'policy', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        actions: [
                            'organizations:UpdateOrganizationalUnit',
                            'organizations:DeleteOrganizationalUnit',
                            'organizations:ListOrganizationalUnitsForParent',
                            'organizations:CreateOrganizationalUnit',
                        ],
                        resources: ['*'],
                    }),
                ],
            });
            role.addManagedPolicy(policy);
            role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'));
        }
        else {
            role = props.role;
        }
        const handlersPath = path.join(__dirname, '../handlers');
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(handlersPath + '/ou'),
            handler: 'index.on_event',
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            role,
        });
        this.provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
    }
}
exports.OrganizationOUProvider = OrganizationOUProvider;
_a = JSII_RTTI_SYMBOL_1;
OrganizationOUProvider[_a] = { fqn: "@renovosolutions/cdk-library-aws-organization.OrganizationOUProvider", version: "0.4.61" };
/**
 * The construct to create or update an Organization OU
 *
 * This relies on the custom resource provider OrganizationOUProvider.
*/
class OrganizationOU extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _g, _h;
        super(scope, id);
        const importOnDuplicate = (_g = props.importOnDuplicate) !== null && _g !== void 0 ? _g : false;
        const allowRecreateOnUpdate = (_h = props.allowRecreateOnUpdate) !== null && _h !== void 0 ? _h : false;
        const parentStr = props.parent instanceof OrganizationOU ? props.parent.resource.ref : props.parent;
        this.resource = new aws_cdk_lib_1.CustomResource(this, 'ou', {
            serviceToken: props.provider.serviceToken,
            properties: {
                Parent: parentStr,
                Name: props.name,
                ImportOnDuplicate: importOnDuplicate,
                AllowRecreateOnUpdate: allowRecreateOnUpdate,
            },
        });
        this.resource.node.addDependency(props.provider);
        if (props.parent instanceof OrganizationOU) {
            this.resource.node.addDependency(props.parent);
        }
        ;
    }
}
exports.OrganizationOU = OrganizationOU;
_b = JSII_RTTI_SYMBOL_1;
OrganizationOU[_b] = { fqn: "@renovosolutions/cdk-library-aws-organization.OrganizationOU", version: "0.4.61" };
/**
 * The provider for account custom resources
 *
 * This creates a lambda function that handles custom resource requests for creating/updating accounts.
 */
class OrganizationAccountProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let role;
        if (!props.role) {
            role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
                assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            });
            let policy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'policy', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        actions: [
                            'organizations:ListOrganizationalUnitsForParent',
                            'organizations:ListAccountsForParent',
                            'organizations:ListRoots',
                            'organizations:MoveAccount',
                            'organizations:DescribeAccount',
                            'organizations:DescribeCreateAccountStatus',
                            'organizations:CreateAccount',
                        ],
                        resources: ['*'],
                    }),
                ],
            });
            role.addManagedPolicy(policy);
            role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'));
        }
        else {
            role = props.role;
        }
        const handlersPath = path.join(__dirname, '../handlers');
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(handlersPath + '/account'),
            handler: 'index.on_event',
            timeout: aws_cdk_lib_1.Duration.seconds(300),
            role,
        });
        this.provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
    }
}
exports.OrganizationAccountProvider = OrganizationAccountProvider;
_c = JSII_RTTI_SYMBOL_1;
OrganizationAccountProvider[_c] = { fqn: "@renovosolutions/cdk-library-aws-organization.OrganizationAccountProvider", version: "0.4.61" };
/**
 * The construct to create or update an Organization account
 *
 * This relies on the custom resource provider OrganizationAccountProvider.
*/
class OrganizationAccount extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _g, _h, _j;
        super(scope, id);
        const importOnDuplicate = (_g = props.importOnDuplicate) !== null && _g !== void 0 ? _g : false;
        const allowMove = (_h = props.allowMove) !== null && _h !== void 0 ? _h : false;
        const disableDelete = (_j = props.disableDelete) !== null && _j !== void 0 ? _j : false;
        const parentStr = props.parent instanceof OrganizationOU ? props.parent.resource.ref : props.parent;
        this.resource = new aws_cdk_lib_1.CustomResource(this, 'ou', {
            serviceToken: props.provider.serviceToken,
            properties: {
                Parent: parentStr,
                Name: props.name,
                Email: props.email,
                ImportOnDuplicate: importOnDuplicate,
                AllowMove: allowMove,
                DisableDelete: disableDelete,
            },
        });
        this.resource.node.addDependency(props.provider);
        if (props.parent instanceof OrganizationOU) {
            this.resource.node.addDependency(props.parent);
        }
        ;
    }
}
exports.OrganizationAccount = OrganizationAccount;
_d = JSII_RTTI_SYMBOL_1;
OrganizationAccount[_d] = { fqn: "@renovosolutions/cdk-library-aws-organization.OrganizationAccount", version: "0.4.61" };
class IPAMAdministratorProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Need updated Boto3 to support IPAM
        const boto3Layer = new aws_cdk_lib_1.aws_lambda.LayerVersion(this, 'boto3Layer', {
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../handlers/boto3layer'), {
                bundling: {
                    image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                    command: [],
                    local: {
                        tryBundle(outputDir) {
                            try {
                                child_process_1.execSync('pip3 --version');
                            }
                            catch {
                                return false;
                            }
                            child_process_1.execSync(`pip install -r ${path.join(__dirname, '../handlers/boto3layer/requirements.txt')} -t ${path.join(outputDir)}`);
                            child_process_1.execSync(`cp -au ${path.join(__dirname, '../handlers/boto3layer/*')} ${path.join(outputDir)}`);
                            return true;
                        },
                    },
                },
            }),
            compatibleRuntimes: [aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9],
        });
        let role;
        if (!props.role) {
            role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
                assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            });
            let policy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'policy', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        actions: [
                            'ec2:EnableIpamOrganizationAdminAccount',
                            'organizations:EnableAwsServiceAccess',
                            'organizations:RegisterDelegatedAdministator',
                            'iam:CreateServiceLinkedRole',
                        ],
                        resources: ['*'],
                    }),
                ],
            });
            role.addManagedPolicy(policy);
            role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'));
        }
        else {
            role = props.role;
        }
        const handlersPath = path.join(__dirname, '../handlers');
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(handlersPath + '/ipamadmin'),
            handler: 'index.on_event',
            timeout: aws_cdk_lib_1.Duration.seconds(300),
            role,
            layers: [boto3Layer],
        });
        this.provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
    }
}
exports.IPAMAdministratorProvider = IPAMAdministratorProvider;
_e = JSII_RTTI_SYMBOL_1;
IPAMAdministratorProvider[_e] = { fqn: "@renovosolutions/cdk-library-aws-organization.IPAMAdministratorProvider", version: "0.4.61" };
/**
 * The construct to create or update the delegated IPAM administrator for an organization
 *
 * This relies on the custom resource provider IPAMAdministratorProvider.
*/
class IPAMdministrator extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.resource = new aws_cdk_lib_1.CustomResource(this, 'ipamAdmin', {
            serviceToken: props.provider.serviceToken,
            properties: {
                DelegatedAdminAccountId: props.delegatedAdminAccountId,
            },
        });
    }
}
exports.IPAMdministrator = IPAMdministrator;
_f = JSII_RTTI_SYMBOL_1;
IPAMdministrator[_f] = { fqn: "@renovosolutions/cdk-library-aws-organization.IPAMdministrator", version: "0.4.61" };
//# sourceMappingURL=data:application/json;base64,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