"""Handles retrieval of saved_queries."""

import click

import spyctl.commands.get.shared_options as _so
import spyctl.config.configs as cfg
import spyctl.resources as _r
import spyctl.spyctl_lib as lib
from spyctl.commands.get import get_lib
import spyctl.api.saved_queries as sq_api


@click.command("saved-queries", cls=lib.CustomCommand, epilog=lib.SUB_EPILOG)
@_so.help_option
@_so.name_or_id_arg
@_so.output_option
@_so.page_option
@_so.page_size_option
@_so.exact_match_option
def get_saved_queries(name_or_id, output, **kwargs):
    """Get saved_queries by name or id."""
    kwargs["page"] = kwargs["page"] - 1
    get_lib.output_time_log(lib.SAVED_QUERY_RESOURCE.name_plural, None, None)
    kwargs = {key: value for key, value in kwargs.items() if value is not None}
    handle_get_saved_queries(name_or_id, output, **kwargs)


def handle_get_saved_queries(name_or_id, output, **kwargs):
    """Output saved_queries by name or id."""
    kwargs["page"] = kwargs.get("page", 0)
    kwargs["page_size"] = kwargs.get("page_size", 10)
    ctx = cfg.get_current_context()
    if name_or_id:
        kwargs["name_or_uid_contains"] = name_or_id
    saved_queries, total_pages = sq_api.get_saved_queries(
        *ctx.get_api_data(), **kwargs
    )
    get_lib.show_get_data(
        saved_queries,
        output,
        lambda data: _r.saved_queries.summary_output(
            data, total_pages, kwargs["page"]
        ),
        data_parser=_r.saved_queries.data_to_yaml,
    )
