"""Contains the delete command group."""

import click

import spyctl.spyctl_lib as lib
from spyctl.commands.delete import (
    notification_config,
    notification_target,
    policy,
    ruleset,
    saved_query,
)


@click.group("delete", cls=lib.CustomSubGroup, epilog=lib.SUB_EPILOG)
@click.help_option("-h", "--help", hidden=True)
def delete():
    """Get Spyderbat Resources."""


delete.add_command(notification_config.delete_notif_cfg_cmd)
delete.add_command(notification_target.delete_notif_tgt_cmd)
delete.add_command(policy.delete_policy_cmd)
delete.add_command(ruleset.delete_ruleset_cmd)
delete.add_command(saved_query.delete_saved_query_cmd)
