/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.plugins.pythoneventserver;

import com.google.common.eventbus.Subscribe;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import mmcorej.CMMCore;
import mmcorej.org.json.JSONObject;
import org.micromanager.Studio;
import org.micromanager.acquisition.AcquisitionEndedEvent;
import org.micromanager.acquisition.AcquisitionSequenceStartedEvent;
import org.micromanager.acquisition.SequenceSettings;
import org.micromanager.data.DataProviderHasNewImageEvent;
import org.micromanager.data.Datastore;
import org.micromanager.data.Image;
import org.micromanager.events.ConfigGroupChangedEvent;
import org.micromanager.events.ExposureChangedEvent;
import org.micromanager.events.GUIRefreshEvent;
import org.micromanager.events.LiveModeEvent;
import org.micromanager.events.StagePositionChangedEvent;
import org.micromanager.events.XYStagePositionChangedEvent;
import org.micromanager.internal.ConfigGroupPad;
import org.micromanager.internal.MMStudio;
import org.micromanager.internal.interfaces.AcqSettingsListener;
import org.micromanager.internal.utils.WindowPositioning;
import org.micromanager.internal.zmq.ZMQUtil;
import org.micromanager.plugins.pythoneventserver.CustomMDAEvent;
import org.micromanager.plugins.pythoneventserver.CustomSettingsEvent;
import org.micromanager.plugins.pythoneventserver.ImageListener;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class PythonEventServerFrame
extends JFrame {
    private final JCheckBox liveCheckBox_;
    private final Studio studio_;
    private ConfigGroupPad pad_;
    private final JTextArea logTextArea;
    private ZMQ.Socket socket_;
    private final ServerThread server;
    public ZMQUtil util_;
    private long lastStageTime;

    public PythonEventServerFrame(Studio studio) {
        super("Python Event Server GUI");
        this.studio_ = studio;
        this.server = new ServerThread();
        this.server.init();
        this.server.start();
        System.out.println("Server started");
        CMMCore core = this.studio_.getCMMCore();
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        classLoaders.add(core.getClass().getClassLoader());
        this.util_ = new ZMQUtil(classLoaders, new String[0]);
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PythonEventServerFrame.this.exitPlugin();
            }
        });
        JLabel title = new JLabel("Python Event Server");
        title.setFont(new Font("Arial", 1, 14));
        title.setMaximumSize(new Dimension(200, 30));
        title.setAlignmentX(0.5f);
        this.liveCheckBox_ = new JCheckBox();
        this.liveCheckBox_.setText("Live Mode Events");
        this.logTextArea = new JTextArea(30, 100);
        this.logTextArea.setAlignmentX(0.5f);
        JScrollPane scrollPane = new JScrollPane(this.logTextArea);
        DefaultCaret caret = (DefaultCaret)this.logTextArea.getCaret();
        caret.setUpdatePolicy(1);
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        panel.add(title);
        panel.add(scrollPane);
        panel.add(this.liveCheckBox_);
        panel.setAlignmentX(0.5f);
        super.add(panel);
        super.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/micromanager/icons/microscope.gif")));
        super.setLocation(100, 100);
        super.setSize(new Dimension(100, 100));
        WindowPositioning.setUpLocationMemory((Window)this, this.getClass(), null);
        super.pack();
    }

    public void exitPlugin() {
        this.server.close();
        super.dispose();
        System.out.println("Closed Server and Frame");
    }

    public class ServerThread
    extends Thread
    implements AcqSettingsListener {
        private ImageListener imageListener_;

        public void init() {
            ZMQ.Context context = ZMQ.context((int)1);
            PythonEventServerFrame.this.socket_ = context.socket(SocketType.PUB);
            PythonEventServerFrame.this.socket_.bind("tcp://*:5556");
            PythonEventServerFrame.this.studio_.events().registerForEvents((Object)this);
            MMStudio studio = (MMStudio)PythonEventServerFrame.this.studio_;
            PythonEventServerFrame.this.pad_ = studio.uiManager().frame().getConfigPad();
            ((MMStudio)PythonEventServerFrame.this.studio_).getAcquisitionEngine().addSettingsListener((AcqSettingsListener)this);
            PythonEventServerFrame.this.lastStageTime = System.currentTimeMillis();
        }

        public void close() {
            PythonEventServerFrame.this.socket_.unbind("tcp://*:5556");
            PythonEventServerFrame.this.socket_.close();
            PythonEventServerFrame.this.studio_.events().unregisterForEvents((Object)this);
            super.interrupt();
        }

        @Subscribe
        public void onConfigGroupChanged(ConfigGroupChangedEvent event) {
            this.addLog("ConfigGroupChangedEvent " + event.getGroupName());
        }

        @Subscribe
        public void onGUIRefresh(GUIRefreshEvent event) {
            String group = PythonEventServerFrame.this.pad_.getSelectedGroup();
            ArrayList<CustomSettingsEvent> changedSettings = new ArrayList<CustomSettingsEvent>();
            try {
                String[] changeList;
                String state = PythonEventServerFrame.this.studio_.core().getConfigGroupState(group).getVerbose();
                System.out.println(state);
                for (String change : changeList = state.substring(6, state.length() - 7).split("<br>")) {
                    System.out.println(change);
                    String device = change.split(":")[0];
                    String setting = change.split(":")[1].split("=")[0];
                    String value = change.split(":")[1].split("=")[1];
                    changedSettings.add(new CustomSettingsEvent(device, setting, value));
                }
            }
            catch (Exception e) {
                System.out.println("Error");
                e.printStackTrace();
            }
            if (changedSettings.isEmpty()) {
                double exposure = 0.0;
                try {
                    exposure = PythonEventServerFrame.this.studio_.core().getExposure();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PythonEventServerFrame.this.studio_.events().post((Object)new CustomSettingsEvent("exposure", "time_ms", String.valueOf(exposure)));
            }
            for (CustomSettingsEvent setting : changedSettings) {
                PythonEventServerFrame.this.studio_.events().post((Object)setting);
            }
            this.addLog("GUIRefreshEvent");
        }

        @Subscribe
        public void onSettingsChanged(CustomSettingsEvent event) {
            this.sendJSON(event, "Settings ");
            this.addLog("CustomSettingsEvent " + event.getDevice() + ":" + event.getProperty() + "=" + event.getValue());
        }

        public void settingsChanged() {
            System.out.println("Setting changed");
            SequenceSettings sequenceSettings = PythonEventServerFrame.this.studio_.acquisitions().getAcquisitionSettings();
            CustomMDAEvent settingsEvent = new CustomMDAEvent(sequenceSettings);
            PythonEventServerFrame.this.studio_.events().post((Object)settingsEvent);
        }

        @Subscribe
        public void onCustomMDA(CustomMDAEvent event) {
            this.sendJSON(event, "Settings ");
            this.addLog("CustomMDAEvent");
        }

        @Subscribe
        public void onExposureChanged(ExposureChangedEvent event) {
            this.sendJSON(event, "Settings ");
        }

        @Subscribe
        public void onStagePositionChanged(StagePositionChangedEvent event) {
            long now = System.currentTimeMillis();
            System.out.println(now - PythonEventServerFrame.this.lastStageTime);
            this.sendJSON(event, "Hardware ");
            PythonEventServerFrame.this.lastStageTime = now;
        }

        @Subscribe
        public void onXYStagePositionChanged(XYStagePositionChangedEvent event) {
            this.sendJSON(event, "Hardware ");
        }

        @Subscribe
        public void onAcquisitionEnded(AcquisitionEndedEvent event) {
            this.sendJSON(event, "Acquisition ");
            this.imageListener_.close();
            this.imageListener_ = null;
            this.addLog("AcquisitionEndedEvent");
        }

        @Subscribe
        public void onAcquisitionSequenceStarted(AcquisitionSequenceStartedEvent event) {
            this.sendJSON(event, "Acquisition ");
            this.imageListener_ = new ImageListener(PythonEventServerFrame.this.studio_, this, event.getDatastore());
            this.addLog("AcquisitionSequenceStartedEvent");
        }

        @Subscribe
        public void onLiveMode(LiveModeEvent event) {
            if (event.isOn() & PythonEventServerFrame.this.liveCheckBox_.isSelected()) {
                this.imageListener_ = new ImageListener(PythonEventServerFrame.this.studio_, this, (Datastore)PythonEventServerFrame.this.studio_.getSnapLiveManager().getDisplay().getDataProvider());
            } else if (this.imageListener_ != null) {
                this.imageListener_.close();
            }
            this.sendJSON(event, "LiveMode ");
            this.addLog("LiveModeEvent");
        }

        void addLog(String eventMsg) {
            String currentText = PythonEventServerFrame.this.logTextArea.getText();
            String newEvent = new Date() + " " + eventMsg;
            PythonEventServerFrame.this.logTextArea.setText(newEvent + "\n" + currentText);
        }

        public void sendImage(DataProviderHasNewImageEvent event) {
            Image image = event.getImage();
            ArrayList<Float> imageParams = new ArrayList<Float>();
            imageParams.add(Float.valueOf(image.getWidth()));
            imageParams.add(Float.valueOf(image.getHeight()));
            imageParams.add(Float.valueOf(image.getCoords().getT()));
            imageParams.add(Float.valueOf(image.getCoords().getC()));
            imageParams.add(Float.valueOf(image.getCoords().getZ()));
            imageParams.add(Float.valueOf((float)image.getMetadata().getElapsedTimeMs(0.0)));
            PythonEventServerFrame.this.socket_.sendMore("NewImage " + imageParams);
            PythonEventServerFrame.this.socket_.sendMore(String.valueOf(image.getBytesPerComponent()));
            PythonEventServerFrame.this.socket_.send(image.getByteArray());
            this.addLog("NewImage");
        }

        public void sendJSON(Object event, String type) {
            JSONObject json = new JSONObject();
            PythonEventServerFrame.this.util_.serialize(event, json, 5556);
            PythonEventServerFrame.this.socket_.send(type + json);
        }
    }
}

