from unittest.mock import Mock

from dissect.etl.headers.headers import EventTraceHeader, Marker

EVENT_TRACE_EVENT = (
    b"\x12\x01\x13\xC0\x01\x00\x00\x00\xE8\x02\x00\x00\xE4\x02\x00\x00"
    b"\x2B\x15\x41\x0B\x00\x00\x00\x00\xA7\xCE\xDD\xB8\x20\xB5\x09\x49"
    b"\xBC\xEB\xE0\x17\x0C\x9F\x0E\x99\x00\x00\x00\x0B\x05\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x20\x00\x00\x11\x00\x00\x00\x02\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x48\x00\x0C\x00\x01\x00\x3D\x00\x3D\x00\x4D\x69\x63\x72\x6F\x73"
    b"\x6F\x66\x74\x2E\x57\x69\x6E\x64\x6F\x77\x73\x2E\x53\x65\x72\x76"
    b"\x69\x63\x65\x43\x6F\x6E\x74\x72\x6F\x6C\x4D\x61\x6E\x61\x67\x65"
    b"\x72\x00\x13\x00\x01\x1A\x73\x50\x4F\xCF\x89\x82\x47\xB3\xE0\xDC"
    b"\xE8\xC9\x04\x76\xBA\x00\x00\x00\x38\x00\x0B\x00\x00\x00\x2C\x00"
    b"\x2C\x00\x00\x53\x65\x72\x76\x69\x63\x65\x48\x6F\x73\x74\x53\x74"
    b"\x61\x72\x74\x65\x64\x00\x53\x65\x72\x76\x69\x63\x65\x48\x6F\x73"
    b"\x74\x4E\x61\x6D\x65\x00\x01\x50\x49\x44\x00\x08\x00\x00\x00\x00"
    b"\x43\x00\x3A\x00\x5C\x00\x57\x00\x69\x00\x6E\x00\x64\x00\x6F\x00"
    b"\x77\x00\x73\x00\x5C\x00\x73\x00\x79\x00\x73\x00\x74\x00\x65\x00"
    b"\x6D\x00\x33\x00\x32\x00\x5C\x00\x73\x00\x70\x00\x70\x00\x73\x00"
    b"\x76\x00\x63\x00\x2E\x00\x65\x00\x78\x00\x65\x00\x00\x00\xF4\x01"
    b"\x00\x00\x00\x00\x00\x00\x00\x00"
)


def create_event():
    header_data = memoryview(EVENT_TRACE_EVENT)
    marker = Marker(0xC000A0112)
    return EventTraceHeader(marker, header_data, Mock())


def test_event_header():
    header = create_event().header
    assert header.Size == 0x112
    assert header.Marker == 0xC013
    assert header.Version == 0x1
    assert header.ThreadId == 0x2E8
    assert header.ProcessId == 0x2E4
    assert header.TimeDelta == 0x0B41152B
    assert header.ProviderId == b"\xA7\xCE\xDD\xB8\x20\xB5\x09\x49\xBC\xEB\xE0\x17\x0C\x9F\x0E\x99"
    assert header.KernelTime == 0xB000000
    assert header.UserTime == 0x5
