"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublishToTopic = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * A Step Functions Task to publish messages to SNS topic.
 *
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 *
 * @deprecated Use `SnsPublish`
 */
class PublishToTopic {
    constructor(topic, props) {
        this.topic = topic;
        this.props = props;
        this.integrationPattern = props.integrationPattern || sfn.ServiceIntegrationPattern.FIRE_AND_FORGET;
        const supportedPatterns = [
            sfn.ServiceIntegrationPattern.FIRE_AND_FORGET,
            sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN,
        ];
        if (!supportedPatterns.includes(this.integrationPattern)) {
            throw new Error(`Invalid Service Integration Pattern: ${this.integrationPattern} is not supported to call SNS.`);
        }
        if (this.integrationPattern === sfn.ServiceIntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.message)) {
                throw new Error('Task Token is missing in message (pass Context.taskToken somewhere in message)');
            }
        }
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('sns', 'publish', this.integrationPattern),
            policyStatements: [new iam.PolicyStatement({
                    actions: ['sns:Publish'],
                    resources: [this.topic.topicArn],
                })],
            parameters: {
                TopicArn: this.topic.topicArn,
                Message: this.props.message.value,
                MessageStructure: this.props.messagePerSubscriptionType ? 'json' : undefined,
                Subject: this.props.subject,
            },
        };
    }
}
exports.PublishToTopic = PublishToTopic;
//# sourceMappingURL=data:application/json;base64,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