"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassicLoadBalancerTarget = void 0;
/**
 * Use a classic ELB as an alias record target
 */
class ClassicLoadBalancerTarget {
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    bind(_record) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneNameId,
            dnsName: this.loadBalancer.loadBalancerDnsName,
        };
    }
}
exports.ClassicLoadBalancerTarget = ClassicLoadBalancerTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xhc3NpYy1sb2FkLWJhbGFuY2VyLXRhcmdldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsYXNzaWMtbG9hZC1iYWxhbmNlci10YXJnZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLHlCQUF5QjtJQUNsQyxZQUE2QixZQUE4QjtRQUE5QixpQkFBWSxHQUFaLFlBQVksQ0FBa0I7SUFDM0QsQ0FBQztJQUNNLElBQUksQ0FBQyxPQUEyQjtRQUNuQyxPQUFPO1lBQ0gsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMscUNBQXFDO1lBQ3JFLE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQjtTQUNqRCxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBVEQsOERBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGIgZnJvbSBcIi4uLy4uL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5nJ1xuaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tIFwiLi4vLi4vYXdzLXJvdXRlNTNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJ1xuLyoqXG4gKiBVc2UgYSBjbGFzc2ljIEVMQiBhcyBhbiBhbGlhcyByZWNvcmQgdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBDbGFzc2ljTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgbG9hZEJhbGFuY2VyOiBlbGIuTG9hZEJhbGFuY2VyKSB7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJDYW5vbmljYWxIb3N0ZWRab25lTmFtZUlkLFxuICAgICAgICAgICAgZG5zTmFtZTogdGhpcy5sb2FkQmFsYW5jZXIubG9hZEJhbGFuY2VyRG5zTmFtZSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=