"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const efs_generated_1 = require("./efs.generated");
/**
 * Represents the AccessPoint
 */
class AccessPoint extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new efs_generated_1.CfnAccessPoint(scope, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
    }
    /**
     * Import an existing Access Point
     */
    static fromAccessPointId(scope, id, accessPointId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.accessPointId = accessPointId;
                this.accessPointArn = core_1.Stack.of(scope).formatArn({
                    service: 'elasticfilesystem',
                    resource: 'access-point',
                    resourceName: accessPointId,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.AccessPoint = AccessPoint;
//# sourceMappingURL=data:application/json;base64,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