"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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