"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcreteWidget = exports.GRID_WIDTH = void 0;
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
class ConcreteWidget {
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
//# sourceMappingURL=data:application/json;base64,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