import { HttpRouteIntegrationConfig, IHttpRouteIntegration } from '../integration';
import { HttpMethod, IHttpRoute } from '../route';
/**
 * Properties to initialize a new `HttpProxyIntegration`.
 */
export interface HttpProxyIntegrationProps {
    /**
     * The full-qualified HTTP URL for the HTTP integration
     */
    readonly url: string;
    /**
     * The HTTP method that must be used to invoke the underlying HTTP proxy.
     * @default HttpMethod.ANY
     */
    readonly method?: HttpMethod;
}
/**
 * The HTTP Proxy integration resource for HTTP API
 */
export declare class HttpProxyIntegration implements IHttpRouteIntegration {
    private readonly props;
    constructor(props: HttpProxyIntegrationProps);
    bind(_: IHttpRoute): HttpRouteIntegrationConfig;
}
