"""
This type stub file was generated by pyright.
"""

from abc import abstractmethod
from typing import Any, Callable, Dict, FrozenSet, List, Literal, MutableMapping, Optional, Sequence, Set, TYPE_CHECKING, Tuple, Type, TypeVar, Union
from .base import BatchOperations, Operations
from .. import util
from ..util import sqla_compat
from sqlalchemy.sql import Executable
from sqlalchemy.sql.elements import ColumnElement, TextClause, conv, quoted_name
from sqlalchemy.sql.functions import Function
from sqlalchemy.sql.schema import CheckConstraint, Column, Computed, Constraint, ForeignKeyConstraint, Identity, Index, MetaData, PrimaryKeyConstraint, SchemaItem, Table, UniqueConstraint
from sqlalchemy.sql.selectable import TableClause
from sqlalchemy.sql.type_api import TypeEngine
from ..autogenerate.rewriter import Rewriter
from ..runtime.migration import MigrationContext
from ..script.revision import _RevIdType

if TYPE_CHECKING:
    ...
_T = TypeVar("_T", bound=Any)
_AC = TypeVar("_AC", bound="AddConstraintOp")
class MigrateOperation:
    """base class for migration command and organization objects.

    This system is part of the operation extensibility API.

    .. seealso::

        :ref:`operation_objects`

        :ref:`operation_plugins`

        :ref:`customizing_revision`

    """
    @util.memoized_property
    def info(self) -> Dict[Any, Any]:
        """A dictionary that may be used to store arbitrary information
        along with this :class:`.MigrateOperation` object.

        """
        ...
    
    _mutations: FrozenSet[Rewriter] = ...
    def reverse(self) -> MigrateOperation:
        ...
    
    def to_diff_tuple(self) -> Tuple[Any, ...]:
        ...
    


class AddConstraintOp(MigrateOperation):
    """Represent an add constraint operation."""
    add_constraint_ops = ...
    @property
    def constraint_type(self) -> str:
        ...
    
    @classmethod
    def register_add_constraint(cls, type_: str) -> Callable[[Type[_AC]], Type[_AC]]:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> AddConstraintOp:
        ...
    
    @abstractmethod
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> Constraint:
        ...
    
    def reverse(self) -> DropConstraintOp:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Constraint]:
        ...
    


@Operations.register_operation("drop_constraint")
@BatchOperations.register_operation("drop_constraint", "batch_drop_constraint")
class DropConstraintOp(MigrateOperation):
    """Represent a drop constraint operation."""
    def __init__(self, constraint_name: Optional[sqla_compat._ConstraintNameDefined], table_name: str, type_: Optional[str] = ..., *, schema: Optional[str] = ..., _reverse: Optional[AddConstraintOp] = ...) -> None:
        ...
    
    def reverse(self) -> AddConstraintOp:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, SchemaItem]:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> DropConstraintOp:
        ...
    
    def to_constraint(self) -> Constraint:
        ...
    
    @classmethod
    def drop_constraint(cls, operations: Operations, constraint_name: str, table_name: str, type_: Optional[str] = ..., *, schema: Optional[str] = ...) -> None:
        r"""Drop a constraint of the given name, typically via DROP CONSTRAINT.

        :param constraint_name: name of the constraint.
        :param table_name: table name.
        :param type\_: optional, required on MySQL.  can be
         'foreignkey', 'primary', 'unique', or 'check'.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    
    @classmethod
    def batch_drop_constraint(cls, operations: BatchOperations, constraint_name: str, type_: Optional[str] = ...) -> None:
        """Issue a "drop constraint" instruction using the
        current batch migration context.

        The batch form of this call omits the ``table_name`` and ``schema``
        arguments from the call.

        .. seealso::

            :meth:`.Operations.drop_constraint`

        """
        ...
    


@Operations.register_operation("create_primary_key")
@BatchOperations.register_operation("create_primary_key", "batch_create_primary_key")
@AddConstraintOp.register_add_constraint("primary_key_constraint")
class CreatePrimaryKeyOp(AddConstraintOp):
    """Represent a create primary key operation."""
    constraint_type = ...
    def __init__(self, constraint_name: Optional[sqla_compat._ConstraintNameDefined], table_name: str, columns: Sequence[str], *, schema: Optional[str] = ..., **kw: Any) -> None:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> CreatePrimaryKeyOp:
        ...
    
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> PrimaryKeyConstraint:
        ...
    
    @classmethod
    def create_primary_key(cls, operations: Operations, constraint_name: Optional[str], table_name: str, columns: List[str], *, schema: Optional[str] = ...) -> None:
        """Issue a "create primary key" instruction using the current
        migration context.

        e.g.::

            from alembic import op

            op.create_primary_key("pk_my_table", "my_table", ["id", "version"])

        This internally generates a :class:`~sqlalchemy.schema.Table` object
        containing the necessary columns, then generates a new
        :class:`~sqlalchemy.schema.PrimaryKeyConstraint`
        object which it then associates with the
        :class:`~sqlalchemy.schema.Table`.
        Any event listeners associated with this action will be fired
        off normally.   The :class:`~sqlalchemy.schema.AddConstraint`
        construct is ultimately used to generate the ALTER statement.

        :param constraint_name: Name of the primary key constraint.  The name
         is necessary so that an ALTER statement can be emitted.  For setups
         that use an automated naming scheme such as that described at
         :ref:`sqla:constraint_naming_conventions`
         ``name`` here can be ``None``, as the event listener will
         apply the name to the constraint object when it is associated
         with the table.
        :param table_name: String name of the target table.
        :param columns: a list of string column names to be applied to the
         primary key constraint.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    
    @classmethod
    def batch_create_primary_key(cls, operations: BatchOperations, constraint_name: str, columns: List[str]) -> None:
        """Issue a "create primary key" instruction using the
        current batch migration context.

        The batch form of this call omits the ``table_name`` and ``schema``
        arguments from the call.

        .. seealso::

            :meth:`.Operations.create_primary_key`

        """
        ...
    


@Operations.register_operation("create_unique_constraint")
@BatchOperations.register_operation("create_unique_constraint", "batch_create_unique_constraint")
@AddConstraintOp.register_add_constraint("unique_constraint")
class CreateUniqueConstraintOp(AddConstraintOp):
    """Represent a create unique constraint operation."""
    constraint_type = ...
    def __init__(self, constraint_name: Optional[sqla_compat._ConstraintNameDefined], table_name: str, columns: Sequence[str], *, schema: Optional[str] = ..., **kw: Any) -> None:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> CreateUniqueConstraintOp:
        ...
    
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> UniqueConstraint:
        ...
    
    @classmethod
    def create_unique_constraint(cls, operations: Operations, constraint_name: Optional[str], table_name: str, columns: Sequence[str], *, schema: Optional[str] = ..., **kw: Any) -> Any:
        """Issue a "create unique constraint" instruction using the
        current migration context.

        e.g.::

            from alembic import op
            op.create_unique_constraint("uq_user_name", "user", ["name"])

        This internally generates a :class:`~sqlalchemy.schema.Table` object
        containing the necessary columns, then generates a new
        :class:`~sqlalchemy.schema.UniqueConstraint`
        object which it then associates with the
        :class:`~sqlalchemy.schema.Table`.
        Any event listeners associated with this action will be fired
        off normally.   The :class:`~sqlalchemy.schema.AddConstraint`
        construct is ultimately used to generate the ALTER statement.

        :param name: Name of the unique constraint.  The name is necessary
         so that an ALTER statement can be emitted.  For setups that
         use an automated naming scheme such as that described at
         :ref:`sqla:constraint_naming_conventions`,
         ``name`` here can be ``None``, as the event listener will
         apply the name to the constraint object when it is associated
         with the table.
        :param table_name: String name of the source table.
        :param columns: a list of string column names in the
         source table.
        :param deferrable: optional bool. If set, emit DEFERRABLE or
         NOT DEFERRABLE when issuing DDL for this constraint.
        :param initially: optional string. If set, emit INITIALLY <value>
         when issuing DDL for this constraint.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    
    @classmethod
    def batch_create_unique_constraint(cls, operations: BatchOperations, constraint_name: str, columns: Sequence[str], **kw: Any) -> Any:
        """Issue a "create unique constraint" instruction using the
        current batch migration context.

        The batch form of this call omits the ``source`` and ``schema``
        arguments from the call.

        .. seealso::

            :meth:`.Operations.create_unique_constraint`

        """
        ...
    


@Operations.register_operation("create_foreign_key")
@BatchOperations.register_operation("create_foreign_key", "batch_create_foreign_key")
@AddConstraintOp.register_add_constraint("foreign_key_constraint")
class CreateForeignKeyOp(AddConstraintOp):
    """Represent a create foreign key constraint operation."""
    constraint_type = ...
    def __init__(self, constraint_name: Optional[sqla_compat._ConstraintNameDefined], source_table: str, referent_table: str, local_cols: List[str], remote_cols: List[str], **kw: Any) -> None:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, ForeignKeyConstraint]:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> CreateForeignKeyOp:
        ...
    
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> ForeignKeyConstraint:
        ...
    
    @classmethod
    def create_foreign_key(cls, operations: Operations, constraint_name: Optional[str], source_table: str, referent_table: str, local_cols: List[str], remote_cols: List[str], *, onupdate: Optional[str] = ..., ondelete: Optional[str] = ..., deferrable: Optional[bool] = ..., initially: Optional[str] = ..., match: Optional[str] = ..., source_schema: Optional[str] = ..., referent_schema: Optional[str] = ..., **dialect_kw: Any) -> None:
        """Issue a "create foreign key" instruction using the
        current migration context.

        e.g.::

            from alembic import op

            op.create_foreign_key(
                "fk_user_address",
                "address",
                "user",
                ["user_id"],
                ["id"],
            )

        This internally generates a :class:`~sqlalchemy.schema.Table` object
        containing the necessary columns, then generates a new
        :class:`~sqlalchemy.schema.ForeignKeyConstraint`
        object which it then associates with the
        :class:`~sqlalchemy.schema.Table`.
        Any event listeners associated with this action will be fired
        off normally.   The :class:`~sqlalchemy.schema.AddConstraint`
        construct is ultimately used to generate the ALTER statement.

        :param constraint_name: Name of the foreign key constraint.  The name
         is necessary so that an ALTER statement can be emitted.  For setups
         that use an automated naming scheme such as that described at
         :ref:`sqla:constraint_naming_conventions`,
         ``name`` here can be ``None``, as the event listener will
         apply the name to the constraint object when it is associated
         with the table.
        :param source_table: String name of the source table.
        :param referent_table: String name of the destination table.
        :param local_cols: a list of string column names in the
         source table.
        :param remote_cols: a list of string column names in the
         remote table.
        :param onupdate: Optional string. If set, emit ON UPDATE <value> when
         issuing DDL for this constraint. Typical values include CASCADE,
         DELETE and RESTRICT.
        :param ondelete: Optional string. If set, emit ON DELETE <value> when
         issuing DDL for this constraint. Typical values include CASCADE,
         DELETE and RESTRICT.
        :param deferrable: optional bool. If set, emit DEFERRABLE or NOT
         DEFERRABLE when issuing DDL for this constraint.
        :param source_schema: Optional schema name of the source table.
        :param referent_schema: Optional schema name of the destination table.

        """
        ...
    
    @classmethod
    def batch_create_foreign_key(cls, operations: BatchOperations, constraint_name: str, referent_table: str, local_cols: List[str], remote_cols: List[str], *, referent_schema: Optional[str] = ..., onupdate: Optional[str] = ..., ondelete: Optional[str] = ..., deferrable: Optional[bool] = ..., initially: Optional[str] = ..., match: Optional[str] = ..., **dialect_kw: Any) -> None:
        """Issue a "create foreign key" instruction using the
        current batch migration context.

        The batch form of this call omits the ``source`` and ``source_schema``
        arguments from the call.

        e.g.::

            with batch_alter_table("address") as batch_op:
                batch_op.create_foreign_key(
                    "fk_user_address",
                    "user",
                    ["user_id"],
                    ["id"],
                )

        .. seealso::

            :meth:`.Operations.create_foreign_key`

        """
        ...
    


@Operations.register_operation("create_check_constraint")
@BatchOperations.register_operation("create_check_constraint", "batch_create_check_constraint")
@AddConstraintOp.register_add_constraint("check_constraint")
@AddConstraintOp.register_add_constraint("table_or_column_check_constraint")
@AddConstraintOp.register_add_constraint("column_check_constraint")
class CreateCheckConstraintOp(AddConstraintOp):
    """Represent a create check constraint operation."""
    constraint_type = ...
    def __init__(self, constraint_name: Optional[sqla_compat._ConstraintNameDefined], table_name: str, condition: Union[str, TextClause, ColumnElement[Any]], *, schema: Optional[str] = ..., **kw: Any) -> None:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: Constraint) -> CreateCheckConstraintOp:
        ...
    
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> CheckConstraint:
        ...
    
    @classmethod
    def create_check_constraint(cls, operations: Operations, constraint_name: Optional[str], table_name: str, condition: Union[str, ColumnElement[bool], TextClause], *, schema: Optional[str] = ..., **kw: Any) -> None:
        """Issue a "create check constraint" instruction using the
        current migration context.

        e.g.::

            from alembic import op
            from sqlalchemy.sql import column, func

            op.create_check_constraint(
                "ck_user_name_len",
                "user",
                func.len(column("name")) > 5,
            )

        CHECK constraints are usually against a SQL expression, so ad-hoc
        table metadata is usually needed.   The function will convert the given
        arguments into a :class:`sqlalchemy.schema.CheckConstraint` bound
        to an anonymous table in order to emit the CREATE statement.

        :param name: Name of the check constraint.  The name is necessary
         so that an ALTER statement can be emitted.  For setups that
         use an automated naming scheme such as that described at
         :ref:`sqla:constraint_naming_conventions`,
         ``name`` here can be ``None``, as the event listener will
         apply the name to the constraint object when it is associated
         with the table.
        :param table_name: String name of the source table.
        :param condition: SQL expression that's the condition of the
         constraint. Can be a string or SQLAlchemy expression language
         structure.
        :param deferrable: optional bool. If set, emit DEFERRABLE or
         NOT DEFERRABLE when issuing DDL for this constraint.
        :param initially: optional string. If set, emit INITIALLY <value>
         when issuing DDL for this constraint.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    
    @classmethod
    def batch_create_check_constraint(cls, operations: BatchOperations, constraint_name: str, condition: Union[str, ColumnElement[bool], TextClause], **kw: Any) -> None:
        """Issue a "create check constraint" instruction using the
        current batch migration context.

        The batch form of this call omits the ``source`` and ``schema``
        arguments from the call.

        .. seealso::

            :meth:`.Operations.create_check_constraint`

        """
        ...
    


@Operations.register_operation("create_index")
@BatchOperations.register_operation("create_index", "batch_create_index")
class CreateIndexOp(MigrateOperation):
    """Represent a create index operation."""
    def __init__(self, index_name: Optional[str], table_name: str, columns: Sequence[Union[str, TextClause, ColumnElement[Any]]], *, schema: Optional[str] = ..., unique: bool = ..., if_not_exists: Optional[bool] = ..., **kw: Any) -> None:
        ...
    
    def reverse(self) -> DropIndexOp:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Index]:
        ...
    
    @classmethod
    def from_index(cls, index: Index) -> CreateIndexOp:
        ...
    
    def to_index(self, migration_context: Optional[MigrationContext] = ...) -> Index:
        ...
    
    @classmethod
    def create_index(cls, operations: Operations, index_name: Optional[str], table_name: str, columns: Sequence[Union[str, TextClause, Function[Any]]], *, schema: Optional[str] = ..., unique: bool = ..., if_not_exists: Optional[bool] = ..., **kw: Any) -> None:
        r"""Issue a "create index" instruction using the current
        migration context.

        e.g.::

            from alembic import op

            op.create_index("ik_test", "t1", ["foo", "bar"])

        Functional indexes can be produced by using the
        :func:`sqlalchemy.sql.expression.text` construct::

            from alembic import op
            from sqlalchemy import text

            op.create_index("ik_test", "t1", [text("lower(foo)")])

        :param index_name: name of the index.
        :param table_name: name of the owning table.
        :param columns: a list consisting of string column names and/or
         :func:`~sqlalchemy.sql.expression.text` constructs.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.
        :param unique: If True, create a unique index.

        :param quote: Force quoting of this column's name on or off,
         corresponding to ``True`` or ``False``. When left at its default
         of ``None``, the column identifier will be quoted according to
         whether the name is case sensitive (identifiers with at least one
         upper case character are treated as case sensitive), or if it's a
         reserved word. This flag is only needed to force quoting of a
         reserved word which is not known by the SQLAlchemy dialect.

        :param if_not_exists: If True, adds IF NOT EXISTS operator when
         creating the new index.

         .. versionadded:: 1.12.0

        :param \**kw: Additional keyword arguments not mentioned above are
         dialect specific, and passed in the form
         ``<dialectname>_<argname>``.
         See the documentation regarding an individual dialect at
         :ref:`dialect_toplevel` for detail on documented arguments.

        """
        ...
    
    @classmethod
    def batch_create_index(cls, operations: BatchOperations, index_name: str, columns: List[str], **kw: Any) -> None:
        """Issue a "create index" instruction using the
        current batch migration context.

        .. seealso::

            :meth:`.Operations.create_index`

        """
        ...
    


@Operations.register_operation("drop_index")
@BatchOperations.register_operation("drop_index", "batch_drop_index")
class DropIndexOp(MigrateOperation):
    """Represent a drop index operation."""
    def __init__(self, index_name: Union[quoted_name, str, conv], table_name: Optional[str] = ..., *, schema: Optional[str] = ..., if_exists: Optional[bool] = ..., _reverse: Optional[CreateIndexOp] = ..., **kw: Any) -> None:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Index]:
        ...
    
    def reverse(self) -> CreateIndexOp:
        ...
    
    @classmethod
    def from_index(cls, index: Index) -> DropIndexOp:
        ...
    
    def to_index(self, migration_context: Optional[MigrationContext] = ...) -> Index:
        ...
    
    @classmethod
    def drop_index(cls, operations: Operations, index_name: str, table_name: Optional[str] = ..., *, schema: Optional[str] = ..., if_exists: Optional[bool] = ..., **kw: Any) -> None:
        r"""Issue a "drop index" instruction using the current
        migration context.

        e.g.::

            drop_index("accounts")

        :param index_name: name of the index.
        :param table_name: name of the owning table.  Some
         backends such as Microsoft SQL Server require this.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        :param if_exists: If True, adds IF EXISTS operator when
         dropping the index.

         .. versionadded:: 1.12.0

        :param \**kw: Additional keyword arguments not mentioned above are
         dialect specific, and passed in the form
         ``<dialectname>_<argname>``.
         See the documentation regarding an individual dialect at
         :ref:`dialect_toplevel` for detail on documented arguments.

        """
        ...
    
    @classmethod
    def batch_drop_index(cls, operations: BatchOperations, index_name: str, **kw: Any) -> None:
        """Issue a "drop index" instruction using the
        current batch migration context.

        .. seealso::

            :meth:`.Operations.drop_index`

        """
        ...
    


@Operations.register_operation("create_table")
class CreateTableOp(MigrateOperation):
    """Represent a create table operation."""
    def __init__(self, table_name: str, columns: Sequence[SchemaItem], *, schema: Optional[str] = ..., _namespace_metadata: Optional[MetaData] = ..., _constraints_included: bool = ..., **kw: Any) -> None:
        ...
    
    def reverse(self) -> DropTableOp:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Table]:
        ...
    
    @classmethod
    def from_table(cls, table: Table, *, _namespace_metadata: Optional[MetaData] = ...) -> CreateTableOp:
        ...
    
    def to_table(self, migration_context: Optional[MigrationContext] = ...) -> Table:
        ...
    
    @classmethod
    def create_table(cls, operations: Operations, table_name: str, *columns: SchemaItem, **kw: Any) -> Table:
        r"""Issue a "create table" instruction using the current migration
        context.

        This directive receives an argument list similar to that of the
        traditional :class:`sqlalchemy.schema.Table` construct, but without the
        metadata::

            from sqlalchemy import INTEGER, VARCHAR, NVARCHAR, Column
            from alembic import op

            op.create_table(
                "account",
                Column("id", INTEGER, primary_key=True),
                Column("name", VARCHAR(50), nullable=False),
                Column("description", NVARCHAR(200)),
                Column("timestamp", TIMESTAMP, server_default=func.now()),
            )

        Note that :meth:`.create_table` accepts
        :class:`~sqlalchemy.schema.Column`
        constructs directly from the SQLAlchemy library.  In particular,
        default values to be created on the database side are
        specified using the ``server_default`` parameter, and not
        ``default`` which only specifies Python-side defaults::

            from alembic import op
            from sqlalchemy import Column, TIMESTAMP, func

            # specify "DEFAULT NOW" along with the "timestamp" column
            op.create_table(
                "account",
                Column("id", INTEGER, primary_key=True),
                Column("timestamp", TIMESTAMP, server_default=func.now()),
            )

        The function also returns a newly created
        :class:`~sqlalchemy.schema.Table` object, corresponding to the table
        specification given, which is suitable for
        immediate SQL operations, in particular
        :meth:`.Operations.bulk_insert`::

            from sqlalchemy import INTEGER, VARCHAR, NVARCHAR, Column
            from alembic import op

            account_table = op.create_table(
                "account",
                Column("id", INTEGER, primary_key=True),
                Column("name", VARCHAR(50), nullable=False),
                Column("description", NVARCHAR(200)),
                Column("timestamp", TIMESTAMP, server_default=func.now()),
            )

            op.bulk_insert(
                account_table,
                [
                    {"name": "A1", "description": "account 1"},
                    {"name": "A2", "description": "account 2"},
                ],
            )

        :param table_name: Name of the table
        :param \*columns: collection of :class:`~sqlalchemy.schema.Column`
         objects within
         the table, as well as optional :class:`~sqlalchemy.schema.Constraint`
         objects
         and :class:`~.sqlalchemy.schema.Index` objects.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.
        :param \**kw: Other keyword arguments are passed to the underlying
         :class:`sqlalchemy.schema.Table` object created for the command.

        :return: the :class:`~sqlalchemy.schema.Table` object corresponding
         to the parameters given.

        """
        ...
    


@Operations.register_operation("drop_table")
class DropTableOp(MigrateOperation):
    """Represent a drop table operation."""
    def __init__(self, table_name: str, *, schema: Optional[str] = ..., table_kw: Optional[MutableMapping[Any, Any]] = ..., _reverse: Optional[CreateTableOp] = ...) -> None:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Table]:
        ...
    
    def reverse(self) -> CreateTableOp:
        ...
    
    @classmethod
    def from_table(cls, table: Table, *, _namespace_metadata: Optional[MetaData] = ...) -> DropTableOp:
        ...
    
    def to_table(self, migration_context: Optional[MigrationContext] = ...) -> Table:
        ...
    
    @classmethod
    def drop_table(cls, operations: Operations, table_name: str, *, schema: Optional[str] = ..., **kw: Any) -> None:
        r"""Issue a "drop table" instruction using the current
        migration context.


        e.g.::

            drop_table("accounts")

        :param table_name: Name of the table
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.
        :param \**kw: Other keyword arguments are passed to the underlying
         :class:`sqlalchemy.schema.Table` object created for the command.

        """
        ...
    


class AlterTableOp(MigrateOperation):
    """Represent an alter table operation."""
    def __init__(self, table_name: str, *, schema: Optional[str] = ...) -> None:
        ...
    


@Operations.register_operation("rename_table")
class RenameTableOp(AlterTableOp):
    """Represent a rename table operation."""
    def __init__(self, old_table_name: str, new_table_name: str, *, schema: Optional[str] = ...) -> None:
        ...
    
    @classmethod
    def rename_table(cls, operations: Operations, old_table_name: str, new_table_name: str, *, schema: Optional[str] = ...) -> None:
        """Emit an ALTER TABLE to rename a table.

        :param old_table_name: old name.
        :param new_table_name: new name.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    


@Operations.register_operation("create_table_comment")
@BatchOperations.register_operation("create_table_comment", "batch_create_table_comment")
class CreateTableCommentOp(AlterTableOp):
    """Represent a COMMENT ON `table` operation."""
    def __init__(self, table_name: str, comment: Optional[str], *, schema: Optional[str] = ..., existing_comment: Optional[str] = ...) -> None:
        ...
    
    @classmethod
    def create_table_comment(cls, operations: Operations, table_name: str, comment: Optional[str], *, existing_comment: Optional[str] = ..., schema: Optional[str] = ...) -> None:
        """Emit a COMMENT ON operation to set the comment for a table.

        :param table_name: string name of the target table.
        :param comment: string value of the comment being registered against
         the specified table.
        :param existing_comment: String value of a comment
         already registered on the specified table, used within autogenerate
         so that the operation is reversible, but not required for direct
         use.

        .. seealso::

            :meth:`.Operations.drop_table_comment`

            :paramref:`.Operations.alter_column.comment`

        """
        ...
    
    @classmethod
    def batch_create_table_comment(cls, operations: BatchOperations, comment: Optional[str], *, existing_comment: Optional[str] = ...) -> None:
        """Emit a COMMENT ON operation to set the comment for a table
        using the current batch migration context.

        :param comment: string value of the comment being registered against
         the specified table.
        :param existing_comment: String value of a comment
         already registered on the specified table, used within autogenerate
         so that the operation is reversible, but not required for direct
         use.

        """
        ...
    
    def reverse(self) -> Union[CreateTableCommentOp, DropTableCommentOp]:
        """Reverses the COMMENT ON operation against a table."""
        ...
    
    def to_table(self, migration_context: Optional[MigrationContext] = ...) -> Table:
        ...
    
    def to_diff_tuple(self) -> Tuple[Any, ...]:
        ...
    


@Operations.register_operation("drop_table_comment")
@BatchOperations.register_operation("drop_table_comment", "batch_drop_table_comment")
class DropTableCommentOp(AlterTableOp):
    """Represent an operation to remove the comment from a table."""
    def __init__(self, table_name: str, *, schema: Optional[str] = ..., existing_comment: Optional[str] = ...) -> None:
        ...
    
    @classmethod
    def drop_table_comment(cls, operations: Operations, table_name: str, *, existing_comment: Optional[str] = ..., schema: Optional[str] = ...) -> None:
        """Issue a "drop table comment" operation to
        remove an existing comment set on a table.

        :param table_name: string name of the target table.
        :param existing_comment: An optional string value of a comment already
         registered on the specified table.

        .. seealso::

            :meth:`.Operations.create_table_comment`

            :paramref:`.Operations.alter_column.comment`

        """
        ...
    
    @classmethod
    def batch_drop_table_comment(cls, operations: BatchOperations, *, existing_comment: Optional[str] = ...) -> None:
        """Issue a "drop table comment" operation to
        remove an existing comment set on a table using the current
        batch operations context.

        :param existing_comment: An optional string value of a comment already
         registered on the specified table.

        """
        ...
    
    def reverse(self) -> CreateTableCommentOp:
        """Reverses the COMMENT ON operation against a table."""
        ...
    
    def to_table(self, migration_context: Optional[MigrationContext] = ...) -> Table:
        ...
    
    def to_diff_tuple(self) -> Tuple[Any, ...]:
        ...
    


@Operations.register_operation("alter_column")
@BatchOperations.register_operation("alter_column", "batch_alter_column")
class AlterColumnOp(AlterTableOp):
    """Represent an alter column operation."""
    def __init__(self, table_name: str, column_name: str, *, schema: Optional[str] = ..., existing_type: Optional[Any] = ..., existing_server_default: Any = ..., existing_nullable: Optional[bool] = ..., existing_comment: Optional[str] = ..., modify_nullable: Optional[bool] = ..., modify_comment: Optional[Union[str, Literal[False]]] = ..., modify_server_default: Any = ..., modify_name: Optional[str] = ..., modify_type: Optional[Any] = ..., **kw: Any) -> None:
        ...
    
    def to_diff_tuple(self) -> Any:
        ...
    
    def has_changes(self) -> bool:
        ...
    
    def reverse(self) -> AlterColumnOp:
        ...
    
    @classmethod
    def alter_column(cls, operations: Operations, table_name: str, column_name: str, *, nullable: Optional[bool] = ..., comment: Optional[Union[str, Literal[False]]] = ..., server_default: Any = ..., new_column_name: Optional[str] = ..., type_: Optional[Union[TypeEngine[Any], Type[TypeEngine[Any]]]] = ..., existing_type: Optional[Union[TypeEngine[Any], Type[TypeEngine[Any]]]] = ..., existing_server_default: Optional[Union[str, bool, Identity, Computed]] = ..., existing_nullable: Optional[bool] = ..., existing_comment: Optional[str] = ..., schema: Optional[str] = ..., **kw: Any) -> None:
        r"""Issue an "alter column" instruction using the
        current migration context.

        Generally, only that aspect of the column which
        is being changed, i.e. name, type, nullability,
        default, needs to be specified.  Multiple changes
        can also be specified at once and the backend should
        "do the right thing", emitting each change either
        separately or together as the backend allows.

        MySQL has special requirements here, since MySQL
        cannot ALTER a column without a full specification.
        When producing MySQL-compatible migration files,
        it is recommended that the ``existing_type``,
        ``existing_server_default``, and ``existing_nullable``
        parameters be present, if not being altered.

        Type changes which are against the SQLAlchemy
        "schema" types :class:`~sqlalchemy.types.Boolean`
        and  :class:`~sqlalchemy.types.Enum` may also
        add or drop constraints which accompany those
        types on backends that don't support them natively.
        The ``existing_type`` argument is
        used in this case to identify and remove a previous
        constraint that was bound to the type object.

        :param table_name: string name of the target table.
        :param column_name: string name of the target column,
         as it exists before the operation begins.
        :param nullable: Optional; specify ``True`` or ``False``
         to alter the column's nullability.
        :param server_default: Optional; specify a string
         SQL expression, :func:`~sqlalchemy.sql.expression.text`,
         or :class:`~sqlalchemy.schema.DefaultClause` to indicate
         an alteration to the column's default value.
         Set to ``None`` to have the default removed.
        :param comment: optional string text of a new comment to add to the
         column.
        :param new_column_name: Optional; specify a string name here to
         indicate the new name within a column rename operation.
        :param type\_: Optional; a :class:`~sqlalchemy.types.TypeEngine`
         type object to specify a change to the column's type.
         For SQLAlchemy types that also indicate a constraint (i.e.
         :class:`~sqlalchemy.types.Boolean`, :class:`~sqlalchemy.types.Enum`),
         the constraint is also generated.
        :param autoincrement: set the ``AUTO_INCREMENT`` flag of the column;
         currently understood by the MySQL dialect.
        :param existing_type: Optional; a
         :class:`~sqlalchemy.types.TypeEngine`
         type object to specify the previous type.   This
         is required for all MySQL column alter operations that
         don't otherwise specify a new type, as well as for
         when nullability is being changed on a SQL Server
         column.  It is also used if the type is a so-called
         SQLAlchemy "schema" type which may define a constraint (i.e.
         :class:`~sqlalchemy.types.Boolean`,
         :class:`~sqlalchemy.types.Enum`),
         so that the constraint can be dropped.
        :param existing_server_default: Optional; The existing
         default value of the column.   Required on MySQL if
         an existing default is not being changed; else MySQL
         removes the default.
        :param existing_nullable: Optional; the existing nullability
         of the column.  Required on MySQL if the existing nullability
         is not being changed; else MySQL sets this to NULL.
        :param existing_autoincrement: Optional; the existing autoincrement
         of the column.  Used for MySQL's system of altering a column
         that specifies ``AUTO_INCREMENT``.
        :param existing_comment: string text of the existing comment on the
         column to be maintained.  Required on MySQL if the existing comment
         on the column is not being changed.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.
        :param postgresql_using: String argument which will indicate a
         SQL expression to render within the Postgresql-specific USING clause
         within ALTER COLUMN.    This string is taken directly as raw SQL which
         must explicitly include any necessary quoting or escaping of tokens
         within the expression.

        """
        ...
    
    @classmethod
    def batch_alter_column(cls, operations: BatchOperations, column_name: str, *, nullable: Optional[bool] = ..., comment: Optional[Union[str, Literal[False]]] = ..., server_default: Any = ..., new_column_name: Optional[str] = ..., type_: Optional[Union[TypeEngine[Any], Type[TypeEngine[Any]]]] = ..., existing_type: Optional[Union[TypeEngine[Any], Type[TypeEngine[Any]]]] = ..., existing_server_default: Optional[Union[str, bool, Identity, Computed]] = ..., existing_nullable: Optional[bool] = ..., existing_comment: Optional[str] = ..., insert_before: Optional[str] = ..., insert_after: Optional[str] = ..., **kw: Any) -> None:
        """Issue an "alter column" instruction using the current
        batch migration context.

        Parameters are the same as that of :meth:`.Operations.alter_column`,
        as well as the following option(s):

        :param insert_before: String name of an existing column which this
         column should be placed before, when creating the new table.

        :param insert_after: String name of an existing column which this
         column should be placed after, when creating the new table.  If
         both :paramref:`.BatchOperations.alter_column.insert_before`
         and :paramref:`.BatchOperations.alter_column.insert_after` are
         omitted, the column is inserted after the last existing column
         in the table.

        .. seealso::

            :meth:`.Operations.alter_column`


        """
        ...
    


@Operations.register_operation("add_column")
@BatchOperations.register_operation("add_column", "batch_add_column")
class AddColumnOp(AlterTableOp):
    """Represent an add column operation."""
    def __init__(self, table_name: str, column: Column[Any], *, schema: Optional[str] = ..., **kw: Any) -> None:
        ...
    
    def reverse(self) -> DropColumnOp:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Optional[str], str, Column[Any]]:
        ...
    
    def to_column(self) -> Column[Any]:
        ...
    
    @classmethod
    def from_column(cls, col: Column[Any]) -> AddColumnOp:
        ...
    
    @classmethod
    def from_column_and_tablename(cls, schema: Optional[str], tname: str, col: Column[Any]) -> AddColumnOp:
        ...
    
    @classmethod
    def add_column(cls, operations: Operations, table_name: str, column: Column[Any], *, schema: Optional[str] = ...) -> None:
        """Issue an "add column" instruction using the current
        migration context.

        e.g.::

            from alembic import op
            from sqlalchemy import Column, String

            op.add_column("organization", Column("name", String()))

        The :meth:`.Operations.add_column` method typically corresponds
        to the SQL command "ALTER TABLE... ADD COLUMN".    Within the scope
        of this command, the column's name, datatype, nullability,
        and optional server-generated defaults may be indicated.

        .. note::

            With the exception of NOT NULL constraints or single-column FOREIGN
            KEY constraints, other kinds of constraints such as PRIMARY KEY,
            UNIQUE or CHECK constraints **cannot** be generated using this
            method; for these constraints, refer to operations such as
            :meth:`.Operations.create_primary_key` and
            :meth:`.Operations.create_check_constraint`. In particular, the
            following :class:`~sqlalchemy.schema.Column` parameters are
            **ignored**:

            * :paramref:`~sqlalchemy.schema.Column.primary_key` - SQL databases
              typically do not support an ALTER operation that can add
              individual columns one at a time to an existing primary key
              constraint, therefore it's less ambiguous to use the
              :meth:`.Operations.create_primary_key` method, which assumes no
              existing primary key constraint is present.
            * :paramref:`~sqlalchemy.schema.Column.unique` - use the
              :meth:`.Operations.create_unique_constraint` method
            * :paramref:`~sqlalchemy.schema.Column.index` - use the
              :meth:`.Operations.create_index` method


        The provided :class:`~sqlalchemy.schema.Column` object may include a
        :class:`~sqlalchemy.schema.ForeignKey` constraint directive,
        referencing a remote table name. For this specific type of constraint,
        Alembic will automatically emit a second ALTER statement in order to
        add the single-column FOREIGN KEY constraint separately::

            from alembic import op
            from sqlalchemy import Column, INTEGER, ForeignKey

            op.add_column(
                "organization",
                Column("account_id", INTEGER, ForeignKey("accounts.id")),
            )

        The column argument passed to :meth:`.Operations.add_column` is a
        :class:`~sqlalchemy.schema.Column` construct, used in the same way it's
        used in SQLAlchemy. In particular, values or functions to be indicated
        as producing the column's default value on the database side are
        specified using the ``server_default`` parameter, and not ``default``
        which only specifies Python-side defaults::

            from alembic import op
            from sqlalchemy import Column, TIMESTAMP, func

            # specify "DEFAULT NOW" along with the column add
            op.add_column(
                "account",
                Column("timestamp", TIMESTAMP, server_default=func.now()),
            )

        :param table_name: String name of the parent table.
        :param column: a :class:`sqlalchemy.schema.Column` object
         representing the new column.
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.

        """
        ...
    
    @classmethod
    def batch_add_column(cls, operations: BatchOperations, column: Column[Any], *, insert_before: Optional[str] = ..., insert_after: Optional[str] = ...) -> None:
        """Issue an "add column" instruction using the current
        batch migration context.

        .. seealso::

            :meth:`.Operations.add_column`

        """
        ...
    


@Operations.register_operation("drop_column")
@BatchOperations.register_operation("drop_column", "batch_drop_column")
class DropColumnOp(AlterTableOp):
    """Represent a drop column operation."""
    def __init__(self, table_name: str, column_name: str, *, schema: Optional[str] = ..., _reverse: Optional[AddColumnOp] = ..., **kw: Any) -> None:
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Optional[str], str, Column[Any]]:
        ...
    
    def reverse(self) -> AddColumnOp:
        ...
    
    @classmethod
    def from_column_and_tablename(cls, schema: Optional[str], tname: str, col: Column[Any]) -> DropColumnOp:
        ...
    
    def to_column(self, migration_context: Optional[MigrationContext] = ...) -> Column[Any]:
        ...
    
    @classmethod
    def drop_column(cls, operations: Operations, table_name: str, column_name: str, *, schema: Optional[str] = ..., **kw: Any) -> None:
        """Issue a "drop column" instruction using the current
        migration context.

        e.g.::

            drop_column("organization", "account_id")

        :param table_name: name of table
        :param column_name: name of column
        :param schema: Optional schema name to operate within.  To control
         quoting of the schema outside of the default behavior, use
         the SQLAlchemy construct
         :class:`~sqlalchemy.sql.elements.quoted_name`.
        :param mssql_drop_check: Optional boolean.  When ``True``, on
         Microsoft SQL Server only, first
         drop the CHECK constraint on the column using a
         SQL-script-compatible
         block that selects into a @variable from sys.check_constraints,
         then exec's a separate DROP CONSTRAINT for that constraint.
        :param mssql_drop_default: Optional boolean.  When ``True``, on
         Microsoft SQL Server only, first
         drop the DEFAULT constraint on the column using a
         SQL-script-compatible
         block that selects into a @variable from sys.default_constraints,
         then exec's a separate DROP CONSTRAINT for that default.
        :param mssql_drop_foreign_key: Optional boolean.  When ``True``, on
         Microsoft SQL Server only, first
         drop a single FOREIGN KEY constraint on the column using a
         SQL-script-compatible
         block that selects into a @variable from
         sys.foreign_keys/sys.foreign_key_columns,
         then exec's a separate DROP CONSTRAINT for that default.  Only
         works if the column has exactly one FK constraint which refers to
         it, at the moment.

        """
        ...
    
    @classmethod
    def batch_drop_column(cls, operations: BatchOperations, column_name: str, **kw: Any) -> None:
        """Issue a "drop column" instruction using the current
        batch migration context.

        .. seealso::

            :meth:`.Operations.drop_column`

        """
        ...
    


@Operations.register_operation("bulk_insert")
class BulkInsertOp(MigrateOperation):
    """Represent a bulk insert operation."""
    def __init__(self, table: Union[Table, TableClause], rows: List[Dict[str, Any]], *, multiinsert: bool = ...) -> None:
        ...
    
    @classmethod
    def bulk_insert(cls, operations: Operations, table: Union[Table, TableClause], rows: List[Dict[str, Any]], *, multiinsert: bool = ...) -> None:
        """Issue a "bulk insert" operation using the current
        migration context.

        This provides a means of representing an INSERT of multiple rows
        which works equally well in the context of executing on a live
        connection as well as that of generating a SQL script.   In the
        case of a SQL script, the values are rendered inline into the
        statement.

        e.g.::

            from alembic import op
            from datetime import date
            from sqlalchemy.sql import table, column
            from sqlalchemy import String, Integer, Date

            # Create an ad-hoc table to use for the insert statement.
            accounts_table = table(
                "account",
                column("id", Integer),
                column("name", String),
                column("create_date", Date),
            )

            op.bulk_insert(
                accounts_table,
                [
                    {
                        "id": 1,
                        "name": "John Smith",
                        "create_date": date(2010, 10, 5),
                    },
                    {
                        "id": 2,
                        "name": "Ed Williams",
                        "create_date": date(2007, 5, 27),
                    },
                    {
                        "id": 3,
                        "name": "Wendy Jones",
                        "create_date": date(2008, 8, 15),
                    },
                ],
            )

        When using --sql mode, some datatypes may not render inline
        automatically, such as dates and other special types.   When this
        issue is present, :meth:`.Operations.inline_literal` may be used::

            op.bulk_insert(
                accounts_table,
                [
                    {
                        "id": 1,
                        "name": "John Smith",
                        "create_date": op.inline_literal("2010-10-05"),
                    },
                    {
                        "id": 2,
                        "name": "Ed Williams",
                        "create_date": op.inline_literal("2007-05-27"),
                    },
                    {
                        "id": 3,
                        "name": "Wendy Jones",
                        "create_date": op.inline_literal("2008-08-15"),
                    },
                ],
                multiinsert=False,
            )

        When using :meth:`.Operations.inline_literal` in conjunction with
        :meth:`.Operations.bulk_insert`, in order for the statement to work
        in "online" (e.g. non --sql) mode, the
        :paramref:`~.Operations.bulk_insert.multiinsert`
        flag should be set to ``False``, which will have the effect of
        individual INSERT statements being emitted to the database, each
        with a distinct VALUES clause, so that the "inline" values can
        still be rendered, rather than attempting to pass the values
        as bound parameters.

        :param table: a table object which represents the target of the INSERT.

        :param rows: a list of dictionaries indicating rows.

        :param multiinsert: when at its default of True and --sql mode is not
           enabled, the INSERT statement will be executed using
           "executemany()" style, where all elements in the list of
           dictionaries are passed as bound parameters in a single
           list.   Setting this to False results in individual INSERT
           statements being emitted per parameter set, and is needed
           in those cases where non-literal values are present in the
           parameter sets.

        """
        ...
    


@Operations.register_operation("execute")
@BatchOperations.register_operation("execute", "batch_execute")
class ExecuteSQLOp(MigrateOperation):
    """Represent an execute SQL operation."""
    def __init__(self, sqltext: Union[Executable, str], *, execution_options: Optional[dict[str, Any]] = ...) -> None:
        ...
    
    @classmethod
    def execute(cls, operations: Operations, sqltext: Union[Executable, str], *, execution_options: Optional[dict[str, Any]] = ...) -> None:
        r"""Execute the given SQL using the current migration context.

        The given SQL can be a plain string, e.g.::

            op.execute("INSERT INTO table (foo) VALUES ('some value')")

        Or it can be any kind of Core SQL Expression construct, such as
        below where we use an update construct::

            from sqlalchemy.sql import table, column
            from sqlalchemy import String
            from alembic import op

            account = table("account", column("name", String))
            op.execute(
                account.update()
                .where(account.c.name == op.inline_literal("account 1"))
                .values({"name": op.inline_literal("account 2")})
            )

        Above, we made use of the SQLAlchemy
        :func:`sqlalchemy.sql.expression.table` and
        :func:`sqlalchemy.sql.expression.column` constructs to make a brief,
        ad-hoc table construct just for our UPDATE statement.  A full
        :class:`~sqlalchemy.schema.Table` construct of course works perfectly
        fine as well, though note it's a recommended practice to at least
        ensure the definition of a table is self-contained within the migration
        script, rather than imported from a module that may break compatibility
        with older migrations.

        In a SQL script context, the statement is emitted directly to the
        output stream.   There is *no* return result, however, as this
        function is oriented towards generating a change script
        that can run in "offline" mode.     Additionally, parameterized
        statements are discouraged here, as they *will not work* in offline
        mode.  Above, we use :meth:`.inline_literal` where parameters are
        to be used.

        For full interaction with a connected database where parameters can
        also be used normally, use the "bind" available from the context::

            from alembic import op

            connection = op.get_bind()

            connection.execute(
                account.update()
                .where(account.c.name == "account 1")
                .values({"name": "account 2"})
            )

        Additionally, when passing the statement as a plain string, it is first
        coerced into a :func:`sqlalchemy.sql.expression.text` construct
        before being passed along.  In the less likely case that the
        literal SQL string contains a colon, it must be escaped with a
        backslash, as::

           op.execute(r"INSERT INTO table (foo) VALUES ('\:colon_value')")


        :param sqltext: Any legal SQLAlchemy expression, including:

        * a string
        * a :func:`sqlalchemy.sql.expression.text` construct.
        * a :func:`sqlalchemy.sql.expression.insert` construct.
        * a :func:`sqlalchemy.sql.expression.update` construct.
        * a :func:`sqlalchemy.sql.expression.delete` construct.
        * Any "executable" described in SQLAlchemy Core documentation,
          noting that no result set is returned.

        .. note::  when passing a plain string, the statement is coerced into
           a :func:`sqlalchemy.sql.expression.text` construct. This construct
           considers symbols with colons, e.g. ``:foo`` to be bound parameters.
           To avoid this, ensure that colon symbols are escaped, e.g.
           ``\:foo``.

        :param execution_options: Optional dictionary of
         execution options, will be passed to
         :meth:`sqlalchemy.engine.Connection.execution_options`.
        """
        ...
    
    @classmethod
    def batch_execute(cls, operations: Operations, sqltext: Union[Executable, str], *, execution_options: Optional[dict[str, Any]] = ...) -> None:
        """Execute the given SQL using the current migration context.

        .. seealso::

            :meth:`.Operations.execute`

        """
        ...
    
    def to_diff_tuple(self) -> Tuple[str, Union[Executable, str]]:
        ...
    


class OpContainer(MigrateOperation):
    """Represent a sequence of operations operation."""
    def __init__(self, ops: Sequence[MigrateOperation] = ...) -> None:
        ...
    
    def is_empty(self) -> bool:
        ...
    
    def as_diffs(self) -> Any:
        ...
    


class ModifyTableOps(OpContainer):
    """Contains a sequence of operations that all apply to a single Table."""
    def __init__(self, table_name: str, ops: Sequence[MigrateOperation], *, schema: Optional[str] = ...) -> None:
        ...
    
    def reverse(self) -> ModifyTableOps:
        ...
    


class UpgradeOps(OpContainer):
    """contains a sequence of operations that would apply to the
    'upgrade' stream of a script.

    .. seealso::

        :ref:`customizing_revision`

    """
    def __init__(self, ops: Sequence[MigrateOperation] = ..., upgrade_token: str = ...) -> None:
        ...
    
    def reverse_into(self, downgrade_ops: DowngradeOps) -> DowngradeOps:
        ...
    
    def reverse(self) -> DowngradeOps:
        ...
    


class DowngradeOps(OpContainer):
    """contains a sequence of operations that would apply to the
    'downgrade' stream of a script.

    .. seealso::

        :ref:`customizing_revision`

    """
    def __init__(self, ops: Sequence[MigrateOperation] = ..., downgrade_token: str = ...) -> None:
        ...
    
    def reverse(self) -> UpgradeOps:
        ...
    


class MigrationScript(MigrateOperation):
    """represents a migration script.

    E.g. when autogenerate encounters this object, this corresponds to the
    production of an actual script file.

    A normal :class:`.MigrationScript` object would contain a single
    :class:`.UpgradeOps` and a single :class:`.DowngradeOps` directive.
    These are accessible via the ``.upgrade_ops`` and ``.downgrade_ops``
    attributes.

    In the case of an autogenerate operation that runs multiple times,
    such as the multiple database example in the "multidb" template,
    the ``.upgrade_ops`` and ``.downgrade_ops`` attributes are disabled,
    and instead these objects should be accessed via the ``.upgrade_ops_list``
    and ``.downgrade_ops_list`` list-based attributes.  These latter
    attributes are always available at the very least as single-element lists.

    .. seealso::

        :ref:`customizing_revision`

    """
    _needs_render: Optional[bool]
    _upgrade_ops: List[UpgradeOps]
    _downgrade_ops: List[DowngradeOps]
    def __init__(self, rev_id: Optional[str], upgrade_ops: UpgradeOps, downgrade_ops: DowngradeOps, *, message: Optional[str] = ..., imports: Set[str] = ..., head: Optional[str] = ..., splice: Optional[bool] = ..., branch_label: Optional[_RevIdType] = ..., version_path: Optional[str] = ..., depends_on: Optional[_RevIdType] = ...) -> None:
        ...
    
    @property
    def upgrade_ops(self) -> Optional[UpgradeOps]:
        """An instance of :class:`.UpgradeOps`.

        .. seealso::

            :attr:`.MigrationScript.upgrade_ops_list`
        """
        ...
    
    @upgrade_ops.setter
    def upgrade_ops(self, upgrade_ops: Union[UpgradeOps, List[UpgradeOps]]) -> None:
        ...
    
    @property
    def downgrade_ops(self) -> Optional[DowngradeOps]:
        """An instance of :class:`.DowngradeOps`.

        .. seealso::

            :attr:`.MigrationScript.downgrade_ops_list`
        """
        ...
    
    @downgrade_ops.setter
    def downgrade_ops(self, downgrade_ops: Union[DowngradeOps, List[DowngradeOps]]) -> None:
        ...
    
    @property
    def upgrade_ops_list(self) -> List[UpgradeOps]:
        """A list of :class:`.UpgradeOps` instances.

        This is used in place of the :attr:`.MigrationScript.upgrade_ops`
        attribute when dealing with a revision operation that does
        multiple autogenerate passes.

        """
        ...
    
    @property
    def downgrade_ops_list(self) -> List[DowngradeOps]:
        """A list of :class:`.DowngradeOps` instances.

        This is used in place of the :attr:`.MigrationScript.downgrade_ops`
        attribute when dealing with a revision operation that does
        multiple autogenerate passes.

        """
        ...
    


