"""
This type stub file was generated by pyright.
"""

from typing import Any, Dict, Literal, Optional, Sequence, TYPE_CHECKING, Tuple, Union
from sqlalchemy import Index, UniqueConstraint
from sqlalchemy.dialects.postgresql import ExcludeConstraint
from sqlalchemy.sql.elements import ClauseElement, ColumnClause, ColumnElement, quoted_name
from .base import AlterColumn, ColumnComment, IdentityColumnDefault, RenameTable, _ServerDefault
from .impl import ComparisonResult, DefaultImpl
from ..operations import ops
from ..operations.base import BatchOperations, Operations
from ..util import sqla_compat
from ..util.sqla_compat import compiles
from sqlalchemy.dialects.postgresql.base import PGDDLCompiler
from sqlalchemy.sql.schema import Table
from sqlalchemy.sql.type_api import TypeEngine
from ..autogenerate.api import AutogenContext
from ..runtime.migration import MigrationContext

if TYPE_CHECKING:
    ...
log = ...
class PostgresqlImpl(DefaultImpl):
    __dialect__ = ...
    transactional_ddl = ...
    type_synonyms = ...
    def create_index(self, index: Index, **kw: Any) -> None:
        ...
    
    def prep_table_for_batch(self, batch_impl, table): # -> None:
        ...
    
    def compare_server_default(self, inspector_column, metadata_column, rendered_metadata_default, rendered_inspector_default): # -> bool:
        ...
    
    def alter_column(self, table_name: str, column_name: str, nullable: Optional[bool] = ..., server_default: Union[_ServerDefault, Literal[False]] = ..., name: Optional[str] = ..., type_: Optional[TypeEngine] = ..., schema: Optional[str] = ..., autoincrement: Optional[bool] = ..., existing_type: Optional[TypeEngine] = ..., existing_server_default: Optional[_ServerDefault] = ..., existing_nullable: Optional[bool] = ..., existing_autoincrement: Optional[bool] = ..., **kw: Any) -> None:
        ...
    
    def autogen_column_reflect(self, inspector, table, column_info): # -> None:
        ...
    
    def correct_for_autogen_constraints(self, conn_unique_constraints, conn_indexes, metadata_unique_constraints, metadata_indexes): # -> None:
        ...
    
    _default_modifiers_re = ...
    def compare_indexes(self, metadata_index: Index, reflected_index: Index) -> ComparisonResult:
        ...
    
    def compare_unique_constraint(self, metadata_constraint: UniqueConstraint, reflected_constraint: UniqueConstraint) -> ComparisonResult:
        ...
    
    def adjust_reflected_dialect_options(self, reflected_options: Dict[str, Any], kind: str) -> Dict[str, Any]:
        ...
    
    def render_ddl_sql_expr(self, expr: ClauseElement, is_server_default: bool = ..., is_index: bool = ..., **kw: Any) -> str:
        """Render a SQL expression that is typically a server default,
        index expression, etc.

        """
        ...
    
    def render_type(self, type_: TypeEngine, autogen_context: AutogenContext) -> Union[str, Literal[False]]:
        ...
    


class PostgresqlColumnType(AlterColumn):
    def __init__(self, name: str, column_name: str, type_: TypeEngine, **kw) -> None:
        ...
    


@compiles(RenameTable, "postgresql")
def visit_rename_table(element: RenameTable, compiler: PGDDLCompiler, **kw) -> str:
    ...

@compiles(PostgresqlColumnType, "postgresql")
def visit_column_type(element: PostgresqlColumnType, compiler: PGDDLCompiler, **kw) -> str:
    ...

@compiles(ColumnComment, "postgresql")
def visit_column_comment(element: ColumnComment, compiler: PGDDLCompiler, **kw) -> str:
    ...

@compiles(IdentityColumnDefault, "postgresql")
def visit_identity_column(element: IdentityColumnDefault, compiler: PGDDLCompiler, **kw): # -> str:
    ...

@Operations.register_operation("create_exclude_constraint")
@BatchOperations.register_operation("create_exclude_constraint", "batch_create_exclude_constraint")
@ops.AddConstraintOp.register_add_constraint("exclude_constraint")
class CreateExcludeConstraintOp(ops.AddConstraintOp):
    """Represent a create exclude constraint operation."""
    constraint_type = ...
    def __init__(self, constraint_name: sqla_compat._ConstraintName, table_name: Union[str, quoted_name], elements: Union[Sequence[Tuple[str, str]], Sequence[Tuple[ColumnClause[Any], str]],], where: Optional[Union[ColumnElement[bool], str]] = ..., schema: Optional[str] = ..., _orig_constraint: Optional[ExcludeConstraint] = ..., **kw) -> None:
        ...
    
    @classmethod
    def from_constraint(cls, constraint: ExcludeConstraint) -> CreateExcludeConstraintOp:
        ...
    
    def to_constraint(self, migration_context: Optional[MigrationContext] = ...) -> ExcludeConstraint:
        ...
    
    @classmethod
    def create_exclude_constraint(cls, operations: Operations, constraint_name: str, table_name: str, *elements: Any, **kw: Any) -> Optional[Table]:
        """Issue an alter to create an EXCLUDE constraint using the
        current migration context.

        .. note::  This method is Postgresql specific, and additionally
           requires at least SQLAlchemy 1.0.

        e.g.::

            from alembic import op

            op.create_exclude_constraint(
                "user_excl",
                "user",
                ("period", "&&"),
                ("group", "="),
                where=("group != 'some group'"),
            )

        Note that the expressions work the same way as that of
        the ``ExcludeConstraint`` object itself; if plain strings are
        passed, quoting rules must be applied manually.

        :param name: Name of the constraint.
        :param table_name: String name of the source table.
        :param elements: exclude conditions.
        :param where: SQL expression or SQL string with optional WHERE
         clause.
        :param deferrable: optional bool. If set, emit DEFERRABLE or
         NOT DEFERRABLE when issuing DDL for this constraint.
        :param initially: optional string. If set, emit INITIALLY <value>
         when issuing DDL for this constraint.
        :param schema: Optional schema name to operate within.

        """
        ...
    
    @classmethod
    def batch_create_exclude_constraint(cls, operations: BatchOperations, constraint_name: str, *elements: Any, **kw: Any) -> Optional[Table]:
        """Issue a "create exclude constraint" instruction using the
        current batch migration context.

        .. note::  This method is Postgresql specific, and additionally
           requires at least SQLAlchemy 1.0.

        .. seealso::

            :meth:`.Operations.create_exclude_constraint`

        """
        ...
    


